/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.rcp.core.internal.rest.util;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.ILocalChange;
import com.ibm.team.filesystem.client.IOperationFactory;
import com.ibm.team.filesystem.client.IShare;
import com.ibm.team.filesystem.client.internal.StringWrapper;
import com.ibm.team.filesystem.client.internal.operations.ApplyAcceptedOperation;
import com.ibm.team.filesystem.client.internal.operations.MarkAsMergedOperation;
import com.ibm.team.filesystem.client.internal.rest.CommonUtil;
import com.ibm.team.filesystem.client.internal.utils.ConfigurationDescriptor;
import com.ibm.team.filesystem.client.internal.utils.PathUtils;
import com.ibm.team.filesystem.client.operations.ApplyAcceptedDilemmaHandler;
import com.ibm.team.filesystem.client.operations.AutoResolveConflictsDilemmaHandler;
import com.ibm.team.filesystem.client.operations.BackupDilemmaHandler;
import com.ibm.team.filesystem.client.operations.ChangePropertiesDilemmaHandler;
import com.ibm.team.filesystem.client.operations.CommitDilemmaHandler;
import com.ibm.team.filesystem.client.operations.IAutoResolveConflictsOperation;
import com.ibm.team.filesystem.client.operations.ICheckinOptions;
import com.ibm.team.filesystem.client.operations.IFailedAutoResolveRequest;
import com.ibm.team.filesystem.client.operations.ILineDelimiterUploadFailure;
import com.ibm.team.filesystem.client.operations.MarkAsMergedDilemmaHandler;
import com.ibm.team.filesystem.client.operations.OutOfSyncDilemmaHandler;
import com.ibm.team.filesystem.client.rest.parameters.ParmsAutoMerge;
import com.ibm.team.filesystem.client.rest.parameters.ParmsBackupDilemmaHandler;
import com.ibm.team.filesystem.client.rest.parameters.ParmsConflictedItemToResolve;
import com.ibm.team.filesystem.client.rest.parameters.ParmsConflictsToResolve;
import com.ibm.team.filesystem.client.rest.parameters.ParmsConflictsToResolveWithProposed;
import com.ibm.team.filesystem.client.rest.parameters.ParmsLineDelimiterDilemmaHandler;
import com.ibm.team.filesystem.client.rest.parameters.ParmsOutOfSyncInstructions;
import com.ibm.team.filesystem.client.rest.parameters.ParmsPendingChangesDilemmaHandler;
import com.ibm.team.filesystem.client.rest.parameters.ParmsResolveAsMerged;
import com.ibm.team.filesystem.client.rest.parameters.ParmsResolveWithProposed;
import com.ibm.team.filesystem.client.rest.parameters.ParmsStorageMergerInstructions;
import com.ibm.team.filesystem.common.ILogicalChange;
import com.ibm.team.filesystem.common.ILogicalConflict;
import com.ibm.team.filesystem.common.ILogicalConflictReport;
import com.ibm.team.filesystem.common.internal.rest.client.changeset.BackupInShedDTO;
import com.ibm.team.filesystem.common.internal.rest.client.changeset.NonAtomicCheckInDTO;
import com.ibm.team.filesystem.common.internal.rest.client.conflict.ConflictedChangeDTO;
import com.ibm.team.filesystem.common.internal.rest.client.conflict.FailedMergeDTO;
import com.ibm.team.filesystem.common.internal.rest.client.conflict.FilesystemRestClientDTOconflictFactory;
import com.ibm.team.filesystem.common.internal.rest.client.conflict.ResolveAsMergedResultDTO;
import com.ibm.team.filesystem.common.internal.rest.client.conflict.ResolveAutoMergeResultDTO;
import com.ibm.team.filesystem.common.internal.rest.client.conflict.ResolveWithProposedEvaluationDTO;
import com.ibm.team.filesystem.common.internal.rest.client.conflict.ResolveWithProposedResultDTO;
import com.ibm.team.filesystem.common.internal.rest.client.core.ConfigurationDescriptorDTO;
import com.ibm.team.filesystem.common.internal.rest.client.core.ShareDTO;
import com.ibm.team.filesystem.common.internal.rest.client.resource.EncodingErrorDTO;
import com.ibm.team.filesystem.common.internal.rest.client.resource.LineDelimiterErrorDTO;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.SyncCache;
import com.ibm.team.filesystem.rcp.core.internal.rest.util.BackupUtil;
import com.ibm.team.filesystem.rcp.core.internal.rest.util.CommitUtil;
import com.ibm.team.filesystem.rcp.core.internal.rest.util.CoreUtil;
import com.ibm.team.filesystem.rcp.core.internal.rest.util.ResourceUtil;
import com.ibm.team.filesystem.rcp.core.internal.rest.util.VerifyOutOfSyncUtil;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IFolder;
import com.ibm.team.scm.common.IFolderHandle;
import com.ibm.team.scm.common.IVersionableHandle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConflictResolutionUtil {
    private static final String RESOLVE_WITH_PROPOSED = "resolveWithProposed";
    private static final String AUTO_RESOLVE_REQUEST = "autoResolve";

    public static ResolveAutoMergeResultDTO autoResolve(ParmsAutoMerge parms, IProgressMonitor progress) throws TeamRepositoryException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)100);
        if (parms.conflictsToResolve.length == 0 && parms.itemsToResolve.length == 0) {
            return FilesystemRestClientDTOconflictFactory.eINSTANCE.createResolveAutoMergeResultDTO();
        }
        ResolveAutoMergeResultDTO result = FilesystemRestClientDTOconflictFactory.eINSTANCE.createResolveAutoMergeResultDTO();
        AutoResolveConflictsDilemmaHandler dilemmaHandler = ConflictResolutionUtil.getAutoResolveConflictsDilemmaHandler(result, parms);
        IAutoResolveConflictsOperation op = ConflictResolutionUtil.prepareAutoResolveOperation(parms, dilemmaHandler, (IProgressMonitor)monitor.newChild(10));
        try {
            op.run((IProgressMonitor)monitor.newChild(90));
        }
        catch (FileSystemClientException e) {
            result.setNumberConflictsResolved(op.numberOfConflictsResolved());
            throw new TeamRepositoryException(CommonUtil.getErrorMessage((FileSystemClientException)e), (Throwable)e);
        }
        catch (OperationCanceledException operationCanceledException) {
            result.setCancelled(true);
        }
        result.setNumberConflictsResolved(op.numberOfConflictsResolved());
        return result;
    }

    private static AutoResolveConflictsDilemmaHandler getAutoResolveConflictsDilemmaHandler(final ResolveAutoMergeResultDTO result, final ParmsAutoMerge parms) throws TeamRepositoryException {
        String generalContentType;
        int generalStoragMergerInstruction;
        ITeamRepository repository = CommonUtil.getTeamRepository((String)parms.workspace.repositoryUrl);
        final MarkAsMergedDilemmaHandler markAsMergeddilemmaHandler = ConflictResolutionUtil.getMarkAsMergedDilemmaHandler(repository, parms.outOfSyncInstructions, result.getOutOfSyncShares(), parms.pendingChangesDilemmaHandler, result.getConfigurationsWithUnCheckedInChanges(), result.getLineDelimiterFailures(), result.getEncodingFailures(), parms.missingRequiredChangesDilemmaHandler, result.getMissingRequiredChanges(), "continue", null, parms.backupDilemmaHandler, result.getBackedUpToShed(), result.getNonAtomicCheckInOffers());
        final ApplyAcceptedDilemmaHandler applyAcceptedDilemmaHandler = ConflictResolutionUtil.getApplyAcceptedDilemmaHandler(parms.outOfSyncInstructions, result.getOutOfSyncShares(), parms.missingRequiredChangesDilemmaHandler, result.getMissingRequiredChanges(), parms.backupDilemmaHandler, result.getBackedUpToShed());
        final BackupDilemmaHandler backupDilemmaHandler = BackupUtil.getBackupDilemmaHandler(parms.backupDilemmaHandler, result.getBackedUpToShed());
        final OutOfSyncDilemmaHandler oosDilemmaHandler = VerifyOutOfSyncUtil.getOutOfSyncDilemmaHandler(parms.outOfSyncInstructions, result.getOutOfSyncShares(), backupDilemmaHandler);
        final HashMap<StringWrapper, String> sensitiveStorageMergerInstructions = new HashMap<StringWrapper, String>();
        final HashMap<StringWrapper, String> insensitiveStorageMergerInstructions = new HashMap<StringWrapper, String>();
        if (parms.missingStorageMergerDilemmaHandler == null) {
            generalStoragMergerInstruction = 2;
            generalContentType = "";
        } else {
            generalStoragMergerInstruction = ConflictResolutionUtil.getInstruction(parms.missingStorageMergerDilemmaHandler.generalStorageMergerInstruction);
            generalContentType = parms.missingStorageMergerDilemmaHandler.generalContentType != null ? parms.missingStorageMergerDilemmaHandler.generalContentType : "";
            ConflictResolutionUtil.initializeStorageMergerInstructions(parms.missingStorageMergerDilemmaHandler.storageMergerInstructions, sensitiveStorageMergerInstructions, insensitiveStorageMergerInstructions);
        }
        AutoResolveConflictsDilemmaHandler dilemmaHandler = new AutoResolveConflictsDilemmaHandler(){

            public ApplyAcceptedDilemmaHandler getApplyAcceptedDilemmaHandler() {
                return applyAcceptedDilemmaHandler;
            }

            public ChangePropertiesDilemmaHandler getChangePropertiesDilemmaHandler() {
                ParmsLineDelimiterDilemmaHandler lineDelimiterDilemmaHandler = null;
                if (parms.pendingChangesDilemmaHandler != null && parms.pendingChangesDilemmaHandler.commitDilemmaHandler != null) {
                    lineDelimiterDilemmaHandler = parms.pendingChangesDilemmaHandler.commitDilemmaHandler.lineDelimiterDilemmaHandler;
                }
                return ResourceUtil.getChangePropertiesDilemmaHandler(lineDelimiterDilemmaHandler, result.getLineDelimiterFailures(), parms.outOfSyncInstructions, result.getOutOfSyncShares(), backupDilemmaHandler);
            }

            public MarkAsMergedDilemmaHandler getMarkAsMergedDilemmaHandler() {
                return markAsMergeddilemmaHandler;
            }

            public OutOfSyncDilemmaHandler getOutOfSyncDilemmaHandler() {
                return oosDilemmaHandler;
            }

            public int missingStorageMerger(Collection<IFailedAutoResolveRequest> unknownTypes, Collection<IFailedAutoResolveRequest> itemsWithNoHandlers, IProgressMonitor monitor) throws FileSystemClientException {
                SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                boolean useGeneralInstruction = false;
                SubMonitor iterProgress = progress.newChild(unknownTypes.size());
                for (IFailedAutoResolveRequest request : unknownTypes) {
                    result.getMissingStorageMergers().add(this.translateFailure(request, true, false, (IProgressMonitor)iterProgress.newChild(1)));
                    useGeneralInstruction |= this.handleMissingStorageMerger(request, generalContentType, sensitiveStorageMergerInstructions, insensitiveStorageMergerInstructions);
                }
                iterProgress = progress.newChild(itemsWithNoHandlers.size());
                for (IFailedAutoResolveRequest request : itemsWithNoHandlers) {
                    result.getMissingStorageMergers().add(this.translateFailure(request, false, true, (IProgressMonitor)iterProgress.newChild(1)));
                    useGeneralInstruction |= this.handleMissingStorageMerger(request, generalContentType, sensitiveStorageMergerInstructions, insensitiveStorageMergerInstructions);
                }
                if (useGeneralInstruction) {
                    return generalStoragMergerInstruction;
                }
                return 0;
            }

            private boolean handleMissingStorageMerger(IFailedAutoResolveRequest request, String generalContentType2, HashMap<StringWrapper, String> sensitiveStorageMergerInstructions2, HashMap<StringWrapper, String> insensitiveStorageMergerInstructions2) {
                boolean useGeneralInstruction = false;
                String contentType = null;
                contentType = request.getConflictedShareable().getSandbox().isCaseSensitive() ? sensitiveStorageMergerInstructions2.get(new StringWrapper(PathUtils.getString((String[])request.getConflictedShareable().getLocalPath().segments()), true)) : insensitiveStorageMergerInstructions2.get(new StringWrapper(PathUtils.getString((String[])request.getConflictedShareable().getLocalPath().segments()), false));
                if (contentType != null) {
                    request.setRetryMerge(true);
                    request.defaultContentTypeMerger(contentType);
                } else if (generalContentType2 != null && generalContentType2.length() > 0) {
                    request.setRetryMerge(true);
                    request.defaultContentTypeMerger(generalContentType2);
                } else {
                    useGeneralInstruction = true;
                }
                return useGeneralInstruction;
            }

            private FailedMergeDTO translateFailure(IFailedAutoResolveRequest request, boolean unknownContentType, boolean noMerger, IProgressMonitor monitor) throws FileSystemClientException {
                SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                FailedMergeDTO failedMerge = FilesystemRestClientDTOconflictFactory.eINSTANCE.createFailedMergeDTO();
                IShare share = request.getConflictedShareable().getShare((IProgressMonitor)progress.newChild(50));
                failedMerge.setComponentItemId(share.getSharingDescriptor().getComponent().getItemId().getUuidValue());
                IVersionableHandle remote = request.getConflictedShareable().getRemote((IProgressMonitor)progress.newChild(50));
                failedMerge.setVersionableItemId(remote.getItemId().getUuidValue());
                failedMerge.setVersionableItemType(CoreUtil.getVersionableItemType(remote));
                failedMerge.setPath(CoreUtil.translatePath(request.getConflictedShareable().getLocalPath()));
                failedMerge.setUnknownContentType(unknownContentType);
                failedMerge.setNoMergerForContentType(noMerger);
                return failedMerge;
            }

            public BackupDilemmaHandler getBackupDilemmaHandler() {
                return backupDilemmaHandler;
            }
        };
        return dilemmaHandler;
    }

    private static void initializeStorageMergerInstructions(ParmsStorageMergerInstructions[] storageMergerInstructions, HashMap<StringWrapper, String> sensitiveStorageMergerInstructions, HashMap<StringWrapper, String> insensitiveStorageMergerInstructions) {
        if (storageMergerInstructions != null) {
            ParmsStorageMergerInstructions[] parmsStorageMergerInstructionsArray = storageMergerInstructions;
            int n = storageMergerInstructions.length;
            int n2 = 0;
            while (n2 < n) {
                ParmsStorageMergerInstructions instruction = parmsStorageMergerInstructionsArray[n2];
                Path path = new Path(instruction.filePath);
                sensitiveStorageMergerInstructions.put(new StringWrapper(PathUtils.getString((String[])path.segments()), true), instruction.contentType);
                insensitiveStorageMergerInstructions.put(new StringWrapper(PathUtils.getString((String[])path.segments()), false), instruction.contentType);
                ++n2;
            }
        }
    }

    private static IAutoResolveConflictsOperation prepareAutoResolveOperation(ParmsAutoMerge parms, AutoResolveConflictsDilemmaHandler dilemmaHandler, IProgressMonitor progress) throws TeamRepositoryException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)100);
        IWorkspaceConnection wc = parms.workspace.getWorkspaceConnection((IProgressMonitor)monitor.newChild(10));
        IAutoResolveConflictsOperation op = IOperationFactory.instance.getAutoResolveConflictsOperation(dilemmaHandler);
        CommitUtil.configureCommit(parms.pendingChangesDilemmaHandler, (ICheckinOptions)op);
        ILogicalConflictReport conflictReport = ConflictResolutionUtil.getLogicalConflictReport(wc, (IProgressMonitor)monitor.newChild(10));
        Collection<ILogicalChange> changes = parms.conflictsToResolve.length > 0 ? ConflictResolutionUtil.getChanges(conflictReport, parms.conflictsToResolve, AUTO_RESOLVE_REQUEST) : ConflictResolutionUtil.getChanges(conflictReport, parms.itemsToResolve);
        for (ILogicalChange change : changes) {
            op.autoResolveConflict(wc, conflictReport, change);
        }
        return op;
    }

    private static Collection<ILogicalChange> getChanges(ILogicalConflictReport conflictReport, ParmsConflictedItemToResolve[] itemsToResolve) {
        ArrayList<ILogicalChange> logicalChanges = new ArrayList<ILogicalChange>(itemsToResolve.length);
        HashMap<UUID, HashMap<UUID, Collection<ILogicalChange>>> organizedConflictReport = new HashMap<UUID, HashMap<UUID, Collection<ILogicalChange>>>();
        ConflictResolutionUtil.organizeConflicts(conflictReport.autoMergeChanges(), organizedConflictReport);
        ConflictResolutionUtil.organizeConflicts(conflictReport.incidentalChanges(), organizedConflictReport);
        ConflictResolutionUtil.organizeConflicts(conflictReport.conflicts(), organizedConflictReport);
        ParmsConflictedItemToResolve[] parmsConflictedItemToResolveArray = itemsToResolve;
        int n = itemsToResolve.length;
        int n2 = 0;
        while (n2 < n) {
            Collection<ILogicalChange> conflicts;
            ParmsConflictedItemToResolve conflictedItem = parmsConflictedItemToResolveArray[n2];
            HashMap<UUID, Collection<ILogicalChange>> conflictedVersionables = organizedConflictReport.get(UUID.valueOf((String)conflictedItem.componentItemId));
            if (conflictedVersionables != null && (conflicts = conflictedVersionables.get(UUID.valueOf((String)conflictedItem.versionableItemId))) != null) {
                for (ILogicalChange change : conflicts) {
                    logicalChanges.add(change);
                }
            }
            ++n2;
        }
        return logicalChanges;
    }

    public static ResolveAsMergedResultDTO resolveAsMerged(ParmsResolveAsMerged parms, IProgressMonitor progress) throws TeamRepositoryException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)100);
        ITeamRepository repository = CommonUtil.getTeamRepository((String)parms.workspace.repositoryUrl);
        ResolveAsMergedResultDTO result = FilesystemRestClientDTOconflictFactory.eINSTANCE.createResolveAsMergedResultDTO();
        MarkAsMergedDilemmaHandler dilemmaHandler = ConflictResolutionUtil.getMarkAsMergedDilemmaHandler(repository, parms.outOfSyncInstructions, result.getOutOfSyncShares(), parms.pendingChangesDilemmaHandler, result.getConfigurationsWithUnCheckedInChanges(), result.getLineDelimiterFailures(), result.getEncodingFailures(), parms.missingRequiredChangesDilemmaHandler, result.getMissingRequiredChanges(), parms.unmergedChangesDilemmaHandler, result.getUnmergedChanges(), parms.backupDilemmaHandler, result.getBackedUpToShed(), result.getNonAtomicCheckInOffers());
        MarkAsMergedOperation op = ConflictResolutionUtil.prepareMarkAsMergedOperation(parms, dilemmaHandler, (IProgressMonitor)monitor.newChild(10));
        try {
            op.run((IProgressMonitor)monitor.newChild(90));
        }
        catch (FileSystemClientException e) {
            throw new TeamRepositoryException(CommonUtil.getErrorMessage((FileSystemClientException)e), (Throwable)e);
        }
        catch (OperationCanceledException operationCanceledException) {
            result.setCancelled(true);
        }
        return result;
    }

    private static MarkAsMergedDilemmaHandler getMarkAsMergedDilemmaHandler(final ITeamRepository repository, ParmsOutOfSyncInstructions outOfSyncDilemmaHandler, List<ShareDTO> outOfSyncShares, ParmsPendingChangesDilemmaHandler changeDilemmaHandler, final List<ConfigurationDescriptorDTO> uncheckedInPendingChanges, List<LineDelimiterErrorDTO> lineDelimiterFailures, List<EncodingErrorDTO> encodingFailures, String missingRequiredChangesDilemmaHandler, final List<ConflictedChangeDTO> missingRequiredChanges, String unmergedChangesDilemmaHandler, final List<ConflictedChangeDTO> unmergedChanges, ParmsBackupDilemmaHandler backupInstructions, List<BackupInShedDTO> backedUpInShed, List<NonAtomicCheckInDTO> nonAtomicCommitOffers) {
        MarkAsMergedDilemmaHandler dilemmaHandler = new MarkAsMergedDilemmaHandler(backupInstructions, backedUpInShed, outOfSyncDilemmaHandler, outOfSyncShares, changeDilemmaHandler, lineDelimiterFailures, encodingFailures, nonAtomicCommitOffers, missingRequiredChangesDilemmaHandler, unmergedChangesDilemmaHandler){
            BackupDilemmaHandler backupDilemmaHandler;
            OutOfSyncDilemmaHandler oosDilemmaHandler;
            CommitDilemmaHandler commitDilemmaHandler;
            int uncheckedinChangesInstruction;
            int missingRequiredChangesInstruction;
            int unmergedChangesInstruction;
            {
                this.backupDilemmaHandler = BackupUtil.getBackupDilemmaHandler(parmsBackupDilemmaHandler, list);
                this.oosDilemmaHandler = VerifyOutOfSyncUtil.getOutOfSyncDilemmaHandler(parmsOutOfSyncInstructions, list2, this.backupDilemmaHandler);
                this.commitDilemmaHandler = CommitUtil.getCommitDilemmaHandler(parmsPendingChangesDilemmaHandler, this.oosDilemmaHandler, this.backupDilemmaHandler, (List<LineDelimiterErrorDTO>)list3, (List<EncodingErrorDTO>)list4, (List<NonAtomicCheckInDTO>)list5);
                this.uncheckedinChangesInstruction = CommitUtil.getUncheckedInChangesInstruction(parmsPendingChangesDilemmaHandler);
                this.missingRequiredChangesInstruction = ConflictResolutionUtil.getInstruction(string);
                this.unmergedChangesInstruction = ConflictResolutionUtil.getInstruction(string2);
            }

            public int missingRequiredChanges(Collection<ILogicalChange> requiredChanges) {
                if (missingRequiredChanges != null) {
                    for (ILogicalChange change : requiredChanges) {
                        ConflictedChangeDTO conflictedChange = ConflictResolutionUtil.translateConflictedChange(change);
                        missingRequiredChanges.add(conflictedChange);
                    }
                }
                return this.missingRequiredChangesInstruction;
            }

            public int uncheckedInChanges(Collection<ILocalChange> changes) {
                if (uncheckedInPendingChanges != null) {
                    HashSet<ConfigurationDescriptor> configurations = new HashSet<ConfigurationDescriptor>();
                    for (ILocalChange uncheckedInChange : changes) {
                        ConfigurationDescriptor descriptor = new ConfigurationDescriptor(repository.getId(), repository.getRepositoryURI(), uncheckedInChange.getConnection(), uncheckedInChange.getComponent());
                        configurations.add(descriptor);
                    }
                    for (ConfigurationDescriptor descriptor : configurations) {
                        uncheckedInPendingChanges.add(CoreUtil.translateConfigurationDescriptor(descriptor));
                    }
                }
                return this.uncheckedinChangesInstruction;
            }

            public int unmergedChanges(Collection<ILogicalChange> changes) {
                if (unmergedChanges != null) {
                    for (ILogicalChange change : changes) {
                        ConflictedChangeDTO conflictedChange = ConflictResolutionUtil.translateConflictedChange(change);
                        unmergedChanges.add(conflictedChange);
                    }
                }
                return this.unmergedChangesInstruction;
            }

            public int lineDelimiterErrors(Collection<? extends ILineDelimiterUploadFailure> failedFiles, IProgressMonitor monitor) throws FileSystemClientException {
                return this.commitDilemmaHandler.lineDelimiterErrors(failedFiles, monitor);
            }

            public OutOfSyncDilemmaHandler getOutOfSyncDilemmaHandler() {
                return this.oosDilemmaHandler;
            }

            public BackupDilemmaHandler getBackupDilemmaHandler() {
                return this.backupDilemmaHandler;
            }

            public int nonAtomicCommit(IWorkspaceConnection workspace, int numChanges, int numUploads) {
                return this.commitDilemmaHandler.nonAtomicCommit(workspace, numChanges, numUploads);
            }
        };
        return dilemmaHandler;
    }

    private static MarkAsMergedOperation prepareMarkAsMergedOperation(ParmsResolveAsMerged parms, MarkAsMergedDilemmaHandler dilemmaHandler, IProgressMonitor progress) throws TeamRepositoryException {
        MarkAsMergedOperation op;
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)100);
        IWorkspaceConnection wc = parms.workspace.getWorkspaceConnection((IProgressMonitor)monitor.newChild(10));
        ILogicalConflictReport conflictReport = ConflictResolutionUtil.getLogicalConflictReport(wc, (IProgressMonitor)monitor.newChild(10));
        Collection<ILogicalChange> changes = ConflictResolutionUtil.getChanges(conflictReport, parms.conflictsToResolve, RESOLVE_WITH_PROPOSED);
        try {
            op = new MarkAsMergedOperation(wc, conflictReport, changes, dilemmaHandler);
        }
        catch (FileSystemClientException e) {
            throw new TeamRepositoryException(CommonUtil.getErrorMessage((FileSystemClientException)e), (Throwable)e);
        }
        CommitUtil.configureCommit(parms.pendingChangesDilemmaHandler, (ICheckinOptions)op);
        return op;
    }

    public static ResolveWithProposedResultDTO resolveWithProposed(ParmsResolveWithProposed parms, IProgressMonitor progress) throws TeamRepositoryException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)100);
        ResolveWithProposedResultDTO result = FilesystemRestClientDTOconflictFactory.eINSTANCE.createResolveWithProposedResultDTO();
        ApplyAcceptedDilemmaHandler dilemmaHandler = ConflictResolutionUtil.getApplyAcceptedDilemmaHandler(parms.outOfSyncInstructions, result.getOutOfSyncShares(), parms.missingRequiredChangesDilemmaHandler, result.getMissingRequiredChanges(), parms.backupDilemmaHandler, result.getBackedUpToShed());
        ApplyAcceptedOperation op = ConflictResolutionUtil.prepareApplyAcceptedOperation(parms, dilemmaHandler, (IProgressMonitor)monitor.newChild(10));
        try {
            op.run((IProgressMonitor)monitor.newChild(90));
        }
        catch (FileSystemClientException e) {
            throw new TeamRepositoryException(CommonUtil.getErrorMessage((FileSystemClientException)e), (Throwable)e);
        }
        catch (OperationCanceledException operationCanceledException) {
            result.setCancelled(true);
        }
        return result;
    }

    private static ApplyAcceptedDilemmaHandler getApplyAcceptedDilemmaHandler(ParmsOutOfSyncInstructions outOfSyncDilemmaHandler, List<ShareDTO> outOfSyncShares, String missingRequiredChangesDilemmaHandler, final List<ConflictedChangeDTO> missingRequiredChanges, ParmsBackupDilemmaHandler parmsBackupDilemmaHandler, List<BackupInShedDTO> backedUpInShed) {
        ApplyAcceptedDilemmaHandler dilemmaHandler = new ApplyAcceptedDilemmaHandler(parmsBackupDilemmaHandler, backedUpInShed, outOfSyncDilemmaHandler, outOfSyncShares, missingRequiredChangesDilemmaHandler){
            BackupDilemmaHandler backupDilemmaHandler;
            OutOfSyncDilemmaHandler oosDilemmaHandler;
            int missingRequiredChangesInstruction;
            {
                this.backupDilemmaHandler = BackupUtil.getBackupDilemmaHandler(parmsBackupDilemmaHandler, list);
                this.oosDilemmaHandler = VerifyOutOfSyncUtil.getOutOfSyncDilemmaHandler(parmsOutOfSyncInstructions, list2, this.backupDilemmaHandler);
                this.missingRequiredChangesInstruction = ConflictResolutionUtil.getInstruction(string);
            }

            public int missingRequiredChanges(Collection<ILogicalChange> requiredChanges) {
                if (missingRequiredChanges != null) {
                    for (ILogicalChange change : requiredChanges) {
                        ConflictedChangeDTO conflictedChange = ConflictResolutionUtil.translateConflictedChange(change);
                        missingRequiredChanges.add(conflictedChange);
                    }
                }
                return this.missingRequiredChangesInstruction;
            }

            public OutOfSyncDilemmaHandler getOutOfSyncDilemmaHandler() {
                return this.oosDilemmaHandler;
            }

            public BackupDilemmaHandler getBackupDilemmaHandler() {
                return this.backupDilemmaHandler;
            }
        };
        return dilemmaHandler;
    }

    private static ApplyAcceptedOperation prepareApplyAcceptedOperation(ParmsResolveWithProposed parms, ApplyAcceptedDilemmaHandler dilemmaHandler, IProgressMonitor progress) throws TeamRepositoryException {
        ApplyAcceptedOperation op;
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)100);
        IWorkspaceConnection wc = parms.workspace.getWorkspaceConnection((IProgressMonitor)monitor.newChild(10));
        ILogicalConflictReport conflictReport = ConflictResolutionUtil.getLogicalConflictReport(wc, (IProgressMonitor)monitor.newChild(10));
        ArrayList<ILogicalChange> changes = new ArrayList<ILogicalChange>();
        ArrayList<IFolderHandle> parentFolders = new ArrayList<IFolderHandle>();
        ArrayList<String> names = new ArrayList<String>();
        ConflictResolutionUtil.getChanges(wc.teamRepository(), conflictReport, parms.conflictsToResolve, changes, parentFolders, names, RESOLVE_WITH_PROPOSED);
        try {
            op = new ApplyAcceptedOperation(wc, conflictReport, changes, dilemmaHandler);
            Iterator iParentFolders = parentFolders.iterator();
            Iterator iNames = names.iterator();
            for (ILogicalChange change : changes) {
                if (!(change instanceof ILogicalConflict)) continue;
                IFolderHandle parentFolder = (IFolderHandle)iParentFolders.next();
                String name = (String)iNames.next();
                if (parentFolder == null) continue;
                op.setParentForResolution((ILogicalConflict)change, parentFolder, name);
            }
        }
        catch (FileSystemClientException e) {
            throw new TeamRepositoryException(CommonUtil.getErrorMessage((FileSystemClientException)e), (Throwable)e);
        }
        return op;
    }

    private static ILogicalConflictReport getLogicalConflictReport(IWorkspaceConnection workspace, IProgressMonitor monitor) throws TeamRepositoryException {
        ILogicalConflictReport conflictReport = SyncCache.get().fetch((IWorkspaceConnection)workspace, (IProgressMonitor)monitor).logicalConflictReport;
        return conflictReport;
    }

    private static void getChanges(ITeamRepository repo, ILogicalConflictReport conflictReport, ParmsConflictsToResolveWithProposed[] conflictsToResolve, List<ILogicalChange> logicalChanges, List<IFolderHandle> parentFolders, List<String> names, String requestName) {
        HashMap<UUID, HashMap<UUID, Collection<ILogicalChange>>> organizedConflictReport = new HashMap<UUID, HashMap<UUID, Collection<ILogicalChange>>>();
        ConflictResolutionUtil.organizeConflicts(conflictReport.autoMergeChanges(), organizedConflictReport);
        ConflictResolutionUtil.organizeConflicts(conflictReport.incidentalChanges(), organizedConflictReport);
        ConflictResolutionUtil.organizeConflicts(conflictReport.conflicts(), organizedConflictReport);
        ParmsConflictsToResolveWithProposed[] parmsConflictsToResolveWithProposedArray = conflictsToResolve;
        int n = conflictsToResolve.length;
        int n2 = 0;
        while (n2 < n) {
            Collection<ILogicalChange> conflicts;
            HashMap<UUID, Collection<ILogicalChange>> conflictedVersionables;
            ParmsConflictsToResolveWithProposed conflictToResolve = parmsConflictsToResolveWithProposedArray[n2];
            int kind = ConflictResolutionUtil.getKind(conflictToResolve.kind);
            int conflictType = -1;
            if (kind == 1) {
                conflictType = ConflictResolutionUtil.getConflictType(conflictToResolve.conflictType, requestName);
            }
            if ((conflictedVersionables = organizedConflictReport.get(UUID.valueOf((String)conflictToResolve.componentItemId))) != null && (conflicts = conflictedVersionables.get(UUID.valueOf((String)conflictToResolve.versionableItemId))) != null) {
                for (ILogicalChange change : conflicts) {
                    if (change.kind() != kind) continue;
                    if (kind == 1) {
                        if (((ILogicalConflict)change).conflictType() != conflictType) continue;
                        logicalChanges.add(change);
                        if (conflictToResolve.newName != null && conflictToResolve.newName.length() > 0) {
                            IFolderHandle parent = (IFolderHandle)IFolder.ITEM_TYPE.createItemHandle((Object)repo, UUID.valueOf((String)conflictToResolve.newParentFolderItemId), null);
                            parentFolders.add(parent);
                            names.add(conflictToResolve.newName);
                            continue;
                        }
                        parentFolders.add(null);
                        names.add(null);
                        continue;
                    }
                    logicalChanges.add(change);
                    parentFolders.add(null);
                    names.add(null);
                }
            }
            ++n2;
        }
    }

    private static Collection<ILogicalChange> getChanges(ILogicalConflictReport conflictReport, ParmsConflictsToResolve[] conflictsToResolve, String requestName) {
        ArrayList<ILogicalChange> logicalChanges = new ArrayList<ILogicalChange>(conflictsToResolve.length);
        HashMap<UUID, HashMap<UUID, Collection<ILogicalChange>>> organizedConflictReport = new HashMap<UUID, HashMap<UUID, Collection<ILogicalChange>>>();
        ConflictResolutionUtil.organizeConflicts(conflictReport.autoMergeChanges(), organizedConflictReport);
        ConflictResolutionUtil.organizeConflicts(conflictReport.incidentalChanges(), organizedConflictReport);
        ConflictResolutionUtil.organizeConflicts(conflictReport.conflicts(), organizedConflictReport);
        ParmsConflictsToResolve[] parmsConflictsToResolveArray = conflictsToResolve;
        int n = conflictsToResolve.length;
        int n2 = 0;
        while (n2 < n) {
            Collection<ILogicalChange> conflicts;
            HashMap<UUID, Collection<ILogicalChange>> conflictedVersionables;
            ParmsConflictsToResolve conflictToResolve = parmsConflictsToResolveArray[n2];
            int kind = ConflictResolutionUtil.getKind(conflictToResolve.kind);
            int conflictType = -1;
            if (kind == 1) {
                conflictType = ConflictResolutionUtil.getConflictType(conflictToResolve.conflictType, requestName);
            }
            if ((conflictedVersionables = organizedConflictReport.get(UUID.valueOf((String)conflictToResolve.componentItemId))) != null && (conflicts = conflictedVersionables.get(UUID.valueOf((String)conflictToResolve.versionableItemId))) != null) {
                for (ILogicalChange change : conflicts) {
                    if (change.kind() != kind) continue;
                    if (kind == 1) {
                        if (((ILogicalConflict)change).conflictType() != conflictType) continue;
                        logicalChanges.add(change);
                        continue;
                    }
                    logicalChanges.add(change);
                }
            }
            ++n2;
        }
        return logicalChanges;
    }

    private static int getKind(String kind) {
        if (kind.equals("conflict")) {
            return 1;
        }
        if (kind.equals("incidental")) {
            return 3;
        }
        if (kind.equals("autoresolve")) {
            return 2;
        }
        throw new IllegalArgumentException(NLS.bind((String)"Invalid kind : {0} was supplied", (Object)kind, (Object[])new Object[0]));
    }

    private static int getConflictType(String conflictType, String requestName) {
        if ("add_add".equals(conflictType)) {
            return 1;
        }
        if ("add_delete".equals(conflictType)) {
            return 2;
        }
        if ("delete_add".equals(conflictType)) {
            return 3;
        }
        if ("delete_move".equals(conflictType)) {
            return 4;
        }
        if ("delete_modify".equals(conflictType)) {
            return 5;
        }
        if ("move_move".equals(conflictType)) {
            return 6;
        }
        if ("move_add".equals(conflictType)) {
            return 7;
        }
        if ("move_delete".equals(conflictType)) {
            return 8;
        }
        if ("modify_modify".equals(conflictType)) {
            return 9;
        }
        if ("modify_delete".equals(conflictType)) {
            return 10;
        }
        throw new IllegalArgumentException(NLS.bind((String)"Invalid conflictType : {0} was supplied", (Object)conflictType, (Object[])new Object[0]));
    }

    public static String getKind(ILogicalChange logicalChange) {
        if (logicalChange.kind() == 1) {
            return "conflict";
        }
        if (logicalChange.kind() == 3) {
            return "incidental";
        }
        if (logicalChange.kind() == 2) {
            return "autoresolve";
        }
        return null;
    }

    public static String getConflictType(ILogicalChange logicalChange) {
        if (logicalChange.kind() == 1) {
            int conflictType = ((ILogicalConflict)logicalChange).conflictType();
            if (conflictType == 1) {
                return "add_add";
            }
            if (conflictType == 2) {
                return "add_delete";
            }
            if (conflictType == 3) {
                return "delete_add";
            }
            if (conflictType == 4) {
                return "delete_move";
            }
            if (conflictType == 5) {
                return "delete_modify";
            }
            if (conflictType == 6) {
                return "move_move";
            }
            if (conflictType == 7) {
                return "move_add";
            }
            if (conflictType == 8) {
                return "move_delete";
            }
            if (conflictType == 9) {
                return "modify_modify";
            }
            if (conflictType == 10) {
                return "modify_delete";
            }
        }
        return null;
    }

    private static void organizeConflicts(Collection<ILogicalChange> changes, HashMap<UUID, HashMap<UUID, Collection<ILogicalChange>>> organizedConflictReport) {
        for (ILogicalChange change : changes) {
            Collection<ILogicalChange> conflicts;
            HashMap<Object, Collection<Object>> conflictedVersionables = organizedConflictReport.get(change.component().getItemId());
            if (conflictedVersionables == null) {
                conflictedVersionables = new HashMap();
                organizedConflictReport.put(change.component().getItemId(), conflictedVersionables);
            }
            if ((conflicts = conflictedVersionables.get(change.item().getItemId())) == null) {
                conflicts = new ArrayList<ILogicalChange>(2);
                conflictedVersionables.put(change.item().getItemId(), conflicts);
            }
            conflicts.add(change);
        }
    }

    private static ConflictedChangeDTO translateConflictedChange(ILogicalChange change) {
        ConflictedChangeDTO conflictedChange = FilesystemRestClientDTOconflictFactory.eINSTANCE.createConflictedChangeDTO();
        conflictedChange.setComponentItemId(change.component().getItemId().getUuidValue());
        conflictedChange.setVersionableItemId(change.item().getItemId().getUuidValue());
        conflictedChange.setVersionableItemType(CoreUtil.getVersionableItemType(change.item()));
        if (change.kind() == 1) {
            conflictedChange.setKind("conflict");
            ILogicalConflict conflict = (ILogicalConflict)change;
            if (conflict.conflictType() == 1) {
                conflictedChange.setConflictType("add_add");
            } else if (conflict.conflictType() == 2) {
                conflictedChange.setConflictType("add_delete");
            } else if (conflict.conflictType() == 3) {
                conflictedChange.setConflictType("delete_add");
            } else if (conflict.conflictType() == 5) {
                conflictedChange.setConflictType("delete_modify");
            } else if (conflict.conflictType() == 4) {
                conflictedChange.setConflictType("delete_move");
            } else if (conflict.conflictType() == 10) {
                conflictedChange.setConflictType("modify_delete");
            } else if (conflict.conflictType() == 9) {
                conflictedChange.setConflictType("modify_modify");
            } else if (conflict.conflictType() == 7) {
                conflictedChange.setConflictType("move_add");
            } else if (conflict.conflictType() == 8) {
                conflictedChange.setConflictType("move_delete");
            } else if (conflict.conflictType() == 6) {
                conflictedChange.setConflictType("move_move");
            }
        } else if (change.kind() == 3) {
            conflictedChange.setKind("incidental");
        } else if (change.kind() == 2) {
            conflictedChange.setKind("autoresolve");
        }
        if (change.isChangeType(8)) {
            conflictedChange.setPath(CoreUtil.translatePath(change.getNewPathHint()));
        } else {
            conflictedChange.setPath(CoreUtil.translatePath(change.getPathHint()));
        }
        return conflictedChange;
    }

    private static int getInstruction(String dilemmaInstruction) {
        if ("continue".equals(dilemmaInstruction)) {
            return 0;
        }
        if ("cancel".equals(dilemmaInstruction)) {
            return 1;
        }
        return 2;
    }

    public static ResolveWithProposedEvaluationDTO evaluateResolveWithProposed(ParmsResolveWithProposed parms, IProgressMonitor progress) throws TeamRepositoryException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)100);
        ResolveWithProposedEvaluationDTO result = FilesystemRestClientDTOconflictFactory.eINSTANCE.createResolveWithProposedEvaluationDTO();
        ApplyAcceptedDilemmaHandler dilemmaHandler = ConflictResolutionUtil.getApplyAcceptedDilemmaHandler(parms.outOfSyncInstructions, null, parms.missingRequiredChangesDilemmaHandler, null, parms.backupDilemmaHandler, null);
        ApplyAcceptedOperation op = ConflictResolutionUtil.prepareApplyAcceptedOperation(parms, dilemmaHandler, (IProgressMonitor)monitor.newChild(10));
        for (ILogicalChange change : op.needContentToRemoved()) {
            result.getNeedContentToRemoved().add(ConflictResolutionUtil.translateConflictedChange(change));
        }
        for (ILogicalChange change : op.needParentForResolution()) {
            result.getNeedParentForResolution().add(ConflictResolutionUtil.translateConflictedChange(change));
        }
        return result;
    }
}

