/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.rcp.core.internal.rest.util;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.FileSystemCore;
import com.ibm.team.filesystem.client.ILocalChange;
import com.ibm.team.filesystem.client.ILocalChangeManager;
import com.ibm.team.filesystem.client.IOperationFactory;
import com.ibm.team.filesystem.client.ISandbox;
import com.ibm.team.filesystem.client.IShare;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.ResourceType;
import com.ibm.team.filesystem.client.internal.Shareable;
import com.ibm.team.filesystem.client.internal.SharingManager;
import com.ibm.team.filesystem.client.internal.rest.CommonUtil;
import com.ibm.team.filesystem.client.internal.utils.ConfigurationDescriptor;
import com.ibm.team.filesystem.client.internal.utils.PathUtils;
import com.ibm.team.filesystem.client.operations.BackupDilemmaHandler;
import com.ibm.team.filesystem.client.operations.CommitDilemmaHandler;
import com.ibm.team.filesystem.client.operations.ICheckinOperation;
import com.ibm.team.filesystem.client.operations.ICheckinOptions;
import com.ibm.team.filesystem.client.operations.IEncodingUploadFailure;
import com.ibm.team.filesystem.client.operations.ILineDelimiterUploadFailure;
import com.ibm.team.filesystem.client.operations.IRefreshingOperation;
import com.ibm.team.filesystem.client.operations.OutOfSyncDilemmaHandler;
import com.ibm.team.filesystem.client.rest.parameters.ParmsCheckInChanges;
import com.ibm.team.filesystem.client.rest.parameters.ParmsCheckInComponentRequest;
import com.ibm.team.filesystem.client.rest.parameters.ParmsCheckInOptions;
import com.ibm.team.filesystem.client.rest.parameters.ParmsCheckInShareablesRequest;
import com.ibm.team.filesystem.client.rest.parameters.ParmsCheckInVersionablesRequest;
import com.ibm.team.filesystem.client.rest.parameters.ParmsCommitDilemmaHandler;
import com.ibm.team.filesystem.client.rest.parameters.ParmsPendingChangesDilemmaHandler;
import com.ibm.team.filesystem.common.internal.rest.client.changeset.CheckInResultDTO;
import com.ibm.team.filesystem.common.internal.rest.client.changeset.FilesystemRestClientDTOchangesetFactory;
import com.ibm.team.filesystem.common.internal.rest.client.changeset.NonAtomicCheckInDTO;
import com.ibm.team.filesystem.common.internal.rest.client.resource.EncodingErrorDTO;
import com.ibm.team.filesystem.common.internal.rest.client.resource.LineDelimiterErrorDTO;
import com.ibm.team.filesystem.rcp.core.internal.Messages;
import com.ibm.team.filesystem.rcp.core.internal.rest.util.BackupUtil;
import com.ibm.team.filesystem.rcp.core.internal.rest.util.EncodingErrorHandler;
import com.ibm.team.filesystem.rcp.core.internal.rest.util.RefreshUtil;
import com.ibm.team.filesystem.rcp.core.internal.rest.util.ResourceUtil;
import com.ibm.team.filesystem.rcp.core.internal.rest.util.VerifyOutOfSyncUtil;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IChangeSetHandle;
import com.ibm.team.scm.common.IComponentHandle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommitUtil {
    public static CheckInResultDTO checkInChanges(ParmsCheckInChanges parms, IProgressMonitor progress) throws TeamRepositoryException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)100);
        CheckInResultDTO result = FilesystemRestClientDTOchangesetFactory.eINSTANCE.createCheckInResultDTO();
        BackupDilemmaHandler backupDilemmaHandler = BackupUtil.getBackupDilemmaHandler(parms.backupDilemmaHandler, result.getBackedUpToShed());
        OutOfSyncDilemmaHandler outOfSyncDilemmaHandler = VerifyOutOfSyncUtil.getOutOfSyncDilemmaHandler(parms.outOfSyncInstructions, result.getOutOfSyncShares(), backupDilemmaHandler);
        CommitDilemmaHandler commitDilemmaHandler = CommitUtil.getCommitDilemmaHandler(parms.commitDilemmaHandler, outOfSyncDilemmaHandler, backupDilemmaHandler, (List<LineDelimiterErrorDTO>)result.getLineDelimiterFailures(), (List<EncodingErrorDTO>)result.getEncodingFailures(), (List<NonAtomicCheckInDTO>)result.getNonAtomicCheckInOffers());
        try {
            ICheckinOperation commitOp;
            try {
                commitOp = CommitUtil.getCommitOp(parms, commitDilemmaHandler, (IProgressMonitor)monitor.newChild(1));
            }
            catch (FileSystemClientException e) {
                throw new TeamRepositoryException(CommonUtil.getErrorMessage((FileSystemClientException)e), (Throwable)e);
            }
            if (commitOp != null) {
                commitOp.run((IProgressMonitor)monitor.newChild(80));
                for (IChangeSetHandle changeSetHandle : commitOp.getCommittedChangeSets()) {
                    result.getChangeSetsCommitted().add(changeSetHandle.getItemId().getUuidValue());
                }
            }
        }
        catch (FileSystemClientException e) {
            throw new TeamRepositoryException(CommonUtil.getErrorMessage((FileSystemClientException)e), (Throwable)e);
        }
        catch (OperationCanceledException operationCanceledException) {
            result.setCancelled(true);
        }
        return result;
    }

    private static ICheckinOperation getCommitOp(ParmsCheckInChanges parms, CommitDilemmaHandler commitDilemmaHandler, IProgressMonitor monitor) throws TeamRepositoryException, FileSystemClientException {
        ParmsCheckInVersionablesRequest request;
        int n;
        int n2;
        ParmsCheckInVersionablesRequest[] parmsCheckInVersionablesRequestArray;
        ICheckinOperation commitOp = IOperationFactory.instance.getCheckinOperation(commitDilemmaHandler);
        CommitUtil.configureCommit(parms.checkInOptions, (ICheckinOptions)commitOp);
        int total = 0;
        total += parms.versionables == null ? 0 : parms.versionables.length;
        total += parms.paths == null ? 0 : parms.paths.length;
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)(total += parms.components == null ? 0 : parms.paths.length));
        if (parms.versionables != null) {
            parmsCheckInVersionablesRequestArray = parms.versionables;
            n2 = parms.versionables.length;
            n = 0;
            while (n < n2) {
                request = parmsCheckInVersionablesRequestArray[n];
                CommitUtil.addRequest(commitOp, request, (IProgressMonitor)subMonitor.newChild(1));
                ++n;
            }
        }
        if (parms.paths != null) {
            parmsCheckInVersionablesRequestArray = parms.paths;
            n2 = parms.paths.length;
            n = 0;
            while (n < n2) {
                request = parmsCheckInVersionablesRequestArray[n];
                CommitUtil.addRequest(commitOp, (ParmsCheckInShareablesRequest)request, (IProgressMonitor)subMonitor.newChild(1));
                ++n;
            }
        }
        if (parms.components != null) {
            parmsCheckInVersionablesRequestArray = parms.components;
            n2 = parms.components.length;
            n = 0;
            while (n < n2) {
                request = parmsCheckInVersionablesRequestArray[n];
                CommitUtil.addRequest(commitOp, (ParmsCheckInComponentRequest)request, (IProgressMonitor)subMonitor.newChild(1));
                ++n;
            }
        }
        RefreshUtil.configureRefresh(parms.preoperationRefresh, (IRefreshingOperation)commitOp);
        return commitOp;
    }

    private static void addRequest(ICheckinOperation commitOp, ParmsCheckInShareablesRequest parms, IProgressMonitor monitor) throws TeamRepositoryException, FileSystemClientException {
        Path sandboxPath = new Path(parms.sandboxPath);
        ArrayList<Shareable> shareableToCommit = new ArrayList<Shareable>(parms.resourcesToCheckIn.length);
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)(parms.resourcesToCheckIn.length * 2 + 5));
        int i = 0;
        while (i < parms.resourcesToCheckIn.length) {
            IPath path = sandboxPath.append(parms.resourcesToCheckIn[i]);
            ResourceType resourceType = PathUtils.getResourceType((IPath)path, (IProgressMonitor)subMonitor.newChild(1));
            if (resourceType == null) {
                throw new TeamRepositoryException(NLS.bind((String)Messages.CommitUtil_1, (Object)parms.resourcesToCheckIn[i], (Object[])new Object[0]));
            }
            Shareable shareable = new Shareable((IPath)sandboxPath, (IPath)new Path(parms.resourcesToCheckIn[i]), resourceType);
            IShare share = shareable.getShare((IProgressMonitor)subMonitor.newChild(1));
            if (share == null) {
                throw new TeamRepositoryException(NLS.bind((String)Messages.CommitUtil_2, (Object)parms.resourcesToCheckIn[i], (Object[])new Object[0]));
            }
            shareableToCommit.add(shareable);
            ++i;
        }
        SharingManager.getInstance().getIgnoreManager().flushInAbsenceOfEvents(shareableToCommit, (IProgressMonitor)subMonitor.newChild(1));
        IShareable[] shareables = shareableToCommit.toArray(new IShareable[shareableToCommit.size()]);
        IChangeSetHandle changeSet = parms.getChangeSetHandle();
        commitOp.requestCheckin(shareables, changeSet, CommitUtil.getComment(parms.newChangeSetComment), (IProgressMonitor)subMonitor.newChild(4));
    }

    private static void addRequest(ICheckinOperation commitOp, ParmsCheckInComponentRequest request, IProgressMonitor monitor) throws FileSystemClientException, TeamRepositoryException {
        ArrayList<IShareable> shareableToCommit = new ArrayList<IShareable>();
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        IWorkspaceConnection workspace = request.workspace.getWorkspaceConnection((IProgressMonitor)subMonitor.newChild(5));
        IComponentHandle component = request.getComponentHandle();
        Collection shares = SharingManager.getInstance().getShares(new ConfigurationDescriptor((IConnection)workspace, component), (IProgressMonitor)subMonitor.newChild(25));
        for (IShare share : shares) {
            shareableToCommit.add(share.getShareable());
        }
        SharingManager.getInstance().getIgnoreManager().flushInAbsenceOfEvents(shareableToCommit, (IProgressMonitor)subMonitor.newChild(5));
        IShareable[] shareables = shareableToCommit.toArray(new IShareable[shareableToCommit.size()]);
        IChangeSetHandle changeSet = request.getChangeSetHandle();
        commitOp.requestCheckin(shareables, changeSet, CommitUtil.getComment(request.newChangeSetComment), (IProgressMonitor)subMonitor.newChild(65));
    }

    private static void addRequest(ICheckinOperation commitOp, ParmsCheckInVersionablesRequest request, IProgressMonitor monitor) throws FileSystemClientException, TeamRepositoryException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        IWorkspaceConnection workspace = request.workspace.getWorkspaceConnection((IProgressMonitor)subMonitor.newChild(10));
        IComponentHandle component = request.getComponentHandle();
        SharingManager.getInstance().getIgnoreManager().flushInAbsenceOfEvents(null, (IProgressMonitor)subMonitor.newChild(5));
        HashMap<UUID, ILocalChange> localChanges = CommitUtil.getLocalChanges(workspace, component, (IProgressMonitor)subMonitor.newChild(25));
        ArrayList<ILocalChange> changesToCheckIn = new ArrayList<ILocalChange>(request.versionablesToCheckIn.length);
        int i = 0;
        while (i < request.versionablesToCheckIn.length) {
            ILocalChange change = localChanges.get(UUID.valueOf((String)request.versionablesToCheckIn[i]));
            if (change != null) {
                changesToCheckIn.add(change);
            }
            ++i;
        }
        if (!changesToCheckIn.isEmpty()) {
            IChangeSetHandle changeSet = request.getChangeSetHandle();
            commitOp.requestCheckin(workspace, component, changesToCheckIn.toArray(new ILocalChange[changesToCheckIn.size()]), changeSet, CommitUtil.getComment(request.newChangeSetComment), (IProgressMonitor)subMonitor.newChild(60));
        }
    }

    private static String getComment(String newChangeSetComment) {
        return newChangeSetComment == null ? "" : newChangeSetComment;
    }

    private static HashMap<UUID, ILocalChange> getLocalChanges(IWorkspaceConnection workspace, IComponentHandle component, IProgressMonitor monitor) throws FileSystemClientException {
        HashMap<UUID, ILocalChange> result = new HashMap<UUID, ILocalChange>();
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        Collection sandboxes = FileSystemCore.getSharingManager().getSandboxes(new ConfigurationDescriptor((IConnection)workspace, component), (IProgressMonitor)progress.newChild(10));
        progress.setWorkRemaining(10 * sandboxes.size());
        for (ISandbox sandbox : sandboxes) {
            ILocalChange[] pendingChanges;
            ILocalChangeManager lcm = FileSystemCore.getSharingManager().getLocalChangeManager();
            lcm.syncPendingChanges(workspace.getContextHandle(), component, sandbox, (IProgressMonitor)progress.newChild(10));
            ILocalChange[] iLocalChangeArray = pendingChanges = lcm.getPendingChanges(workspace.getContextHandle(), component, sandbox);
            int n = pendingChanges.length;
            int n2 = 0;
            while (n2 < n) {
                ILocalChange change = iLocalChangeArray[n2];
                result.put(change.getTarget().getItemId(), change);
                ++n2;
            }
        }
        return result;
    }

    public static final CommitDilemmaHandler getCommitDilemmaHandler(ParmsCommitDilemmaHandler commitDilemmaHandlerParms, OutOfSyncDilemmaHandler oosDilemmaHandler, BackupDilemmaHandler backupDilemmaHandler, List<LineDelimiterErrorDTO> lineDelimiterErrorsReported, List<EncodingErrorDTO> encodingErrorsReported, final List<NonAtomicCheckInDTO> nonAtomicCommitNotifications) {
        final OutOfSyncDilemmaHandler outOfSyncDilemmaHandler = oosDilemmaHandler == null ? OutOfSyncDilemmaHandler.getDefault() : oosDilemmaHandler;
        final BackupDilemmaHandler backupHandler = backupDilemmaHandler == null ? BackupDilemmaHandler.getDefault() : backupDilemmaHandler;
        final ResourceUtil.LineDelimiterErrorHandler lineDelimiterErrorHandler = commitDilemmaHandlerParms == null ? new ResourceUtil.LineDelimiterErrorHandler(null, lineDelimiterErrorsReported) : new ResourceUtil.LineDelimiterErrorHandler(commitDilemmaHandlerParms.lineDelimiterDilemmaHandler, lineDelimiterErrorsReported);
        final EncodingErrorHandler encodingErrorHandler = commitDilemmaHandlerParms == null || commitDilemmaHandlerParms.encodingDilemmaHandler == null ? new EncodingErrorHandler(encodingErrorsReported) : new EncodingErrorHandler(commitDilemmaHandlerParms.encodingDilemmaHandler, encodingErrorsReported);
        final int nonAtomicCommitInstruction = commitDilemmaHandlerParms == null || commitDilemmaHandlerParms.nonAtomicCommitInstruction == null ? 0 : CommitUtil.getInstruction(commitDilemmaHandlerParms.nonAtomicCommitInstruction);
        CommitDilemmaHandler commitDilemmaHandler = new CommitDilemmaHandler(){

            public OutOfSyncDilemmaHandler getOutOfSyncDilemmaHandler() {
                return outOfSyncDilemmaHandler;
            }

            public int lineDelimiterErrors(Collection<? extends ILineDelimiterUploadFailure> failedFiles, IProgressMonitor monitor) throws FileSystemClientException {
                return lineDelimiterErrorHandler.lineDelimiterErrors(failedFiles, monitor);
            }

            public BackupDilemmaHandler getBackupDilemmaHandler() {
                return backupHandler;
            }

            public int encodingErrors(Collection<? extends IEncodingUploadFailure> failedUploads, IProgressMonitor monitor) {
                try {
                    Collection<? extends IEncodingUploadFailure> remainingFailures = encodingErrorHandler.applyDetailedInstructions(failedUploads);
                    if (!remainingFailures.isEmpty() && encodingErrorHandler.isPerformDefault()) {
                        super.encodingErrors(failedUploads, monitor);
                    }
                    for (IEncodingUploadFailure iEncodingUploadFailure : failedUploads) {
                        if (iEncodingUploadFailure.hasDirection()) continue;
                        int n = encodingErrorHandler.getDirection();
                        return n;
                    }
                }
                finally {
                    encodingErrorHandler.recordUploadFailures(failedUploads);
                }
                return 0;
            }

            public int nonAtomicCommit(IWorkspaceConnection workspace, int numChanges, int numUploads) {
                if (nonAtomicCommitNotifications != null) {
                    nonAtomicCommitNotifications.add(CommitUtil.translateNonAtomicCommit(workspace, numChanges, numUploads));
                }
                return nonAtomicCommitInstruction;
            }
        };
        return commitDilemmaHandler;
    }

    public static NonAtomicCheckInDTO translateNonAtomicCommit(IWorkspaceConnection workspace, int numChanges, int numUploads) {
        NonAtomicCheckInDTO result = FilesystemRestClientDTOchangesetFactory.eINSTANCE.createNonAtomicCheckInDTO();
        result.setRepositoryURL(workspace.teamRepository().getRepositoryURI());
        result.setWorkspaceItemId(workspace.getResolvedWorkspace().getItemId().getUuidValue());
        result.setNumChanges(numChanges);
        result.setNumUploads(numUploads);
        return result;
    }

    public static int getUncheckedInChangesInstruction(ParmsPendingChangesDilemmaHandler changeDilemmaHandlerParm) {
        int uncheckedInChangesInstruction = 2;
        if (changeDilemmaHandlerParm != null) {
            uncheckedInChangesInstruction = CommitUtil.getInstruction(changeDilemmaHandlerParm.pendingChangesInstruction);
        }
        return uncheckedInChangesInstruction;
    }

    private static int getInstruction(String instruction) {
        int uncheckedInChangesInstruction = 2;
        if ("continue".equals(instruction)) {
            uncheckedInChangesInstruction = 0;
        } else if (instruction == null) {
            uncheckedInChangesInstruction = 2;
        } else if ("cancel".equals(instruction)) {
            uncheckedInChangesInstruction = 1;
        } else if ("fail".equals(instruction)) {
            uncheckedInChangesInstruction = 2;
        } else if ("no".equals(instruction)) {
            uncheckedInChangesInstruction = 3;
        } else {
            throw new IllegalArgumentException("The value of uncheckedInChangesInstruction must be one of cancel, continue, no or fail");
        }
        return uncheckedInChangesInstruction;
    }

    public static CommitDilemmaHandler getCommitDilemmaHandler(ParmsPendingChangesDilemmaHandler pendingChangesDilemmaHandler, OutOfSyncDilemmaHandler outOfSyncDilemmaHandler, BackupDilemmaHandler backupDilemmaHandler, List<LineDelimiterErrorDTO> lineDelimiterErrors, List<EncodingErrorDTO> encodingErrors, List<NonAtomicCheckInDTO> nonAtomicCheckinNotifications) {
        if (pendingChangesDilemmaHandler == null) {
            return CommitUtil.getCommitDilemmaHandler(null, outOfSyncDilemmaHandler, backupDilemmaHandler, lineDelimiterErrors, encodingErrors, nonAtomicCheckinNotifications);
        }
        return CommitUtil.getCommitDilemmaHandler(pendingChangesDilemmaHandler.commitDilemmaHandler, outOfSyncDilemmaHandler, backupDilemmaHandler, lineDelimiterErrors, encodingErrors, nonAtomicCheckinNotifications);
    }

    public static void configureCommit(ParmsPendingChangesDilemmaHandler parms, ICheckinOptions operation) {
        if (parms == null) {
            CommitUtil.configureCommit(null, operation);
        } else {
            CommitUtil.configureCommit(parms.checkInOptions, operation);
        }
    }

    public static void configureCommit(ParmsCheckInOptions parms, ICheckinOptions operation) {
        if (parms == null) {
            operation.enableNonAtomicCommit(200);
        } else if (parms.allowNonAtomicCommit.booleanValue()) {
            operation.enableNonAtomicCommit(parms.numberOfUploads);
        } else {
            operation.disableNonAtomicCommit();
        }
    }
}

