/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.rcp.core.internal.rest.util;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.ILocalChange;
import com.ibm.team.filesystem.client.IOperationFactory;
import com.ibm.team.filesystem.client.internal.rest.CommonUtil;
import com.ibm.team.filesystem.client.internal.utils.ConfigurationDescriptor;
import com.ibm.team.filesystem.client.operations.BackupDilemmaHandler;
import com.ibm.team.filesystem.client.operations.CommitDilemmaHandler;
import com.ibm.team.filesystem.client.operations.CreateBaselineDilemmaHandler;
import com.ibm.team.filesystem.client.operations.ICheckinOptions;
import com.ibm.team.filesystem.client.operations.ICreateBaselineOperation;
import com.ibm.team.filesystem.client.operations.IRefreshingOperation;
import com.ibm.team.filesystem.client.operations.OutOfSyncDilemmaHandler;
import com.ibm.team.filesystem.client.rest.parameters.ParmsCreateBaselineDilemmaHandler;
import com.ibm.team.filesystem.client.rest.parameters.ParmsCreateBaselineRequest;
import com.ibm.team.filesystem.client.rest.parameters.ParmsCreateBaselineSet;
import com.ibm.team.filesystem.client.rest.parameters.ParmsCreateBaselines;
import com.ibm.team.filesystem.client.rest.parameters.ParmsGetBaselines;
import com.ibm.team.filesystem.client.rest.parameters.ParmsRemoveBaselineSet;
import com.ibm.team.filesystem.client.rest.parameters.ParmsUpdateBaseline;
import com.ibm.team.filesystem.client.rest.parameters.ParmsUpdateBaselineSet;
import com.ibm.team.filesystem.client.rest.parameters.ParmsWorkspace;
import com.ibm.team.filesystem.common.internal.rest.client.changeset.BackupInShedDTO;
import com.ibm.team.filesystem.common.internal.rest.client.changeset.NonAtomicCheckInDTO;
import com.ibm.team.filesystem.common.internal.rest.client.core.BaselineSetDTO;
import com.ibm.team.filesystem.common.internal.rest.client.core.ConfigurationDescriptorDTO;
import com.ibm.team.filesystem.common.internal.rest.client.resource.EncodingErrorDTO;
import com.ibm.team.filesystem.common.internal.rest.client.resource.LineDelimiterErrorDTO;
import com.ibm.team.filesystem.common.internal.rest.client.sync.FilesystemRestClientDTOsyncFactory;
import com.ibm.team.filesystem.common.internal.rest.client.sync.GetBaselineSetsDTO;
import com.ibm.team.filesystem.common.internal.rest.client.sync.GetBaselinesDTO;
import com.ibm.team.filesystem.common.internal.rest.client.workspace.CreateBaselineResultDTO;
import com.ibm.team.filesystem.common.internal.rest.client.workspace.CreateBaselineSetResultDTO;
import com.ibm.team.filesystem.common.internal.rest.client.workspace.FilesystemRestClientDTOworkspaceFactory;
import com.ibm.team.filesystem.rcp.core.internal.rest.util.BackupUtil;
import com.ibm.team.filesystem.rcp.core.internal.rest.util.CommitUtil;
import com.ibm.team.filesystem.rcp.core.internal.rest.util.CoreUtil;
import com.ibm.team.filesystem.rcp.core.internal.rest.util.RefreshUtil;
import com.ibm.team.filesystem.rcp.core.internal.rest.util.VerifyOutOfSyncUtil;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.rcp.common.NullUtil;
import com.ibm.team.scm.client.IBaselineConnection;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.IWorkspaceManager;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.common.ComponentNotInWorkspaceException;
import com.ibm.team.scm.common.IBaseline;
import com.ibm.team.scm.common.IBaselineHandle;
import com.ibm.team.scm.common.IBaselineSet;
import com.ibm.team.scm.common.IBaselineSetHandle;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IComponentInfo;
import com.ibm.team.scm.common.dto.IBaselineSearchCriteria;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BaselineUtil {
    public static CreateBaselineResultDTO createBaselines(ParmsCreateBaselines parms, IProgressMonitor progress) throws TeamRepositoryException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)100);
        CreateBaselineResultDTO result = FilesystemRestClientDTOworkspaceFactory.eINSTANCE.createCreateBaselineResultDTO();
        CreateBaselineDilemmaHandler dilemmaHandler = BaselineUtil.getCreateBaselineDilemmaHandler(parms, result.getOutOfSyncShares(), result.getConfigurationsWithUnCheckedInChanges(), result.getLineDelimiterFailures(), result.getEncodingFailures(), result.getConfigurationsWithConflicts(), result.getBackedUpToShed(), result.getNonAtomicCheckInOffers(), (IProgressMonitor)monitor.newChild(10));
        ICreateBaselineOperation op = BaselineUtil.prepareOperation(parms, dilemmaHandler, (IProgressMonitor)monitor.newChild(10));
        if (monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        try {
            op.run((IProgressMonitor)monitor.newChild(70));
        }
        catch (FileSystemClientException e) {
            throw new TeamRepositoryException(CommonUtil.getErrorMessage((FileSystemClientException)e), (Throwable)e);
        }
        catch (OperationCanceledException operationCanceledException) {
            result.setCancelled(true);
        }
        Collection baselinesCreated = op.getBaselinesCreated();
        SubMonitor subMonitor = monitor.newChild(10);
        subMonitor.setWorkRemaining(baselinesCreated.size());
        for (IBaselineConnection baselineConnection : baselinesCreated) {
            HashMap<UUID, IContributor> contributors = CoreUtil.fetchCreatorAndGetModifiedBy(baselineConnection.teamRepository(), Collections.singletonList(baselineConnection.getResolvedBaseline()), (IProgressMonitor)subMonitor.newChild(1));
            result.getBaselines().add(CoreUtil.translateBaseline(baselineConnection, contributors));
        }
        return result;
    }

    private static ICreateBaselineOperation prepareOperation(ParmsCreateBaselines parms, CreateBaselineDilemmaHandler dilemmaHandler, IProgressMonitor progress) throws TeamRepositoryException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)(parms.requests.length * 10));
        ICreateBaselineOperation op = IOperationFactory.instance.getCreateBaselineOperation(dilemmaHandler);
        RefreshUtil.configureRefresh(parms.preoperationRefresh, (IRefreshingOperation)op);
        CommitUtil.configureCommit(parms.pendingChangesDilemmaHandler, (ICheckinOptions)op);
        ParmsCreateBaselineRequest[] parmsCreateBaselineRequestArray = parms.requests;
        int n = parms.requests.length;
        int n2 = 0;
        while (n2 < n) {
            ParmsCreateBaselineRequest request = parmsCreateBaselineRequestArray[n2];
            IWorkspaceConnection workspaceConnection = request.workspace.getWorkspaceConnection((IProgressMonitor)monitor.newChild(5));
            IComponentHandle component = request.getComponentHandle();
            op.createBaselineRequest(workspaceConnection, component, request.name, request.comment);
            ++n2;
        }
        return op;
    }

    private static CreateBaselineDilemmaHandler getCreateBaselineDilemmaHandler(ParmsCreateBaselines parms, List outOfSyncShares, final List configurationsWithPendingChanges, List lineDelimiterFailures, List<EncodingErrorDTO> encodingFailures, final List configurationsWithConflicts, List<BackupInShedDTO> backedUpInShed, List<NonAtomicCheckInDTO> nonAtomicCommitOffers, IProgressMonitor progress) {
        final int pendingChangesInstruction = CommitUtil.getUncheckedInChangesInstruction(parms.pendingChangesDilemmaHandler);
        final int conflictedConfigurationsInstruction = BaselineUtil.getInstruction(parms.createBaselineDilemmaHandler);
        final BackupDilemmaHandler backupDilemmaHandler = BackupUtil.getBackupDilemmaHandler(parms.backupDilemmaHandler, backedUpInShed);
        final OutOfSyncDilemmaHandler outOfSyncDilemmaHandler = VerifyOutOfSyncUtil.getOutOfSyncDilemmaHandler(parms.outOfSyncInstructions, outOfSyncShares, backupDilemmaHandler);
        final CommitDilemmaHandler commitDilemmaHandler = CommitUtil.getCommitDilemmaHandler(parms.pendingChangesDilemmaHandler, outOfSyncDilemmaHandler, backupDilemmaHandler, (List<LineDelimiterErrorDTO>)lineDelimiterFailures, encodingFailures, nonAtomicCommitOffers);
        CreateBaselineDilemmaHandler dilemmaHandler = new CreateBaselineDilemmaHandler(){

            public int conflictedConfigurations(List<ConfigurationDescriptor> conflictedConfigurations) {
                this.recordConfigurationDescriptors(conflictedConfigurations, configurationsWithConflicts);
                return conflictedConfigurationsInstruction;
            }

            public CommitDilemmaHandler getCommitDilemmaHandler() {
                return commitDilemmaHandler;
            }

            public int uncheckedInChanges(Map<ConfigurationDescriptor, Collection<ILocalChange>> changes) {
                this.recordConfigurationDescriptors(changes.keySet(), configurationsWithPendingChanges);
                return pendingChangesInstruction;
            }

            public OutOfSyncDilemmaHandler getOutOfSyncDilemmaHandler() {
                return outOfSyncDilemmaHandler;
            }

            private void recordConfigurationDescriptors(Collection<ConfigurationDescriptor> configurationDescriptors, List<ConfigurationDescriptorDTO> configurationDescriptorDTOs) {
                if (configurationDescriptorDTOs != null) {
                    for (ConfigurationDescriptor descriptor : configurationDescriptors) {
                        configurationDescriptorDTOs.add(CoreUtil.translateConfigurationDescriptor(descriptor));
                    }
                }
            }

            public BackupDilemmaHandler getBackupDilemmaHandler() {
                return backupDilemmaHandler;
            }
        };
        return dilemmaHandler;
    }

    private static int getInstruction(ParmsCreateBaselineDilemmaHandler createBaselineDilemmaHandler) {
        int uncheckedInChangesInstruction = 2;
        if (createBaselineDilemmaHandler != null) {
            String instruction = createBaselineDilemmaHandler.conflictedConfigurationsDirection;
            if ("continue".equals(instruction)) {
                uncheckedInChangesInstruction = 0;
            } else if (instruction == null) {
                uncheckedInChangesInstruction = 2;
            } else if ("cancel".equals(instruction)) {
                uncheckedInChangesInstruction = 1;
            } else if ("fail".equals(instruction)) {
                uncheckedInChangesInstruction = 2;
            } else {
                throw new IllegalArgumentException("The value of conflictedConfigurationsDirection must be one of cancel, continue or fail");
            }
        }
        return uncheckedInChangesInstruction;
    }

    public static void updateBaseline(ParmsUpdateBaseline parms, IProgressMonitor progress) throws TeamRepositoryException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)100);
        IBaselineConnection baselineConnection = parms.baseline.getBaselineConnection((IProgressMonitor)monitor.newChild(10));
        if (parms.name != null) {
            baselineConnection.setName(parms.name, (IProgressMonitor)monitor.newChild(45));
        }
        if (parms.comment != null) {
            baselineConnection.setComment(parms.comment, (IProgressMonitor)monitor.newChild(45));
        }
    }

    public static CreateBaselineSetResultDTO createBaselineSet(ParmsCreateBaselineSet parms, IProgressMonitor progress) throws TeamRepositoryException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)100);
        CreateBaselineSetResultDTO result = FilesystemRestClientDTOworkspaceFactory.eINSTANCE.createCreateBaselineSetResultDTO();
        IWorkspaceConnection workspaceConnection = parms.workspace.getWorkspaceConnection((IProgressMonitor)monitor.newChild(5));
        List componentsToExclude = parms.getExcludedComponentHandles();
        IBaselineSetHandle baselineSetHandle = workspaceConnection.createBaselineSet((Collection)componentsToExclude, parms.name, parms.comment, parms.createNewBaselines.booleanValue(), (IProgressMonitor)monitor.newChild(90));
        IBaselineSet baselineSet = (IBaselineSet)workspaceConnection.teamRepository().itemManager().fetchCompleteItem((IItemHandle)baselineSetHandle, 0, (IProgressMonitor)monitor.newChild(5));
        result.setBaselineSet(CoreUtil.translateBaselineSet(workspaceConnection.teamRepository(), baselineSet));
        return result;
    }

    public static void updateBaselineSet(ParmsUpdateBaselineSet parms, IProgressMonitor progress) throws TeamRepositoryException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)100);
        ITeamRepository repo = CommonUtil.getTeamRepository((String)parms.baselineSet.repositoryUrl);
        IBaselineSetHandle baselineSet = parms.baselineSet.getBaselineSetHandle();
        IWorkspaceManager workspaceManager = SCMPlatform.getWorkspaceManager((ITeamRepository)repo);
        if (parms.comment != null) {
            workspaceManager.setComment(baselineSet, parms.comment, (IProgressMonitor)monitor.newChild(30));
        }
        if (parms.name != null) {
            workspaceManager.setName(baselineSet, parms.name, (IProgressMonitor)monitor.newChild(30));
        }
        if (parms.promotionWorkspace != null) {
            IWorkspaceConnection workspaceConnection = parms.promotionWorkspace.getWorkspaceConnection((IProgressMonitor)monitor.newChild(5));
            workspaceConnection.addBaselineSet(baselineSet, (IProgressMonitor)monitor.newChild(20));
        }
    }

    public static void removeBaselineSet(ParmsRemoveBaselineSet parms, IProgressMonitor progress) throws TeamRepositoryException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)100);
        IBaselineSetHandle baselineSet = parms.baselineSet.getBaselineSetHandle();
        IWorkspaceConnection workspaceConnection = parms.workspace.getWorkspaceConnection((IProgressMonitor)monitor.newChild(5));
        workspaceConnection.removeBaselineSet(baselineSet, (IProgressMonitor)monitor.newChild(85));
    }

    /*
     * Unable to fully structure code
     */
    public static GetBaselinesDTO getBaselines(ParmsGetBaselines parms, IProgressMonitor progress) throws TeamRepositoryException {
        block16: {
            block15: {
                block13: {
                    block14: {
                        monitor = SubMonitor.convert((IProgressMonitor)progress, (int)100);
                        repo = CommonUtil.getTeamRepository((String)parms.repositoryUrl);
                        result = FilesystemRestClientDTOsyncFactory.eINSTANCE.createGetBaselinesDTO();
                        if (parms.baselineItemIds != null && parms.baselineItemIds.length > 0) {
                            handles = new ArrayList<IBaselineHandle>();
                            var9_7 = parms.baselineItemIds;
                            var8_10 = parms.baselineItemIds.length;
                            var7_14 = 0;
                            while (var7_14 < var8_10) {
                                baselineItemId = var9_7[var7_14];
                                handles.add((IBaselineHandle)IBaseline.ITEM_TYPE.createItemHandle((Object)repo, UUID.valueOf((String)baselineItemId), null));
                                ++var7_14;
                            }
                            baselines = repo.itemManager().fetchCompleteItems(handles, 0, (IProgressMonitor)monitor.newChild(50));
                            contributors = CoreUtil.fetchCreatorAndGetModifiedBy(repo, baselines, (IProgressMonitor)monitor.newChild(50));
                            for (IBaseline baseline : baselines) {
                                if (baseline == null) continue;
                                result.getBaselinesInRepository().add(CoreUtil.translateBaseline(repo, baseline, contributors));
                            }
                            result.setTotalEntries((long)result.getBaselinesInRepository().size());
                            return result;
                        }
                        component = CommonUtil.createComponentHandle((ITeamRepository)repo, (String)parms.componentItemId);
                        if (parms.workspaceItemId == null) break block15;
                        workspace = new ParmsWorkspace();
                        workspace.repositoryUrl = parms.repositoryUrl;
                        workspace.workspaceItemId = parms.workspaceItemId;
                        connection = workspace.getWorkspaceConnection((IProgressMonitor)monitor.newChild(5));
                        try {
                            numBasisInHistory = connection.getComponentInfo(component).numBasisInHistory();
                            break block13;
                        }
                        catch (TeamRepositoryException e) {
                            if (!(e instanceof ComponentNotInWorkspaceException)) break block14;
                            pastComponentInfos = connection.getPastComponentInfos((IProgressMonitor)monitor.newChild(5));
                            numBasisInHistory = 0L;
                            ** for (pastInfo : pastComponentInfos)
                        }
lbl-1000:
                        // 1 sources

                        {
                            if (!pastInfo.component().sameItemId((IItemHandle)component)) continue;
                            numBasisInHistory = pastInfo.numBasisInHistory();
lbl40:
                            // 2 sources

                            break block13;
                        }
                    }
                    throw e;
                }
                result.setTotalEntries(numBasisInHistory);
                if (numBasisInHistory <= 0L) break block16;
                baselineHandles = new ArrayList<IBaselineHandle>(parms.max);
                trail = new ArrayList<E>(parms.max);
                if (parms.start == null) {
                    max = Math.min(parms.max, 512);
                    max = Math.min(max, numBasisInHistory);
                    start = numBasisInHistory - max;
                    done = false;
                    while (!done) {
                        trailBatch = connection.getComponentAuditTrail(component, start, max, (IProgressMonitor)monitor.newChild(50));
                        trail.addAll(trailBatch);
                        if ((long)trailBatch.size() < max && trailBatch.size() > 0) {
                            max = -trailBatch.size();
                            start = trailBatch.size();
                            continue;
                        }
                        done = true;
                    }
                } else {
                    trail = connection.getComponentAuditTrail(component, parms.start.longValue(), (long)parms.max.intValue(), (IProgressMonitor)monitor.newChild(50));
                }
                for (IComponentInfo info : trail) {
                    if (info.basis() == null) continue;
                    baselineHandles.add(info.basis());
                }
                baselines = repo.itemManager().fetchCompleteItems(baselineHandles, 0, (IProgressMonitor)monitor.newChild(15));
                contributors = CoreUtil.fetchCreatorAndGetModifiedBy(repo, baselines, (IProgressMonitor)monitor.newChild(5));
                iBaselines = baselines.iterator();
                for (IComponentInfo info : trail) {
                    baselineEntry = FilesystemRestClientDTOsyncFactory.eINSTANCE.createBaselineHistoryEntryDTO();
                    result.getBaselineHistoryEntriesInWorkspace().add(baselineEntry);
                    baselineEntry.setDeliveredByItemId(info.deliveredBy().getItemId().getUuidValue());
                    baselineEntry.setDeliveryDate(info.deliveryDate().getTime());
                    if (info.basis() == null) continue;
                    baseline = (IBaseline)iBaselines.next();
                    baselineEntry.setBaseline(CoreUtil.translateBaseline(repo, baseline, contributors));
                }
                break block16;
            }
            wm = SCMPlatform.getWorkspaceManager((ITeamRepository)repo);
            baselineHandles = wm.findBaselines(IBaselineSearchCriteria.FACTORY.newInstance().setComponentRequired(component), 0x7FFFFFFF, (IProgressMonitor)monitor.newChild(50));
            result.setTotalEntries((long)baselineHandles.size());
            baselines = repo.itemManager().fetchCompleteItems(baselineHandles, 0, (IProgressMonitor)monitor.newChild(15));
            contributors = CoreUtil.fetchCreatorAndGetModifiedBy(repo, baselines, (IProgressMonitor)monitor.newChild(5));
            Collections.sort(baselines, new Comparator<IBaseline>(){

                @Override
                public int compare(IBaseline o1, IBaseline o2) {
                    return NullUtil.compare((Comparable)o1.getCreationDate(), (Comparable)o2.getCreationDate());
                }
            });
            for (IBaseline baseline : baselines) {
                result.getBaselinesInRepository().add(CoreUtil.translateBaseline(repo, baseline, contributors));
            }
        }
        return result;
    }

    public static GetBaselineSetsDTO getBaselineSets(ParmsWorkspace parms, IProgressMonitor progress) throws TeamRepositoryException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)100);
        ITeamRepository repo = CommonUtil.getTeamRepository((String)parms.repositoryUrl);
        IWorkspaceConnection wc = parms.getWorkspaceConnection((IProgressMonitor)monitor.newChild(5));
        List handles = wc.getBaselineSets((IProgressMonitor)monitor.newChild(75));
        List baselineSets = repo.itemManager().fetchCompleteItems(handles, 0, (IProgressMonitor)monitor.newChild(20));
        GetBaselineSetsDTO result = FilesystemRestClientDTOsyncFactory.eINSTANCE.createGetBaselineSetsDTO();
        for (IBaselineSet baselineSet : baselineSets) {
            BaselineSetDTO dto = CoreUtil.translateBaselineSet(repo, baselineSet);
            result.getBaselineSets().add(dto);
        }
        return result;
    }
}

