/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.rcp.core.internal.rest.util;

import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.operations.BackupDilemmaHandler;
import com.ibm.team.filesystem.client.rest.parameters.ParmsBackupDilemmaHandler;
import com.ibm.team.filesystem.common.internal.rest.client.changeset.BackupInShedDTO;
import com.ibm.team.filesystem.common.internal.rest.client.changeset.FilesystemRestClientDTOchangesetFactory;
import com.ibm.team.filesystem.rcp.core.internal.rest.util.CoreUtil;
import java.util.List;
import org.eclipse.core.runtime.IPath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BackupUtil {
    public static BackupDilemmaHandler getBackupDilemmaHandler(final ParmsBackupDilemmaHandler backupInstructions, final List<BackupInShedDTO> backedUpInShed) {
        BackupDilemmaHandler dilemmaHandler = backupInstructions == null ? new BackupDilemmaHandler(){

            public boolean backupEnabled() {
                return true;
            }

            public void backedUpInShed(IShareable shareable, IPath shedLocation) {
                if (backedUpInShed != null) {
                    backedUpInShed.add(BackupUtil.translateBackupInShed(shareable, shedLocation));
                }
            }
        } : new BackupDilemmaHandler(){

            public boolean backupEnabled() {
                return backupInstructions.backupEnabled;
            }

            public int getMaxFileSize() {
                if (backupInstructions.maxFileSize == null) {
                    return super.getMaxFileSize();
                }
                return backupInstructions.maxFileSize;
            }

            public int getPreferredShedLifespan() {
                if (backupInstructions.preferredShedLifespan == null) {
                    return super.getPreferredShedLifespan();
                }
                return backupInstructions.preferredShedLifespan;
            }

            public void backedUpInShed(IShareable shareable, IPath shedLocation) {
                if (backedUpInShed != null) {
                    backedUpInShed.add(BackupUtil.translateBackupInShed(shareable, shedLocation));
                }
            }
        };
        return dilemmaHandler;
    }

    private static BackupInShedDTO translateBackupInShed(IShareable shareable, IPath shedLocation) {
        BackupInShedDTO result = FilesystemRestClientDTOchangesetFactory.eINSTANCE.createBackupInShedDTO();
        result.setShareable(CoreUtil.translateShareable(shareable));
        result.setShedLocation(shedLocation.toOSString());
        return result;
    }
}

