/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.rcp.core.internal.rest;

import com.ibm.team.filesystem.client.daemon.events.ConnectionEvent;
import com.ibm.team.filesystem.client.daemon.events.IHttpServerEvent;
import com.ibm.team.filesystem.client.daemon.events.ILightweightEventListener;
import com.ibm.team.filesystem.rcp.core.internal.rest.LifecycleRestClient;
import java.io.IOException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InactivityTimingJob
extends Job
implements ILightweightEventListener<IHttpServerEvent> {
    private volatile long timeToDie = -1L;
    private volatile long timeout = -1L;
    private LifecycleRestClient controller;

    public InactivityTimingJob() {
        super("Inactivity timer");
    }

    protected IStatus run(IProgressMonitor monitor) {
        this.attemptShutdown();
        return Status.OK_STATUS;
    }

    public void setTimeout(long millisOfInactivityBeforeShutdown) {
        this.timeout = millisOfInactivityBeforeShutdown;
        if (millisOfInactivityBeforeShutdown == -1L) {
            this.timeToDie = -1L;
            return;
        }
        this.timeToDie = System.currentTimeMillis() + millisOfInactivityBeforeShutdown;
    }

    void connect(LifecycleRestClient controller) {
        this.controller = controller;
    }

    public void handleEvent(IHttpServerEvent e) {
        if (!(e instanceof ConnectionEvent)) {
            return;
        }
        ConnectionEvent event = (ConnectionEvent)e;
        this.cancel();
        long t = this.timeout;
        if (event.getType().equals((Object)ConnectionEvent.Type.CLOSED) && !e.getServer().hasConnections() && t >= 0L) {
            this.schedule(t);
        }
    }

    public void attemptShutdown() {
        if (this.timeToDie != -1L && this.timeToDie < System.currentTimeMillis() && this.controller.mayShutdownDueToTimeout()) {
            try {
                this.controller.shutdown();
            }
            catch (IOException e) {
                e.printStackTrace();
                this.schedule(this.timeout);
            }
        }
    }
}

