/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.rcp.core.internal.rest;

import com.ibm.team.filesystem.client.daemon.IHttpServer;
import com.ibm.team.filesystem.client.daemon.IServerController;
import com.ibm.team.filesystem.client.daemon.JSONHandler;
import com.ibm.team.filesystem.client.daemon.JSONReceiver;
import com.ibm.team.filesystem.client.daemon.events.ConnectionEvent;
import com.ibm.team.filesystem.client.daemon.events.ILightweightEvent;
import com.ibm.team.filesystem.client.daemon.events.ILightweightEventListener;
import com.ibm.team.filesystem.client.daemon.events.RequestEvent;
import com.ibm.team.filesystem.client.internal.daemon.FSDaemon;
import com.ibm.team.filesystem.client.rest.IDebugRestClient;
import com.ibm.team.filesystem.client.restproxy.notification.NotificationQueuedEvent;
import com.ibm.team.filesystem.common.internal.rest.debug.core.DebugRestClientDTOFactory;
import com.ibm.team.filesystem.common.internal.rest.debug.core.PlatformInformationDTO;
import com.ibm.team.filesystem.common.internal.rest.debug.core.StatisticDTO;
import com.ibm.team.filesystem.common.internal.rest.debug.core.StatisticsDTO;
import com.ibm.team.repository.client.IStatistics;
import com.ibm.team.repository.client.internal.Statistics;
import com.ibm.team.repository.common.LogFactory;
import java.util.List;
import org.apache.commons.logging.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DebugRestClient
extends JSONReceiver
implements IDebugRestClient,
ILightweightEventListener<ILightweightEvent> {
    private static volatile IPlatformInformationSource platformInfoSource = null;
    private static final Log log = LogFactory.getLog((String)DebugRestClient.class.getName());
    IServerController controller;
    JSONHandler handler;
    final IStatistics stats = new Statistics(null);

    public static void setPlatformInformationSource(IPlatformInformationSource src) {
        platformInfoSource = src;
    }

    public void installationNotification(IServerController controller, JSONHandler handler) {
        this.controller = controller;
        this.handler = handler;
    }

    public StatisticsDTO getStatistics() {
        StatisticsDTO dto = DebugRestClientDTOFactory.eINSTANCE.createStatisticsDTO();
        List list = dto.getStatistics();
        String[] stringArray = this.stats.getContextTypes();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String ctxType = stringArray[n2];
            Object[] objectArray = this.stats.getContexts(ctxType);
            int n3 = objectArray.length;
            int n4 = 0;
            while (n4 < n3) {
                Object ctx = objectArray[n4];
                String[] stringArray2 = this.stats.getStatisticNames(ctxType, ctx);
                int n5 = stringArray2.length;
                int n6 = 0;
                while (n6 < n5) {
                    String statisticName = stringArray2[n6];
                    long value = this.stats.getStatisticValue(ctxType, ctx, statisticName);
                    StatisticDTO stat = DebugRestClientDTOFactory.eINSTANCE.createStatisticDTO();
                    stat.setContextType(ctxType);
                    stat.setContext(this.stringifyContext(ctx));
                    stat.setStatisticName(statisticName);
                    stat.setValue(value);
                    list.add(stat);
                    ++n6;
                }
                ++n4;
            }
            ++n2;
        }
        return dto;
    }

    private String stringifyContext(Object ctx) {
        return ctx.toString();
    }

    public void postInstall() {
        if (this.stats.enabled()) {
            throw new IllegalStateException("Already installed");
        }
        this.stats.enable();
        IHttpServer s = this.handler.getHttpServer();
        s.addListener((ILightweightEventListener)this);
        FSDaemon fsd = this.handler.getFSDaemon();
        fsd.getNotificationChannel().addListener((ILightweightEventListener)this);
    }

    public void handleEvent(ILightweightEvent genericEvent) {
        if (genericEvent instanceof ConnectionEvent) {
            String type;
            ConnectionEvent event = (ConnectionEvent)genericEvent;
            switch (event.getType()) {
                case CLOSED: {
                    type = "Closed";
                    break;
                }
                case OPENED: {
                    type = "Opened";
                    break;
                }
                default: {
                    type = "<unknown>";
                    log.error((Object)("Unknown ConnectionEvent type: " + event.getType()), null);
                }
            }
            this.stats.incStatisticValue("Connection", (Object)event.getServer(), type, 1L);
        } else if (genericEvent instanceof RequestEvent) {
            RequestEvent event = (RequestEvent)genericEvent;
            StringBuffer buf = new StringBuffer();
            String[] stringArray = event.getRequest().getPathSegments();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String segment = stringArray[n2];
                buf.append('/');
                buf.append(segment);
                ++n2;
            }
            this.stats.incStatisticValue("Received Request", (Object)event.getServer(), buf.toString(), 1L);
        } else if (genericEvent instanceof NotificationQueuedEvent) {
            NotificationQueuedEvent event = (NotificationQueuedEvent)genericEvent;
            this.stats.incStatisticValue("Notification", (Object)event.getChannel().getFSDaemon().getHttpServer(), event.getType(), 1L);
        }
    }

    public PlatformInformationDTO getDebugInformation() {
        IPlatformInformationSource source = platformInfoSource;
        if (source == null) {
            return null;
        }
        PlatformInformationDTO dto = DebugRestClientDTOFactory.eINSTANCE.createPlatformInformationDTO();
        dto.setEclipseWorkspacePath(source.getEclipseWorkspacePath());
        dto.setUserConfigurationPath(source.getUserConfigurationPath());
        return dto;
    }

    public static interface IPlatformInformationSource {
        public String getEclipseWorkspacePath();

        public String getUserConfigurationPath();
    }
}

