/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.rcp.core.internal.resources;

import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.ResourceType;
import com.ibm.team.filesystem.client.internal.Shareable;
import com.ibm.team.filesystem.client.internal.SharingManager;
import com.ibm.team.filesystem.rcp.core.internal.resources.EclipseFileStorage;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class ShareableAdapterFactory
implements IAdapterFactory {
    private Class[] ADAPTER_LIST = new Class[]{IShareable.class};

    public Object getAdapter(Object adaptableObject, Class adapterType) {
        if (adaptableObject instanceof IResource) {
            IResource resource = (IResource)adaptableObject;
            IResource originalResource = (IResource)adaptableObject;
            if (resource.getType() != 8) {
                IPath path = resource.getLocation();
                Path relativePath = new Path("");
                while (resource.isLinked(512) || path == null && !resource.exists() && resource.getType() != 8) {
                    relativePath = new Path(resource.getName()).append((IPath)relativePath);
                    resource = resource.getParent();
                    path = resource.getLocation();
                }
                if (path != null) {
                    path = path.append((IPath)relativePath);
                    Shareable shareable = (Shareable)SharingManager.getInstance().findShareable(path, adaptableObject instanceof IContainer ? ResourceType.FOLDER : ResourceType.FILE);
                    if (shareable != null && originalResource.getProject().isAccessible()) {
                        new EclipseFileStorage(shareable.getFileStorage(), originalResource);
                        return shareable;
                    }
                    return shareable;
                }
            }
        }
        return null;
    }

    public Class[] getAdapterList() {
        return this.ADAPTER_LIST;
    }
}

