/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.rcp.core.internal.resources;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.FileSystemCore;
import com.ibm.team.filesystem.client.IContentProperties;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.internal.IFileStorage;
import com.ibm.team.filesystem.client.internal.magic.ContentProperties;
import com.ibm.team.filesystem.client.internal.magic.ContentPropertyUtil;
import com.ibm.team.filesystem.common.FileLineDelimiter;
import com.ibm.team.filesystem.rcp.core.internal.resources.ContentPropertiesPreference;
import com.ibm.team.filesystem.rcp.core.internal.resources.ContentPropertiesPreferenceManager;
import com.ibm.team.filesystem.rcp.core.internal.streams.InputStreamStorage;
import com.ibm.team.internal.repository.rcp.streams.EmptyInputStreamProvider;
import com.ibm.team.internal.repository.rcp.streams.InputStreamUtil;
import com.ibm.team.repository.common.utils.DisposableInputStreamProvider;
import com.ibm.team.repository.common.utils.IInputStreamProvider;
import com.ibm.team.repository.common.utils.TemporaryOutputStream;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.content.IContentType;

public class ResourceUtil {
    private static final IContentType ICONTENT_TYPE_TEXT = Platform.getContentTypeManager().getContentType("org.eclipse.core.runtime.text");
    private static final byte[] UTF_8_BOM = new byte[]{-17, -69, -65};
    private static final byte[] UTF_16_BE_BOM = new byte[]{-2, -1};
    private static final byte[] UTF_16_LE_BOM = new byte[]{-1, -2};

    public static IContentProperties getContentPropertiesNotNull(IFile file, IProgressMonitor monitor) throws CoreException {
        IContentProperties result = ResourceUtil.getContentProperties(file, monitor);
        if (result == null) {
            return ContentProperties.UNKNOWN;
        }
        return result;
    }

    private static IContentProperties getContentProperties(IFile file, IProgressMonitor monitor) throws CoreException {
        if (!file.exists()) {
            return null;
        }
        CoreException encodingException = null;
        String encoding = null;
        try {
            encoding = file.getCharset(true);
        }
        catch (CoreException e) {
            encodingException = e;
        }
        String mimeType = null;
        FileLineDelimiter lineDelimiter = null;
        IShareable shareable = (IShareable)file.getAdapter(IShareable.class);
        if (shareable != null) {
            SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
            mimeType = shareable.getContentType((IProgressMonitor)progress.newChild(50));
            lineDelimiter = shareable.getLineDelimiter((IProgressMonitor)progress.newChild(50));
        }
        IContentType contentType = ResourceUtil.getContentTypeFor(file);
        if (mimeType == null || lineDelimiter == null) {
            ContentPropertiesPreferenceManager manager = new ContentPropertiesPreferenceManager();
            ContentPropertiesPreference pref = manager.get(contentType, file.getName());
            if (mimeType == null) {
                mimeType = pref.getMimeType();
            }
            if (lineDelimiter == null) {
                lineDelimiter = pref.getLineDelimiter();
            }
        }
        ContentProperties properties = ResourceUtil.createContentProperties(contentType, encoding, mimeType, lineDelimiter);
        if (encodingException != null && (properties.isText() || lineDelimiter != FileLineDelimiter.LINE_DELIMITER_NONE)) {
            throw encodingException;
        }
        return properties;
    }

    private static ContentProperties createContentProperties(IContentType contentType, String encoding, String mimeType, FileLineDelimiter lineDelimiter) {
        boolean isContentTypeText = contentType != null && contentType.isKindOf(ICONTENT_TYPE_TEXT);
        String contentTypeForMerge = contentType == null ? null : contentType.getId();
        return new ContentProperties(encoding, mimeType, lineDelimiter, contentTypeForMerge, isContentTypeText);
    }

    public static boolean isText(String mimeType, IContentType contentType) {
        return mimeType != null && ContentPropertyUtil.isText((String)mimeType) || contentType != null && contentType.isKindOf(ICONTENT_TYPE_TEXT);
    }

    public static void createPath(IContainer toCreate, IProgressMonitor monitor) throws CoreException {
        ResourceUtil.createPath(toCreate, false, true, monitor);
    }

    public static void createPath(IContainer toCreate, boolean force, boolean keepHistory, IProgressMonitor monitor) throws CoreException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        if (toCreate.exists() || toCreate instanceof IWorkspaceRoot) {
            return;
        }
        if (toCreate instanceof IFolder) {
            ResourceUtil.createPath(toCreate.getParent(), force, keepHistory, (IProgressMonitor)progress.newChild(50));
            progress.setWorkRemaining(100);
        }
        ResourceUtil.createShallow(toCreate, force, keepHistory, (IProgressMonitor)progress.newChild(100));
    }

    private static void createShallow(IContainer toCreate, boolean force, boolean keepHistory, IProgressMonitor monitor) throws CoreException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        if (toCreate instanceof IProject) {
            IProject project = (IProject)toCreate;
            project.create((IProgressMonitor)progress.newChild(50));
            project.open((IProgressMonitor)progress.newChild(50));
            return;
        }
        if (toCreate instanceof IFolder) {
            IFolder folder = (IFolder)toCreate;
            folder.create(force, keepHistory, (IProgressMonitor)progress.newChild(100));
        }
    }

    public static IFile getFile(IPath targetPath) {
        try {
            return ResourcesPlugin.getWorkspace().getRoot().getFile(targetPath);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static IContainer getContainer(IPath targetPath) {
        Object root = targetPath.segmentCount() == 0 ? ResourcesPlugin.getWorkspace().getRoot() : (targetPath.segmentCount() == 1 ? ResourcesPlugin.getWorkspace().getRoot().getProject(targetPath.segment(0)) : ResourcesPlugin.getWorkspace().getRoot().getFolder(targetPath));
        return root;
    }

    public static IResource getResource(IPath targetPath) {
        if (targetPath.segmentCount() >= 2) {
            IContainer container;
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            IFile file = root.getFile(targetPath);
            if (!file.exists() && (container = ResourceUtil.getContainer(targetPath)).exists()) {
                return container;
            }
            return file;
        }
        return ResourceUtil.getContainer(targetPath);
    }

    public static void deleteAllMembers(IContainer container, IProgressMonitor monitor) throws CoreException {
        IResource[] members = container.members();
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)members.length);
        int i = 0;
        while (i < members.length) {
            IResource next = members[i];
            next.delete(false, (IProgressMonitor)progress.newChild(1));
            ++i;
        }
    }

    public static IContentType getContentTypeFor(IFile resource) throws CoreException {
        if (!resource.exists()) {
            return null;
        }
        IContentDescription contentDescription = resource.getContentDescription();
        if (contentDescription == null) {
            return null;
        }
        return contentDescription.getContentType();
    }

    public static IContentType getContentTypeFor(String fileName) {
        return Platform.getContentTypeManager().findContentTypeFor(fileName);
    }

    public static IContentType getContentTypeFor(InputStream contents, String fileName) {
        IContentType type;
        block13: {
            type = null;
            if (contents != null) {
                try {
                    try {
                        type = Platform.getContentTypeManager().findContentTypeFor(contents, fileName);
                    }
                    catch (IOException e) {
                        StatusUtil.log(ResourceUtil.class, (Throwable)e);
                        try {
                            contents.close();
                        }
                        catch (IOException iOException) {}
                        break block13;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        contents.close();
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
                try {
                    contents.close();
                }
                catch (IOException iOException) {}
            }
        }
        if (type == null) {
            type = Platform.getContentTypeManager().findContentTypeFor(fileName);
        }
        return type;
    }

    public static String getFileExtension(String filename) {
        int index = filename.lastIndexOf(46);
        if (index == -1) {
            return null;
        }
        if (index == filename.length() - 1) {
            return null;
        }
        return "*." + filename.substring(index + 1).toLowerCase();
    }

    public static boolean validMimeType(String mime) {
        return mime.matches("\\w((\\+|-)?\\w)*/\\w((\\+|-)?\\w)*");
    }

    public static DisposableInputStreamProvider getCurrentFileContents(IPath targetPath) throws CoreException {
        try {
            IFile theFile = ResourceUtil.getFile(targetPath);
            if (theFile == null) {
                return new EmptyInputStreamProvider();
            }
            long estimatedLength = 0x100000L;
            try {
                IFileStore theStore = EFS.getStore((URI)theFile.getLocationURI());
                IFileInfo info = theStore.fetchInfo();
                estimatedLength = info.getLength();
            }
            catch (CoreException coreException) {}
            TemporaryOutputStream outputStream = TemporaryOutputStream.getEstimatedSizeTemporaryOutputStream((long)estimatedLength);
            InputStream currentInputStream = null;
            boolean success = false;
            try {
                int read;
                currentInputStream = theFile.getContents();
                byte[] buffer = new byte[4096];
                do {
                    if ((read = currentInputStream.read(buffer)) <= 0) continue;
                    outputStream.write(buffer, 0, read);
                } while (read == buffer.length);
                currentInputStream.close();
                currentInputStream = null;
                success = true;
            }
            catch (Throwable throwable) {
                if (currentInputStream != null) {
                    try {
                        currentInputStream.close();
                    }
                    catch (IOException iOException) {}
                }
                if (!success) {
                    try {
                        outputStream.dispose();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (currentInputStream != null) {
                try {
                    currentInputStream.close();
                }
                catch (IOException iOException) {}
            }
            if (!success) {
                try {
                    outputStream.dispose();
                }
                catch (IOException iOException) {}
            }
            return outputStream;
        }
        catch (IOException e) {
            throw new CoreException(StatusUtil.newStatus(InputStreamUtil.class, (Throwable)e));
        }
    }

    public static IStorage getStorageForPath(IPath targetPath) {
        IFile _file = ResourceUtil.getFile(targetPath);
        InputStreamStorage storage = _file != null && _file.exists() && _file.getProject().isOpen() ? _file : new InputStreamStorage((IInputStreamProvider)new EmptyInputStreamProvider());
        return storage;
    }

    public static String getEncoding(String encoding, DisposableInputStreamProvider buffer, IProgressMonitor monitor) throws IOException {
        BufferedInputStream stream;
        String utfEncoding;
        if (ResourceUtil.requiresCheckForBom(encoding) && (utfEncoding = ResourceUtil.getUTFEncoding(stream = new BufferedInputStream(buffer.getInputStream(monitor)))) != null) {
            return utfEncoding;
        }
        return encoding;
    }

    /*
     * Loose catch block
     */
    private static String getUTFEncoding(InputStream stream) {
        block22: {
            block21: {
                int offset;
                byte[] bom;
                block20: {
                    block19: {
                        bom = new byte[3];
                        offset = 0;
                        int count = 0;
                        while (offset < 3 && count != -1) {
                            count = stream.read(bom, offset, 3 - offset);
                            if (count == -1) continue;
                            offset += count;
                        }
                        if (offset != 3 || !ResourceUtil.isBytesEqual(bom, UTF_8_BOM, 3)) break block19;
                        try {
                            stream.close();
                        }
                        catch (IOException iOException) {}
                        return "UTF-8";
                    }
                    if (offset < 2 || !ResourceUtil.isBytesEqual(bom, UTF_16_BE_BOM, 2)) break block20;
                    try {
                        stream.close();
                    }
                    catch (IOException iOException) {}
                    return "UTF-16BE";
                }
                if (offset < 2 || !ResourceUtil.isBytesEqual(bom, UTF_16_LE_BOM, 2)) break block21;
                try {
                    stream.close();
                }
                catch (IOException iOException) {}
                return "UTF-16LE";
                catch (IOException e) {
                    try {
                        StatusUtil.log(ResourceUtil.class, (Throwable)e);
                    }
                    catch (Throwable throwable) {
                        try {
                            stream.close();
                        }
                        catch (IOException iOException) {}
                        throw throwable;
                    }
                    try {
                        stream.close();
                    }
                    catch (IOException iOException) {}
                    break block22;
                }
            }
            try {
                stream.close();
            }
            catch (IOException iOException) {}
        }
        return null;
    }

    private static boolean isBytesEqual(byte[] b1, byte[] b2, int length) {
        int i = 0;
        while (i < length) {
            if (b1[i] != b2[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static boolean requiresCheckForBom(String encoding) {
        return !encoding.toUpperCase().startsWith("UTF");
    }

    public static String getEncoding(IFile file) throws CoreException {
        BufferedInputStream stream;
        String utfEncoding;
        String encoding = file.getCharset();
        if (ResourceUtil.requiresCheckForBom(encoding) && (utfEncoding = ResourceUtil.getUTFEncoding(stream = new BufferedInputStream(file.getContents()))) != null) {
            return utfEncoding;
        }
        return encoding;
    }

    public static String getEncoding(IFileStorage file, IProgressMonitor progress) throws FileSystemClientException {
        BufferedInputStream stream;
        String utfEncoding;
        String encoding = FileSystemCore.getSharingManager().getContentExaminer().getEncoding((IShareable)file.getShareable(), progress);
        if (ResourceUtil.requiresCheckForBom(encoding) && (utfEncoding = ResourceUtil.getUTFEncoding(stream = new BufferedInputStream(file.getContents()))) != null) {
            return utfEncoding;
        }
        return encoding;
    }
}

