/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.rcp.core.internal.resources;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.ISandbox;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.ISharingManager;
import com.ibm.team.filesystem.client.ResourceType;
import com.ibm.team.filesystem.client.internal.FileStorage;
import com.ibm.team.filesystem.client.internal.FileStorageWrapper;
import com.ibm.team.filesystem.client.internal.FileSystemStatus;
import com.ibm.team.filesystem.client.internal.IFileContentMerger;
import com.ibm.team.filesystem.client.internal.IFileStorage;
import com.ibm.team.filesystem.client.internal.Shareable;
import com.ibm.team.filesystem.client.internal.SharingManager;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileArea;
import com.ibm.team.filesystem.client.internal.load.LoadLocation;
import com.ibm.team.filesystem.client.internal.load.UpdateMutator;
import com.ibm.team.filesystem.client.internal.operations.FileSystemOperation;
import com.ibm.team.filesystem.client.internal.utils.IRunnableWithProgress;
import com.ibm.team.filesystem.client.internal.utils.PathUtils;
import com.ibm.team.filesystem.client.operations.IDownloadListener;
import com.ibm.team.filesystem.client.operations.LoadDilemmaHandler;
import com.ibm.team.filesystem.client.operations.UpdateDilemmaHandler;
import com.ibm.team.filesystem.common.internal.dto.FileAreaUpdateReport;
import com.ibm.team.filesystem.common.internal.dto.LoadTree;
import com.ibm.team.filesystem.rcp.core.internal.FileSystemResourcesPlugin;
import com.ibm.team.filesystem.rcp.core.internal.Messages;
import com.ibm.team.filesystem.rcp.core.internal.operations.merge.FileContentMerger;
import com.ibm.team.filesystem.rcp.core.internal.resources.EclipseFileStorage;
import com.ibm.team.filesystem.rcp.core.internal.resources.EclipseWorkspaceMergeLoadMutator;
import com.ibm.team.filesystem.rcp.core.internal.resources.EclipseWorkspaceMutator;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.dto.IComponentStateSummary;
import com.ibm.team.scm.common.dto.IItemConflictReport;
import com.ibm.team.scm.common.dto.IUpdateReport;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.MultiRule;
import org.eclipse.osgi.service.datalocation.Location;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceSharingManager
extends SharingManager {
    protected final IPath defaultRoot;
    private Constructor logicalModelMutatorConstructor;
    private boolean logicalModelConstructionFailed;

    public ResourceSharingManager() throws IOException {
        Location instanceLocation = Platform.getInstanceLocation();
        this.defaultRoot = new Path(new File(instanceLocation.getURL().getPath()).getCanonicalPath());
    }

    public IPath getIDEWorkAreaRoot() {
        return this.defaultRoot;
    }

    public FileSystemOperation getLoadMutator(int options, IConnection connection, IComponent component, ISandbox sandbox, List<LoadLocation> itemsToLoad, LoadTree loadTree, LoadDilemmaHandler loadProblemHandler, IDownloadListener downloadMonitor) {
        return new EclipseWorkspaceMergeLoadMutator(options, connection, component, sandbox, itemsToLoad, loadTree, loadProblemHandler, downloadMonitor);
    }

    public void resolveFileStorage(FileStorageWrapper storage, ResourceType resourceTypeHint) {
        File file;
        ISandbox sandbox = storage.getShareable().getSandbox();
        IPath path = storage.getShareable().getLocalPath();
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IResource resource = null;
        ResourceType hint = resourceTypeHint;
        if (hint == ResourceType.SYMBOLIC_LINK && (file = sandbox.getRoot().append(path).toFile()).exists()) {
            hint = file.isDirectory() ? ResourceType.FOLDER : ResourceType.FILE;
        }
        if (PathUtils.samePath((IPath)sandbox.getRoot(), (boolean)sandbox.isCaseSensitive(), (IPath)this.getIDEWorkAreaRoot(), (boolean)sandbox.isCaseSensitive())) {
            IPath projectLocation;
            if (path.segmentCount() == 1) {
                Path canonicalPath;
                String realPath;
                resource = root.getProject(path.segment(0));
                if (!(resource.exists() || sandbox.isCaseSensitive() || (realPath = PathUtils.getRealPath((String)sandbox.getRoot().append(path).toOSString())) == null || (canonicalPath = new Path(realPath)).lastSegment() == null || canonicalPath.lastSegment().equals(path.segment(0)))) {
                    resource = root.getProject(canonicalPath.lastSegment());
                }
                if ((projectLocation = resource.getLocation()) != null && !PathUtils.samePath((IPath)projectLocation, (boolean)sandbox.isCaseSensitive(), (IPath)sandbox.getRoot().append(path), (boolean)sandbox.isCaseSensitive())) {
                    resource = null;
                }
            } else {
                resource = root.findMember(path);
                if (resource == null) {
                    if (hint == ResourceType.FOLDER) {
                        resource = root.getFolder(path);
                    } else if (hint == ResourceType.FILE) {
                        resource = root.getFile(path);
                    }
                    if (resource != null) {
                        projectLocation = resource.getProject().getLocation();
                        if (!resource.getProject().exists() || projectLocation == null || projectLocation.segmentCount() > sandbox.getRoot().segmentCount() + 1 || !PathUtils.isPrefixOf((IPath)sandbox.getRoot(), (boolean)sandbox.isCaseSensitive(), (IPath)projectLocation)) {
                            resource = this.findImportedResource(root, sandbox, path, hint, false);
                        }
                    }
                }
            }
            if (resource == null || resource.getProject() == null || !resource.getProject().isAccessible()) {
                resource = null;
            }
        } else {
            resource = this.findImportedResource(root, sandbox, path, hint, false);
        }
        if (resource != null && resource.getProject() != null && resource.getProject().isAccessible()) {
            storage.setUnderlyingStorage((FileStorage)new EclipseFileStorage((IFileStorage)storage, resource));
        } else {
            super.resolveFileStorage(storage, resourceTypeHint);
        }
    }

    private IResource findImportedResource(IWorkspaceRoot root, ISandbox sandbox, IPath sandboxRelativePath, ResourceType resourceTypeHint, boolean includeLinks) {
        IPath location = sandbox.getRoot().append(sandboxRelativePath);
        File file = location.toFile();
        if (file.exists()) {
            resourceTypeHint = !file.isFile() ? ResourceType.FOLDER : ResourceType.FILE;
        }
        IResource resource = resourceTypeHint == ResourceType.FOLDER ? this.getContainerForLocation(root, location, includeLinks) : this.getFileForLocation(root, location, includeLinks);
        return resource;
    }

    private IResource getFileForLocation(IWorkspaceRoot root, IPath location, boolean includeLinks) {
        IFile[] resources;
        IFile file = root.getFileForLocation(location);
        Object resource = includeLinks && file == null ? ((resources = root.findFilesForLocation(location)).length > 0 ? resources[0] : null) : file;
        return resource;
    }

    private IResource getContainerForLocation(IWorkspaceRoot root, IPath location, boolean includeLinks) {
        IContainer container = root.getContainerForLocation(location);
        if (includeLinks && container == null) {
            IContainer[] resources = root.findContainersForLocation(location);
            if (resources.length > 0) {
                return resources[0];
            }
            return null;
        }
        return container;
    }

    public UpdateMutator getUpdateMutator(IConnection connection, Collection<IComponentStateSummary> componentStatesBefore, Collection<IComponentStateSummary> componentStatesAfter, FileAreaUpdateReport updates, Collection<ICopyFileArea> copyFileAreasToUpdate, UpdateDilemmaHandler dilemmaHandler, IDownloadListener downloadMonitor) {
        UpdateMutator mutator;
        Collection conflicts = null;
        if (connection instanceof IWorkspaceConnection) {
            IWorkspaceConnection wc = (IWorkspaceConnection)connection;
            IUpdateReport conflictReport = wc.conflictReport();
            conflicts = conflictReport.conflicts();
        }
        if (conflicts != null && !conflicts.isEmpty() && this.isLogicalModelSupportEnabled() && (mutator = this.createLogicalModelMutator(connection, componentStatesBefore, componentStatesAfter, updates, conflicts, copyFileAreasToUpdate, dilemmaHandler, downloadMonitor)) != null) {
            return mutator;
        }
        return new EclipseWorkspaceMutator(connection, componentStatesBefore, componentStatesAfter, updates, copyFileAreasToUpdate, dilemmaHandler, downloadMonitor);
    }

    private UpdateMutator createLogicalModelMutator(IConnection connection, Collection<IComponentStateSummary> componentStatesBefore, Collection<IComponentStateSummary> componentStatesAfter, FileAreaUpdateReport updates, Collection<IItemConflictReport> conflicts, Collection<ICopyFileArea> copyFileAreasToUpdate, UpdateDilemmaHandler dilemmaHandler, IDownloadListener downloadMonitor) {
        String className = "com.ibm.team.filesystem.ide.ui.internal.logical.EclipseWorkspaceLogicalModelMutator";
        String bundleName = "com.ibm.team.filesystem.ide.ui";
        Bundle bundle = Platform.getBundle((String)bundleName);
        if (bundle == null) {
            return null;
        }
        try {
            if (this.logicalModelMutatorConstructor == null) {
                Class clazz = bundle.loadClass(className);
                this.logicalModelMutatorConstructor = clazz.getConstructor(IConnection.class, Collection.class, Collection.class, FileAreaUpdateReport.class, Collection.class, Collection.class, UpdateDilemmaHandler.class, IDownloadListener.class);
            }
            return (UpdateMutator)this.logicalModelMutatorConstructor.newInstance(connection, componentStatesBefore, componentStatesAfter, updates, conflicts, copyFileAreasToUpdate, dilemmaHandler, downloadMonitor);
        }
        catch (ClassNotFoundException e) {
            StatusUtil.log((Object)((Object)this), (Throwable)e);
        }
        catch (ClassCastException e) {
            StatusUtil.log((Object)((Object)this), (Throwable)e);
        }
        catch (SecurityException e) {
            StatusUtil.log((Object)((Object)this), (Throwable)e);
        }
        catch (NoSuchMethodException e) {
            StatusUtil.log((Object)((Object)this), (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            StatusUtil.log((Object)((Object)this), (Throwable)e);
        }
        catch (InstantiationException e) {
            StatusUtil.log((Object)((Object)this), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            StatusUtil.log((Object)((Object)this), (Throwable)e);
        }
        catch (InvocationTargetException e) {
            StatusUtil.log((Object)((Object)this), (Throwable)e);
        }
        this.logicalModelConstructionFailed = true;
        return null;
    }

    private boolean isLogicalModelSupportEnabled() {
        return !this.logicalModelConstructionFailed && FileSystemResourcesPlugin.getDefault().getPluginPreferences().getBoolean("logical_model_support");
    }

    public ISchedulingRule getTrackingRule(IPath cfaRoot) {
        if (cfaRoot.equals((Object)this.getIDEWorkAreaRoot())) {
            return ResourcesPlugin.getWorkspace().getRoot();
        }
        return super.getTrackingRule(cfaRoot);
    }

    public void runWithinFileSystemLock(final IRunnableWithProgress runnableWithProgress, ISchedulingRule rule, IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        final InvocationTargetException[] invocationTargetExceptions = new InvocationTargetException[1];
        if (rule == null) {
            rule = ResourcesPlugin.getWorkspace().getRoot();
        }
        IWorkspaceRunnable workspaceOp = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                try {
                    runnableWithProgress.run(monitor);
                }
                catch (InvocationTargetException e) {
                    invocationTargetExceptions[0] = e;
                }
                catch (InterruptedException interruptedException) {
                    throw new OperationCanceledException();
                }
            }
        };
        try {
            ResourcesPlugin.getWorkspace().run(workspaceOp, rule, 1, monitor);
            if (invocationTargetExceptions[0] != null) {
                throw invocationTargetExceptions[0];
            }
        }
        catch (CoreException e) {
            throw new InvocationTargetException(e);
        }
    }

    public ISchedulingRule makeSchedulingRuleForIDE(Collection<IShareable> shareables) {
        IPath eclipseWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot().getLocation();
        for (IShareable shareable : shareables) {
            if (!shareable.getFullPath().isPrefixOf(eclipseWorkspaceRoot)) continue;
            return ResourcesPlugin.getWorkspace().getRoot();
        }
        ISchedulingRule rule = null;
        for (IShareable shareable : shareables) {
            IPath fullPath = shareable.getFullPath();
            if (!eclipseWorkspaceRoot.isPrefixOf(fullPath)) continue;
            IPath relativePath = fullPath.removeFirstSegments(eclipseWorkspaceRoot.segmentCount());
            relativePath = relativePath.setDevice(null);
            IResource resource = ResourcesPlugin.getWorkspace().getRoot().findMember(relativePath);
            rule = MultiRule.combine(rule, (ISchedulingRule)resource);
        }
        return rule;
    }

    public ISchedulingRule makeSchedulingRuleForIDE(Collection<IShareable> shareables, ISharingManager.RuleKind kind) {
        IPath eclipseWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot().getLocation();
        for (IShareable shareable : shareables) {
            if (!shareable.getFullPath().isPrefixOf(eclipseWorkspaceRoot)) continue;
            return EclipseFileStorage.getResourceRule((IResource)ResourcesPlugin.getWorkspace().getRoot(), kind);
        }
        ISchedulingRule rule = null;
        for (IShareable shareable : shareables) {
            IPath fullPath;
            ISchedulingRule myRule = ((Shareable)shareable).getFileStorage().getResourceRuleForIDE(kind);
            if (myRule == null && eclipseWorkspaceRoot.isPrefixOf(fullPath = shareable.getFullPath())) {
                return EclipseFileStorage.getResourceRule((IResource)ResourcesPlugin.getWorkspace().getRoot(), kind);
            }
            rule = MultiRule.combine(rule, (ISchedulingRule)myRule);
        }
        return rule;
    }

    public IFileContentMerger getFileContentMerger() {
        return FileContentMerger.getInstance();
    }

    public void deregister(ISandbox sandbox, IProgressMonitor monitor) throws FileSystemClientException {
        IProject[] projects;
        IPath sandboxRoot = sandbox.getRoot();
        boolean caseSensitive = sandbox.isCaseSensitive();
        IProject[] iProjectArray = projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            IPath projectLocation = project.getLocation();
            if (projectLocation != null && (PathUtils.isPrefixOf((IPath)sandboxRoot, (boolean)caseSensitive, (IPath)project.getLocation()) || PathUtils.isPrefixOf((IPath)projectLocation, (boolean)caseSensitive, (IPath)sandboxRoot)) && EclipseFileStorage.isRepositoryProviderRegistered(project)) {
                throw new FileSystemClientException(FileSystemStatus.getStatusFor((int)4, (String)Messages.ResourceSharingManager_0, null));
            }
            ++n2;
        }
        super.deregister(sandbox, monitor);
    }
}

