/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.rcp.core.internal.resources;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.IContentExaminer;
import com.ibm.team.filesystem.client.IContentProperties;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.ResourceType;
import com.ibm.team.filesystem.client.internal.FileSystemStatus;
import com.ibm.team.filesystem.client.internal.IFileStorage;
import com.ibm.team.filesystem.client.internal.Shareable;
import com.ibm.team.filesystem.client.internal.magic.ContentProperties;
import com.ibm.team.filesystem.client.internal.magic.LocalContentExaminer;
import com.ibm.team.filesystem.common.FileLineDelimiter;
import com.ibm.team.filesystem.rcp.core.internal.Messages;
import com.ibm.team.filesystem.rcp.core.internal.resources.ContentPropertiesPreference;
import com.ibm.team.filesystem.rcp.core.internal.resources.ContentPropertiesPreferenceManager;
import com.ibm.team.filesystem.rcp.core.internal.resources.ResourceUtil;
import com.ibm.team.repository.common.util.NLS;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.content.IContentType;

public class ResourceContentExaminer
implements IContentExaminer {
    private static ResourceContentExaminer instance = null;
    private static final IContentType ICONTENT_TYPE_TEXT = Platform.getContentTypeManager().getContentType("org.eclipse.core.runtime.text");

    public static synchronized IContentExaminer getInstance() {
        if (instance == null) {
            instance = new ResourceContentExaminer();
        }
        return instance;
    }

    public IContentProperties examine(IShareable shareable, IProgressMonitor mon) throws FileSystemClientException {
        return this.getContentProperties(shareable, false, mon);
    }

    public IContentProperties examine(String name, IContentExaminer.IStreamSource data, IProgressMonitor mon) throws FileSystemClientException {
        return this.getContentProperties(data, name);
    }

    public IContentProperties findStoredProperties(IShareable shareable, IProgressMonitor mon) throws FileSystemClientException {
        return this.getContentProperties(shareable, true, mon);
    }

    /*
     * Unable to fully structure code
     */
    public String getEncoding(IShareable shareable, IProgressMonitor progress) throws FileSystemClientException {
        block18: {
            encoding = null;
            resource = (IResource)shareable.getAdapter(IResource.class);
            if (resource != null) {
                try {
                    if (resource.getType() == 1) {
                        encoding = ((IFile)resource).getCharset(true);
                    }
                    if (!(resource instanceof IContainer)) ** GOTO lbl38
                    encoding = ((IContainer)resource).getDefaultCharset(true);
                }
                catch (CoreException e) {
                    throw new FileSystemClientException(FileSystemStatus.getStatusFor((int)4, (String)NLS.bind((String)Messages.ResourceContentExaminer_1, (Object)shareable.getLocalPath(), (Object[])new Object[0]), (Throwable)e));
                }
            } else {
                resourceType = shareable.getResourceType(progress);
                if (resourceType == ResourceType.FILE) {
                    contents = ((Shareable)shareable).getFileStorage().getContents();
                    try {
                        try {
                            description = Platform.getContentTypeManager().getDescriptionFor(contents, shareable.getLocalPath().lastSegment(), new QualifiedName[]{IContentDescription.CHARSET, IContentDescription.BYTE_ORDER_MARK});
                            encoding = this.getEncoding(description);
                        }
                        catch (IOException v0) {
                            try {
                                contents.close();
                            }
                            catch (IOException v1) {}
                            break block18;
                        }
                    }
                    catch (Throwable var8_9) {
                        try {
                            contents.close();
                        }
                        catch (IOException v2) {}
                        throw var8_9;
                    }
                    try {
                        contents.close();
                    }
                    catch (IOException v3) {}
                }
            }
        }
        if (encoding == null) {
            encoding = ResourcesPlugin.getEncoding();
        }
        return encoding;
    }

    private ContentProperties getContentProperties(IContentExaminer.IStreamSource data, String name) throws FileSystemClientException {
        String encoding;
        IContentType contentType;
        block17: {
            contentType = null;
            encoding = null;
            InputStream contents = data.getStream();
            if (contents == null) {
                contentType = Platform.getContentTypeManager().findContentTypeFor(name);
                if (contentType != null) {
                    encoding = this.getEncoding(contentType.getDefaultDescription());
                }
            } else {
                try {
                    try {
                        IContentDescription description = Platform.getContentTypeManager().getDescriptionFor(contents, name, new QualifiedName[]{IContentDescription.CHARSET, IContentDescription.BYTE_ORDER_MARK});
                        encoding = this.getEncoding(description);
                        if (description != null) {
                            contentType = description.getContentType();
                        }
                    }
                    catch (IOException iOException) {
                        try {
                            contents.close();
                        }
                        catch (IOException iOException2) {}
                        break block17;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        contents.close();
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
                try {
                    contents.close();
                }
                catch (IOException iOException) {}
            }
        }
        if (encoding == null) {
            encoding = LocalContentExaminer.sniffEncoding((IContentExaminer.IStreamSource)data);
        }
        ContentPropertiesPreferenceManager manager = new ContentPropertiesPreferenceManager();
        ContentPropertiesPreference pref = manager.get(contentType, name);
        String mimeType = pref.getMimeType();
        FileLineDelimiter lineDelimiter = pref.getLineDelimiter();
        if (encoding == null) {
            encoding = ResourcesPlugin.getEncoding();
        }
        return this.createContentProperties(contentType, encoding, mimeType, lineDelimiter);
    }

    private ContentProperties createContentProperties(IContentType contentType, String encoding, String mimeType, FileLineDelimiter lineDelimiter) {
        boolean isContentTypeText = contentType != null && contentType.isKindOf(ICONTENT_TYPE_TEXT);
        String contentTypeForMerge = contentType == null ? null : contentType.getId();
        ContentProperties p = new ContentProperties(encoding, mimeType, lineDelimiter, contentTypeForMerge, isContentTypeText);
        return p;
    }

    private IContentProperties getContentProperties(IShareable shareable, boolean includeStored, IProgressMonitor monitor) throws FileSystemClientException {
        IResource resource = (IResource)shareable.getAdapter(IResource.class);
        if (resource != null) {
            if (resource.getType() == 1) {
                try {
                    IFile file = (IFile)resource;
                    if (!file.exists()) {
                        return ContentProperties.UNKNOWN;
                    }
                    CoreException encodingException = null;
                    String encoding = null;
                    try {
                        encoding = file.getCharset(true);
                    }
                    catch (CoreException e) {
                        encodingException = e;
                    }
                    String mimeType = null;
                    FileLineDelimiter lineDelimiter = null;
                    if (includeStored) {
                        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                        mimeType = shareable.getContentType((IProgressMonitor)progress.newChild(50));
                        lineDelimiter = shareable.getLineDelimiter((IProgressMonitor)progress.newChild(50));
                    }
                    IContentType contentType = ResourceUtil.getContentTypeFor(file);
                    if (mimeType == null || lineDelimiter == null) {
                        ContentPropertiesPreferenceManager manager = new ContentPropertiesPreferenceManager();
                        ContentPropertiesPreference pref = manager.get(contentType, file.getName());
                        if (mimeType == null) {
                            mimeType = pref.getMimeType();
                        }
                        if (lineDelimiter == null) {
                            lineDelimiter = pref.getLineDelimiter();
                        }
                    }
                    ContentProperties properties = this.createContentProperties(contentType, encoding, mimeType, lineDelimiter);
                    if (encodingException != null && (properties.isText() || lineDelimiter != FileLineDelimiter.LINE_DELIMITER_NONE)) {
                        throw encodingException;
                    }
                    return properties;
                }
                catch (CoreException e) {
                    throw new FileSystemClientException(FileSystemStatus.getStatusFor((int)4, (String)NLS.bind((String)Messages.ResourceContentExaminer_0, (Object)shareable.getLocalPath().toString(), (Object[])new Object[0]), (Throwable)e));
                }
            }
            return ContentProperties.UNKNOWN;
        }
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        if (!shareable.exists((IProgressMonitor)progress.newChild(1))) {
            return ContentProperties.UNKNOWN;
        }
        String mimeType = null;
        FileLineDelimiter lineDelimiter = null;
        if (includeStored) {
            mimeType = shareable.getContentType((IProgressMonitor)progress.newChild(49));
            lineDelimiter = shareable.getLineDelimiter((IProgressMonitor)progress.newChild(50));
        }
        final IFileStorage storage = ((Shareable)shareable).getFileStorage();
        IContentExaminer.IStreamSource data = new IContentExaminer.IStreamSource(){

            public InputStream getStream() throws FileSystemClientException {
                return storage.getContents();
            }
        };
        ContentProperties properties = this.getContentProperties(data, shareable.getLocalPath().lastSegment());
        if (mimeType == null && lineDelimiter == null) {
            return properties;
        }
        if (mimeType == null) {
            mimeType = properties.getMimeType();
        } else if (lineDelimiter == null) {
            lineDelimiter = properties.getLineDelimiter();
        }
        String encoding = properties.getEncoding();
        if (encoding.equals(IContentProperties.CHARACTER_ENCODING_UNKNOWN)) {
            encoding = ResourcesPlugin.getEncoding();
        }
        properties = new ContentProperties(encoding, mimeType, lineDelimiter, properties.getContentTypeForMerge(), properties.isContentTypeText());
        return properties;
    }

    private String getEncoding(IContentDescription description) {
        String encoding = null;
        if (description != null) {
            byte[] bom = (byte[])description.getProperty(IContentDescription.BYTE_ORDER_MARK);
            if (bom == null) {
                encoding = (String)description.getProperty(IContentDescription.CHARSET);
            } else if (Arrays.equals(bom, IContentDescription.BOM_UTF_8)) {
                encoding = "UTF-8";
            } else if (Arrays.equals(bom, IContentDescription.BOM_UTF_16BE)) {
                encoding = "UTF-16BE";
            } else if (Arrays.equals(bom, IContentDescription.BOM_UTF_16LE)) {
                encoding = "UTF-16LE";
            }
        }
        return encoding;
    }
}

