/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.rcp.core.internal.resources;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.ResourceType;
import com.ibm.team.filesystem.client.internal.FileItemInfo;
import com.ibm.team.filesystem.client.internal.FileStorage;
import com.ibm.team.filesystem.client.internal.FileStorageWrapper;
import com.ibm.team.filesystem.client.internal.FileSystemStatus;
import com.ibm.team.filesystem.client.internal.IFileStorage;
import com.ibm.team.filesystem.client.internal.Shareable;
import com.ibm.team.filesystem.client.internal.SharingManager;
import com.ibm.team.filesystem.client.internal.Shed;
import com.ibm.team.filesystem.client.internal.localchanges.LocalChangeManager;
import com.ibm.team.filesystem.client.internal.utils.PathUtils;
import com.ibm.team.filesystem.client.operations.BackupDilemmaHandler;
import com.ibm.team.filesystem.rcp.core.internal.Messages;
import com.ibm.team.filesystem.rcp.core.internal.resources.EclipseFileStorage;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.repository.common.utils.TemporaryOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.osgi.service.datalocation.Location;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectCreator {
    private HashSet<Shareable> projectFiles;
    private HashSet<Shareable> newProjects;
    private boolean importProjects;
    private boolean createProjects;
    private IPath defaultWorkspacePath;
    private List<IStatus> errors;
    private IWorkspaceRoot workspaceRoot;
    private List<Shareable> projectFilesPossiblyUpdated;
    private Shed backupShed;

    public ProjectCreator(boolean importProjects, boolean createProjects) {
        this.importProjects = importProjects;
        this.createProjects = createProjects;
        this.projectFiles = new HashSet();
        this.newProjects = new HashSet();
        this.errors = new ArrayList<IStatus>();
        this.projectFilesPossiblyUpdated = new ArrayList<Shareable>();
        Location instanceLocation = Platform.getInstanceLocation();
        String file = instanceLocation.getURL().getPath();
        try {
            file = new File(file).getCanonicalPath();
        }
        catch (IOException iOException) {}
        this.defaultWorkspacePath = new Path(file);
        this.workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        BackupDilemmaHandler backupDilemmaHandler = new BackupDilemmaHandler(){

            public boolean backupEnabled() {
                return false;
            }
        };
        this.backupShed = new Shed(backupDilemmaHandler);
    }

    public void addPotentialProjectFile(Shareable possibleProjectFile) {
        if (possibleProjectFile.getLocalPath().lastSegment().equals(".project")) {
            this.projectFiles.add(possibleProjectFile);
        }
    }

    public void addNewProject(Shareable newProjectFolder) {
        this.newProjects.add(newProjectFolder);
    }

    public List<IStatus> createNewProjects(IProgressMonitor progress) throws FileSystemClientException {
        Collection<Object> projectsCreated;
        this.errors = new ArrayList<IStatus>();
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)(10 + 20 * (this.newProjects.size() + this.projectFiles.size())));
        if (this.createProjects && !this.newProjects.isEmpty()) {
            for (Shareable projectFolder : this.newProjects) {
                Shareable projectFile = new Shareable(projectFolder.getCopyFileAreaRoot(), projectFolder.getLocalPath().append(".project"), ResourceType.FILE);
                boolean isLoadAs = this.isLoadedWithAlternativeName(projectFolder, (IProgressMonitor)monitor.newChild(1));
                projectsCreated = this.createProject(projectFolder.getFullPath(), projectFile, isLoadAs, (IProgressMonitor)monitor.newChild(10));
                this.registerTeamProvider(projectsCreated, projectFolder, (IProgressMonitor)monitor.newChild(10));
            }
            this.newProjects.clear();
        }
        if (!this.projectFiles.isEmpty()) {
            ArrayList<Shareable> toImport = new ArrayList<Shareable>();
            toImport.addAll(this.projectFiles);
            Comparator<IShareable> comparator = new Comparator<IShareable>(){

                @Override
                public int compare(IShareable left, IShareable right) {
                    IPath leftPath = left.getFullPath();
                    IPath rightPath = right.getFullPath();
                    if (leftPath.segmentCount() < rightPath.segmentCount()) {
                        return -1;
                    }
                    if (leftPath.segmentCount() > rightPath.segmentCount()) {
                        return 1;
                    }
                    return 0;
                }
            };
            Collections.sort(toImport, comparator);
            for (Shareable projectFile : toImport) {
                Shareable projectFolder = new Shareable(projectFile.getSandbox(), projectFile.getLocalPath().removeLastSegments(1), ResourceType.FOLDER);
                boolean isLoadAs = this.isLoadedWithAlternativeName(projectFolder, (IProgressMonitor)monitor.newChild(1));
                projectsCreated = this.isDirectlyUnderDefaultWorkspace(projectFile) ? (this.importProjects ? this.createProject(projectFolder.getFullPath(), projectFile, isLoadAs, (IProgressMonitor)monitor.newChild(9)) : Collections.EMPTY_LIST) : this.importProject(projectFolder, projectFile, isLoadAs, (IProgressMonitor)monitor.newChild(9));
                this.registerTeamProvider(projectsCreated, projectFolder, (IProgressMonitor)monitor.newChild(10));
            }
            this.projectFiles.clear();
        }
        for (Shareable projectFile : this.projectFilesPossiblyUpdated) {
            LocalChangeManager.getInstance().computeChanges((IShareable)projectFile, (IProgressMonitor)monitor.newChild(1));
        }
        return this.errors;
    }

    private boolean isLoadedWithAlternativeName(Shareable projectFolder, IProgressMonitor progress) throws FileSystemClientException {
        FileItemInfo info;
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)2);
        boolean isLoadAs = false;
        if (projectFolder.isShare((IProgressMonitor)monitor.newChild(1)) && (info = projectFolder.getFileItemInfo((IProgressMonitor)monitor.newChild(1))) != null) {
            isLoadAs = info.isLoadedWithAnotherName();
        }
        return isLoadAs;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Collection<IProject> importProject(Shareable projectFolder, Shareable dotProjectFile, boolean isLoadAs, IProgressMonitor progress) {
        ArrayList<IProject> projects;
        block16: {
            SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)100);
            projects = new ArrayList<IProject>();
            ArrayList<IProject> movedProjects = new ArrayList<IProject>();
            try {
                IFile[] files;
                IFile[] iFileArray = files = this.workspaceRoot.findFilesForLocation(dotProjectFile.getFullPath());
                int n = files.length;
                int n2 = 0;
                while (n2 < n) {
                    IFile file = iFileArray[n2];
                    this.updateProjects((IResource)file, projects);
                    ++n2;
                }
                IProjectDescription projectDescription = ResourcesPlugin.getWorkspace().loadProjectDescription(dotProjectFile.getFullPath());
                Iterator<IProject> iProjects = projects.iterator();
                while (iProjects.hasNext()) {
                    IProject project = iProjects.next();
                    TemporaryOutputStream copy = this.preserve((IShareable)dotProjectFile, (IProgressMonitor)monitor.newChild(1));
                    try {
                        if (isLoadAs || project.getName().equals(projectDescription.getName()) || !PathUtils.samePath((IPath)projectFolder.getFullPath(), (boolean)projectFolder.getSandbox().isCaseSensitive(), (IPath)project.getLocation(), (boolean)projectFolder.getSandbox().isCaseSensitive())) continue;
                        dotProjectFile = new Shareable(dotProjectFile.getSandbox(), dotProjectFile.getLocalPath(), ResourceType.FILE);
                        projectDescription.setLocationURI(project.getDescription().getLocationURI());
                        project.move(projectDescription, 291, (IProgressMonitor)monitor.newChild(97));
                        iProjects.remove();
                        project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectDescription.getName());
                        if (!project.exists()) continue;
                        movedProjects.add(project);
                    }
                    finally {
                        this.restore((IShareable)dotProjectFile, copy, (IProgressMonitor)monitor.newChild(1));
                    }
                }
                projects.addAll(movedProjects);
                if (!this.importProjects || files.length != 0) break block16;
                TemporaryOutputStream preservedCopy = this.preserve((IShareable)dotProjectFile, (IProgressMonitor)monitor.newChild(25));
                IPath projectFolderFullPath = projectFolder.getFullPath();
                if (isLoadAs) {
                    projectDescription.setName(projectFolderFullPath.lastSegment());
                } else if (this.isDirectlyUnderDefaultWorkspace(dotProjectFile)) {
                    projectDescription.setName(projectFolderFullPath.lastSegment());
                }
                IProject project = this.workspaceRoot.getProject(projectDescription.getName());
                if (project.exists()) {
                    if (!project.getLocation().equals((Object)projectFolderFullPath)) {
                        this.collectStatus((IStatus)new FileSystemStatus(4, NLS.bind((String)Messages.EclipseWorkspaceMergeLoadMutator_0, (Object)dotProjectFile.getFullPath(), (Object[])new Object[]{projectDescription.getName()})));
                        return projects;
                    }
                    if (!project.isOpen()) {
                        try {
                            project.open((IProgressMonitor)monitor.newChild(90));
                        }
                        catch (CoreException e) {
                            this.collectStatus(FileSystemStatus.getStatusFor((int)4, (String)NLS.bind((String)Messages.EclipseWorkspaceMergeLoadMutator_2, (Object)dotProjectFile.getFullPath(), (Object[])new Object[0]), (Throwable)e));
                            return projects;
                        }
                    }
                    projects.add(project);
                } else {
                    project.create(projectDescription, (IProgressMonitor)monitor.newChild(10));
                    project.open((IProgressMonitor)monitor.newChild(80));
                    projects.add(project);
                }
                this.restore((IShareable)dotProjectFile, preservedCopy, (IProgressMonitor)monitor.newChild(10));
                return projects;
            }
            catch (CoreException e) {
                this.collectStatus(FileSystemStatus.getStatusFor((int)4, (String)NLS.bind((String)Messages.EclipseWorkspaceMergeLoadMutator_2, (Object)dotProjectFile.getFullPath(), (Object[])new Object[0]), (Throwable)e));
            }
        }
        return projects;
    }

    private Collection<IProject> createProject(IPath projectFolderFullPath, Shareable projectFile, boolean loadAs, IProgressMonitor progress) throws FileSystemClientException {
        ArrayList<IProject> projectsCreated;
        block18: {
            IProjectDescription projectDescription;
            SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)100);
            if (projectFile.exists((IProgressMonitor)monitor.newChild(1))) {
                try {
                    projectDescription = ResourcesPlugin.getWorkspace().loadProjectDescription(projectFile.getFullPath());
                }
                catch (CoreException coreException) {
                    projectDescription = this.newProjectDescription(this.workspaceRoot, projectFolderFullPath);
                }
            } else {
                projectDescription = this.newProjectDescription(this.workspaceRoot, projectFolderFullPath);
            }
            if (this.isDirectlyUnderDefaultWorkspace(projectFile)) {
                projectDescription.setName(projectFolderFullPath.lastSegment());
                projectDescription.setLocation(null);
            } else if (loadAs) {
                projectDescription.setName(projectFolderFullPath.lastSegment());
            }
            String projectName = projectDescription.getName();
            projectsCreated = new ArrayList<IProject>(1);
            try {
                IProject project = this.workspaceRoot.getProject(projectName);
                if (project.exists()) {
                    if (project.getLocation().equals((Object)projectFolderFullPath)) {
                        if (!project.isOpen()) {
                            try {
                                TemporaryOutputStream copy = this.preserve((IShareable)projectFile, (IProgressMonitor)monitor.newChild(1));
                                project.open((IProgressMonitor)monitor.newChild(70));
                                this.restore((IShareable)projectFile, copy, (IProgressMonitor)monitor.newChild(1));
                            }
                            catch (CoreException e) {
                                if (e.getStatus().getCode() == 567) {
                                    project.delete(false, true, (IProgressMonitor)monitor.newChild(10));
                                    project.create(projectDescription, (IProgressMonitor)monitor.newChild(10));
                                    project.open((IProgressMonitor)monitor.newChild(10));
                                    this.recomputeChangeForProjectFile((IShareable)projectFile);
                                }
                                throw e;
                            }
                        }
                        projectsCreated.add(project);
                        break block18;
                    }
                    IContainer container = this.workspaceRoot.getContainerForLocation(projectFolderFullPath);
                    if (container == null || container.getProject() == null) {
                        this.collectStatus((IStatus)new FileSystemStatus(4, NLS.bind((String)Messages.EclipseWorkspaceMergeLoadMutator_1, (Object)projectFolderFullPath.toString(), (Object[])new Object[]{projectName})));
                    }
                    break block18;
                }
                IContainer container = this.workspaceRoot.getContainerForLocation(projectFolderFullPath);
                if (container == null || container.getProject() == null) {
                    TemporaryOutputStream preservedCopy = this.preserve((IShareable)projectFile, (IProgressMonitor)monitor.newChild(5));
                    project.create(projectDescription, (IProgressMonitor)monitor.newChild(10));
                    if (!project.isOpen()) {
                        project.open((IProgressMonitor)monitor.newChild(80));
                    }
                    this.restore((IShareable)projectFile, preservedCopy, (IProgressMonitor)monitor.newChild(5));
                    preservedCopy = null;
                    projectsCreated.add(project);
                }
            }
            catch (CoreException e) {
                MultiStatus status = new MultiStatus("com.ibm.team.filesystem.client", 4, new IStatus[]{e.getStatus()}, NLS.bind((String)Messages.EclipseWorkspaceMergeLoadMutator_3, (Object)projectName, (Object[])new Object[0]), (Throwable)e);
                status.add(e.getStatus());
                this.collectStatus((IStatus)status);
            }
        }
        return projectsCreated;
    }

    private boolean isDirectlyUnderDefaultWorkspace(Shareable dotProjectFile) {
        return PathUtils.isPrefixOf((IPath)this.defaultWorkspacePath, (boolean)dotProjectFile.getSandbox().isCaseSensitive(), (IPath)dotProjectFile.getFullPath()) && dotProjectFile.getFullPath().segmentCount() == this.defaultWorkspacePath.segmentCount() + 2;
    }

    private void registerTeamProvider(Collection<IProject> projectsCreated, Shareable projectFolder, IProgressMonitor monitor) throws FileSystemClientException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)(projectsCreated.size() * 3));
        for (IProject newProject : projectsCreated) {
            IPath newProjectPath = newProject.getLocation();
            if (newProjectPath.segmentCount() <= projectFolder.getCopyFileAreaRoot().segmentCount()) continue;
            newProjectPath = newProjectPath.removeFirstSegments(projectFolder.getCopyFileAreaRoot().segmentCount()).setDevice(null);
            Shareable projectFile = new Shareable(projectFolder.getSandbox(), newProjectPath.append(".project"), ResourceType.FILE);
            TemporaryOutputStream preservedCopy = this.preserve((IShareable)projectFile, (IProgressMonitor)progress.newChild(1));
            Shareable shareable = new Shareable(projectFolder.getSandbox(), newProject.getLocation().removeFirstSegments(projectFolder.getCopyFileAreaRoot().segmentCount()).setDevice(null), ResourceType.FOLDER);
            FileStorageWrapper storage = new FileStorageWrapper(shareable, ResourceType.FOLDER);
            storage.setUnderlyingStorage((FileStorage)new EclipseFileStorage((IFileStorage)storage, (IResource)newProject));
            SharingManager sm = SharingManager.getInstance();
            sm.disableChangeMonitoring();
            try {
                storage.registerRepositorProvider((IProgressMonitor)progress.newChild(1));
            }
            finally {
                sm.enableChangeMonitoring();
            }
            this.restore((IShareable)projectFile, preservedCopy, (IProgressMonitor)progress.newChild(1));
        }
    }

    private void updateProjects(IResource projectFile, ArrayList<IProject> projects) {
        IProject project;
        if (projectFile != null && (project = projectFile.getProject()).equals((Object)projectFile.getParent())) {
            projects.add(project);
        }
    }

    private IProjectDescription newProjectDescription(IWorkspaceRoot workspaceRoot, IPath projectFolderFullPath) {
        IProjectDescription projectDescription = workspaceRoot.getWorkspace().newProjectDescription(projectFolderFullPath.lastSegment());
        IPath platform = this.defaultWorkspacePath.append(projectDescription.getName());
        if (!projectFolderFullPath.toFile().equals(platform.toFile())) {
            projectDescription.setLocation(projectFolderFullPath);
        }
        return projectDescription;
    }

    private TemporaryOutputStream preserve(IShareable projectFile, IProgressMonitor progress) {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)100);
        TemporaryOutputStream tmpOut = null;
        try {
            IFileStorage storage;
            long size;
            if (projectFile.exists((IProgressMonitor)monitor.newChild(1)) && (size = (storage = ((Shareable)projectFile).getFileStorage()).getSize((IProgressMonitor)monitor)) > 0L) {
                tmpOut = TemporaryOutputStream.getTemporaryOutputStream((long)storage.getSize((IProgressMonitor)monitor.newChild(99)));
                InputStream in = storage.getContents();
                byte[] buffer = new byte[4096];
                int numbytes = in.read(buffer);
                while (numbytes != -1) {
                    tmpOut.write(buffer, 0, numbytes);
                    numbytes = in.read(buffer);
                }
                in.close();
                in = null;
                tmpOut.close();
            }
        }
        catch (IOException iOException) {
        }
        catch (FileSystemClientException fileSystemClientException) {}
        return tmpOut;
    }

    private void restore(IShareable projectFile, TemporaryOutputStream preservedCopy, IProgressMonitor monitor) {
        if (preservedCopy != null) {
            SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
            try {
                InputStream tmpIn = preservedCopy.getInputStream((IProgressMonitor)progress.newChild(25));
                Shareable refreshedProjectFile = new Shareable(projectFile.getSandbox(), projectFile.getLocalPath(), ResourceType.FILE);
                IFileStorage contents = refreshedProjectFile.getFileStorage();
                contents.setContents(tmpIn, this.backupShed, (IProgressMonitor)progress.newChild(25));
                tmpIn.close();
                tmpIn = null;
                preservedCopy.dispose();
            }
            catch (IOException iOException) {
                this.recomputeChangeForProjectFile(projectFile);
            }
            catch (FileSystemClientException fileSystemClientException) {
                this.recomputeChangeForProjectFile(projectFile);
            }
            catch (TeamRepositoryException teamRepositoryException) {
                this.recomputeChangeForProjectFile(projectFile);
            }
        } else {
            this.recomputeChangeForProjectFile(projectFile);
        }
    }

    private void recomputeChangeForProjectFile(IShareable projectFile) {
        this.projectFilesPossiblyUpdated.add(new Shareable(projectFile.getSandbox(), projectFile.getLocalPath(), ResourceType.FILE));
    }

    private void collectStatus(IStatus error) {
        this.errors.add(error);
    }
}

