/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.rcp.core.internal.resources;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.FileSystemCore;
import com.ibm.team.filesystem.client.ILocalChangeManager;
import com.ibm.team.filesystem.client.ISandbox;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.ResourceType;
import com.ibm.team.filesystem.client.internal.FileSystemStatus;
import com.ibm.team.filesystem.client.internal.ManagedFileStore;
import com.ibm.team.filesystem.client.internal.ManagedFileSystem;
import com.ibm.team.filesystem.client.internal.Share;
import com.ibm.team.filesystem.client.internal.SharingManager;
import com.ibm.team.filesystem.client.internal.copyfileareas.AbstractLock;
import com.ibm.team.filesystem.client.internal.copyfileareas.CFALockUtil;
import com.ibm.team.filesystem.client.internal.copyfileareas.CopyFileArea;
import com.ibm.team.filesystem.client.internal.copyfileareas.CopyFileAreaManager;
import com.ibm.team.filesystem.client.internal.localchanges.LocalChangeTracker;
import com.ibm.team.filesystem.rcp.core.internal.Messages;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.team.IMoveDeleteHook;
import org.eclipse.core.resources.team.IResourceTree;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.osgi.util.NLS;

public class MoveDeleteHook
implements IMoveDeleteHook {
    public boolean deleteFile(IResourceTree tree, IFile file, int updateFlags, IProgressMonitor monitor) {
        return this.deleteResource(tree, (IResource)file, updateFlags, monitor);
    }

    public boolean deleteFolder(IResourceTree tree, IFolder folder, int updateFlags, IProgressMonitor monitor) {
        return this.deleteResource(tree, (IResource)folder, updateFlags, monitor);
    }

    private boolean deleteResource(IResourceTree tree, IResource resource, int updateFlags, IProgressMonitor monitor) {
        block11: {
            CFALockUtil.LockResult lock;
            SubMonitor progress;
            block10: {
                ManagedFileStore managedStore;
                block9: {
                    IFileStore store = EFS.getStore((URI)resource.getLocationURI());
                    managedStore = null;
                    if (store instanceof ManagedFileStore) {
                        managedStore = (ManagedFileStore)store;
                    }
                    if (managedStore != null) break block9;
                    return false;
                }
                progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                lock = CFALockUtil.createAndLockForUpdateOfChildren((IPath)managedStore.getCfaPath(), (IPath)managedStore.getLocalPath(), (boolean)true, (IProgressMonitor)progress.newChild(10));
                try {
                    if (resource instanceof IFolder) {
                        tree.standardDeleteFolder((IFolder)resource, updateFlags, (IProgressMonitor)progress.newChild(80));
                        break block10;
                    }
                    tree.standardDeleteFile((IFile)resource, updateFlags, (IProgressMonitor)progress.newChild(80));
                }
                catch (Throwable throwable) {
                    try {
                        CFALockUtil.endBatching((CFALockUtil.LockResult)lock, (SubMonitor)progress.newChild(10));
                        throw throwable;
                    }
                    catch (FileSystemClientException e) {
                        StatusUtil.log((Object)this, (Throwable)e);
                        break block11;
                    }
                    catch (CoreException e) {
                        StatusUtil.log((Object)this, (Throwable)e);
                    }
                }
            }
            CFALockUtil.endBatching((CFALockUtil.LockResult)lock, (SubMonitor)progress.newChild(10));
            return true;
        }
        return false;
    }

    public boolean deleteProject(IResourceTree tree, IProject project, int updateFlags, IProgressMonitor monitor) {
        if (this.trackingChanges()) {
            SubMonitor progress;
            block13: {
                URI uri;
                block12: {
                    progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                    uri = project.getDescription().getLocationURI();
                    if (uri != null) break block12;
                    return false;
                }
                try {
                    ManagedFileSystem.ManagedLocation location = ManagedFileSystem.expandUri((URI)uri);
                    SharingManager sm = SharingManager.getInstance();
                    ISandbox sandbox = sm.getSandbox(location.getCfaRoot(), false);
                    IPath localPath = location.getSharePath();
                    AbstractLock lock = CFALockUtil.createAndLockForUpdate((IPath)location.getCfaRoot(), (IPath)location.getSharePath(), (boolean)true, (IProgressMonitor)progress.newChild(1));
                    if (lock == null) break block13;
                    try {
                        CopyFileArea copyFileArea = CopyFileAreaManager.instance.getExistingCopyFileArea(sandbox.getRoot());
                        Share share = copyFileArea.getShare(localPath);
                        if (share.getPath().segmentCount() == localPath.segmentCount()) {
                            copyFileArea.forget(localPath, (IProgressMonitor)progress.newChild(98));
                        } else {
                            boolean delete;
                            if (project.isOpen()) {
                                delete = (updateFlags & 8) == 0;
                            } else {
                                boolean bl = delete = (updateFlags & 4) != 0;
                            }
                            if (delete) {
                                copyFileArea.deleteTreeInfo(localPath, false, (IProgressMonitor)progress.newChild(98));
                            }
                        }
                    }
                    finally {
                        CFALockUtil.endBatching((AbstractLock)lock, (IProgressMonitor)progress.newChild(1));
                    }
                }
                catch (CoreException e) {
                    tree.failed(FileSystemStatus.getStatusFor((Throwable)e));
                }
            }
            progress.done();
        }
        return false;
    }

    public boolean moveFile(IResourceTree tree, IFile source, IFile destination, int updateFlags, IProgressMonitor monitor) {
        return this.moveResource(tree, (IResource)source, (IResource)destination, updateFlags, monitor);
    }

    public boolean moveFolder(IResourceTree tree, IFolder source, IFolder destination, int updateFlags, IProgressMonitor monitor) {
        return this.moveResource(tree, (IResource)source, (IResource)destination, updateFlags, monitor);
    }

    private boolean moveResource(IResourceTree tree, IResource source, IResource destination, int updateFlags, IProgressMonitor monitor) {
        block12: {
            CFALockUtil.LockResult lock;
            SubMonitor progress;
            block11: {
                ManagedFileStore managedSource;
                IFileStore destinationStore;
                block10: {
                    IFileStore sourceStore = EFS.getStore((URI)source.getLocationURI());
                    destinationStore = EFS.getStore((URI)destination.getLocationURI());
                    managedSource = null;
                    if (sourceStore instanceof ManagedFileStore) {
                        managedSource = (ManagedFileStore)sourceStore;
                    }
                    if (managedSource != null) break block10;
                    return false;
                }
                ManagedFileStore managedDestination = null;
                if (destinationStore instanceof ManagedFileStore) {
                    managedDestination = (ManagedFileStore)destinationStore;
                }
                progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                lock = managedDestination == null ? CFALockUtil.createAndLockForUpdateOfChildren((IPath)managedSource.getCfaPath(), (IPath)managedSource.getLocalPath(), (boolean)true, (IProgressMonitor)progress.newChild(10)) : CFALockUtil.createAndLockForUpdateOfChildren(Arrays.asList(managedSource.getCfaPath(), managedDestination.getCfaPath()), Arrays.asList(managedSource.getLocalPath(), managedDestination.getLocalPath()), (boolean)true, (IProgressMonitor)progress.newChild(10));
                try {
                    if (source instanceof IFolder) {
                        tree.standardMoveFolder((IFolder)source, (IFolder)destination, updateFlags, (IProgressMonitor)progress.newChild(80));
                        break block11;
                    }
                    tree.standardMoveFile((IFile)source, (IFile)destination, updateFlags, monitor);
                }
                catch (Throwable throwable) {
                    try {
                        CFALockUtil.endBatching((CFALockUtil.LockResult)lock, (SubMonitor)progress.newChild(10));
                        throw throwable;
                    }
                    catch (FileSystemClientException e) {
                        StatusUtil.log((Object)this, (Throwable)e);
                        break block12;
                    }
                    catch (CoreException e) {
                        StatusUtil.log((Object)this, (Throwable)e);
                    }
                }
            }
            CFALockUtil.endBatching((CFALockUtil.LockResult)lock, (SubMonitor)progress.newChild(10));
            return true;
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    public boolean moveProject(IResourceTree tree, IProject source, IProjectDescription description, int updateFlags, IProgressMonitor monitor) {
        sm = SharingManager.getInstance();
        src = source.getLocationURI();
        if (!"sourcecontrol".equals(src.getScheme())) {
            return false;
        }
        targetURI = description.getLocationURI();
        equal = src.equals(targetURI);
        if (targetURI == null) {
            managed = false;
        } else {
            managed = "sourcecontrol".equals(targetURI.getScheme());
            if (!equal && managed) {
                return false;
            }
        }
        try {
            rootStore = EFS.getStore((URI)ResourcesPlugin.getWorkspace().getRoot().getLocationURI());
            fullPath = new Path(src.getPath());
            if (fullPath.segment(0).equals("default")) {
                numSegments = 0;
                cfaPath = null;
            } else {
                numSegments = Integer.parseInt(fullPath.segment(0));
                cfaPath = fullPath.removeLastSegments(fullPath.segmentCount() - numSegments - 1).removeFirstSegments(1).makeUNC(fullPath.isUNC()).makeAbsolute();
                if (cfaPath.equals((Object)sm.getIDEWorkAreaRoot())) {
                    cfaPath = null;
                }
            }
            srcSharePath = fullPath.removeFirstSegments(numSegments + 1);
            srcSharePath = srcSharePath.setDevice(null).makeUNC(false).makeAbsolute();
            srcBaseStore = src.getQuery() == null ? (cfaPath == null ? EFS.getStore((URI)URIUtil.toURI((IPath)sm.getIDEWorkAreaRoot().append(srcSharePath))) : EFS.getStore((URI)URIUtil.toURI((IPath)cfaPath.append(srcSharePath)))) : EFS.getStore((URI)new URI(src.getQuery()));
            cfaRootStore = srcBaseStore;
            i = srcSharePath.segmentCount();
            while (i != 0) {
                cfaRootStore = cfaRootStore.getParent();
                --i;
            }
            intermediateBaseStoreURI = baseStoreURI = managed ? (targetURI.getQuery() == null ? null : new URI(targetURI.getQuery())) : targetURI;
            baseStore = null;
            if (baseStoreURI == null && srcSharePath.segmentCount() == 1) ** GOTO lbl-1000
            if (baseStoreURI != null) {
                baseStore = EFS.getStore((URI)baseStoreURI);
                ** if (!rootStore.getChild((String)source.getName()).equals((Object)baseStore)) goto lbl-1000
            }
            ** GOTO lbl-1000
lbl-1000:
            // 2 sources

            {
                sharePath = Path.EMPTY;
                currentStore = rootStore.getChild(description.getName());
                while (!currentStore.equals(cfaRootStore)) {
                    sharePath = new Path(null, currentStore.getName()).append((IPath)sharePath);
                    if ((currentStore = currentStore.getParent()) != null) continue;
                    throw new FileSystemClientException(FileSystemStatus.getStatusFor((int)4, (String)NLS.bind((String)Messages.MoveDeleteHook_0, (Object)rootStore.getChild(description.getName()).toString()), null));
                }
                sharePath = sharePath.setDevice(null).makeUNC(false).makeAbsolute();
                baseStoreURI = null;
                if (!managed) {
                    intermediateBaseStoreURI = cfaRootStore.getChild((IPath)sharePath).toURI();
                }
                ** GOTO lbl62
            }
lbl-1000:
            // 2 sources

            {
                if (baseStore == null) {
                    baseStore = baseStoreURI == null ? rootStore.getChild(srcSharePath) : EFS.getStore((URI)baseStoreURI);
                }
                sharePath = Path.EMPTY;
                currentStore = baseStore;
                while (!currentStore.equals(cfaRootStore)) {
                    sharePath = new Path(null, currentStore.getName()).append((IPath)sharePath);
                    if ((currentStore = currentStore.getParent()) != null) continue;
                    throw new FileSystemClientException(FileSystemStatus.getStatusFor((int)4, (String)NLS.bind((String)Messages.MoveDeleteHook_0, (Object)baseStore.toString()), null));
                }
                sharePath = sharePath.setDevice(null).makeUNC(false).makeAbsolute();
                if (baseStoreURI == null && !sharePath.equals((Object)srcSharePath)) {
                    baseStoreURI = baseStore.toURI();
                }
            }
lbl62:
            // 4 sources

            uri = ManagedFileSystem.getManagedURI((IPath)cfaPath, (IPath)sharePath, (URI)baseStoreURI);
            intermediate = ManagedFileSystem.getManagedURI((IPath)cfaPath, (IPath)srcSharePath, (URI)intermediateBaseStoreURI);
        }
        catch (CoreException e) {
            tree.failed(FileSystemStatus.getStatusFor((Throwable)e));
            return true;
        }
        catch (URISyntaxException e) {
            tree.failed(FileSystemStatus.getStatusFor((Throwable)e));
            return true;
        }
        if (uri.equals(src)) {
            return false;
        }
        progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        if (!equal) {
            description.setLocationURI(uri);
        }
        sm.disableChangeMonitoring();
        try {
            tree.standardMoveProject(source, description, updateFlags, (IProgressMonitor)progress.newChild(50));
        }
        finally {
            sm.enableChangeMonitoring();
        }
        if (!sharePath.equals((Object)srcSharePath)) {
            progress.setWorkRemaining(100);
            try {
                EFS.getStore((URI)intermediate).move(EFS.getStore((URI)uri), 0, (IProgressMonitor)progress.newChild(50));
            }
            catch (CoreException e) {
                tree.failed(FileSystemStatus.getStatusFor((Throwable)e));
                return true;
            }
        }
        dest = source.getWorkspace().getRoot().getProject(description.getName());
        if (equal) {
            description.setLocationURI(uri);
            tree.movedProjectSubtree(dest, description);
        }
        if (sm.isChangeMonitoringEnabled()) {
            if (cfaPath == null) {
                cfaPath = sm.getIDEWorkAreaRoot();
            }
            try {
                shareable = sm.findShareable(sm.getSandbox(cfaPath, false), (IPath)sharePath, ResourceType.FOLDER);
                LocalChangeTracker.computePendingChanges((IShareable)shareable, (ILocalChangeManager.RefreshType)ILocalChangeManager.RefreshType.TRAVERSE_ALL_KNOWN, (IProgressMonitor)progress.newChild(50));
            }
            catch (FileSystemClientException e) {
                tree.failed(FileSystemStatus.getStatusFor((Throwable)e));
                return true;
            }
        }
        return true;
    }

    private boolean trackingChanges() {
        return SharingManager.getInstance().isChangeMonitoringEnabled() && !FileSystemCore.isShutDown();
    }
}

