/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.rcp.core.internal.resources;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.IShare;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.internal.SharingManager;
import com.ibm.team.filesystem.client.internal.ignore.IIgnoreEvent;
import com.ibm.team.filesystem.client.internal.ignore.IIgnoreManager;
import com.ibm.team.filesystem.client.internal.ignore.IIgnoreProvider;
import com.ibm.team.filesystem.client.internal.ignore.IgnoreProvider;
import com.ibm.team.filesystem.rcp.core.internal.Messages;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LinkedResourceIgnoreProvider
extends IgnoreProvider {
    public static final String LINKED_RESOURCE_PROVIDER = "linkResourceIgnores";
    private boolean triggerFlush;
    static final Map<IIgnoreManager, Boolean> cacheFlushRegistry = new IdentityHashMap<IIgnoreManager, Boolean>();

    public static final synchronized LinkedResourceIgnoreProvider getInstance(IProgressMonitor progress) {
        return (LinkedResourceIgnoreProvider)SharingManager.getInstance().getIgnoreManager().getIgnoreProvider(LINKED_RESOURCE_PROVIDER, progress);
    }

    protected void syncChangeTrackerForEvent(IShareable ignoreRoot, IIgnoreEvent event, SubMonitor monitor) throws FileSystemClientException {
    }

    public IIgnoreProvider.IIgnoreTester getTester(IShareable shareable) {
        return new IIgnoreProvider.IIgnoreTester(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean shouldInvalidateCache(IShareable shareable) {
                Map<IIgnoreManager, Boolean> map = cacheFlushRegistry;
                synchronized (map) {
                    Boolean r;
                    block4: {
                        r = cacheFlushRegistry.remove(LinkedResourceIgnoreProvider.this.getIgnoreManager());
                        if (r != null) break block4;
                        return false;
                    }
                    return r;
                }
            }

            public boolean shouldBeIgnored(IShareable toIgnore, IPath path, IProgressMonitor progress) {
                IResource member = ResourcesPlugin.getWorkspace().getRoot().findMember(path);
                if (member != null) {
                    return member.isLinked();
                }
                return false;
            }

            public List findIgnoreReasons(IShareable shareable, IPath path, IProgressMonitor progress) {
                IResource member = ResourcesPlugin.getWorkspace().getRoot().findMember(path);
                if (member != null && member.isLinked()) {
                    boolean isLink = this.getPath(shareable).equals(path);
                    return Collections.singletonList(new LinkedResourceIgnoreRule(LinkedResourceIgnoreProvider.this, isLink));
                }
                return Collections.EMPTY_LIST;
            }

            private Object getPath(IShareable shareable) {
                IResource resource = (IResource)shareable.getAdapter(IResource.class);
                if (resource != null) {
                    return resource.getFullPath();
                }
                return Path.EMPTY;
            }

            public void done() {
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void triggerCacheFlushFor(IIgnoreManager igMan) {
        Map<IIgnoreManager, Boolean> map = cacheFlushRegistry;
        synchronized (map) {
            cacheFlushRegistry.put(igMan, true);
        }
    }

    protected IgnoreProvider createCopyInternal(Collection<IIgnoreManager.ICopyParameter> params, IIgnoreManager ignoreManager, IProgressMonitor progress) {
        return new LinkedResourceIgnoreProvider();
    }

    public void flushInAbsenceOfEvents(Collection<IShareable> roots, IProgressMonitor newChild) {
    }

    private class LinkedResourceIgnoreRule
    implements IIgnoreProvider.IIgnoreRule {
        private final LinkedResourceIgnoreProvider provider;
        private final boolean isLink;

        public LinkedResourceIgnoreRule(LinkedResourceIgnoreProvider provider, boolean isLink) {
            this.provider = provider;
            this.isLink = isLink;
        }

        public List getEffectiveFrom(IProgressMonitor monitor) {
            IShare[] shares;
            try {
                shares = SharingManager.getInstance().allShares(monitor);
            }
            catch (FileSystemClientException e) {
                e.printStackTrace();
                return Collections.emptyList();
            }
            ArrayList<IShareable> shareables = new ArrayList<IShareable>(shares.length);
            IShare[] iShareArray = shares;
            int n = shares.length;
            int n2 = 0;
            while (n2 < n) {
                IShare share = iShareArray[n2];
                shareables.add(share.getShareable());
                ++n2;
            }
            return shareables;
        }

        public IIgnoreProvider getProvider() {
            return this.provider;
        }

        public boolean isEffectiveBelow(IShareable shareable) {
            return true;
        }

        public boolean shouldBeIgnored(IShareable shareable) {
            IResource resource = (IResource)shareable.getAdapter(IResource.class);
            if (resource != null) {
                return resource.isLinked();
            }
            return false;
        }

        public String getShortDescription() {
            if (this.isLink) {
                return Messages.LinkedResourceIgnoreProvider_0;
            }
            return Messages.LinkedResourceIgnoreProvider_1;
        }
    }
}

