/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.rcp.core.internal.resources;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.ISandbox;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.internal.Shareable;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileArea;
import com.ibm.team.filesystem.client.internal.load.DeferredUpdateInformation;
import com.ibm.team.filesystem.client.internal.load.LoadLocation;
import com.ibm.team.filesystem.client.internal.load.MergeLoadMutator;
import com.ibm.team.filesystem.client.internal.utils.NonCancellingProgressMonitor;
import com.ibm.team.filesystem.client.operations.IDownloadListener;
import com.ibm.team.filesystem.client.operations.LoadDilemmaHandler;
import com.ibm.team.filesystem.common.internal.dto.FileAreaUpdate;
import com.ibm.team.filesystem.common.internal.dto.LoadTree;
import com.ibm.team.filesystem.rcp.core.internal.resources.ProjectCreator;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.common.IComponent;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EclipseWorkspaceMergeLoadMutator
extends MergeLoadMutator {
    private boolean importProjects;
    private boolean preserveShareRootProject;
    private boolean createProjects;
    private ProjectCreator projectCreator;

    public EclipseWorkspaceMergeLoadMutator(int options, IConnection connection, IComponent component, ISandbox sandbox, List<LoadLocation> itemsToLoad, LoadTree loadTree, LoadDilemmaHandler problemHandler, IDownloadListener downloadMonitor) {
        super(connection, component, sandbox, itemsToLoad, loadTree, problemHandler, downloadMonitor);
        if ((options & 3) == 3) {
            throw new IllegalArgumentException("Only one of CREATE_PROJECTS_FOR_NEW_SHARE_ROOTS or IMPORT_PROJECTS can be specified");
        }
        if (options > 7) {
            throw new IllegalArgumentException("Invalid option " + options);
        }
        this.importProjects = (options & 2) == 2;
        this.preserveShareRootProject = (options & 4) == 4;
        this.createProjects = (options & 1) == 1;
        this.projectCreator = new ProjectCreator(this.importProjects, this.createProjects);
    }

    protected void createNewFile(DeferredUpdateInformation deferredUpdateInformation, IProgressMonitor monitor) throws FileSystemClientException, TeamRepositoryException {
        super.createNewFile(deferredUpdateInformation, monitor);
    }

    protected void modifyFile(Shareable shareable, DeferredUpdateInformation deferredUpdateInformation, IProgressMonitor monitor) throws FileSystemClientException, TeamRepositoryException {
        super.modifyFile(shareable, deferredUpdateInformation, monitor);
    }

    protected void createNewFolder(ICopyFileArea copyFileArea, boolean isShare, Shareable shareable, FileAreaUpdate update, IProgressMonitor monitor) throws FileSystemClientException, TeamRepositoryException {
        super.createNewFolder(copyFileArea, isShare, shareable, update, monitor);
        if (this.createProjects && isShare) {
            this.projectCreator.addNewProject(shareable);
        }
    }

    protected void contentLoadCompleted(Shareable shareable, IProgressMonitor progress) throws FileSystemClientException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)100);
        this.projectCreator.addPotentialProjectFile(shareable);
        super.contentLoadCompleted(shareable, (IProgressMonitor)monitor.newChild(10));
    }

    protected void contentLoadCompleted(IProgressMonitor monitor) throws FileSystemClientException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)new NonCancellingProgressMonitor(monitor), (int)100);
        if (this.createProjects || this.importProjects) {
            List<IStatus> createErrors = this.projectCreator.createNewProjects((IProgressMonitor)progress.newChild(90));
            for (IStatus status : createErrors) {
                this.collectStatus(status);
            }
        }
        super.contentLoadCompleted((IProgressMonitor)progress.newChild(10));
    }

    protected boolean isSpecialCase(IShareable shareable, IProgressMonitor monitor) throws FileSystemClientException {
        Shareable parent;
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        if ((this.preserveShareRootProject || this.createProjects) && ".project".equals(shareable.getLocalPath().lastSegment()) && (parent = (Shareable)((Shareable)shareable).getParent()) != null && parent.isShare((IProgressMonitor)progress.newChild(50)) && shareable.getRemote((IProgressMonitor)progress.newChild(49)) == null) {
            return true;
        }
        progress.setWorkRemaining(1);
        return super.isSpecialCase(shareable, (IProgressMonitor)progress.newChild(1));
    }
}

