/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.rcp.core.internal.resources;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.ISandbox;
import com.ibm.team.filesystem.client.IShare;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.ISharingManager;
import com.ibm.team.filesystem.client.ResourceType;
import com.ibm.team.filesystem.client.internal.FileStorage;
import com.ibm.team.filesystem.client.internal.FileStorageWrapper;
import com.ibm.team.filesystem.client.internal.FileSystemStatus;
import com.ibm.team.filesystem.client.internal.IFileStorage;
import com.ibm.team.filesystem.client.internal.LoggingHelper;
import com.ibm.team.filesystem.client.internal.ManagedFileStore;
import com.ibm.team.filesystem.client.internal.Shareable;
import com.ibm.team.filesystem.client.internal.SharingManager;
import com.ibm.team.filesystem.client.internal.Shed;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileArea;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileAreaManager;
import com.ibm.team.filesystem.client.internal.utils.PathUtils;
import com.ibm.team.filesystem.client.operations.BackupDilemmaHandler;
import com.ibm.team.filesystem.rcp.core.internal.Messages;
import com.ibm.team.filesystem.rcp.core.internal.resources.ApoRepositoryProvider;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceRuleFactory;
import org.eclipse.core.resources.ResourceAttributes;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.osgi.util.NLS;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.core.TeamException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EclipseFileStorage
extends FileStorage {
    protected static final Method setWritableMethod;
    private final IResource resource;

    static {
        Method m = null;
        try {
            m = File.class.getMethod("setWritable", Boolean.TYPE, Boolean.TYPE);
        }
        catch (NoSuchMethodException noSuchMethodException) {}
        setWritableMethod = m;
    }

    EclipseFileStorage(IFileStorage storage, IResource resource) {
        super(storage);
        this.resource = resource;
    }

    private IResource getResource() {
        return this.resource;
    }

    public long getModificationStamp() {
        return this.resource.getModificationStamp();
    }

    public long getLocalTimeStamp() {
        return this.resource.getLocalTimeStamp();
    }

    public IFileStorage getParent() {
        FileStorageWrapper parent = null;
        IPath parentPath = this.getLocalPath().removeLastSegments(1);
        if (parentPath.segmentCount() != 0) {
            Shareable parentShareable = new Shareable(this.getSandbox(), parentPath, ResourceType.FOLDER);
            parent = new FileStorageWrapper(parentShareable, ResourceType.FOLDER);
            if (this.resource.isLinked()) {
                SharingManager.getInstance().resolveFileStorage(parent, ResourceType.FOLDER);
            } else if (this.resource.getType() == 4) {
                SharingManager.getInstance().resolveFileStorage(parent, ResourceType.FOLDER);
            } else {
                new EclipseFileStorage((IFileStorage)parent, (IResource)this.resource.getParent());
            }
        }
        return parent;
    }

    public void resolveChildStorage(FileStorageWrapper childStorage, String name, ResourceType type) {
        if (this.resource.getType() == 1) {
            SharingManager.getInstance().resolveLocalFileStorage(childStorage, type);
        } else {
            File file;
            IResource childResource = ((IContainer)this.resource).findMember(name);
            if (childResource == null && !childStorage.getShareable().getSandbox().isCaseSensitive()) {
                String lowerCaseName = name.toUpperCase().toLowerCase();
                IResource[] children = new IResource[]{};
                try {
                    children = ((IContainer)this.resource).members();
                }
                catch (CoreException coreException) {}
                IResource[] iResourceArray = children;
                int n = children.length;
                int n2 = 0;
                while (n2 < n) {
                    IResource r = iResourceArray[n2];
                    if (r.getName().toUpperCase().toLowerCase().equals(lowerCaseName)) {
                        childResource = r;
                        break;
                    }
                    ++n2;
                }
            }
            if (childResource != null) {
                IPath path;
                if (this.withinCopyFileArea(childResource)) {
                    childStorage.setUnderlyingStorage((FileStorage)new EclipseFileStorage((IFileStorage)childStorage, childResource));
                    return;
                }
                if (childResource.exists() && (path = childResource.getLocation()) != null) {
                    type = childResource.getType() == 1 ? ResourceType.FILE : ResourceType.FOLDER;
                    SharingManager.getInstance().resolveFileStorage(childStorage, type);
                    return;
                }
            }
            if (type == ResourceType.SYMBOLIC_LINK && (file = childStorage.getShareable().getFullPath().toFile()).exists()) {
                type = file.isFile() ? ResourceType.FILE : ResourceType.FOLDER;
            }
            if (type == ResourceType.FILE) {
                childResource = ((IContainer)this.resource).getFile((IPath)new Path(name));
                childStorage.setUnderlyingStorage((FileStorage)new EclipseFileStorage((IFileStorage)childStorage, childResource));
            } else if (type == ResourceType.FOLDER) {
                childResource = ((IContainer)this.resource).getFolder((IPath)new Path(name));
                childStorage.setUnderlyingStorage((FileStorage)new EclipseFileStorage((IFileStorage)childStorage, childResource));
            } else {
                SharingManager.getInstance().resolveLocalFileStorage(childStorage, type);
            }
        }
    }

    private boolean withinCopyFileArea(IResource resource) {
        IPath path = resource.getLocation();
        ISandbox sandbox = this.getSandbox();
        return path != null && PathUtils.isPrefixOf((IPath)sandbox.getRoot(), (boolean)sandbox.isCaseSensitive(), (IPath)path);
    }

    public Collection<IFileStorage> getChildren(IProgressMonitor progress) throws FileSystemClientException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)100);
        IFileStore fileStorage = this.getFileStore();
        SharingManager sm = SharingManager.getInstance();
        sm.disableChangeMonitoring();
        try {
            IFileInfo fileInfo = fileStorage.fetchInfo(0, (IProgressMonitor)monitor.newChild(1));
            if (!fileInfo.isDirectory() || fileInfo.getAttribute(32)) {
                return null;
            }
        }
        catch (CoreException e) {
            throw new FileSystemClientException(FileSystemStatus.getStatusFor((int)4, (String)NLS.bind((String)Messages.EclipseFileStorage_8, (Object)this.getLocalPath().toString()), (Throwable)e));
        }
        finally {
            sm.enableChangeMonitoring();
        }
        if (this.resource.getType() != 1) {
            IResource[] children = null;
            try {
                children = ((IContainer)this.resource).members(2);
            }
            catch (CoreException e) {
                if (e.getStatus().getCode() == 368) {
                    return null;
                }
                throw new FileSystemClientException(FileSystemStatus.getStatusFor((int)4, (int)205, (String)"Couldn't find children", (Throwable)e));
            }
            ArrayList<IFileStorage> storageChildren = new ArrayList<IFileStorage>();
            ISandbox sandbox = this.getSandbox();
            IPath path = this.getLocalPath();
            IResource[] iResourceArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                IResource child = iResourceArray[n2];
                if (this.withinCopyFileArea(child)) {
                    ResourceType type = child instanceof IContainer ? ResourceType.FOLDER : ResourceType.FILE;
                    Shareable childShareable = new Shareable(sandbox, path.append(child.getName()), type);
                    FileStorageWrapper storage = new FileStorageWrapper(childShareable, this.getStorage(), type);
                    storage.setUnderlyingStorage((FileStorage)new EclipseFileStorage((IFileStorage)storage, child));
                    storageChildren.add((IFileStorage)storage);
                }
                ++n2;
            }
            return storageChildren;
        }
        return null;
    }

    public InputStream getContents() throws FileSystemClientException {
        return this.getContents(false);
    }

    public InputStream getContents(boolean force) throws FileSystemClientException {
        if (this.resource.getType() != 1) {
            return null;
        }
        try {
            return ((IFile)this.resource).getContents(force);
        }
        catch (CoreException e) {
            URI uri;
            if (force && e.getStatus().getCode() == 368 && this.resource.getParent() != null && this.resource.getParent().exists() && (uri = this.resource.getLocationURI()) != null) {
                try {
                    final IFileStore store = EFS.getStore((URI)uri);
                    final InputStream[] stream = new InputStream[1];
                    SharingManager.getInstance().doSilentChange(new SharingManager.CoreRunnable(){

                        public void run() throws CoreException {
                            stream[0] = store.openInputStream(0, null);
                        }
                    });
                    return stream[0];
                }
                catch (CoreException coreException) {}
            }
            throw new FileSystemClientException(FileSystemStatus.getStatusFor((int)4, (int)203, (String)"Error getting contents", (Throwable)e));
        }
    }

    public void create(InputStream in, IProgressMonitor monitor) throws FileSystemClientException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        try {
            try {
                if (this.resource.getType() != 1) {
                    throw new FileSystemClientException((IStatus)new FileSystemStatus(Messages.EclipseFileStorage_0));
                }
                ((IFile)this.resource).create(in, false, (IProgressMonitor)progress.newChild(100));
            }
            catch (CoreException e) {
                throw new FileSystemClientException(FileSystemStatus.getStatusFor((Throwable)e));
            }
        }
        catch (Throwable throwable) {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
            progress.done();
            throw throwable;
        }
        if (in != null) {
            try {
                in.close();
            }
            catch (IOException iOException) {}
        }
        progress.done();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void create(boolean createParents, IProgressMonitor progress) throws FileSystemClientException {
        if (this.resource.getType() == 2) {
            if (!this.resource.getParent().exists() && !createParents) throw new FileSystemClientException(FileSystemStatus.getStatusFor((int)4, (String)NLS.bind((String)Messages.EclipseFileStorage_5, (Object)this.resource.getFullPath().toPortableString()), null));
            boolean created = this.createFolder((IFolder)this.resource, SubMonitor.convert((IProgressMonitor)progress, (int)(this.resource.getFullPath().segmentCount() + 1)));
            if (created || !createParents) return;
            SharingManager.getInstance().resolveLocalFileStorage((FileStorageWrapper)this.getStorage(), ResourceType.FOLDER);
            this.getStorage().create(createParents, progress);
            return;
        } else {
            if (this.resource.getType() != 4) throw new FileSystemClientException(FileSystemStatus.getStatusFor((int)4, (String)Messages.EclipseFileStorage_1, null));
            SharingManager.getInstance().resolveLocalFileStorage((FileStorageWrapper)this.getStorage(), ResourceType.FOLDER);
            this.getStorage().create(createParents, progress);
        }
    }

    private boolean createFolder(IFolder resourceToCreate, SubMonitor progress) throws FileSystemClientException {
        IContainer parent = resourceToCreate.getParent();
        if (parent.exists()) {
            try {
                resourceToCreate.create(true, true, (IProgressMonitor)progress.newChild(1));
                return true;
            }
            catch (CoreException e) {
                throw new FileSystemClientException(FileSystemStatus.getStatusFor((Throwable)e));
            }
        }
        if (parent.getType() != 2) {
            return false;
        }
        if (this.createFolder((IFolder)parent, progress)) {
            try {
                resourceToCreate.create(true, true, (IProgressMonitor)progress.newChild(1));
                return true;
            }
            catch (CoreException e) {
                throw new FileSystemClientException(FileSystemStatus.getStatusFor((Throwable)e));
            }
        }
        return false;
    }

    public void setContents(InputStream in, boolean force, IProgressMonitor monitor) throws FileSystemClientException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        try {
            if (this.resource.getType() != 1) {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException e) {
                        throw new FileSystemClientException(FileSystemStatus.getStatusFor((Throwable)e));
                    }
                }
                throw new FileSystemClientException((IStatus)new FileSystemStatus("Cannot set contents on a folder"));
            }
            try {
                ((IFile)this.resource).setContents(in, force, true, (IProgressMonitor)progress.newChild(100));
            }
            catch (FileSystemClientException e) {
                throw e;
            }
            catch (CoreException e) {
                throw new FileSystemClientException(FileSystemStatus.getStatusFor((Throwable)e));
            }
        }
        finally {
            progress.done();
        }
    }

    public void setContents(InputStream in, Shed backupShed, IProgressMonitor monitor) throws FileSystemClientException, TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        try {
            if (this.resource.getType() != 1) {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException e) {
                        throw new FileSystemClientException(FileSystemStatus.getStatusFor((Throwable)e));
                    }
                }
                throw new FileSystemClientException((IStatus)new FileSystemStatus("Cannot set contents on a folder"));
            }
            try {
                boolean backedUp = backupShed.backupIfDirty(this.getStorage().getShareable(), (IProgressMonitor)progress.newChild(50));
                ((IFile)this.resource).setContents(in, true, !backedUp, (IProgressMonitor)progress.newChild(50));
            }
            catch (FileSystemClientException e) {
                throw e;
            }
            catch (CoreException e) {
                throw new FileSystemClientException(FileSystemStatus.getStatusFor((Throwable)e));
            }
        }
        finally {
            progress.done();
        }
    }

    public IPath getIDEPath() {
        return this.resource.getFullPath();
    }

    public String getActualName() {
        return this.resource.getName();
    }

    public String toString() {
        return String.valueOf(this.getIDEPath().toString()) + (this.resource.getType() == 1 ? "" : "/");
    }

    public boolean isExecutable(IProgressMonitor monitor) throws FileSystemClientException {
        ResourceAttributes attr = this.getResource().getResourceAttributes();
        return attr == null ? false : attr.isExecutable();
    }

    public boolean setExecutable(boolean exec, IProgressMonitor monitor) {
        ResourceAttributes attr = this.getResource().getResourceAttributes();
        if (attr != null) {
            attr.setExecutable(exec);
            try {
                this.getResource().setResourceAttributes(attr);
                return true;
            }
            catch (CoreException e) {
                LoggingHelper.log((IStatus)FileSystemStatus.getStatusFor((Throwable)e));
            }
        }
        return false;
    }

    public void move(FileStorage target, IProgressMonitor monitor) throws FileSystemClientException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        ResourceType actualResourceType = this.getStorage().getResourceType((IProgressMonitor)progress.newChild(1));
        if (actualResourceType == null) {
            throw new FileSystemClientException((IStatus)new FileSystemStatus(4, NLS.bind((String)Messages.EclipseFileStorage_7, (Object)this.getLocalPath(), (Object)target.getIDEPath())));
        }
        if (target instanceof EclipseFileStorage && (this.resource.exists() || actualResourceType != ResourceType.SYMBOLIC_LINK)) {
            try {
                this.resource.move(target.getIDEPath(), 35, (IProgressMonitor)progress.newChild(99));
            }
            catch (CoreException e) {
                throw new FileSystemClientException(FileSystemStatus.getStatusFor((Throwable)e));
            }
        }
        if (this.resource.getType() == 4 && actualResourceType != ResourceType.SYMBOLIC_LINK) {
            Path defaultRoot;
            ISandbox targetSandbox = target.getStorage().getShareable().getSandbox();
            IPath relativeDestination = target.getStorage().getShareable().getLocalPath();
            IPath fullPath = targetSandbox.getRoot().append(relativeDestination);
            IPath targetParent = fullPath.removeLastSegments(1);
            Location instanceLocation = Platform.getInstanceLocation();
            try {
                defaultRoot = new Path(new File(instanceLocation.getURL().getPath()).getCanonicalPath());
            }
            catch (IOException iOException) {
                defaultRoot = new Path(new File(instanceLocation.getURL().getPath()).getAbsolutePath());
            }
            try {
                IProjectDescription description = ((IProject)this.resource).getDescription();
                if (PathUtils.samePath((IPath)targetParent, (boolean)targetSandbox.isCaseSensitive(), (IPath)defaultRoot, (boolean)targetSandbox.isCaseSensitive())) {
                    description.setName(relativeDestination.lastSegment());
                    description.setLocation(null);
                } else {
                    description.setLocation(fullPath);
                }
                IProject project = (IProject)this.resource;
                project.move(description, 35, (IProgressMonitor)progress.newChild(99));
            }
            catch (CoreException e) {
                throw new FileSystemClientException(FileSystemStatus.getStatusFor((Throwable)e));
            }
        }
        ISandbox targetSandbox = target.getStorage().getShareable().getSandbox();
        IPath relativeDestination = target.getStorage().getShareable().getLocalPath();
        ResourceType type = this.resource.getType() == 1 ? ResourceType.FILE : ResourceType.FOLDER;
        IFileStorage localSource = SharingManager.getInstance().getLocalFileStorage(this.getSandbox(), this.getLocalPath(), type);
        localSource.move(targetSandbox, relativeDestination, (IProgressMonitor)progress.newChild(40));
        this.refreshCachedSubTree(Integer.MAX_VALUE, (IProgressMonitor)progress.newChild(25));
        target.refreshCachedSubTree(Integer.MAX_VALUE, (IProgressMonitor)progress.newChild(25));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void delete(IProgressMonitor monitor) throws FileSystemClientException, TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        if (this.resource.exists()) {
            try {
                if (this.resource.getType() == 4) {
                    ((IProject)this.resource).clearHistory((IProgressMonitor)progress.newChild(10));
                    ((IProject)this.resource).delete(true, true, (IProgressMonitor)progress.newChild(90));
                    return;
                }
                if (this.resource.getType() == 2) {
                    ((IFolder)this.resource).delete(true, true, (IProgressMonitor)progress.newChild(100));
                    return;
                }
                if (this.resource.getType() != 1) return;
                ((IFile)this.resource).delete(true, true, (IProgressMonitor)progress.newChild(100));
                return;
            }
            catch (CoreException e) {
                throw new FileSystemClientException(FileSystemStatus.getStatusFor((Throwable)e));
            }
        } else {
            IFileStorage localStorage = this.getLocalStorageEquiv((IProgressMonitor)progress.newChild(1));
            localStorage.delete((IProgressMonitor)progress.newChild(99));
        }
    }

    private IFileStorage getLocalStorageEquiv(IProgressMonitor progress) throws FileSystemClientException, TeamRepositoryException {
        ResourceType type = this.resource.getType() == 1 ? ResourceType.FILE : ResourceType.FOLDER;
        return SharingManager.getInstance().getLocalFileStorage(this.getSandbox(), this.getLocalPath(), type);
    }

    public boolean contains(ISchedulingRule rule) {
        if (rule instanceof EclipseFileStorage) {
            rule = ((EclipseFileStorage)rule).resource;
        }
        return this.getResource().contains(rule);
    }

    public boolean isConflicting(ISchedulingRule rule) {
        if (rule instanceof EclipseFileStorage) {
            rule = ((EclipseFileStorage)rule).resource;
        }
        return this.getResource().isConflicting(rule);
    }

    public void refreshCachedSubTree(int depth, IProgressMonitor monitor) throws FileSystemClientException {
        try {
            int resourceDepth = depth == 0 ? 0 : (depth == 1 ? 1 : 2);
            this.resource.refreshLocal(resourceDepth, monitor);
        }
        catch (FileSystemClientException e) {
            throw e;
        }
        catch (CoreException e) {
            throw new FileSystemClientException(FileSystemStatus.getStatusFor((Throwable)e));
        }
    }

    public boolean shouldBeIgnored(IProgressMonitor monitor) {
        IResource walker = this.resource;
        while (walker != null) {
            if (walker.isDerived()) {
                return true;
            }
            walker = walker.getParent();
        }
        return super.shouldBeIgnored(monitor);
    }

    public Object getAdapter(Class adaptTo) {
        if (adaptTo.isAssignableFrom(IResource.class)) {
            return this.getResource();
        }
        if (adaptTo.isAssignableFrom(File.class)) {
            return this.getStorage().getShareable().getFullPath().toFile();
        }
        IResource resource = this.getResource();
        if (adaptTo.isAssignableFrom(resource.getClass())) {
            return resource;
        }
        return Platform.getAdapterManager().getAdapter((Object)this.getStorage().getShareable(), adaptTo);
    }

    public ISchedulingRule getExternalSchedulingRule() {
        return this.resource;
    }

    public void deregisterRepositoryProvider(IProgressMonitor monitor) throws FileSystemClientException {
        IProject sharedProject = this.resource.getProject();
        IPath path = sharedProject.getLocation();
        IPath sandboxRoot = this.getSandbox().getRoot();
        if (path != null && PathUtils.isPrefixOf((IPath)sandboxRoot, (boolean)this.getSandbox().isCaseSensitive(), (IPath)path)) {
            if (!this.resource.equals((Object)sharedProject)) {
                ICopyFileArea copyFileArea = ICopyFileAreaManager.instance.getExistingCopyFileArea(sandboxRoot);
                for (IShare share : copyFileArea.allShares()) {
                    IPath fullPath = share.getSandbox().getRoot().append(share.getPath());
                    if (path.segmentCount() == fullPath.segmentCount() || !path.isPrefixOf(fullPath)) continue;
                    return;
                }
            }
            if (RepositoryProvider.getProvider((IProject)sharedProject, (String)"com.ibm.team.filesystem.rcp.core.provider") != null) {
                try {
                    ApoRepositoryProvider.unmap(sharedProject.getProject(), monitor);
                }
                catch (TeamException e) {
                    throw new FileSystemClientException(FileSystemStatus.getStatusFor((int)4, (int)206, (String)NLS.bind((String)Messages.ShareableResource_5, (Object)sharedProject.getName()), (Throwable)e));
                }
            }
        }
    }

    public void registerRepositorProvider(IProgressMonitor monitor) throws FileSystemClientException {
        block5: {
            RepositoryProvider existing;
            IProject project = this.resource.getProject();
            IPath path = project.getLocation();
            if (path != null && PathUtils.isPrefixOf((IPath)this.getSandbox().getRoot(), (boolean)this.getSandbox().isCaseSensitive(), (IPath)path) && project.exists() && (existing = RepositoryProvider.getProvider((IProject)project)) == null) {
                try {
                    SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                    if (!project.isOpen()) {
                        project.open((IProgressMonitor)progress.newChild(98));
                    }
                    ApoRepositoryProvider.map(project, (IProgressMonitor)progress.newChild(1));
                }
                catch (TeamException e) {
                    throw new FileSystemClientException(FileSystemStatus.getStatusFor((int)4, (int)204, (String)Messages.ShareableResource_4, (Throwable)e));
                }
                catch (CoreException e) {
                    IStatus status = e.getStatus();
                    if (status != null && status.getCode() == 567) break block5;
                    throw new FileSystemClientException(FileSystemStatus.getStatusFor((int)4, (String)NLS.bind((String)Messages.EclipseFileStorage_4, (Object)project.getName()), (Throwable)e));
                }
            }
        }
    }

    public boolean isRepositoryProviderRegistered(IProgressMonitor monitor) throws FileSystemClientException {
        IProject p = this.getResource().getProject();
        return EclipseFileStorage.isRepositoryProviderRegistered(p);
    }

    static boolean isRepositoryProviderRegistered(IProject p) {
        URI l = p.getLocationURI();
        if (l != null && "sourcecontrol".equals(l.getScheme())) {
            return true;
        }
        RepositoryProvider provider = RepositoryProvider.getProvider((IProject)p);
        return provider != null && "com.ibm.team.filesystem.rcp.core.provider".equals(provider.getID());
    }

    public void preserveHistory(IProgressMonitor monitor) throws TeamRepositoryException {
        block6: {
            if (this.resource instanceof IFile) {
                final SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                try {
                    SharingManager.getInstance().doSilentChange(new SharingManager.CoreRunnable(){

                        public void run() throws CoreException {
                            ((IFile)EclipseFileStorage.this.resource).appendContents((InputStream)new ByteArrayInputStream(new byte[0]), true, true, (IProgressMonitor)progress.newChild(50));
                        }
                    });
                }
                catch (CoreException e) {
                    if (e.getStatus().getCode() == 279) {
                        if (!this.setWritable(true, (IProgressMonitor)progress.newChild(1))) break block6;
                        try {
                            SharingManager.getInstance().doSilentChange(new SharingManager.CoreRunnable(){

                                public void run() throws CoreException {
                                    ((IFile)EclipseFileStorage.this.resource).appendContents((InputStream)new ByteArrayInputStream(new byte[0]), true, true, (IProgressMonitor)progress.newChild(49));
                                }
                            });
                        }
                        catch (CoreException coreException) {
                            throw new TeamRepositoryException(NLS.bind((String)Messages.EclipseFileStorage_3, (Object)this.resource.getFullPath()), (Throwable)e);
                        }
                    }
                    throw new TeamRepositoryException(NLS.bind((String)Messages.EclipseFileStorage_3, (Object)this.resource.getFullPath()), (Throwable)e);
                }
            }
        }
    }

    public void lock(IProgressMonitor mon) {
        Job.getJobManager().beginRule((ISchedulingRule)this.resource, mon);
    }

    public void unlock() {
        Job.getJobManager().endRule((ISchedulingRule)this.resource);
    }

    public URI getLocationURI() {
        return this.resource.getLocationURI();
    }

    public ISchedulingRule getResourceRuleForIDE(ISharingManager.RuleKind kind) {
        return EclipseFileStorage.getResourceRule(this.resource, kind);
    }

    public static ISchedulingRule getResourceRule(IResource resource, ISharingManager.RuleKind kind) {
        IResourceRuleFactory factory = ResourcesPlugin.getWorkspace().getRuleFactory();
        switch (kind) {
            case CREATE: {
                return factory.createRule(resource);
            }
            case DELETE: {
                return factory.deleteRule(resource);
            }
            case MODIFY: {
                return factory.modifyRule(resource);
            }
            case REFRESH: {
                return factory.refreshRule(resource);
            }
        }
        throw new IllegalArgumentException(NLS.bind((String)Messages.EclipseFileStorage_2, (Object)kind));
    }

    public boolean requiresBackup(IProgressMonitor monitor) throws FileSystemClientException {
        ResourceType actualResourceType = this.getStorage().getResourceType(monitor);
        if (actualResourceType == ResourceType.SYMBOLIC_LINK) {
            return false;
        }
        if (this.resource.getType() == 1) {
            return !this.resource.isSynchronized(0);
        }
        try {
            return ((IContainer)this.resource).members(2).length != 0;
        }
        catch (CoreException coreException) {
            return false;
        }
    }

    public void backup(Shed shed, BackupDilemmaHandler dilemmaHandler, IProgressMonitor monitor) throws TeamRepositoryException, FileSystemClientException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        Shareable shareable = this.getStorage().getShareable();
        ResourceType actualResourceType = this.getStorage().getResourceType((IProgressMonitor)progress.newChild(1));
        if (actualResourceType != ResourceType.SYMBOLIC_LINK && this.resource.getType() == 1) {
            if (!this.resource.exists()) {
                shed.backupInShed(this.getStorage().getShareable(), (IProgressMonitor)progress.newChild(98));
            } else if (!this.resource.isSynchronized(0)) {
                shed.backupInShed(shareable, (IProgressMonitor)progress.newChild(98));
                this.preserveHistory((IProgressMonitor)progress.newChild(1));
                dilemmaHandler.backedUpInIDE((IShareable)shareable);
            } else {
                this.preserveHistory((IProgressMonitor)progress.newChild(1));
                dilemmaHandler.backedUpInIDE((IShareable)shareable);
            }
        } else {
            shed.backupInShed(shareable, (IProgressMonitor)progress.newChild(100));
        }
    }

    public boolean storageExists(IProgressMonitor progress) {
        return this.resource.exists();
    }

    public boolean supportsExecBit() {
        return FileStorage.PLATFORM_SUPPORTS_EXEC_BIT;
    }

    protected IFileStore getFileStore() {
        try {
            return EFS.getStore((URI)this.resource.getLocationURI());
        }
        catch (CoreException coreException) {
            return new ManagedFileStore(this.getSandbox().getRoot(), this.getLocalPath(), EFS.getLocalFileSystem().getStore(this.getStorage().getShareable().getFullPath()));
        }
    }

    public boolean setWritable(boolean writable, IProgressMonitor progress) {
        boolean success;
        block9: {
            success = false;
            SharingManager sm = SharingManager.getInstance();
            sm.disableChangeMonitoring();
            try {
                try {
                    ResourceAttributes attributes = this.resource.getResourceAttributes();
                    attributes.setReadOnly(false);
                    this.resource.setResourceAttributes(attributes);
                    attributes = this.resource.getResourceAttributes();
                    success = !attributes.isReadOnly();
                }
                catch (CoreException coreException) {
                    sm.enableChangeMonitoring();
                    break block9;
                }
            }
            catch (Throwable throwable) {
                sm.enableChangeMonitoring();
                throw throwable;
            }
            sm.enableChangeMonitoring();
        }
        if (!success && setWritableMethod != null) {
            try {
                success = (Boolean)setWritableMethod.invoke((Object)writable, true);
            }
            catch (IllegalAccessException e) {
                LoggingHelper.log((IStatus)FileSystemStatus.getStatusFor((Throwable)e));
            }
            catch (InvocationTargetException e) {
                LoggingHelper.log((IStatus)FileSystemStatus.getStatusFor((Throwable)e.getTargetException()));
            }
        }
        return success;
    }
}

