/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.rcp.core.internal.resources;

import com.ibm.team.filesystem.common.FileLineDelimiter;
import com.ibm.team.filesystem.rcp.core.internal.resources.ContentPropertiesPreferenceManager;
import com.ibm.team.filesystem.rcp.core.internal.resources.ResourceUtil;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.content.IContentType;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public abstract class ContentPropertiesPreference {
    private static final String MIME_TYPE = "MimeType";
    private static final String LINE_DELIMITER = "LineDelimiter";
    protected Map<String, ContentPropertiesPreference> map;
    protected ContentPropertiesPreferenceManager manager;
    private String id;
    private FileLineDelimiter lineDelimiter;
    private String mimeType;
    private FileLineDelimiter originalLineDelimiter;
    private String originalMimeType;

    public abstract ContentPropertiesPreference getParent();

    public abstract IContentType getIContentType();

    ContentPropertiesPreference get(String filename) {
        String extension = ResourceUtil.getFileExtension(filename);
        if (extension == null || this.getId().equals(extension)) {
            ContentPropertiesPreference filenamePref = this.map.get(filename);
            if (filenamePref == null) {
                filenamePref = new FilenameFilePropertyPreference(this.manager, this.getPrefParentKey(), filename, this);
                this.map.put(filename, filenamePref);
            }
            return filenamePref;
        }
        ContentPropertiesPreference extensionPref = this.map.get(extension);
        if (extensionPref == null) {
            extensionPref = new FilenameFilePropertyPreference(this.manager, this.getPrefParentKey(), extension, this);
            this.map.put(extension, extensionPref);
        }
        if (filename.toLowerCase().equals(extension)) {
            return extensionPref;
        }
        return extensionPref.get(filename);
    }

    abstract String getPrefParentKey();

    public abstract String getName();

    protected Preferences getPreference() {
        return this.manager.getPreference();
    }

    public String getId() {
        return this.id;
    }

    public FileLineDelimiter getTrueLineDelimiter() {
        return this.lineDelimiter;
    }

    public FileLineDelimiter getLineDelimiter() {
        ContentPropertiesPreference ancestor = this;
        do {
            if (ancestor.lineDelimiter == null) continue;
            return ancestor.lineDelimiter;
        } while ((ancestor = ancestor.getParent()) != null);
        return this.isText() ? FileLineDelimiter.LINE_DELIMITER_PLATFORM : FileLineDelimiter.LINE_DELIMITER_NONE;
    }

    public void setLineDelimiter(FileLineDelimiter lineDelimiter) {
        this.lineDelimiter = lineDelimiter;
    }

    public String getTrueMimeType() {
        return this.mimeType;
    }

    public String getMimeType() {
        ContentPropertiesPreference ancestor = this;
        do {
            if (ancestor.mimeType == null) continue;
            return ancestor.mimeType;
        } while ((ancestor = ancestor.getParent()) != null);
        return "application/unknown";
    }

    public void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }

    public boolean isText() {
        return ResourceUtil.isText(this.getMimeType(), this.getIContentType());
    }

    ContentPropertiesPreference() {
    }

    void init(ContentPropertiesPreferenceManager manager, String key) {
        this.manager = manager;
        this.id = key;
        this.map = new HashMap<String, ContentPropertiesPreference>();
        this.refresh();
    }

    public ContentPropertiesPreference[] getChildren() {
        return this.map.values().toArray(new ContentPropertiesPreference[this.map.size()]);
    }

    public boolean preferenceHeiarchyExists() {
        if (this.preferenceExists()) {
            return true;
        }
        ContentPropertiesPreference parent = this.getParent();
        if (parent != null && parent != this.manager.getFileNamesAndExtensions()) {
            return parent.preferenceExists();
        }
        return false;
    }

    public boolean preferenceExists() {
        Preferences pref = this.getPreference();
        try {
            return pref.nodeExists(this.id);
        }
        catch (BackingStoreException backingStoreException) {
            return false;
        }
    }

    public void refresh() {
        ContentPropertiesPreference[] contentPropertiesPreferenceArray = this.getChildren();
        int n = contentPropertiesPreferenceArray.length;
        int n2 = 0;
        while (n2 < n) {
            ContentPropertiesPreference child = contentPropertiesPreferenceArray[n2];
            child.refresh();
            ++n2;
        }
        this.setLineDelimiter(null);
        this.setMimeType(null);
        if (this.preferenceExists()) {
            Preferences pref = this.getPreference();
            Preferences node = pref.node(this.id);
            int lineDelimiterIndex = node.getInt(LINE_DELIMITER, -1);
            this.setLineDelimiter(lineDelimiterIndex == -1 ? null : FileLineDelimiter.getLineDelimiter((int)lineDelimiterIndex));
            this.setMimeType(node.get(MIME_TYPE, null));
        }
        this.originalLineDelimiter = this.lineDelimiter;
        this.originalMimeType = this.mimeType;
    }

    private static boolean nullOrEquals(Object o1, Object o2) {
        if (o1 == null) {
            return o2 == null;
        }
        return o1.equals(o2);
    }

    public boolean isDirty() {
        return !ContentPropertiesPreference.nullOrEquals(this.lineDelimiter, this.originalLineDelimiter) || !ContentPropertiesPreference.nullOrEquals(this.mimeType, this.originalMimeType);
    }

    public void flush() throws BackingStoreException {
        ContentPropertiesPreference[] contentPropertiesPreferenceArray = this.getChildren();
        int n = contentPropertiesPreferenceArray.length;
        int n2 = 0;
        while (n2 < n) {
            ContentPropertiesPreference child = contentPropertiesPreferenceArray[n2];
            child.flush();
            ++n2;
        }
        if (this.mimeType == null && this.lineDelimiter == null) {
            this.removeNode();
            this.originalLineDelimiter = null;
            this.originalMimeType = null;
            return;
        }
        if (!this.isDirty()) {
            return;
        }
        Preferences pref = this.getPreference();
        Preferences node = pref.node(this.id);
        if (this.lineDelimiter == null) {
            node.remove(LINE_DELIMITER);
        } else {
            node.putInt(LINE_DELIMITER, this.lineDelimiter.dbValue());
        }
        if (this.mimeType == null) {
            node.remove(MIME_TYPE);
        } else {
            node.put(MIME_TYPE, this.mimeType);
        }
        this.originalLineDelimiter = this.lineDelimiter;
        this.originalMimeType = this.mimeType;
        node.flush();
    }

    protected void removeNode() throws BackingStoreException {
        Preferences pref = this.getPreference();
        if (pref.nodeExists(this.id)) {
            Preferences node = pref.node(this.id);
            if (node.childrenNames().length == 0) {
                node.removeNode();
                pref.flush();
                return;
            }
            node.remove(LINE_DELIMITER);
            node.remove(MIME_TYPE);
        }
    }

    static class FilenameFilePropertyPreference
    extends ContentPropertiesPreference {
        private String parentKey;
        private ContentPropertiesPreference parent;

        public FilenameFilePropertyPreference(ContentPropertiesPreferenceManager manager, String parentKey, String filename, ContentPropertiesPreference parent) {
            this.parentKey = parentKey;
            this.parent = parent;
            this.init(manager, filename);
        }

        String getPrefParentKey() {
            return this.parentKey;
        }

        public ContentPropertiesPreference getParent() {
            return this.parent;
        }

        public IContentType getIContentType() {
            if (this.parent == null) {
                return null;
            }
            return this.parent.getIContentType();
        }

        protected Preferences getPreference() {
            if (this.parentKey == null) {
                return this.manager.getPreference();
            }
            return this.manager.getPreference().node(this.parentKey);
        }

        public boolean preferenceExists() {
            if (this.parentKey == null) {
                return super.preferenceExists();
            }
            try {
                if (!this.manager.getPreference().nodeExists(this.parentKey)) {
                    return false;
                }
            }
            catch (BackingStoreException backingStoreException) {
                return false;
            }
            return super.preferenceExists();
        }

        protected void removeNode() throws BackingStoreException {
            if (this.parentKey != null && this.manager.getPreference().nodeExists(this.parentKey)) {
                super.removeNode();
                Preferences parentNode = this.getPreference();
                if (parentNode.childrenNames().length == 0 && parentNode.keys().length == 0) {
                    parentNode.removeNode();
                    this.manager.getPreference().flush();
                }
            }
        }

        public void refresh() {
            Preferences pref = this.manager.getPreference();
            if (this.parentKey == null) {
                super.refresh();
                return;
            }
            try {
                Preferences parentNode;
                if (pref.nodeExists(this.parentKey) && (parentNode = pref.node(this.parentKey)).nodeExists(this.getId())) {
                    super.refresh();
                    return;
                }
            }
            catch (BackingStoreException backingStoreException) {}
            this.setLineDelimiter(null);
            this.setMimeType(null);
        }

        public String getName() {
            return this.getId();
        }
    }

    public static class IContentTypePreferences
    extends ContentPropertiesPreference {
        private IContentType contentType;
        private Set<IContentTypePreferences> children;

        public IContentTypePreferences(ContentPropertiesPreferenceManager manager, IContentType contentType) {
            this.contentType = contentType;
            this.children = new HashSet<IContentTypePreferences>();
            this.init(manager, contentType.getId());
        }

        String getPrefParentKey() {
            return this.contentType.getId();
        }

        void addChild(IContentTypePreferences child) {
            this.children.add(child);
        }

        public ContentPropertiesPreference[] getChildren() {
            HashSet<ContentPropertiesPreference> allChildren = new HashSet<ContentPropertiesPreference>();
            allChildren.addAll(this.children);
            ContentPropertiesPreference[] contentPropertiesPreferenceArray = super.getChildren();
            int n = contentPropertiesPreferenceArray.length;
            int n2 = 0;
            while (n2 < n) {
                ContentPropertiesPreference child = contentPropertiesPreferenceArray[n2];
                allChildren.add(child);
                ++n2;
            }
            return allChildren.toArray(new ContentPropertiesPreference[allChildren.size()]);
        }

        public IContentType getIContentType() {
            return this.contentType;
        }

        public ContentPropertiesPreference getParent() {
            return this.manager.get(this.contentType.getBaseType(), null);
        }

        public String getName() {
            return this.contentType.getName();
        }
    }
}

