/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.rcp.core.internal.resources;

import com.ibm.team.filesystem.client.internal.ManagedFileSystem;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileArea;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileAreaManager;
import com.ibm.team.filesystem.rcp.core.internal.Messages;
import com.ibm.team.filesystem.rcp.core.internal.resources.MoveDeleteHook;
import com.ibm.team.filesystem.rcp.core.internal.resources.RepositoryProviderChangeNotifier;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceRuleFactory;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.team.IMoveDeleteHook;
import org.eclipse.core.resources.team.ResourceRuleFactory;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.core.TeamException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApoRepositoryProvider
extends RepositoryProvider {
    private static final ResourceRuleFactory RULE_FACTORY = new ResourceRuleFactory(){};
    public static final String ID = "com.ibm.team.filesystem.rcp.core.provider";
    private MoveDeleteHook moveDeleteHook = new MoveDeleteHook();
    private static final ThreadLocal<IProgressMonitor> threadMonitor = new ThreadLocal();

    public static Collection<IStatus> map(Collection<IProject> projectsToConnect, IProgressMonitor monitor) {
        ArrayList<IStatus> errors = new ArrayList<IStatus>(4);
        RepositoryProviderChangeNotifier.getInstance().acquire();
        try {
            SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)projectsToConnect.size());
            for (IProject project : projectsToConnect) {
                try {
                    ApoRepositoryProvider.map(project, (IProgressMonitor)progress);
                }
                catch (TeamException e) {
                    errors.add(StatusUtil.newStatus((Object)"com.ibm.team.filesystem.rcp.core", (Throwable)e));
                }
            }
        }
        finally {
            RepositoryProviderChangeNotifier.getInstance().release();
        }
        return errors;
    }

    public static void map(IProject project, IProgressMonitor monitor) throws TeamException {
        try {
            monitor.subTask(NLS.bind((String)Messages.ApoRepositoryProvider_ConnectingProjectSubTask, (Object)project.getName()));
            threadMonitor.set(monitor);
            RepositoryProvider.map((IProject)project, (String)ID);
        }
        finally {
            threadMonitor.set(null);
        }
    }

    public static void unmap(IProject project, IProgressMonitor monitor) throws TeamException {
        try {
            monitor.subTask(NLS.bind((String)Messages.ApoRepositoryProvider_DisconnectProjectSubTask, (Object)project.getName()));
            threadMonitor.set(monitor);
            RepositoryProvider.unmap((IProject)project);
        }
        finally {
            threadMonitor.set(null);
        }
    }

    public void configureProject() throws CoreException {
        IProject project = this.getProject();
        IProjectDescription projectDesc = project.getDescription();
        URI projectLocation = projectDesc.getLocationURI();
        if (projectLocation != null && "sourcecontrol".equals(projectLocation.getScheme())) {
            return;
        }
        ICopyFileArea cfa = ICopyFileAreaManager.instance.getCopyFileAreaForPath(project.getLocation());
        IPath relativePath = project.getLocation().removeFirstSegments(cfa.getRoot().segmentCount()).makeRelative();
        projectDesc.setLocationURI(ManagedFileSystem.getCanonicalManagedURI((IPath)cfa.getRoot(), (IPath)relativePath, (URI)projectLocation));
        project.move(projectDesc, 289, threadMonitor.get());
        RepositoryProviderChangeNotifier.getInstance().queueMapping(project);
    }

    public String getID() {
        return ID;
    }

    public void deconfigure() throws CoreException {
    }

    protected void deconfigured() {
        block7: {
            IProject project = this.getProject();
            URI projectLocation = project.getLocationURI();
            if (projectLocation == null || !"sourcecontrol".equals(projectLocation.getScheme())) {
                return;
            }
            try {
                try {
                    IProjectDescription projectDesc = project.getDescription();
                    URI basicURI = ManagedFileSystem.getBasicURI((URI)projectLocation);
                    if (ResourcesPlugin.getWorkspace().validateProjectLocationURI(project, basicURI).getSeverity() != 0) {
                        basicURI = null;
                    }
                    projectDesc.setLocationURI(basicURI);
                    project.move(projectDesc, 289, threadMonitor.get());
                }
                catch (CoreException e) {
                    StatusUtil.log((Object)((Object)this), (Throwable)e);
                    RepositoryProviderChangeNotifier.getInstance().queueUnmapping(project);
                    break block7;
                }
            }
            catch (Throwable throwable) {
                RepositoryProviderChangeNotifier.getInstance().queueUnmapping(project);
                throw throwable;
            }
            RepositoryProviderChangeNotifier.getInstance().queueUnmapping(project);
        }
        super.deconfigured();
    }

    public IMoveDeleteHook getMoveDeleteHook() {
        return this.moveDeleteHook;
    }

    public IResourceRuleFactory getRuleFactory() {
        return RULE_FACTORY;
    }

    public boolean canHandleLinkedResourceURI() {
        return true;
    }

    public IStatus validateCreateLink(IResource resource, int updateFlags, URI location) {
        return super.validateCreateLink(resource, updateFlags, location);
    }
}

