/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.rcp.core.internal.patches.impl;

import com.ibm.team.filesystem.rcp.core.internal.patches.FilePatch;
import com.ibm.team.filesystem.rcp.core.internal.patches.FilePatchFactory;
import com.ibm.team.filesystem.rcp.core.internal.patches.impl.DefaultFilePatch;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import org.eclipse.compare.patch.IFilePatch2;
import org.eclipse.compare.patch.PatchParser;
import org.eclipse.compare.patch.ReaderCreator;
import org.eclipse.core.resources.IEncodedStorage;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;

public class DefaultFilePatchFactory
extends FilePatchFactory {
    public FilePatch[] parsePatch(IStorage storage) throws CoreException {
        ReaderCreator creator = DefaultFilePatchFactory.asReaderCreator(storage);
        IFilePatch2[] parsePatch = PatchParser.parsePatch((ReaderCreator)creator);
        FilePatch[] result = new FilePatch[parsePatch.length];
        int i = 0;
        while (i < parsePatch.length) {
            IFilePatch2 filePatch = parsePatch[i];
            result[i] = new DefaultFilePatch(filePatch);
            ++i;
        }
        return result;
    }

    public static ReaderCreator asReaderCreator(final IStorage storage) {
        ReaderCreator creator = new ReaderCreator(){

            public Reader createReader() throws CoreException {
                IEncodedStorage es;
                if (storage instanceof IEncodedStorage && (es = (IEncodedStorage)storage).getCharset() != null) {
                    try {
                        return new BufferedReader(new InputStreamReader(storage.getContents(), es.getCharset()));
                    }
                    catch (UnsupportedEncodingException e) {
                        throw new CoreException(StatusUtil.newStatus((Object)((Object)this), (Throwable)e));
                    }
                }
                return new BufferedReader(new InputStreamReader(storage.getContents()));
            }
        };
        return creator;
    }
}

