/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.rcp.core.internal.patches;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.rcp.core.internal.Messages;
import com.ibm.team.filesystem.rcp.core.internal.patches.CreateFolderOp;
import com.ibm.team.filesystem.rcp.core.internal.patches.DeleteFolderOp;
import com.ibm.team.filesystem.rcp.core.internal.patches.MovableResource;
import com.ibm.team.filesystem.rcp.core.internal.patches.MoveFileOp;
import com.ibm.team.filesystem.rcp.core.patches.PatchConflictException;
import com.ibm.team.filesystem.rcp.core.patches.PatchOp;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.core.utils.CategoryComparator;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import com.ibm.team.scm.common.internal.util.NewCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SubMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class TargettedPatchOp {
    private MovableResource path;
    private PatchOp patchOp;

    public TargettedPatchOp(MovableResource path, PatchOp patchOp) {
        this.path = path;
        this.patchOp = patchOp;
    }

    public MovableResource getPath() {
        return this.path;
    }

    public PatchOp getPatchOp() {
        return this.patchOp;
    }

    public static Map<TargettedPatchOp, IStatus> verifyPatchOps(Collection<TargettedPatchOp> ops, IProgressMonitor monitor) throws FileSystemClientException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)ops.size());
        HashMap failures = NewCollection.hashMap();
        for (TargettedPatchOp next : ops) {
            SubMonitor nextIteration = progress.newChild(1).setWorkRemaining(100);
            IStatus status = next.getPatchOp().verify(next.getPath(), (IProgressMonitor)nextIteration.newChild(100));
            failures.put(next, status);
        }
        return failures;
    }

    public static Map<TargettedPatchOp, IStatus> applyPatchOps(Collection<TargettedPatchOp> ops, IProgressMonitor monitor) {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor);
        HashMap failures = NewCollection.hashMap();
        List toApply = ops;
        while (!toApply.isEmpty()) {
            progress.setWorkRemaining(100);
            SubMonitor nextIteration = progress.newChild(80).setWorkRemaining(toApply.size());
            boolean foundSuccess = false;
            ArrayList toRetry = NewCollection.arrayList();
            List<TargettedPatchOp> sortedOps = TargettedPatchOp.sortPatchOps(toApply);
            for (TargettedPatchOp next : sortedOps) {
                IStatus status;
                try {
                    next.getPatchOp().autoResolve(next.getPath(), (IProgressMonitor)nextIteration.newChild(1));
                    foundSuccess = true;
                    failures.remove(next);
                }
                catch (FileSystemClientException e) {
                    status = StatusUtil.newStatus(TargettedPatchOp.class, (String)Messages.TargettedPatchOp_0, (Throwable)e);
                    StatusUtil.log((IStatus)status);
                    failures.put(next, status);
                }
                catch (PatchConflictException e) {
                    toRetry.add(next);
                    failures.put(next, e.getStatus());
                }
                catch (TeamRepositoryException e) {
                    status = StatusUtil.newStatus(TargettedPatchOp.class, (String)Messages.TargettedPatchOp_0, (Throwable)e);
                    StatusUtil.log((IStatus)status);
                    failures.put(next, status);
                }
            }
            toApply = foundSuccess ? toRetry : Collections.EMPTY_LIST;
        }
        return failures;
    }

    private static List<TargettedPatchOp> sortPatchOps(Collection<TargettedPatchOp> toApply) {
        ArrayList<TargettedPatchOp> result = new ArrayList<TargettedPatchOp>();
        result.addAll(toApply);
        Collections.sort(result, new CategoryComparator<TargettedPatchOp>(){

            protected int category(TargettedPatchOp e1) {
                if (e1.patchOp instanceof CreateFolderOp) {
                    return 0;
                }
                if (e1.patchOp instanceof MoveFileOp) {
                    return 20;
                }
                if (e1.patchOp instanceof DeleteFolderOp) {
                    return 10;
                }
                return 3;
            }

            protected int compareSameCategory(int category, TargettedPatchOp e1, TargettedPatchOp e2) {
                if (category == 0) {
                    IPath path1 = e1.getPath().getResource().getFullPath();
                    IPath path2 = e2.getPath().getResource().getFullPath();
                    return path1.segmentCount() - path2.segmentCount();
                }
                if (category == 10) {
                    IPath path1 = e1.getPath().getResource().getFullPath();
                    IPath path2 = e2.getPath().getResource().getFullPath();
                    return path2.segmentCount() - path1.segmentCount();
                }
                if (category == 20) {
                    MoveFileOp m1 = (MoveFileOp)e1.getPatchOp();
                    MoveFileOp m2 = (MoveFileOp)e2.getPatchOp();
                    int order = m1.getTargetVersionablePath().segmentCount() - m2.getTargetVersionablePath().segmentCount();
                    if (order == 0) {
                        order = m1.getOrder() - m2.getOrder();
                    }
                    return order;
                }
                return super.compareSameCategory(category, (Object)e1, (Object)e2);
            }
        });
        return result;
    }
}

