/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.rcp.core.internal.patches;

import com.ibm.team.filesystem.client.ISharingDescriptor;
import com.ibm.team.filesystem.client.internal.SharingDescriptor;
import com.ibm.team.filesystem.client.internal.namespace.ItemNamespace;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.client.internal.RepoFetcher;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IContextHandle;
import com.ibm.team.scm.common.IFolder;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.internal.util.ItemId;
import com.ibm.team.scm.common.internal.util.StateId;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ShareTarget {
    private String repositoryUri;
    private UUID repoId;
    private ItemId<IItem> connectionHandle;
    private String connectionName;
    private ItemId<IComponent> component;
    private String componentName;

    private ShareTarget(String repositoryUri, UUID repoId, ItemId<IItem> connectionHandle, String connectionName, ItemId<IComponent> component, String componentName) {
        this.repositoryUri = repositoryUri;
        this.repoId = repoId;
        this.connectionHandle = connectionHandle;
        this.connectionName = connectionName;
        this.component = component;
        this.componentName = componentName;
    }

    public ShareTarget setComponent(ItemId<IComponent> targetComponent) {
        this.component = targetComponent;
        return this;
    }

    public ISharingDescriptor asSharingDescriptorFor(StateId<IFolder> target) {
        return new SharingDescriptor(this.repositoryUri, this.repoId, (IContextHandle)this.connectionHandle.toHandle(), this.connectionName, (IComponentHandle)this.component.toHandle(), this.componentName, (IVersionableHandle)target.toHandle());
    }

    public static ShareTarget createFrom(ItemNamespace namespace, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        ITeamRepository repo = namespace.getRepository();
        IContextHandle handle = namespace.getContextHandle();
        IConnection connection = namespace.getConnection((IProgressMonitor)progress.newChild(40));
        ItemId componentId = namespace.fetchComponentId((IProgressMonitor)progress.newChild(40));
        IComponent component = (IComponent)RepoFetcher.fetchCurrent((ITeamRepository)repo, (ItemId)componentId, (IProgressMonitor)progress.newChild(20));
        return new ShareTarget(repo.getRepositoryURI(), repo.getId(), (ItemId<IItem>)ItemId.create((IItemHandle)handle), connection.getName(), (ItemId<IComponent>)componentId, component.getName());
    }

    public static ShareTarget createTemp() {
        return new ShareTarget("https://localhost:9080/jazz", UUID.generate(), (ItemId<IItem>)new ItemId(IWorkspace.ITEM_TYPE, UUID.generate()), "Nonexistent connection", (ItemId<IComponent>)new ItemId(IComponent.ITEM_TYPE, UUID.generate()), "Nonexistent component");
    }
}

