/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.rcp.core.internal.patches;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.ResourceType;
import com.ibm.team.filesystem.rcp.core.internal.patches.AbstractFileStateChangeOp;
import com.ibm.team.filesystem.rcp.core.internal.patches.MovableResource;
import com.ibm.team.filesystem.rcp.core.internal.patches.ParsedFilePatch;
import com.ibm.team.filesystem.rcp.core.patches.PatchConflictException;
import com.ibm.team.filesystem.rcp.core.patches.PatchOp;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.utils.IInputStreamProvider;
import com.ibm.team.repository.rcp.core.preferences.SerializationContext;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import com.ibm.team.scm.common.internal.util.StateId;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

public class ResolveWithProposedOp
extends PatchOp {
    private AbstractFileStateChangeOp fileOp;

    public ResolveWithProposedOp(AbstractFileStateChangeOp fileOp) {
        this.fileOp = fileOp;
    }

    public void save(SerializationContext whereToSave, IProgressMonitor monitor) throws CoreException {
        throw new UnsupportedOperationException("The op type cannot be saved");
    }

    public void autoResolve(MovableResource resource, IProgressMonitor monitor) throws FileSystemClientException, PatchConflictException, TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        StateId beforeState = this.getBeforeState();
        StateId afterState = this.getAfterState();
        ResourceType resourceType = resource.getResourceType((IProgressMonitor)progress.newChild(1));
        if (this.fileOp.isFile(resourceType)) {
            try {
                if (!afterState.equals((Object)ParsedFilePatch.UNKNOWN_STATE) && afterState.isDeleted()) {
                    if (resource.exists((IProgressMonitor)progress.newChild(1))) {
                        resource.delete((IProgressMonitor)progress.newChild(98));
                    }
                    return;
                }
                if (!beforeState.equals((Object)ParsedFilePatch.UNKNOWN_STATE) && beforeState.isDeleted()) {
                    resource.createFile(this.getAfterStream((IProgressMonitor)progress.newChild(5)), this.fileOp.getKnownPathSegments(), (IProgressMonitor)progress.newChild(20));
                    return;
                }
                IInputStreamProvider isp = this.getAfterStream((IProgressMonitor)progress.newChild(5));
                InputStream input = isp.getInputStream((IProgressMonitor)progress.newChild(1));
                try {
                    resource.setContents(input, (IProgressMonitor)progress.newChild(4));
                }
                finally {
                    input.close();
                }
            }
            catch (IOException e) {
                throw new FileSystemClientException(StatusUtil.newStatus((Object)this, (Throwable)e));
            }
        }
    }

    protected void doVerify(MovableResource resource, IProgressMonitor monitor) throws PatchConflictException, FileSystemClientException {
    }

    public void dispose() {
        this.fileOp.dispose();
    }

    public PatchOp copy() {
        return new ResolveWithProposedOp((AbstractFileStateChangeOp)this.fileOp.copy());
    }

    public StateId getBeforeState() {
        return this.fileOp.getBeforeState();
    }

    public StateId getAfterState() {
        return this.fileOp.getAfterState();
    }

    public boolean isModify() {
        return this.fileOp.isModify();
    }

    public boolean isDelete() {
        return this.fileOp.isDelete();
    }

    public boolean isCreate() {
        return this.fileOp.isCreate();
    }

    public IInputStreamProvider getBeforeStream(IProgressMonitor monitor) throws FileSystemClientException {
        return this.fileOp.getBeforeStream(monitor);
    }

    public IInputStreamProvider getAfterStream(IProgressMonitor monitor) throws FileSystemClientException {
        return this.fileOp.getAfterStream(monitor);
    }

    public PatchOp getFileOp() {
        return this.fileOp;
    }
}

