/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.rcp.core.internal.patches;

import com.ibm.team.filesystem.common.ISymbolicLink;
import com.ibm.team.filesystem.common.changemodel.VersionablePath;
import com.ibm.team.filesystem.rcp.core.internal.InternalPreferencesUtil;
import com.ibm.team.filesystem.rcp.core.internal.patches.AbstractLinkStateChangeOp;
import com.ibm.team.filesystem.rcp.core.internal.patches.PureFileStateChangeOp;
import com.ibm.team.filesystem.rcp.core.patches.PatchOp;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.core.preferences.SerializationContext;
import com.ibm.team.scm.client.internal.RepoFetcher;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IVersionable;
import com.ibm.team.scm.common.internal.util.ItemId;
import com.ibm.team.scm.common.internal.util.StateId;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.osgi.service.prefs.Preferences;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PureLinkStateChangeOp
extends AbstractLinkStateChangeOp {
    private final ITeamRepository repository;
    private final ItemId<IComponent> component;
    private IVersionable afterFullState;

    public PureLinkStateChangeOp(SerializationContext ctxt, IProgressMonitor monitor) throws CoreException {
        super(ctxt);
        Preferences savedState = ctxt.getPrefs();
        this.component = InternalPreferencesUtil.getItemId(savedState, "component");
        this.repository = PureFileStateChangeOp.getRepository(savedState, "repo");
    }

    public PureLinkStateChangeOp(ITeamRepository repository, ItemId<IComponent> component, StateId beforeState, StateId afterState, VersionablePath knownPathSegments) {
        super(beforeState, afterState, knownPathSegments);
        this.repository = repository;
        this.component = component;
    }

    @Override
    public void save(SerializationContext ctxt, IProgressMonitor monitor) throws CoreException {
        super.save(ctxt, monitor);
        Preferences whereToSave = ctxt.getPrefs();
        InternalPreferencesUtil.putItemId(whereToSave, "component", this.component);
        PureFileStateChangeOp.putRepository(whereToSave, "repo", this.repository);
    }

    @Override
    public String getAfterLinkTarget(SubMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        this.fetchItems((IProgressMonitor)progress.newChild(100));
        if (this.afterFullState instanceof ISymbolicLink) {
            return ((ISymbolicLink)this.afterFullState).getTarget();
        }
        return null;
    }

    private void fetchItems(IProgressMonitor monitor) throws TeamRepositoryException {
        HashSet<StateId> toFetch = new HashSet<StateId>();
        toFetch.add(this.getAfterState());
        Map fetched = RepoFetcher.fetchItems((ITeamRepository)this.repository, toFetch, (IProgressMonitor)monitor);
        this.afterFullState = (IVersionable)fetched.get(this.getAfterState());
    }

    @Override
    public PatchOp copy() {
        return new PureLinkStateChangeOp(this.repository, this.component, this.getBeforeState(), this.getAfterState(), this.getKnownPathSegments());
    }

    @Override
    public void dispose() {
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.component == null ? 0 : this.component.hashCode());
        result = 31 * result + (this.repository == null ? 0 : this.repository.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PureLinkStateChangeOp other = (PureLinkStateChangeOp)obj;
        if (this.component == null ? other.component != null : !this.component.equals(other.component)) {
            return false;
        }
        return !(this.repository == null ? other.repository != null : !this.repository.equals(other.repository));
    }
}

