/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.rcp.core.internal.patches;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.IContentProperties;
import com.ibm.team.filesystem.client.internal.ClientFileStateFactory;
import com.ibm.team.filesystem.client.internal.FileContentInputStreamProvider;
import com.ibm.team.filesystem.client.internal.utils.RepositoryUtils;
import com.ibm.team.filesystem.common.IFileItem;
import com.ibm.team.filesystem.common.IFileItemHandle;
import com.ibm.team.filesystem.common.changemodel.FileState;
import com.ibm.team.filesystem.common.changemodel.VersionablePath;
import com.ibm.team.filesystem.rcp.core.internal.InternalPreferencesUtil;
import com.ibm.team.filesystem.rcp.core.internal.patches.AbstractFileStateChangeOp;
import com.ibm.team.filesystem.rcp.core.patches.PatchOp;
import com.ibm.team.internal.repository.rcp.streams.EmptyInputStreamProvider;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.utils.DisposableInputStreamProvider;
import com.ibm.team.repository.common.utils.IInputStreamProvider;
import com.ibm.team.repository.common.utils.TemporaryOutputStream;
import com.ibm.team.repository.rcp.core.preferences.PreferencesUtil;
import com.ibm.team.repository.rcp.core.preferences.SerializationContext;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import com.ibm.team.repository.rcp.core.utils.StreamReference;
import com.ibm.team.scm.client.internal.RepoFetcher;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IVersionable;
import com.ibm.team.scm.common.internal.util.ItemId;
import com.ibm.team.scm.common.internal.util.StateId;
import java.io.IOException;
import java.lang.ref.SoftReference;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.osgi.service.prefs.Preferences;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PureFileStateChangeOp
extends AbstractFileStateChangeOp {
    static final String ATTR_COMPONENT = "component";
    static final String ATTR_REPOSITORY = "repo";
    private final ItemId<IComponent> component;
    private final ITeamRepository repository;
    private IVersionable afterFullState;
    private IVersionable beforeFullState;
    private SoftReference<StreamReference> afterStream = new SoftReference<Object>(null);
    private SoftReference<StreamReference> beforeStream = new SoftReference<Object>(null);

    public PureFileStateChangeOp(ITeamRepository repository, ItemId<IComponent> component, StateId<IVersionable> before, StateId<IVersionable> after, VersionablePath knownPathSegments) {
        super(before, after, knownPathSegments);
        this.component = component;
        this.repository = repository;
    }

    public PureFileStateChangeOp(SerializationContext ctxt, IProgressMonitor monitor) throws CoreException {
        super(ctxt);
        Preferences savedState = ctxt.getPrefs();
        this.component = InternalPreferencesUtil.getItemId(savedState, ATTR_COMPONENT);
        this.repository = PureFileStateChangeOp.getRepository(savedState, ATTR_REPOSITORY);
    }

    @Override
    public void save(SerializationContext ctxt, IProgressMonitor monitor) throws CoreException {
        super.save(ctxt, monitor);
        Preferences whereToSave = ctxt.getPrefs();
        InternalPreferencesUtil.putItemId(whereToSave, ATTR_COMPONENT, this.component);
        PureFileStateChangeOp.putRepository(whereToSave, ATTR_REPOSITORY, this.repository);
    }

    @Override
    public String getAfterCharset(IProgressMonitor monitor) throws TeamRepositoryException {
        IFileItem item = this.getAfterFileItem(monitor);
        if (item == null || item.getContent().getCharacterEncoding() == null) {
            return IContentProperties.CHARACTER_ENCODING_UNKNOWN;
        }
        return item.getContent().getCharacterEncoding();
    }

    @Override
    public String getBeforeCharset(IProgressMonitor monitor) throws TeamRepositoryException {
        IFileItem item = this.getBeforeFileItem(monitor);
        if (item == null || item.getContent().getCharacterEncoding() == null) {
            return IContentProperties.CHARACTER_ENCODING_UNKNOWN;
        }
        return item.getContent().getCharacterEncoding();
    }

    protected IFileItem getBeforeFileItem(IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        this.fetchItems((IProgressMonitor)progress.newChild(100));
        if (this.beforeFullState instanceof IFileItem) {
            return (IFileItem)this.beforeFullState;
        }
        return null;
    }

    protected IFileItem getAfterFileItem(IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        this.fetchItems((IProgressMonitor)progress.newChild(100));
        if (this.afterFullState instanceof IFileItem) {
            return (IFileItem)this.afterFullState;
        }
        return null;
    }

    @Override
    public IInputStreamProvider getAfterStream(IProgressMonitor monitor) throws FileSystemClientException {
        IInputStreamProvider afterStream;
        block6: {
            SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
            afterStream = (IInputStreamProvider)this.afterStream.get();
            if (afterStream == null) {
                try {
                    IFileItem afterItem = this.getAfterFileItem((IProgressMonitor)progress.newChild(20));
                    if (afterItem == null) {
                        afterStream = EmptyInputStreamProvider.getDefault();
                        break block6;
                    }
                    try {
                        afterStream = TemporaryOutputStream.createLocalBuffer((IInputStreamProvider)new FileContentInputStreamProvider(this.getRepository(), (IFileItemHandle)afterItem, afterItem.getContent()), null);
                    }
                    catch (IOException exception) {
                        throw new FileSystemClientException(StatusUtil.newStatus((Object)this, (Throwable)exception));
                    }
                }
                catch (TeamRepositoryException e) {
                    throw new FileSystemClientException(StatusUtil.newStatus((Object)this, (Throwable)e));
                }
            }
        }
        this.afterStream = new SoftReference<StreamReference>(StreamReference.create((IInputStreamProvider)afterStream));
        return afterStream;
    }

    @Override
    public IInputStreamProvider getBeforeStream(IProgressMonitor monitor) throws FileSystemClientException {
        IInputStreamProvider beforeStream;
        block6: {
            SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
            beforeStream = (IInputStreamProvider)this.beforeStream.get();
            if (beforeStream == null) {
                try {
                    IFileItem beforeItem = this.getBeforeFileItem((IProgressMonitor)progress.newChild(20));
                    if (beforeItem == null) {
                        beforeStream = EmptyInputStreamProvider.getDefault();
                        break block6;
                    }
                    try {
                        beforeStream = TemporaryOutputStream.createLocalBuffer((IInputStreamProvider)new FileContentInputStreamProvider(this.getRepository(), (IFileItemHandle)beforeItem, beforeItem.getContent()), null);
                    }
                    catch (IOException exception) {
                        throw new FileSystemClientException(StatusUtil.newStatus((Object)this, (Throwable)exception));
                    }
                }
                catch (TeamRepositoryException e) {
                    throw new FileSystemClientException(StatusUtil.newStatus((Object)this, (Throwable)e));
                }
            }
        }
        this.beforeStream = new SoftReference<StreamReference>(StreamReference.create((IInputStreamProvider)beforeStream));
        return beforeStream;
    }

    private void fetchItems(IProgressMonitor monitor) throws TeamRepositoryException {
        HashSet<StateId> toFetch = new HashSet<StateId>();
        toFetch.add(this.getBeforeState());
        toFetch.add(this.getAfterState());
        Map fetched = RepoFetcher.fetchItems((ITeamRepository)this.getRepository(), toFetch, (IProgressMonitor)monitor);
        this.beforeFullState = (IVersionable)fetched.get(this.getBeforeState());
        this.afterFullState = (IVersionable)fetched.get(this.getAfterState());
    }

    private ITeamRepository getRepository() {
        return this.repository;
    }

    static ITeamRepository getRepository(Preferences prefs, String key) throws CoreException {
        String repoString = PreferencesUtil.getString((Preferences)prefs, (String)key);
        ITeamRepository repo = RepositoryUtils.getTeamRepository((String)repoString);
        return repo;
    }

    static void putRepository(Preferences prefs, String key, ITeamRepository repo) {
        PreferencesUtil.putString((Preferences)prefs, (String)key, (String)repo.getRepositoryURI());
    }

    @Override
    public void dispose() {
        this.disposeStream((IInputStreamProvider)this.beforeStream.get());
        this.disposeStream((IInputStreamProvider)this.afterStream.get());
    }

    private void disposeStream(IInputStreamProvider provider) {
        if (provider instanceof DisposableInputStreamProvider) {
            DisposableInputStreamProvider prov = (DisposableInputStreamProvider)provider;
            try {
                prov.dispose();
            }
            catch (IOException e) {
                StatusUtil.log((Object)this, (Throwable)e);
            }
        }
    }

    @Override
    public PatchOp copy() {
        PureFileStateChangeOp result = new PureFileStateChangeOp(this.repository, this.component, (StateId<IVersionable>)this.getBeforeState(), (StateId<IVersionable>)this.getAfterState(), this.getKnownPathSegments());
        result.beforeStream = this.copySoftRef(this.beforeStream);
        result.afterStream = this.copySoftRef(this.afterStream);
        return result;
    }

    private SoftReference<StreamReference> copySoftRef(SoftReference<StreamReference> toCopy) {
        StreamReference sr = toCopy.get();
        if (sr == null) {
            return new SoftReference<Object>(null);
        }
        return new SoftReference<StreamReference>(sr.incRef());
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.component == null ? 0 : this.component.hashCode());
        result = 31 * result + (this.repository == null ? 0 : this.repository.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PureFileStateChangeOp other = (PureFileStateChangeOp)obj;
        if (this.component == null ? other.component != null : !this.component.equals(other.component)) {
            return false;
        }
        return !(this.repository == null ? other.repository != null : !this.repository.equals(other.repository));
    }

    @Override
    public FileState getBeforeState(FileState currentState, IProgressMonitor monitor) throws FileSystemClientException, TeamRepositoryException {
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)40);
        IFileItem fileItem = this.getBeforeFileItem((IProgressMonitor)sub.newChild(20));
        if (fileItem == null) {
            return super.getBeforeState(currentState, (IProgressMonitor)sub.newChild(20));
        }
        return ClientFileStateFactory.create((ITeamRepository)this.repository, (IItemType)fileItem.getItemType(), (IVersionable)fileItem);
    }

    @Override
    public FileState getAfterState(FileState currentState, IProgressMonitor monitor) throws FileSystemClientException, TeamRepositoryException {
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)40);
        IFileItem fileItem = this.getAfterFileItem((IProgressMonitor)sub.newChild(20));
        if (fileItem == null) {
            return super.getAfterState(currentState, monitor);
        }
        return ClientFileStateFactory.create((ITeamRepository)this.repository, (IItemType)fileItem.getItemType(), (IVersionable)fileItem);
    }
}

