/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.rcp.core.internal.patches;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.IOperationFactory;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.internal.ClientRepositoryUtil;
import com.ibm.team.filesystem.client.internal.FileContentInputStreamProvider;
import com.ibm.team.filesystem.client.internal.TempHelper;
import com.ibm.team.filesystem.client.internal.namespace.IItemContext;
import com.ibm.team.filesystem.client.internal.namespace.ItemNamespace;
import com.ibm.team.filesystem.client.internal.namespace.impl.WorkspaceContext;
import com.ibm.team.filesystem.client.internal.snapshot.NamespaceSetId;
import com.ibm.team.filesystem.client.internal.snapshot.SnapshotId;
import com.ibm.team.filesystem.client.operations.CommitDilemmaHandler;
import com.ibm.team.filesystem.client.operations.ICheckinOperation;
import com.ibm.team.filesystem.common.FileLineDelimiter;
import com.ibm.team.filesystem.common.IFileItem;
import com.ibm.team.filesystem.common.IFileItemHandle;
import com.ibm.team.filesystem.common.ISymbolicLink;
import com.ibm.team.filesystem.common.changemodel.ChangeDescription;
import com.ibm.team.filesystem.common.changemodel.ConfigurationChange;
import com.ibm.team.filesystem.common.changemodel.FileChange;
import com.ibm.team.filesystem.common.changemodel.FileState;
import com.ibm.team.filesystem.common.changemodel.IPathResolver;
import com.ibm.team.filesystem.common.changemodel.VersionablePath;
import com.ibm.team.filesystem.common.internal.util.ChangeSetUtil;
import com.ibm.team.filesystem.rcp.core.internal.CoreShareablesUtil;
import com.ibm.team.filesystem.rcp.core.internal.FileSystemResourcesPlugin;
import com.ibm.team.filesystem.rcp.core.internal.Messages;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.CopyFileAreaPathResolver;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.FallbackPathResolver;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.SnapshotPathResolver;
import com.ibm.team.filesystem.rcp.core.internal.operations.FilesystemUtil;
import com.ibm.team.filesystem.rcp.core.internal.patches.AbstractFileStateChangeOp;
import com.ibm.team.filesystem.rcp.core.internal.patches.ApplyFileStateChangeOp;
import com.ibm.team.filesystem.rcp.core.internal.patches.ApplyLinkStateChangeOp;
import com.ibm.team.filesystem.rcp.core.internal.patches.CreateFolderOp;
import com.ibm.team.filesystem.rcp.core.internal.patches.DeleteFolderOp;
import com.ibm.team.filesystem.rcp.core.internal.patches.DeleteLinkOp;
import com.ibm.team.filesystem.rcp.core.internal.patches.MovableResource;
import com.ibm.team.filesystem.rcp.core.internal.patches.MoveFileOp;
import com.ibm.team.filesystem.rcp.core.internal.patches.ParsedFilePatch;
import com.ibm.team.filesystem.rcp.core.internal.patches.PatchParser;
import com.ibm.team.filesystem.rcp.core.internal.patches.PatchResult;
import com.ibm.team.filesystem.rcp.core.internal.patches.PureFileStateChangeOp;
import com.ibm.team.filesystem.rcp.core.internal.patches.PureLinkStateChangeOp;
import com.ibm.team.filesystem.rcp.core.internal.patches.ResolveWithProposedOp;
import com.ibm.team.filesystem.rcp.core.internal.patches.TargettedPatchOp;
import com.ibm.team.filesystem.rcp.core.patches.PatchOp;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.utils.IInputStreamProvider;
import com.ibm.team.repository.common.utils.TemporaryOutputStream;
import com.ibm.team.repository.rcp.common.collection.CollectionUtil;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import com.ibm.team.repository.rcp.core.utils.StreamReference;
import com.ibm.team.scm.client.internal.ClientProviderFactory;
import com.ibm.team.scm.client.internal.RepoFetcher;
import com.ibm.team.scm.client.internal.StateLocator;
import com.ibm.team.scm.common.IChange;
import com.ibm.team.scm.common.IChangeSet;
import com.ibm.team.scm.common.IChangeSetHandle;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IFolder;
import com.ibm.team.scm.common.IVersionable;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.internal.util.ItemId;
import com.ibm.team.scm.common.internal.util.ItemProviderUtil;
import com.ibm.team.scm.common.internal.util.NewCollection;
import com.ibm.team.scm.common.internal.util.SiloedItemId;
import com.ibm.team.scm.common.internal.util.StateId;
import com.ibm.team.scm.common.links.GenericLinkCreator;
import com.ibm.team.scm.common.providers.ProviderFactory;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParsedPatch {
    public static final Object PATCH_TYPE_JAZZ = new String("jazz");
    public static final Object PATCH_TYPE_NORMAL = new String("normal");
    public static final Object PATCH_TYPE_ECLIPSE = new String("eclipse");
    private Map<VersionablePath, ParsedFilePatch> filePatches = NewCollection.hashMap();
    private ChangeDescription description;
    private Object patchType = PATCH_TYPE_NORMAL;

    private ParsedPatch(ChangeDescription description, Collection<ParsedFilePatch> patches) {
        this.description = description;
        for (ParsedFilePatch next : patches) {
            this.filePatches.put(next.getVersionablePath(), next);
        }
    }

    public static ParsedPatch create(ChangeDescription description, Collection<ParsedFilePatch> patches) {
        return new ParsedPatch(description, patches);
    }

    public static ParsedPatch create() {
        return new ParsedPatch(new ChangeDescription(), Collections.<ParsedFilePatch>emptySet());
    }

    public Object getPatchType() {
        return this.patchType;
    }

    public ChangeDescription getDescription() {
        return this.description;
    }

    public Set<ParsedFilePatch> getFilePatchSet() {
        HashSet<ParsedFilePatch> filePatches = new HashSet<ParsedFilePatch>();
        filePatches.addAll(this.filePatches.values());
        return filePatches;
    }

    public ParsedFilePatch createPatchFor(VersionablePath thePath) {
        ParsedFilePatch result = this.filePatches.get(thePath);
        if (result == null) {
            result = new ParsedFilePatch(thePath);
            this.filePatches.put(thePath, result);
        }
        return result;
    }

    public void setPatchType(Object type) {
        this.patchType = type;
    }

    public void setDescription(ChangeDescription description) {
        this.description = description;
    }

    public Set<VersionablePath> getAffectedVersionablePaths(IPath root, IProgressMonitor monitor) {
        return this.filePatches.keySet();
    }

    public Set<IShareable> getAffectedShareables(IPath root, IProgressMonitor monitor) throws FileSystemClientException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        Set<VersionablePath> paths = this.getAffectedVersionablePaths(root, (IProgressMonitor)progress.newChild(10));
        HashSet shareable = NewCollection.hashSet();
        SubMonitor loopProgress = progress.newChild(90).setWorkRemaining(paths.size());
        for (VersionablePath next : paths) {
            IShareable nextShareable;
            try {
                nextShareable = CoreShareablesUtil.getShareableFor(next, (IProgressMonitor)loopProgress.newChild(1));
            }
            catch (TeamRepositoryException e) {
                StatusUtil.log(ParsedPatch.class, (Throwable)e);
                nextShareable = null;
            }
            if (nextShareable == null) continue;
            shareable.add(nextShareable);
        }
        return shareable;
    }

    public static ParsedPatch parse(IInputStreamProvider patchData, int segmentsToRemove, IPath prefixToAdd, IProgressMonitor monitor) throws FileSystemClientException {
        return PatchParser.parse(patchData, segmentsToRemove, prefixToAdd, monitor);
    }

    public boolean isEmpty() {
        return this.filePatches.isEmpty();
    }

    public void dispose() {
        for (ParsedFilePatch next : this.filePatches.values()) {
            next.dispose();
        }
        this.filePatches.clear();
    }

    public ParsedPatch downloadStates(IProgressMonitor monitor) throws TeamRepositoryException, IOException, FileSystemClientException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        ArrayList<ParsedFilePatch> resultingFilePatches = new ArrayList<ParsedFilePatch>();
        Set<StateLocator<IVersionable>> toFetch = this.getTouchedStates(progress.newChild(30));
        Map fetchedItems = RepoFetcher.fetchItems(toFetch, (IProgressMonitor)progress.newChild(30));
        SubMonitor loopProgress2 = progress.newChild(40).setWorkRemaining(this.filePatches.size());
        for (ParsedFilePatch next : this.filePatches.values()) {
            ParsedFilePatch nextResult = null;
            SubMonitor iterationProgress = loopProgress2.newChild(1).setWorkRemaining(100);
            VersionablePath path = next.getVersionablePath();
            if (next.containsHunks()) {
                MovableResource resource = MovableResource.create(path, (IProgressMonitor)iterationProgress.newChild(95));
                if (!(next.getBeforeState().equals((Object)ParsedFilePatch.UNKNOWN_STATE) || next.getAfterState().equals((Object)ParsedFilePatch.UNKNOWN_STATE) || next.getAfterState().isDeleted())) {
                    ITeamRepository repo;
                    try {
                        repo = resource.getRepository((IProgressMonitor)iterationProgress.newChild(5));
                    }
                    catch (FileSystemClientException e) {
                        throw TempHelper.throwEx((FileSystemClientException)e);
                    }
                    if (repo != null) {
                        StateLocator beforeState = StateLocator.create((ITeamRepository)repo, (StateId)next.getBeforeState());
                        StateLocator afterState = StateLocator.create((ITeamRepository)repo, (StateId)next.getAfterState());
                        IVersionable beforeItem = (IVersionable)fetchedItems.get(beforeState);
                        IVersionable afterItem = (IVersionable)fetchedItems.get(afterState);
                        if (beforeItem instanceof IFileItem && afterItem instanceof IFileItem) {
                            IFileItem f1 = (IFileItem)beforeItem;
                            IFileItem f2 = (IFileItem)afterItem;
                            StreamReference beforeStream = StreamReference.create((IInputStreamProvider)TemporaryOutputStream.createLocalBuffer((IInputStreamProvider)new FileContentInputStreamProvider(repo, (IFileItemHandle)f1, f1.getContent()), null));
                            StreamReference afterStream = StreamReference.create((IInputStreamProvider)TemporaryOutputStream.createLocalBuffer((IInputStreamProvider)new FileContentInputStreamProvider(repo, (IFileItemHandle)f2, f2.getContent()), null));
                            try {
                                ApplyFileStateChangeOp patchOp = new ApplyFileStateChangeOp(beforeState.getStateId(), afterState.getStateId(), beforeStream, f1.getContent().getCharacterEncoding(), f1.getContent().getLineDelimiter(), afterStream, f2.getContent().getCharacterEncoding(), f2.getContent().getLineDelimiter(), path);
                                nextResult = next.withAlternateMods(patchOp);
                            }
                            finally {
                                beforeStream.dispose();
                                afterStream.dispose();
                            }
                        }
                    }
                }
            }
            if (nextResult == null) {
                nextResult = next.copy();
            }
            resultingFilePatches.add(nextResult);
        }
        return new ParsedPatch(this.description, resultingFilePatches);
    }

    private Set<StateLocator<IVersionable>> getTouchedStates(SubMonitor loopProgress) throws TeamRepositoryException, FileSystemClientException {
        loopProgress.setWorkRemaining(this.filePatches.size());
        HashSet<StateLocator<IVersionable>> toFetch = new HashSet<StateLocator<IVersionable>>();
        for (ParsedFilePatch next : this.filePatches.values()) {
            ItemNamespace namespace;
            SubMonitor iterationProgress = loopProgress.newChild(1).setWorkRemaining(100);
            VersionablePath path = next.getVersionablePath();
            if (!next.containsHunks()) continue;
            MovableResource resource = MovableResource.create(path, (IProgressMonitor)iterationProgress.newChild(95));
            if (next.getBeforeState().equals((Object)ParsedFilePatch.UNKNOWN_STATE) || next.getAfterState().equals((Object)ParsedFilePatch.UNKNOWN_STATE) || next.getAfterState().isDeleted()) continue;
            try {
                namespace = resource.getContributorPlace((IProgressMonitor)iterationProgress.newChild(5));
            }
            catch (FileSystemClientException e) {
                throw TempHelper.throwEx((FileSystemClientException)e);
            }
            if (namespace == null) continue;
            ITeamRepository repo = namespace.getRepository();
            toFetch.add((StateLocator<IVersionable>)StateLocator.create((ITeamRepository)repo, (StateId)next.getBeforeState()));
            toFetch.add((StateLocator<IVersionable>)StateLocator.create((ITeamRepository)repo, (StateId)next.getAfterState()));
        }
        return toFetch;
    }

    public ParsedPatch mergeHunks(IProgressMonitor monitor) {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        ArrayList<ParsedFilePatch> resultingFilePatches = new ArrayList<ParsedFilePatch>();
        SubMonitor loopProgress = progress.newChild(30).setWorkRemaining(this.filePatches.size());
        for (ParsedFilePatch next : this.filePatches.values()) {
            SubMonitor iterationProgress = loopProgress.newChild(1).setWorkRemaining(100);
            ParsedFilePatch nextResult = next.mergeHunks((IProgressMonitor)iterationProgress);
            resultingFilePatches.add(nextResult);
        }
        return new ParsedPatch(this.description, resultingFilePatches);
    }

    public ParsedPatch resolveHunks(IProgressMonitor monitor) throws TeamRepositoryException, IOException, FileSystemClientException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        ParsedPatch withDownloadedStates = this.downloadStates((IProgressMonitor)progress.newChild(90));
        try {
            ParsedPatch withAppliedHunks;
            ParsedPatch parsedPatch = withAppliedHunks = withDownloadedStates.mergeHunks((IProgressMonitor)progress.newChild(10));
            return parsedPatch;
        }
        finally {
            withDownloadedStates.dispose();
        }
    }

    public PatchResult apply(IProgressMonitor monitor) throws TeamRepositoryException, FileSystemClientException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        HashSet patchOps = NewCollection.hashSet();
        HashMap<MovableResource, VersionablePath> mapToOriginalPaths = new HashMap<MovableResource, VersionablePath>();
        SubMonitor resolvePathsProgress = progress.newChild(10).setWorkRemaining(this.filePatches.size());
        for (ParsedFilePatch nextFile : this.filePatches.values()) {
            List<PatchOp> allOps;
            SubMonitor iterationProgress = resolvePathsProgress.newChild(1).setWorkRemaining(100);
            MovableResource moveResource = MovableResource.create(nextFile.getVersionablePath(), (IProgressMonitor)iterationProgress.newChild(50));
            mapToOriginalPaths.put(moveResource, nextFile.getVersionablePath());
            try {
                allOps = nextFile.getAllOps((IProgressMonitor)iterationProgress.newChild(50));
            }
            catch (CoreException e) {
                throw new FileSystemClientException(e.getStatus());
            }
            Iterator iterator = allOps.iterator();
            while (iterator.hasNext()) {
                PatchOp nextOp = (PatchOp)iterator.next();
                TargettedPatchOp patchOp = new TargettedPatchOp(moveResource, nextOp);
                patchOps.add(patchOp);
            }
        }
        Map<TargettedPatchOp, IStatus> failures = TargettedPatchOp.applyPatchOps(patchOps, (IProgressMonitor)progress.newChild(70));
        ArrayList<IShareable> shareableList = new ArrayList<IShareable>();
        SubMonitor iterProgress = progress.newChild(10).setWorkRemaining(patchOps.size());
        for (TargettedPatchOp patchOp : patchOps) {
            IShareable shareable;
            MovableResource moveResource = patchOp.getPath();
            IStatus status = failures.get(patchOp);
            if (status != null || (shareable = moveResource.getShareable((IProgressMonitor)iterProgress.newChild(1))) == null) continue;
            shareableList.add(shareable);
        }
        boolean isAutosaveOn = FileSystemResourcesPlugin.getComponentSyncModel().getLocalSynchronizationManager().getAutoSave();
        if (isAutosaveOn) {
            this.commitChanges(shareableList, progress.newChild(10));
        }
        PatchResult result = new PatchResult();
        for (TargettedPatchOp next : patchOps) {
            IStatus resultStatus = failures.get(next);
            if (resultStatus == null) {
                resultStatus = Status.OK_STATUS;
            }
            VersionablePath path = (VersionablePath)mapToOriginalPaths.get(next.getPath());
            result.addResult(path, next.getPatchOp().copy(), resultStatus);
        }
        return result;
    }

    public PatchResult resolveWithProposed(IProgressMonitor monitor) throws TeamRepositoryException, FileSystemClientException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        HashSet patchOps = NewCollection.hashSet();
        HashMap<MovableResource, VersionablePath> mapToOriginalPaths = new HashMap<MovableResource, VersionablePath>();
        SubMonitor resolvePathsProgress = progress.newChild(10).setWorkRemaining(this.filePatches.size());
        for (ParsedFilePatch nextFile : this.filePatches.values()) {
            List<PatchOp> allOps;
            SubMonitor iterationProgress = resolvePathsProgress.newChild(1).setWorkRemaining(100);
            MovableResource moveResource = MovableResource.create(nextFile.getVersionablePath(), (IProgressMonitor)iterationProgress.newChild(50));
            mapToOriginalPaths.put(moveResource, nextFile.getVersionablePath());
            try {
                allOps = nextFile.getAllOps((IProgressMonitor)iterationProgress.newChild(50));
            }
            catch (CoreException e) {
                throw new FileSystemClientException(e.getStatus());
            }
            Iterator iterator = allOps.iterator();
            while (iterator.hasNext()) {
                PatchOp nextOp = (PatchOp)iterator.next();
                if (!this.canResolveWithProposed(nextOp, progress.newChild(1))) continue;
                TargettedPatchOp patchOp = new TargettedPatchOp(moveResource, new ResolveWithProposedOp((AbstractFileStateChangeOp)nextOp));
                patchOps.add(patchOp);
            }
        }
        if (patchOps.isEmpty()) {
            return new PatchResult();
        }
        Map<TargettedPatchOp, IStatus> failures = TargettedPatchOp.applyPatchOps(patchOps, (IProgressMonitor)progress.newChild(70));
        ArrayList<IShareable> shareableList = new ArrayList<IShareable>();
        SubMonitor iterProgress = progress.newChild(10).setWorkRemaining(patchOps.size());
        for (TargettedPatchOp patchOp : patchOps) {
            IShareable shareable;
            MovableResource moveResource = patchOp.getPath();
            IStatus status = failures.get(patchOp);
            if (status != null || (shareable = moveResource.getShareable((IProgressMonitor)iterProgress.newChild(1))) == null) continue;
            shareableList.add(shareable);
        }
        boolean isAutosaveOn = FileSystemResourcesPlugin.getComponentSyncModel().getLocalSynchronizationManager().getAutoSave();
        if (isAutosaveOn) {
            this.commitChanges(shareableList, progress.newChild(10));
        }
        PatchResult result = new PatchResult();
        for (TargettedPatchOp next : patchOps) {
            IStatus resultStatus = failures.get(next);
            if (resultStatus == null) {
                resultStatus = Status.OK_STATUS;
            }
            VersionablePath path = (VersionablePath)mapToOriginalPaths.get(next.getPath());
            PatchOp patchOp = next.getPatchOp();
            if (patchOp instanceof ResolveWithProposedOp) {
                patchOp = ((ResolveWithProposedOp)patchOp).getFileOp();
            }
            result.addResult(path, patchOp.copy(), resultStatus);
        }
        return result;
    }

    private boolean canResolveWithProposed(PatchOp nextOp, SubMonitor subMonitor) throws TeamRepositoryException {
        if (nextOp instanceof AbstractFileStateChangeOp) {
            AbstractFileStateChangeOp op = (AbstractFileStateChangeOp)nextOp;
            FileLineDelimiter ld = op.isCreate() || !op.isDelete() ? op.getAfterLineDelimiter((IProgressMonitor)subMonitor.newChild(1)) : op.getBeforeLineDelimiter((IProgressMonitor)subMonitor.newChild(1));
            return ld == FileLineDelimiter.LINE_DELIMITER_NONE;
        }
        return false;
    }

    private void commitChanges(List<IShareable> shareableList, SubMonitor progress) throws TeamRepositoryException, FileSystemClientException {
        progress.setWorkRemaining(100);
        HashMap toCommit = NewCollection.hashMap();
        SubMonitor subProgress = progress.newChild(5).setWorkRemaining(shareableList.size());
        for (IShareable shareable : shareableList) {
            ItemNamespace contributorPlace = CoreShareablesUtil.getContributorPlace(shareable, (IProgressMonitor)subProgress.newChild(1));
            if (contributorPlace == null) continue;
            CollectionUtil.addToMapOfLists((Map)toCommit, (Object)contributorPlace, (Object)shareable);
        }
        progress.setWorkRemaining(toCommit.size());
        String comment = this.getDescription().getComment();
        Collection workItems = this.getDescription().getWorkItems();
        for (ItemNamespace next : toCommit.keySet()) {
            if (!next.getRepository().loggedIn()) continue;
            SubMonitor iterationProgress = progress.newChild(1).setWorkRemaining(100);
            List shareables = (List)toCommit.get(next);
            IItemContext context = next.getContext((IProgressMonitor)iterationProgress.newChild(10));
            if (!(context instanceof WorkspaceContext)) continue;
            ICheckinOperation op = IOperationFactory.instance.getCheckinOperation(CommitDilemmaHandler.getDefault());
            op.requestCheckin(shareables.toArray(new IShareable[shareables.size()]), null, comment, (IProgressMonitor)iterationProgress.newChild(10));
            op.run((IProgressMonitor)iterationProgress.newChild(60));
            GenericLinkCreator links = new GenericLinkCreator();
            SubMonitor linkProgress = iterationProgress.newChild(20).setWorkRemaining(workItems.size() * op.getCommittedChangeSets().size());
            for (IChangeSetHandle csh : op.getCommittedChangeSets()) {
                for (ItemId nextWorkItem : workItems) {
                    links.createLinks(csh.getItemType(), (Object)csh, nextWorkItem.getItemType(), (Object)nextWorkItem.toHandle(), (IProgressMonitor)linkProgress.newChild(1));
                }
            }
        }
    }

    static Collection<ParsedFilePatch> convertMapToFilePatches(Map<VersionablePath, List<PatchOp>> patchOps) {
        ArrayList<ParsedFilePatch> result = new ArrayList<ParsedFilePatch>();
        for (Map.Entry<VersionablePath, List<PatchOp>> next : patchOps.entrySet()) {
            result.add(new ParsedFilePatch(next.getKey(), next.getValue()));
            PatchOp.disposeOps((Collection<PatchOp>)next.getValue());
        }
        return result;
    }

    private static SiloedItemId getParent(FileChange change, boolean beforeState) {
        return SiloedItemId.create((ItemId)change.getNonDeleted(beforeState).getPath().getParent(), (ItemId)change.getSiloedItemId().getComponent());
    }

    private static VersionablePath getUnresolvedPath(FileChange change, boolean beforeState) {
        FileState state = change.getNonDeleted(beforeState);
        return VersionablePath.create(Collections.singletonList(state.getPath()), (SiloedItemId)change.getSiloedItemId(), (boolean)false, (boolean)false);
    }

    public static ParsedPatch createFromConfigurationChange(ChangeDescription description, ConfigurationChange change, IPathResolver optionalBackupPathResolver, IProgressMonitor monitor) throws TeamRepositoryException, IOException {
        return ParsedPatch.createFromConfigurationChange(description, change, optionalBackupPathResolver, true, monitor);
    }

    public static ParsedPatch createFromConfigurationChange(ChangeDescription description, ConfigurationChange change, IPathResolver optionalBackupPathResolver, boolean getContent, IProgressMonitor monitor) throws TeamRepositoryException, IOException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        FallbackPathResolver pathResolver = ParsedPatch.getPathResolver(optionalBackupPathResolver);
        HashSet<VersionablePath> toResolve = new HashSet<VersionablePath>();
        for (FileChange nextChange : change.getChanges()) {
            toResolve.add(ParsedPatch.getUnresolvedPath(nextChange, true));
            toResolve.add(ParsedPatch.getUnresolvedPath(nextChange, false));
        }
        HashMap<VersionablePath, List<PatchOp>> patchOps = new HashMap<VersionablePath, List<PatchOp>>();
        Map<VersionablePath, VersionablePath> resolvedPaths = FilesystemUtil.resolvePaths(pathResolver, toResolve, (IProgressMonitor)progress.newChild(20));
        SubMonitor loopProgress = progress.newChild(80).setWorkRemaining(change.getChanges().size());
        for (FileChange nextChange : change.getChanges()) {
            PatchOp contentOp;
            SubMonitor iterationProgress = loopProgress.newChild(1).setWorkRemaining(100);
            FileState before = nextChange.getInitial();
            FileState after = nextChange.getFinal();
            VersionablePath beforePath = resolvedPaths.get(ParsedPatch.getUnresolvedPath(nextChange, true));
            VersionablePath afterPath = resolvedPaths.get(ParsedPatch.getUnresolvedPath(nextChange, false));
            if (nextChange.getSiloedItemId().getItemType().equals(IFolder.ITEM_TYPE)) {
                if (after.getStateId().isDeleted()) {
                    contentOp = new DeleteFolderOp();
                    CollectionUtil.addToMapOfLists(patchOps, (Object)beforePath, (Object)contentOp);
                }
                if (before.getStateId().isDeleted()) {
                    contentOp = new CreateFolderOp(afterPath);
                    CollectionUtil.addToMapOfLists(patchOps, (Object)afterPath, (Object)contentOp);
                }
            } else if (nextChange.getSiloedItemId().getItemType().equals(IFileItem.ITEM_TYPE)) {
                StreamReference beforeStream = getContent ? ParsedPatch.copyStream(before.getContents(), (IProgressMonitor)iterationProgress.newChild(50)) : null;
                StreamReference afterStream = getContent ? ParsedPatch.copyStream(after.getContents(), (IProgressMonitor)iterationProgress.newChild(50)) : null;
                ItemId itemId = nextChange.getItemId();
                if (itemId.isNull()) {
                    itemId = new ItemId(itemId.getItemType(), UUID.generate());
                }
                StateId beforeState = new StateId(itemId, nextChange.getInitial().getStateId().getStateUUID());
                StateId afterState = new StateId(itemId, nextChange.getFinal().getStateId().getStateUUID());
                boolean same = ParsedPatch.isKnownToBeSameContent(before, after);
                if (!same) {
                    ApplyFileStateChangeOp contentOp2 = new ApplyFileStateChangeOp(beforeState, afterState, beforeStream, before.getCharacterEncoding(), before.getLineDelimiter(), afterStream, after.getCharacterEncoding(), after.getLineDelimiter(), afterPath);
                    CollectionUtil.addToMapOfLists(patchOps, (Object)beforePath, (Object)contentOp2);
                }
            } else if (nextChange.getSiloedItemId().getItemType().equals(ISymbolicLink.ITEM_TYPE)) {
                if (after.getStateId().isDeleted()) {
                    contentOp = new DeleteLinkOp();
                    CollectionUtil.addToMapOfLists(patchOps, (Object)beforePath, (Object)contentOp);
                } else {
                    ItemId itemId = nextChange.getItemId();
                    StateId beforeState = new StateId(itemId, nextChange.getInitial().getStateId().getStateUUID());
                    StateId afterState = new StateId(itemId, nextChange.getFinal().getStateId().getStateUUID());
                    ApplyLinkStateChangeOp linkOp = new ApplyLinkStateChangeOp(nextChange.getFinal().getTarget(), before.getStateId().isDeleted(), beforeState, afterState, afterPath);
                    CollectionUtil.addToMapOfLists(patchOps, (Object)beforePath, (Object)linkOp);
                }
            }
            if (beforePath.equals((Object)afterPath)) continue;
            MoveFileOp contentOp2 = new MoveFileOp(afterPath, 0);
            CollectionUtil.addToMapOfLists(patchOps, (Object)beforePath, (Object)contentOp2);
        }
        Collection<ParsedFilePatch> filePatches = ParsedPatch.convertMapToFilePatches(patchOps);
        ParsedPatch result = ParsedPatch.create(description, filePatches);
        return result;
    }

    private static boolean isKnownToBeSameContent(FileState before, FileState after) {
        before.getContents();
        if (before.getContents() instanceof FileContentInputStreamProvider && after.getContents() instanceof FileContentInputStreamProvider) {
            return ((FileContentInputStreamProvider)before.getContents()).getContent().sameContent(((FileContentInputStreamProvider)after.getContents()).getContent());
        }
        return false;
    }

    private static StreamReference copyStream(IInputStreamProvider beforeProvider, IProgressMonitor monitor) throws IOException {
        return StreamReference.create((IInputStreamProvider)TemporaryOutputStream.createLocalBuffer((IInputStreamProvider)beforeProvider, (IProgressMonitor)monitor));
    }

    public static ParsedPatch createFromChangeSet(ItemNamespace workspace, ItemId<IChangeSet> changeSet, boolean reverse, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        IChangeSet changeSetItem = (IChangeSet)RepoFetcher.fetchCurrent((ITeamRepository)workspace.getRepository(), changeSet, (IProgressMonitor)progress.newChild(10));
        SnapshotPathResolver pathResolver = SnapshotPathResolver.create((SnapshotId)NamespaceSetId.create((ItemNamespace)workspace));
        return ParsedPatch.createFromChangeSets(workspace.getRepository(), Collections.singletonList(changeSetItem), reverse, pathResolver, (IProgressMonitor)progress.newChild(90));
    }

    public static ParsedPatch createFromChangeSets(ITeamRepository teamRepository, List<IChangeSet> changeSets, boolean reverse, IPathResolver optionalBackupPathResolver, IProgressMonitor monitor) throws TeamRepositoryException {
        String newText;
        Object workItems;
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        HashSet<ItemId> changeSetIdSet = new HashSet<ItemId>();
        HashSet toFetch = NewCollection.hashSet();
        HashMap changeSetsByRepository = NewCollection.hashMap();
        Date date = new Date();
        for (IChangeSet changeSet : changeSets) {
            ITeamRepository origin = ClientRepositoryUtil.getRepository((IItemHandle)changeSet);
            if (origin == null) {
                origin = teamRepository;
            }
            for (IChange nextChange : changeSet.changes()) {
                toFetch.add(StateLocator.create((ITeamRepository)origin, (StateId)ChangeSetUtil.getLastMergeState((IChange)nextChange)));
                toFetch.add(StateLocator.create((ITeamRepository)origin, (StateId)ChangeSetUtil.getAfterState((IChange)nextChange)));
            }
            CollectionUtil.addToMapOfLists((Map)changeSetsByRepository, (Object)origin, (Object)ItemId.forItem((IItem)changeSet));
            changeSetIdSet.add(ItemId.forItem((IItem)changeSet));
            date = changeSet.getLastChangeDate();
        }
        Map fetched = RepoFetcher.fetchItems((Set)toFetch, (IProgressMonitor)progress.newChild(40));
        HashSet toResolve = NewCollection.hashSet();
        for (IChangeSet changeSet : changeSets) {
            ITeamRepository repo = ClientRepositoryUtil.getRepository((IItemHandle)changeSet);
            if (repo == null) {
                repo = teamRepository;
            }
            IComponentHandle componentHandle = changeSet.getComponent();
            for (IChange nextChange : changeSet.changes()) {
                StateLocator before = StateLocator.create((ITeamRepository)repo, (StateId)ChangeSetUtil.getLastMergeState((IChange)nextChange));
                StateLocator after = StateLocator.create((ITeamRepository)repo, (StateId)ChangeSetUtil.getAfterState((IChange)nextChange));
                IVersionable fetchedBefore = (IVersionable)fetched.get(before);
                IVersionable fetchedAfter = (IVersionable)fetched.get(after);
                if (fetchedBefore != null) {
                    toResolve.add(SiloedItemId.create((IVersionableHandle)fetchedBefore.getParent(), (IComponentHandle)componentHandle));
                }
                if (fetchedAfter == null) continue;
                toResolve.add(SiloedItemId.create((IVersionableHandle)fetchedAfter.getParent(), (IComponentHandle)componentHandle));
            }
        }
        FallbackPathResolver fpr = ParsedPatch.getPathResolver(optionalBackupPathResolver);
        Map<SiloedItemId<IVersionable>, VersionablePath> resolvedPaths = fpr.resolve(toResolve, (IProgressMonitor)progress.newChild(30));
        HashMap resolvedWorkItems = NewCollection.hashMap();
        SubMonitor linksMonitor = progress.newChild(20).setWorkRemaining(changeSetsByRepository.size());
        for (ITeamRepository repo : changeSetsByRepository.keySet()) {
            List changeSetIds = (List)changeSetsByRepository.get(repo);
            workItems = ItemProviderUtil.resolveLinks((ProviderFactory)new ClientProviderFactory(repo), (List)changeSetIds, (IProgressMonitor)linksMonitor.newChild(1));
            resolvedWorkItems.put(repo, workItems);
        }
        if (changeSets.size() == 1) {
            IChangeSet changeSet = changeSets.iterator().next();
            String text = changeSet.getComment();
            newText = reverse ? (text.equals("") ? NLS.bind((String)Messages.HistoryReverseChangesAction_0, (Object)changeSet.getLastChangeDate()) : NLS.bind((String)Messages.HistoryReverseChangesAction_1, (Object)text)) : (text.equals("") ? NLS.bind((String)Messages.ApplyPatchUtil_0, (Object)changeSet.getLastChangeDate()) : NLS.bind((String)Messages.ApplyPatchUtil_1, (Object)text));
        } else {
            newText = reverse ? NLS.bind((String)Messages.ApplyPatchUtil_2, (Object)new Date()) : NLS.bind((String)Messages.ApplyPatchUtil_3, (Object)new Date());
        }
        ItemId component = ItemId.getNullItem((IItemType)IComponent.ITEM_TYPE);
        HashMap<VersionablePath, List<PatchOp>> patchOps = new HashMap<VersionablePath, List<PatchOp>>();
        workItems = new HashSet();
        for (IChangeSet changeSet : changeSets) {
            List workItemList;
            ITeamRepository repo = ClientRepositoryUtil.getRepository((IItemHandle)changeSet);
            if (repo == null) {
                repo = teamRepository;
            }
            component = ChangeSetUtil.getComponent((IChangeSet)changeSet);
            IComponentHandle componentHandle = changeSet.getComponent();
            Map mapForThisRepo = (Map)resolvedWorkItems.get(repo);
            if (mapForThisRepo != null && (workItemList = (List)mapForThisRepo.get(ItemId.forItem((IItem)changeSet))) != null) {
                workItems.addAll(workItemList);
            }
            for (IChange nextChange : changeSet.changes()) {
                PatchOp contentOp;
                IVersionable pathVersionable;
                StateLocator before = StateLocator.create((ITeamRepository)repo, (StateId)ChangeSetUtil.getLastMergeState((IChange)nextChange));
                StateLocator after = StateLocator.create((ITeamRepository)repo, (StateId)ChangeSetUtil.getAfterState((IChange)nextChange));
                if (reverse) {
                    StateLocator temp = before;
                    before = after;
                    after = temp;
                }
                IVersionable fetchedBefore = (IVersionable)fetched.get(before);
                IVersionable fetchedAfter = (IVersionable)fetched.get(after);
                IVersionable iVersionable = pathVersionable = fetchedBefore != null ? fetchedBefore : fetchedAfter;
                if (pathVersionable == null) continue;
                SiloedItemId parentItem = SiloedItemId.create((IVersionableHandle)pathVersionable.getParent(), (IComponentHandle)componentHandle);
                VersionablePath beforePath = resolvedPaths.get(parentItem);
                beforePath = beforePath.append(pathVersionable.getName(), ItemId.forItem((IItem)pathVersionable));
                IVersionable afterPathVersionable = fetchedAfter != null ? fetchedAfter : fetchedBefore;
                SiloedItemId afterParentItem = SiloedItemId.create((IVersionableHandle)afterPathVersionable.getParent(), (IComponentHandle)componentHandle);
                VersionablePath afterPath = resolvedPaths.get(afterParentItem);
                afterPath = afterPath.append(afterPathVersionable.getName(), ItemId.forItem((IItem)afterPathVersionable));
                if (nextChange.item().getItemType().equals(IFolder.ITEM_TYPE)) {
                    if (after.getStateId().isDeleted()) {
                        contentOp = new DeleteFolderOp();
                        CollectionUtil.addToMapOfLists(patchOps, (Object)beforePath, (Object)contentOp);
                    }
                    if (before.getStateId().isDeleted()) {
                        contentOp = new CreateFolderOp(afterPath);
                        CollectionUtil.addToMapOfLists(patchOps, (Object)afterPath, (Object)contentOp);
                    }
                } else if (nextChange.item().getItemType().equals(IFileItem.ITEM_TYPE)) {
                    contentOp = new PureFileStateChangeOp(repo, (ItemId<IComponent>)component, (StateId<IVersionable>)before.getStateId(), (StateId<IVersionable>)after.getStateId(), afterPath);
                    CollectionUtil.addToMapOfLists(patchOps, (Object)beforePath, (Object)contentOp);
                } else if (nextChange.item().getItemType().equals(ISymbolicLink.ITEM_TYPE)) {
                    if (after.getStateId().isDeleted()) {
                        contentOp = new DeleteLinkOp();
                        CollectionUtil.addToMapOfLists(patchOps, (Object)beforePath, (Object)contentOp);
                    } else {
                        contentOp = new PureLinkStateChangeOp(repo, (ItemId<IComponent>)component, before.getStateId(), after.getStateId(), afterPath);
                        CollectionUtil.addToMapOfLists(patchOps, (Object)beforePath, (Object)contentOp);
                    }
                }
                if (beforePath.equals((Object)afterPath)) continue;
                MoveFileOp contentOp2 = new MoveFileOp(afterPath, 0);
                CollectionUtil.addToMapOfLists(patchOps, (Object)beforePath, (Object)contentOp2);
            }
        }
        ChangeDescription description = new ChangeDescription(newText, (Collection)workItems, component, changeSetIdSet, date);
        Collection<ParsedFilePatch> filePatches = ParsedPatch.convertMapToFilePatches(patchOps);
        ParsedPatch result = ParsedPatch.create(description, filePatches);
        return result;
    }

    private static FallbackPathResolver getPathResolver(IPathResolver optionalBackupPathResolver) {
        ArrayList<IPathResolver> pathResolvers = new ArrayList<IPathResolver>();
        pathResolvers.add(CopyFileAreaPathResolver.create());
        if (optionalBackupPathResolver != null) {
            pathResolvers.add(optionalBackupPathResolver);
        }
        FallbackPathResolver fpr = new FallbackPathResolver(pathResolvers);
        return fpr;
    }

    public ParsedPatch copy() {
        ArrayList<ParsedFilePatch> copiedFilePatches = new ArrayList<ParsedFilePatch>();
        for (ParsedFilePatch next : this.filePatches.values()) {
            copiedFilePatches.add(next.copy());
        }
        return ParsedPatch.create(this.description, copiedFilePatches);
    }
}

