/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.rcp.core.internal.patches;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.FileSystemCore;
import com.ibm.team.filesystem.client.IContentExaminer;
import com.ibm.team.filesystem.client.IContentProperties;
import com.ibm.team.filesystem.client.ILocalChangeManager;
import com.ibm.team.filesystem.client.IOperationFactory;
import com.ibm.team.filesystem.client.ISandbox;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.ResourceType;
import com.ibm.team.filesystem.client.internal.FileStorageInputStreamProvider;
import com.ibm.team.filesystem.client.internal.FileSystemStatus;
import com.ibm.team.filesystem.client.internal.IFileStorage;
import com.ibm.team.filesystem.client.internal.ManagedFileStore;
import com.ibm.team.filesystem.client.internal.Shareable;
import com.ibm.team.filesystem.client.internal.SharingManager;
import com.ibm.team.filesystem.client.internal.Shed;
import com.ibm.team.filesystem.client.internal.TempHelper;
import com.ibm.team.filesystem.client.internal.localchanges.LocalChangeManager;
import com.ibm.team.filesystem.client.internal.namespace.IItemContext;
import com.ibm.team.filesystem.client.internal.namespace.ItemNamespace;
import com.ibm.team.filesystem.client.internal.namespace.impl.WorkspaceContext;
import com.ibm.team.filesystem.client.operations.CommitDilemmaHandler;
import com.ibm.team.filesystem.client.operations.IDeleteFoldersOperation;
import com.ibm.team.filesystem.common.changemodel.VersionablePath;
import com.ibm.team.filesystem.rcp.core.internal.CoreShareablesUtil;
import com.ibm.team.filesystem.rcp.core.internal.Messages;
import com.ibm.team.filesystem.rcp.core.internal.patches.FilePatch;
import com.ibm.team.filesystem.rcp.core.internal.patches.FilePatchResult;
import com.ibm.team.filesystem.rcp.core.internal.patches.Hunk;
import com.ibm.team.filesystem.rcp.core.internal.patches.IgnoreSyncsHandler;
import com.ibm.team.filesystem.rcp.core.internal.resources.ResourceUtil;
import com.ibm.team.filesystem.rcp.core.internal.streams.InputStreamStorage;
import com.ibm.team.filesystem.rcp.core.internal.streams.ResourceInputStreamProvider;
import com.ibm.team.filesystem.rcp.core.patches.PatchConflictException;
import com.ibm.team.foundation.common.util.Adapters;
import com.ibm.team.internal.repository.rcp.streams.EmptyInputStreamProvider;
import com.ibm.team.internal.repository.rcp.streams.InputStreamUtil;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.utils.IInputStreamProvider;
import com.ibm.team.repository.rcp.common.collection.WeakValueMap;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import com.ibm.team.scm.common.internal.util.ItemId;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IEncodedStorage;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.osgi.util.NLS;

public class MovableResource {
    private IPath path;
    private static WeakValueMap<IPath, MovableResource> allKnownResources = new WeakValueMap();
    private final boolean isResource;

    private MovableResource(IPath path, boolean isResource) {
        this.path = path;
        this.isResource = isResource;
    }

    public static MovableResource create(IResource resource) {
        return MovableResource.create(resource.getFullPath(), true);
    }

    public static MovableResource create(IShareable shareable) {
        Object adapter = shareable.getAdapter(IResource.class);
        if (adapter instanceof IResource) {
            return MovableResource.create((IResource)adapter);
        }
        return MovableResource.create(shareable.getLocalPath(), false);
    }

    public static MovableResource create(VersionablePath versionablePath, IProgressMonitor monitor) throws TeamRepositoryException, FileSystemClientException {
        IShareable shareable = CoreShareablesUtil.getShareableFor(versionablePath, monitor);
        if (shareable != null) {
            return MovableResource.create(shareable);
        }
        return MovableResource.create(ResourceUtil.getResource(versionablePath.toPath()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static MovableResource create(IPath path, boolean isResource) {
        WeakValueMap<IPath, MovableResource> weakValueMap = allKnownResources;
        synchronized (weakValueMap) {
            MovableResource res = (MovableResource)allKnownResources.get((Object)path);
            if (res != null) {
                return res;
            }
            res = new MovableResource(path, isResource);
            allKnownResources.put((Object)path, (Object)res);
            return res;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void move(IPath destination, VersionablePath targetPath, IProgressMonitor monitor) throws CoreException, TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        IFileStorage fileStorage = this.getFileStorage((IProgressMonitor)progress.newChild(10));
        IPath source = this.path;
        if (this.isResource || fileStorage == null) {
            IResource targetResource = ResourceUtil.getResource(destination);
            CoreShareablesUtil.createFolder(targetResource.getParent(), targetPath.removeLastSegment(), (IProgressMonitor)progress.newChild(20));
            this.getResource().move(destination, false, (IProgressMonitor)progress.newChild(80));
        } else {
            IShareable targetShareable = CoreShareablesUtil.getShareableFor(targetPath, (IProgressMonitor)progress.newChild(20));
            if (targetShareable == null) {
                throw new FileSystemClientException(StatusUtil.newStatus((Object)this, (String)NLS.bind((String)Messages.MovableResource_NoShareableForTargetPath, (Object)targetPath.toPath().toOSString())));
            }
            IFileStorage theFolder = CoreShareablesUtil.getFileStorage(CoreShareablesUtil.getParent(targetShareable));
            CoreShareablesUtil.createFolder(theFolder, targetPath.removeLastSegment(), (IProgressMonitor)progress.newChild(20));
            fileStorage.move(targetShareable.getSandbox(), targetShareable.getLocalPath(), monitor);
        }
        WeakValueMap<IPath, MovableResource> weakValueMap = allKnownResources;
        synchronized (weakValueMap) {
            HashSet knownValues = new HashSet();
            knownValues.addAll(allKnownResources.values());
            for (MovableResource res : knownValues) {
                IPath path;
                if (res == null || !source.isPrefixOf(path = res.getPath())) continue;
                allKnownResources.remove((Object)path);
                res.setTargetPath(destination.append(path.removeFirstSegments(source.segmentCount())));
                allKnownResources.put((Object)res.getPath(), (Object)res);
            }
        }
    }

    private void setTargetPath(IPath newPath) {
        this.path = newPath;
    }

    public IResource getResource() {
        return ResourceUtil.getResource(this.path);
    }

    private IPath getPath() {
        return this.path;
    }

    protected void finalize() throws Throwable {
        super.finalize();
    }

    public IShareable getShareable(IProgressMonitor progress) {
        IResource resource;
        Object adapter;
        if (this.isResource && (adapter = (resource = this.getResource()).getAdapter(IShareable.class)) instanceof IShareable) {
            return (IShareable)adapter;
        }
        Collection sandboxes = FileSystemCore.getSharingManager().getRegisteredSandboxes();
        int maxCount = 0;
        IShareable winner = null;
        for (ISandbox sandbox : sandboxes) {
            IShareable shareable = sandbox.findShareable(this.path, ResourceType.FILE);
            int count = this.getExisitingSegmentCount(sandbox, this.path, progress);
            if (count <= maxCount) continue;
            maxCount = count;
            winner = shareable;
        }
        if (maxCount > 0) {
            return winner;
        }
        return null;
    }

    private int getExisitingSegmentCount(ISandbox sandbox, IPath path, IProgressMonitor progress) {
        String[] segments = path.segments();
        int count = 0;
        IFileStorage fileStorage = null;
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)(segments.length * 2));
        int i = 0;
        while (i < segments.length) {
            if (fileStorage == null) {
                fileStorage = CoreShareablesUtil.getFileStorage((IShareable)new Shareable(sandbox, (IPath)new Path(segments[i]), ResourceType.FOLDER));
            } else {
                try {
                    fileStorage = fileStorage.getChild(segments[i], (IProgressMonitor)monitor.newChild(1));
                }
                catch (FileSystemClientException fileSystemClientException) {}
            }
            boolean exists = false;
            try {
                exists = fileStorage != null && fileStorage.getShareable().exists((IProgressMonitor)monitor.newChild(1));
            }
            catch (FileSystemClientException fileSystemClientException) {}
            if (!exists) break;
            ++count;
            ++i;
        }
        return count;
    }

    public IFileStorage getFileStorage(IProgressMonitor progress) {
        IShareable shareable = this.getShareable(progress);
        if (shareable != null) {
            return CoreShareablesUtil.getFileStorage(shareable);
        }
        return null;
    }

    public IPath getFullPath(IProgressMonitor progress) {
        IShareable shareable = this.getShareable(progress);
        if (this.isResource || shareable == null) {
            IResource resource = this.getResource();
            return resource.getFullPath();
        }
        return shareable.getFullPath();
    }

    public IPath getLocalPath(IProgressMonitor progress) {
        IShareable shareable = this.getShareable(progress);
        if (this.isResource || shareable == null) {
            IResource resource = this.getResource();
            return resource.getFullPath();
        }
        return shareable.getLocalPath();
    }

    public ItemNamespace getContributorPlace(IProgressMonitor monitor) throws FileSystemClientException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        IShareable shareable = this.getShareable((IProgressMonitor)progress.newChild(1));
        if (shareable != null) {
            return CoreShareablesUtil.getContributorPlace(shareable, (IProgressMonitor)progress.newChild(99));
        }
        return null;
    }

    public ITeamRepository getRepository(IProgressMonitor monitor) throws FileSystemClientException {
        ItemNamespace namespace = this.getContributorPlace(monitor);
        if (namespace == null) {
            return null;
        }
        return namespace.getRepository();
    }

    public ResourceType getResourceType(IProgressMonitor progress) throws FileSystemClientException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)2);
        IShareable shareable = this.getShareable((IProgressMonitor)monitor.newChild(1));
        if (this.isResource || shareable == null) {
            IResource resource = this.getResource();
            try {
                IFileStore store;
                IFileInfo info;
                URI uri = resource.getLocationURI();
                if (uri != null && (info = (store = EFS.getStore((URI)uri)).fetchInfo(0, (IProgressMonitor)monitor.newChild(1))).getAttribute(32)) {
                    return ResourceType.SYMBOLIC_LINK;
                }
            }
            catch (CoreException e) {
                StatusUtil.log((Object)this, (Throwable)e);
            }
            if (!resource.exists()) {
                return null;
            }
            int resourceType = resource.getType();
            if ((resourceType & 1) != 0) {
                return ResourceType.FILE;
            }
            if ((resourceType & 2) != 0) {
                return ResourceType.FOLDER;
            }
            if ((resourceType & 4) != 0) {
                return ResourceType.FOLDER;
            }
            throw new IllegalStateException(Integer.toString(resourceType));
        }
        return shareable.getResourceType((IProgressMonitor)monitor.newChild(1));
    }

    public boolean exists(IProgressMonitor progress) throws FileSystemClientException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)100);
        IShareable shareable = this.getShareable((IProgressMonitor)monitor.newChild(50));
        if (this.isResource || shareable == null) {
            IResource resource = this.getResource();
            boolean exists = resource.exists();
            if (!exists) {
                URI uri;
                block6: {
                    uri = resource.getLocationURI();
                    if (uri != null) break block6;
                    return false;
                }
                try {
                    IFileStore store = EFS.getStore((URI)uri);
                    IFileInfo info = store.fetchInfo(0, (IProgressMonitor)monitor.newChild(1));
                    if (info.getAttribute(32)) {
                        return true;
                    }
                }
                catch (CoreException e) {
                    StatusUtil.log((Object)this, (Throwable)e);
                }
            }
            return exists;
        }
        return shareable.exists((IProgressMonitor)monitor.newChild(50));
    }

    public void mkdirs(VersionablePath path, IProgressMonitor monitor) throws FileSystemClientException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        IShareable shareable = this.getShareable((IProgressMonitor)progress.newChild(1));
        if (this.isResource || shareable == null) {
            IContainer container = ResourceUtil.getContainer(this.getResource().getFullPath());
            CoreShareablesUtil.createFolder(container, path, (IProgressMonitor)progress.newChild(99));
        } else {
            if (!shareable.exists((IProgressMonitor)progress.newChild(1))) {
                shareable = new Shareable(shareable.getSandbox(), shareable.getLocalPath(), ResourceType.FOLDER);
            }
            IFileStorage storage = CoreShareablesUtil.getFileStorage(shareable);
            CoreShareablesUtil.createFolder(storage, path, (IProgressMonitor)progress.newChild(98));
        }
    }

    public void setContents(InputStream inputStream, IProgressMonitor monitor) throws FileSystemClientException {
        try {
            try {
                SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                IShareable shareable = this.getShareable((IProgressMonitor)progress.newChild(1));
                if (this.isResource || shareable == null) {
                    IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile(this.getResource().getFullPath());
                    file.setContents(inputStream, false, true, (IProgressMonitor)progress.newChild(99));
                } else {
                    if (!shareable.exists((IProgressMonitor)progress.newChild(1))) {
                        shareable = new Shareable(shareable.getSandbox(), shareable.getLocalPath(), ResourceType.FILE);
                    }
                    IFileStorage storage = CoreShareablesUtil.getFileStorage(shareable);
                    storage.setContents(inputStream, false, (IProgressMonitor)progress.newChild(98));
                }
            }
            catch (CoreException e) {
                throw new FileSystemClientException(FileSystemStatus.getStatusFor((Throwable)e));
            }
        }
        catch (Throwable throwable) {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            inputStream.close();
        }
        catch (IOException iOException) {}
    }

    public void delete(IProgressMonitor monitor) throws FileSystemClientException, TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        IFileStorage fileStorage = this.getFileStorage((IProgressMonitor)progress.newChild(1));
        if (this.isResource || fileStorage == null) {
            IItemContext context;
            ItemNamespace workspace;
            IShareable shareable;
            IResource resource = this.getResource();
            if (resource instanceof IProject && (shareable = (IShareable)Adapters.getAdapter((Object)resource, IShareable.class)) != null && (workspace = CoreShareablesUtil.getContributorPlace(shareable, (IProgressMonitor)progress.newChild(4))) != null && (context = workspace.getContext((IProgressMonitor)progress.newChild(10))) instanceof WorkspaceContext) {
                WorkspaceContext workspaceContext = (WorkspaceContext)context;
                ItemId changeSet = workspaceContext.getCurrentChangeSet();
                if (changeSet.isNull()) {
                    changeSet = workspaceContext.createChangeSet(NLS.bind((String)"", (Object)resource.getName()), true, (IProgressMonitor)progress.newChild(20));
                }
                IgnoreSyncsHandler ignoreSyncs = new IgnoreSyncsHandler();
                IDeleteFoldersOperation op = IOperationFactory.instance.getDeleteFoldersOperation((CommitDilemmaHandler)ignoreSyncs);
                op.setDeleteContent(false);
                op.addDeleteRequest(new IShareable[]{shareable}, (IProgressMonitor)progress.newChild(5));
                op.run((IProgressMonitor)progress.newChild(20));
                progress.setWorkRemaining(100);
            }
            try {
                resource.delete(false, (IProgressMonitor)progress.newChild(50));
            }
            catch (CoreException e) {
                throw new FileSystemClientException(FileSystemStatus.getStatusFor((Throwable)e));
            }
        } else {
            fileStorage.delete((IProgressMonitor)progress.newChild(98));
        }
    }

    public void createFile(IInputStreamProvider contents, VersionablePath versionablePath, IProgressMonitor monitor) throws FileSystemClientException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        IFileStorage fileStorage = this.getFileStorage((IProgressMonitor)progress.newChild(1));
        if (this.isResource || fileStorage == null) {
            IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile(this.getResource().getFullPath());
            CoreShareablesUtil.createFile(file, contents, versionablePath, (IProgressMonitor)progress.newChild(99));
        } else {
            CoreShareablesUtil.createFile(fileStorage, contents, versionablePath, (IProgressMonitor)progress.newChild(99));
        }
    }

    public String getCharset(IProgressMonitor monitor) throws CoreException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        IContentExaminer examiner = FileSystemCore.getSharingManager().getContentExaminer();
        return examiner.getEncoding(this.getShareable((IProgressMonitor)progress.newChild(50)), (IProgressMonitor)progress.newChild(50));
    }

    public IEncodedStorage asEncodedStorage(IProgressMonitor monitor) {
        IFileStorage fileStorage = this.getFileStorage(monitor);
        if (this.isResource || fileStorage == null) {
            IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile(this.getResource().getFullPath());
            return file;
        }
        return MovableResource.asIStorage(fileStorage);
    }

    private static IEncodedStorage asIStorage(final IFileStorage fileStorage) {
        return new IEncodedStorage(){

            public Object getAdapter(Class adapter) {
                return null;
            }

            public boolean isReadOnly() {
                try {
                    return fileStorage.isReadOnly((IProgressMonitor)TempHelper.MONITOR);
                }
                catch (FileSystemClientException fileSystemClientException) {
                    return false;
                }
            }

            public String getName() {
                return fileStorage.getName();
            }

            public IPath getFullPath() {
                return fileStorage.getShareable().getFullPath();
            }

            public InputStream getContents() throws CoreException {
                return fileStorage.getContents();
            }

            public String getCharset() throws CoreException {
                IContentExaminer examiner = FileSystemCore.getSharingManager().getContentExaminer();
                return examiner.getEncoding((IShareable)fileStorage.getShareable(), (IProgressMonitor)TempHelper.MONITOR);
            }
        };
    }

    public boolean hasNonderivedChildren() throws CoreException {
        if (this.isResource) {
            IContainer container = ResourceUtil.getContainer(this.getResource().getFullPath());
            return this.hasNonderivedChildren(container);
        }
        return false;
    }

    private boolean hasNonderivedChildren(IContainer container) throws CoreException {
        boolean found = false;
        IResource[] members = container.members();
        int i = 0;
        while (i < members.length) {
            IResource next = members[i];
            if (!next.isDerived()) {
                found = true;
            }
            ++i;
        }
        return found;
    }

    public void autoResolve(FilePatchResult result, VersionablePath versionablePath, boolean isDeletion, boolean isCreation, IProgressMonitor monitor) throws PatchConflictException, FileSystemClientException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        IFileStorage fileStorage = this.getFileStorage((IProgressMonitor)progress.newChild(1));
        try {
            if (this.isResource || fileStorage == null) {
                IFile file = (IFile)this.getResource();
                if (isDeletion) {
                    file.delete(2, (IProgressMonitor)progress);
                } else if (isCreation) {
                    if (result.getRejects().length != 0) {
                        throw new FileSystemClientException(StatusUtil.newStatus((Object)this, (String)Messages.ApplyHunkOp_2));
                    }
                    CoreShareablesUtil.createFile(file, result.getPatchedContents(), versionablePath, (IProgressMonitor)progress);
                } else {
                    file.setContents(result.getPatchedContents(), 2, (IProgressMonitor)progress);
                }
            } else if (isDeletion) {
                fileStorage.delete((IProgressMonitor)progress);
            } else if (isCreation) {
                if (result.getRejects().length != 0) {
                    throw new FileSystemClientException(StatusUtil.newStatus((Object)this, (String)Messages.ApplyHunkOp_2));
                }
                CoreShareablesUtil.createFile(fileStorage, result.getPatchedContents(), versionablePath, (IProgressMonitor)progress);
            } else {
                fileStorage.setContents(result.getPatchedContents(), false, (IProgressMonitor)progress);
            }
        }
        catch (CoreException e) {
            if (e instanceof PatchConflictException) {
                throw (PatchConflictException)e;
            }
            throw new FileSystemClientException(StatusUtil.newStatus((Object)this, (Throwable)e));
        }
        catch (TeamRepositoryException e) {
            throw new FileSystemClientException(StatusUtil.newStatus((Object)this, (Throwable)e));
        }
    }

    public FilePatchResult computeResolve(Hunk toApply, VersionablePath versionablePath, boolean isDeletion, boolean isCreation, IProgressMonitor monitor) throws PatchConflictException, FileSystemClientException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        IFileStorage fileStorage = this.getFileStorage((IProgressMonitor)progress.newChild(1));
        if (this.isResource || fileStorage == null) {
            return this.computeResolve(toApply, this.getResource(), versionablePath, isDeletion, isCreation, (IProgressMonitor)progress.newChild(99));
        }
        return this.computeResolve(toApply, this.getShareable((IProgressMonitor)progress.newChild(1)), versionablePath, isDeletion, isCreation, (IProgressMonitor)progress.newChild(98));
    }

    private FilePatchResult computeResolve(Hunk toApply, IShareable shareable, VersionablePath versionablePath, boolean isDeletion, boolean isCreation, IProgressMonitor monitor) throws PatchConflictException, FileSystemClientException {
        FilePatchResult result;
        boolean isEmptyFile;
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        IFileStorage file = CoreShareablesUtil.getFileStorage(shareable);
        ResourceType type = shareable.getResourceType((IProgressMonitor)progress.newChild(1));
        if (type != ResourceType.FILE && type != null) {
            throw new PatchConflictException(StatusUtil.newStatus((Object)this, (String)Messages.ApplyHunkOp_3));
        }
        if (type != null) {
            try {
                isEmptyFile = InputStreamUtil.isEmpty((IInputStreamProvider)FileStorageInputStreamProvider.create((IFileStorage)file), (IProgressMonitor)progress.newChild(10));
            }
            catch (IOException e) {
                throw new FileSystemClientException(StatusUtil.newStatus((Object)this, (Throwable)e));
            }
        } else {
            isEmptyFile = true;
        }
        progress.setWorkRemaining(100);
        IContentProperties contentProperties = FileSystemCore.getSharingManager().getContentExaminer().examine(shareable, (IProgressMonitor)progress.newChild(1));
        InputStreamStorage storage = new InputStreamStorage((IInputStreamProvider)FileStorageInputStreamProvider.create((IFileStorage)file), contentProperties.getEncoding(), file.getName());
        if (isCreation && type != null && !isEmptyFile) {
            throw new PatchConflictException(StatusUtil.newStatus((Object)this, (String)Messages.ApplyHunkOp_4));
        }
        if (!isCreation && type == null) {
            throw new PatchConflictException(StatusUtil.newStatus((Object)this, (String)Messages.ApplyHunkOp_5));
        }
        IPath path = shareable.getLocalPath();
        Date theDate = new Date();
        try {
            FilePatch nextFile = Hunk.createFilePatch(path, path, theDate, theDate, Collections.singletonList(toApply), "", (IProgressMonitor)progress.newChild(30));
            result = nextFile.apply(storage, (IProgressMonitor)progress.newChild(30));
            if (type != null && !contentProperties.isText() && !isEmptyFile) {
                throw new PatchConflictException(StatusUtil.newStatus((Object)this, (String)Messages.ApplyHunkOp_1));
            }
            if (!isCreation && !isDeletion && result.getRejects().length != 0) {
                throw new PatchConflictException(StatusUtil.newStatus((Object)this, (String)Messages.ApplyHunkOp_9));
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new FileSystemClientException(StatusUtil.newStatus((Object)this, (Throwable)e));
        }
        catch (IOException e) {
            throw new FileSystemClientException(StatusUtil.newStatus((Object)this, (Throwable)e));
        }
        catch (CoreException e) {
            if (e instanceof PatchConflictException) {
                throw (PatchConflictException)e;
            }
            throw new FileSystemClientException(StatusUtil.newStatus((Object)this, (Throwable)e));
        }
        return result;
    }

    private FilePatchResult computeResolve(Hunk toApply, IResource resource, VersionablePath versionablePath, boolean isDeletion, boolean isCreation, IProgressMonitor monitor) throws PatchConflictException, FileSystemClientException {
        FilePatchResult result;
        boolean isEmptyFile;
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        if (!(resource instanceof IFile)) {
            throw new PatchConflictException(StatusUtil.newStatus((Object)this, (String)Messages.ApplyHunkOp_3));
        }
        IFile file = (IFile)resource;
        if (file.exists()) {
            try {
                isEmptyFile = InputStreamUtil.isEmpty((IInputStreamProvider)new ResourceInputStreamProvider(file), (IProgressMonitor)progress.newChild(10));
            }
            catch (IOException e) {
                throw new FileSystemClientException(StatusUtil.newStatus((Object)this, (Throwable)e));
            }
        } else {
            isEmptyFile = true;
        }
        progress.setWorkRemaining(100);
        IStorage storage = ResourceUtil.getStorageForPath(file.getFullPath());
        if (isCreation) {
            if (resource.exists()) {
                if (resource.getFullPath().segmentCount() == 2 && resource.getName().equals(".project")) {
                    storage = new InputStreamStorage((IInputStreamProvider)new EmptyInputStreamProvider());
                } else if (!isEmptyFile) {
                    throw new PatchConflictException(StatusUtil.newStatus((Object)this, (String)Messages.ApplyHunkOp_4));
                }
            }
        } else if (!resource.exists()) {
            throw new PatchConflictException(StatusUtil.newStatus((Object)this, (String)Messages.ApplyHunkOp_5));
        }
        if (file.getProject().exists() && !file.getProject().isOpen()) {
            throw new PatchConflictException(StatusUtil.newStatus((Object)this, (String)Messages.ApplyHunkOp_6));
        }
        IPath path = resource.getFullPath();
        Date theDate = new Date();
        try {
            FilePatch nextFile = Hunk.createFilePatch(path, path, theDate, theDate, Collections.singletonList(toApply), "", (IProgressMonitor)progress.newChild(30));
            result = nextFile.apply(storage, (IProgressMonitor)progress.newChild(30));
            IContentProperties contentProperties = ResourceUtil.getContentPropertiesNotNull(file, (IProgressMonitor)progress.newChild(10));
            if (file.exists() && !contentProperties.isText() && !isEmptyFile) {
                throw new PatchConflictException(StatusUtil.newStatus((Object)this, (String)Messages.ApplyHunkOp_1));
            }
            if (!isCreation && !isDeletion && result.getRejects().length != 0) {
                throw new PatchConflictException(StatusUtil.newStatus((Object)this, (String)Messages.ApplyHunkOp_9));
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new FileSystemClientException(StatusUtil.newStatus((Object)this, (Throwable)e));
        }
        catch (IOException e) {
            throw new FileSystemClientException(StatusUtil.newStatus((Object)this, (Throwable)e));
        }
        catch (CoreException e) {
            if (e instanceof PatchConflictException) {
                throw (PatchConflictException)e;
            }
            throw new FileSystemClientException(StatusUtil.newStatus((Object)this, (Throwable)e));
        }
        return result;
    }

    public void createLink(String target, VersionablePath versionablePath, IProgressMonitor monitor) throws FileSystemClientException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        IShareable shareable = this.getShareable((IProgressMonitor)progress.newChild(1));
        if (shareable == null) {
            if (this.isResource) {
                IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile(this.getResource().getFullPath());
                try {
                    IFileStore store = EFS.getStore((URI)file.getLocationURI());
                    if (store != null) {
                        ManagedFileStore.createSymlink((IFileStore)store, (String)target, (IProgressMonitor)progress.newChild(1));
                        file.refreshLocal(2, (IProgressMonitor)progress.newChild(1));
                        return;
                    }
                }
                catch (CoreException e) {
                    throw new FileSystemClientException(FileSystemStatus.getStatusFor((Throwable)e));
                }
            }
            throw new FileSystemClientException(FileSystemStatus.getStatusFor((int)4, (String)NLS.bind((String)Messages.MovableResource_0, (Object)target), null));
        }
        if (!shareable.exists((IProgressMonitor)progress.newChild(1))) {
            shareable = new Shareable(shareable.getSandbox(), shareable.getLocalPath(), ResourceType.SYMBOLIC_LINK);
        }
        IFileStorage storage = CoreShareablesUtil.getFileStorage(shareable);
        CoreShareablesUtil.createLink(storage, target, versionablePath, (IProgressMonitor)progress.newChild(99));
        if (this.isResource) {
            IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile(this.getResource().getFullPath());
            try {
                file.refreshLocal(2, (IProgressMonitor)progress.newChild(1));
            }
            catch (CoreException e) {
                throw new FileSystemClientException(FileSystemStatus.getStatusFor((Throwable)e));
            }
        }
    }

    public void setLink(String target, VersionablePath knownPathSegments, IProgressMonitor monitor) throws FileSystemClientException, TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)4);
        IShareable shareable = this.getShareable((IProgressMonitor)progress.newChild(1));
        if (shareable == null) {
            if (this.isResource) {
                IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile(this.getResource().getFullPath());
                try {
                    IFileStore store = EFS.getStore((URI)file.getLocationURI());
                    if (store != null) {
                        ManagedFileStore.createSymlink((IFileStore)store, (String)target, (IProgressMonitor)progress.newChild(1));
                        file.refreshLocal(2, (IProgressMonitor)progress.newChild(1));
                        return;
                    }
                }
                catch (CoreException e) {
                    throw new FileSystemClientException(FileSystemStatus.getStatusFor((Throwable)e));
                }
            }
            throw new FileSystemClientException(FileSystemStatus.getStatusFor((int)4, (String)NLS.bind((String)Messages.MovableResource_0, (Object)target), null));
        }
        if (!shareable.exists((IProgressMonitor)progress.newChild(1))) {
            shareable = new Shareable(shareable.getSandbox(), shareable.getLocalPath(), ResourceType.SYMBOLIC_LINK);
        }
        IFileStorage storage = CoreShareablesUtil.getFileStorage(shareable);
        SharingManager sm = SharingManager.getInstance();
        sm.disableChangeMonitoring();
        try {
            storage.setTarget(new Shed(null), target, (IProgressMonitor)progress.newChild(1));
        }
        finally {
            sm.enableChangeMonitoring();
        }
        ((LocalChangeManager)sm.getLocalChangeManager()).refreshChanges(shareable, ILocalChangeManager.RefreshType.TRAVERSE_ALL_WITH_RECOMPUTE_OF_KNOWN, (IProgressMonitor)progress.newChild(1));
    }
}

