/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.rcp.core.internal.patches;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.IContentProperties;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.ResourceType;
import com.ibm.team.filesystem.client.internal.FileStorageInputStreamProvider;
import com.ibm.team.filesystem.client.internal.IFileStorage;
import com.ibm.team.filesystem.client.internal.SharingManager;
import com.ibm.team.filesystem.common.FileLineDelimiter;
import com.ibm.team.filesystem.common.changemodel.FileState;
import com.ibm.team.filesystem.common.changemodel.VersionablePathSegment;
import com.ibm.team.filesystem.rcp.core.internal.CoreShareablesUtil;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.utils.IInputStreamProvider;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.internal.util.StateId;
import java.util.Date;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

public class FileStateFactory {
    public static FileState create(IShareable shareable, IProgressMonitor monitor) throws FileSystemClientException, TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        VersionablePathSegment path = CoreShareablesUtil.getSegment(shareable, (IProgressMonitor)progress.newChild(25));
        IFileStorage file = CoreShareablesUtil.getFileStorage(shareable);
        Date date = new Date(file.getModificationStamp());
        boolean executable = shareable.isExecutable((IProgressMonitor)progress.newChild(25));
        IVersionableHandle versionableHandle = shareable.getVersionable((IProgressMonitor)progress.newChild(25));
        StateId stateId = StateId.getDeletedState((IItemType)versionableHandle.getItemType(), (UUID)versionableHandle.getItemId());
        ResourceType type = shareable.getResourceType((IProgressMonitor)progress.newChild(25));
        boolean exists = true;
        if (type == null) {
            exists = false;
            type = ResourceType.getResourceType((IVersionableHandle)versionableHandle);
        }
        switch (type) {
            case FILE: {
                IContentProperties contentProperties = SharingManager.getInstance().getContentExaminer().examine(shareable, (IProgressMonitor)progress.newChild(1));
                FileStorageInputStreamProvider inputStreamProvider = FileStorageInputStreamProvider.create((IFileStorage)file);
                return FileState.create((VersionablePathSegment)path, (Date)date, (IInputStreamProvider)inputStreamProvider, (boolean)executable, (String)contentProperties.getMimeType(), (FileLineDelimiter)contentProperties.getLineDelimiter(), (boolean)contentProperties.isText(), (String)contentProperties.getEncoding(), (!exists ? 1 : 0) != 0, (StateId)stateId);
            }
            case SYMBOLIC_LINK: {
                FileStorageInputStreamProvider inputStreamProvider = FileStorageInputStreamProvider.create((IFileStorage)file);
                String target = file.getTarget((IProgressMonitor)progress.newChild(5));
                return FileState.create((VersionablePathSegment)path, (Date)date, (IInputStreamProvider)inputStreamProvider, (!exists ? 1 : 0) != 0, (StateId)stateId, (String)target);
            }
        }
        return FileState.create((VersionablePathSegment)path, (Date)date, (!exists ? 1 : 0) != 0, (StateId)stateId);
    }
}

