/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.rcp.core.internal.patches;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.ResourceType;
import com.ibm.team.filesystem.rcp.core.internal.Messages;
import com.ibm.team.filesystem.rcp.core.internal.patches.AbstractTrivialOp;
import com.ibm.team.filesystem.rcp.core.internal.patches.MovableResource;
import com.ibm.team.filesystem.rcp.core.patches.PatchConflictException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.core.preferences.SerializationContext;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.osgi.util.NLS;

public class DeleteLinkOp
extends AbstractTrivialOp {
    public DeleteLinkOp() {
    }

    public DeleteLinkOp(SerializationContext savedState, IProgressMonitor monitor) throws CoreException {
    }

    public void autoResolve(MovableResource resource, IProgressMonitor monitor) throws FileSystemClientException, PatchConflictException, TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)3);
        if (resource.exists((IProgressMonitor)progress.newChild(1))) {
            this.doVerify(resource, (IProgressMonitor)progress.newChild(1));
            resource.delete((IProgressMonitor)progress.newChild(1));
        }
    }

    protected void doVerify(MovableResource resource, IProgressMonitor monitor) throws PatchConflictException, FileSystemClientException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)3);
        if (!resource.exists((IProgressMonitor)progress)) {
            return;
        }
        ResourceType resourceType = resource.getResourceType((IProgressMonitor)progress.newChild(1));
        if (resourceType != ResourceType.SYMBOLIC_LINK) {
            throw new PatchConflictException(StatusUtil.newStatus((Object)this, (String)NLS.bind((String)Messages.DeleteLinkOp_0, (Object)resource.getFullPath((IProgressMonitor)progress.newChild(1)).toOSString())));
        }
    }
}

