/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.rcp.core.internal.patches;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.rcp.core.internal.Messages;
import com.ibm.team.filesystem.rcp.core.internal.patches.AbstractTrivialOp;
import com.ibm.team.filesystem.rcp.core.internal.patches.MovableResource;
import com.ibm.team.filesystem.rcp.core.patches.PatchConflictException;
import com.ibm.team.internal.repository.rcp.streams.EmptyInputStreamProvider;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.utils.IInputStreamProvider;
import com.ibm.team.repository.rcp.core.preferences.SerializationContext;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

public class DeleteFolderOp
extends AbstractTrivialOp {
    public DeleteFolderOp() {
    }

    public DeleteFolderOp(SerializationContext savedState, IProgressMonitor monitor) throws CoreException {
    }

    public void autoResolve(MovableResource moveResource, IProgressMonitor monitor) throws FileSystemClientException, PatchConflictException, TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        if (moveResource.exists((IProgressMonitor)progress.newChild(1))) {
            this.doVerify(moveResource, (IProgressMonitor)progress.newChild(1));
            moveResource.delete((IProgressMonitor)progress.newChild(98));
        }
    }

    public void save(SerializationContext whereToSave, IProgressMonitor monitor) throws CoreException {
    }

    protected void doVerify(MovableResource resource, IProgressMonitor progress) throws PatchConflictException, FileSystemClientException {
        if (!resource.exists(progress)) {
            return;
        }
        try {
            if (resource.hasNonderivedChildren()) {
                throw new PatchConflictException(StatusUtil.newStatus((Object)this, (String)Messages.DeleteFolderOp_0));
            }
        }
        catch (CoreException e) {
            if (e instanceof PatchConflictException) {
                throw (PatchConflictException)e;
            }
            throw new FileSystemClientException(StatusUtil.newStatus((Object)this, (Throwable)e));
        }
    }

    public boolean isDelete() {
        return true;
    }

    public IInputStreamProvider getAfterStream(IProgressMonitor monitor) throws FileSystemClientException {
        return EmptyInputStreamProvider.getDefault();
    }

    public IInputStreamProvider getBeforeStream(IProgressMonitor monitor) throws FileSystemClientException {
        return EmptyInputStreamProvider.getDefault();
    }
}

