/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.rcp.core.internal.patches;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.common.changemodel.VersionablePath;
import com.ibm.team.filesystem.rcp.core.internal.InternalPreferencesUtil;
import com.ibm.team.filesystem.rcp.core.internal.Messages;
import com.ibm.team.filesystem.rcp.core.internal.patches.MovableResource;
import com.ibm.team.filesystem.rcp.core.patches.PatchConflictException;
import com.ibm.team.filesystem.rcp.core.patches.PatchOp;
import com.ibm.team.internal.repository.rcp.streams.EmptyInputStreamProvider;
import com.ibm.team.repository.common.utils.IInputStreamProvider;
import com.ibm.team.repository.rcp.core.preferences.SerializationContext;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import com.ibm.team.scm.common.internal.util.ItemId;
import com.ibm.team.scm.common.internal.util.StateId;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.osgi.util.NLS;
import org.osgi.service.prefs.Preferences;

public class CreateEmptyFileOp
extends PatchOp {
    private static final String ATTR_AFTER = "after";
    private static final String ATTR_BEFORE = "before";
    private static final String ATTR_PATH = "path";
    private final VersionablePath knownPathSegments;
    private final StateId beforeState;
    private final StateId afterState;

    public CreateEmptyFileOp(StateId beforeState, StateId afterState, VersionablePath path) {
        this.beforeState = beforeState;
        this.afterState = afterState;
        this.knownPathSegments = path;
    }

    public CreateEmptyFileOp(SerializationContext ctxt, IProgressMonitor monitor) throws CoreException {
        Preferences savedState = ctxt.getPrefs();
        this.beforeState = InternalPreferencesUtil.getStateId(savedState, ATTR_BEFORE);
        this.afterState = InternalPreferencesUtil.getStateId(savedState, ATTR_AFTER);
        this.knownPathSegments = InternalPreferencesUtil.getVersionablePath(savedState, ATTR_PATH, VersionablePath.getUnresolvedPath((ItemId)this.afterState.getItemId()));
    }

    public void save(SerializationContext context, IProgressMonitor monitor) throws CoreException {
        Preferences whereToSave = context.getPrefs();
        InternalPreferencesUtil.putStateId(whereToSave, ATTR_BEFORE, this.getBeforeState());
        InternalPreferencesUtil.putStateId(whereToSave, ATTR_AFTER, this.getAfterState());
        InternalPreferencesUtil.putVersionablePath(whereToSave, ATTR_PATH, this.knownPathSegments);
    }

    public void autoResolve(MovableResource resource, IProgressMonitor monitor) throws FileSystemClientException, PatchConflictException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        this.doVerify(resource, (IProgressMonitor)progress.newChild(1));
        try {
            resource.createFile((IInputStreamProvider)EmptyInputStreamProvider.getDefault(), this.knownPathSegments, (IProgressMonitor)progress.newChild(50));
        }
        catch (Exception e) {
            throw new FileSystemClientException(StatusUtil.newStatus((Object)this, (Throwable)e));
        }
    }

    protected void doVerify(MovableResource resource, IProgressMonitor monitor) throws PatchConflictException, FileSystemClientException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        if (resource.exists((IProgressMonitor)progress.newChild(1))) {
            throw new PatchConflictException(StatusUtil.newStatus((Object)this, (String)NLS.bind((String)Messages.CreateEmptyFileOp_0, (Object)resource.getFullPath((IProgressMonitor)progress.newChild(1)))));
        }
    }

    public boolean isCreate() {
        return true;
    }

    public void dispose() {
    }

    public PatchOp copy() {
        return new CreateEmptyFileOp(this.beforeState, this.afterState, this.knownPathSegments);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.knownPathSegments == null ? 0 : this.knownPathSegments.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CreateEmptyFileOp other = (CreateEmptyFileOp)obj;
        return !(this.knownPathSegments == null ? other.knownPathSegments != null : !this.knownPathSegments.equals((Object)other.knownPathSegments));
    }
}

