/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.rcp.core.internal.patches;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.ResourceType;
import com.ibm.team.filesystem.rcp.core.internal.Messages;
import com.ibm.team.filesystem.rcp.core.internal.patches.AbstractTrivialOp;
import com.ibm.team.filesystem.rcp.core.internal.patches.MovableResource;
import com.ibm.team.filesystem.rcp.core.patches.PatchConflictException;
import com.ibm.team.internal.repository.rcp.streams.EmptyInputStreamProvider;
import com.ibm.team.repository.common.utils.IInputStreamProvider;
import com.ibm.team.repository.rcp.core.preferences.SerializationContext;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.osgi.util.NLS;

public class ClearFileContentsOp
extends AbstractTrivialOp {
    public ClearFileContentsOp() {
    }

    public ClearFileContentsOp(SerializationContext savedState, IProgressMonitor monitor) throws CoreException {
    }

    public void autoResolve(MovableResource resource, IProgressMonitor monitor) throws FileSystemClientException, PatchConflictException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        this.doVerify(resource, (IProgressMonitor)progress.newChild(5));
        try {
            resource.setContents(EmptyInputStreamProvider.getDefault().getInputStream((IProgressMonitor)progress.newChild(45)), (IProgressMonitor)progress.newChild(50));
        }
        catch (Exception e) {
            throw new FileSystemClientException(StatusUtil.newStatus((Object)this, (Throwable)e));
        }
    }

    protected void doVerify(MovableResource resource, IProgressMonitor monitor) throws PatchConflictException, FileSystemClientException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        if (!resource.exists((IProgressMonitor)progress.newChild(25))) {
            throw new PatchConflictException(StatusUtil.newStatus((Object)this, (String)NLS.bind((String)Messages.ClearFileContentsOp_1, (Object)resource.getFullPath((IProgressMonitor)progress.newChild(25)).toString())));
        }
        ResourceType resourceType = resource.getResourceType((IProgressMonitor)progress.newChild(25));
        if (resourceType != ResourceType.FILE && resourceType != null) {
            throw new PatchConflictException(StatusUtil.newStatus((Object)this, (String)NLS.bind((String)"{0}", (Object)resource.getFullPath((IProgressMonitor)progress.newChild(25)).toString())));
        }
    }

    public boolean isModify() {
        return true;
    }

    public IInputStreamProvider getAfterStream(IProgressMonitor monitor) throws FileSystemClientException {
        return EmptyInputStreamProvider.getDefault();
    }

    public IInputStreamProvider getBeforeStream(IProgressMonitor monitor) throws FileSystemClientException {
        return EmptyInputStreamProvider.getDefault();
    }
}

