/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.rcp.core.internal.patches;

import com.ibm.team.filesystem.common.changemodel.VersionablePath;
import com.ibm.team.filesystem.rcp.core.internal.patches.AbstractLinkStateChangeOp;
import com.ibm.team.filesystem.rcp.core.patches.PatchOp;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.core.preferences.PreferencesUtil;
import com.ibm.team.repository.rcp.core.preferences.SerializationContext;
import com.ibm.team.scm.common.internal.util.StateId;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.osgi.service.prefs.Preferences;

public class ApplyLinkStateChangeOp
extends AbstractLinkStateChangeOp {
    private static final String ATTR_TARGET = "target";
    private static final String ATTR_CREATION = "creation";
    private final String target;
    private final boolean isCreation;

    public ApplyLinkStateChangeOp(SerializationContext ctxt, IProgressMonitor monitor) throws CoreException {
        super(ctxt);
        Preferences savedState = ctxt.getPrefs();
        this.target = PreferencesUtil.getString((Preferences)savedState, (String)ATTR_TARGET);
        this.isCreation = PreferencesUtil.getBoolean((Preferences)savedState, (String)ATTR_CREATION);
    }

    public ApplyLinkStateChangeOp(String target, boolean isCreation, StateId beforeState, StateId afterState, VersionablePath knownPathSegments) {
        super(beforeState, afterState, knownPathSegments);
        this.target = target;
        this.isCreation = isCreation;
    }

    public void save(SerializationContext context, IProgressMonitor monitor) throws CoreException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)110);
        super.save(context, (IProgressMonitor)progress.newChild(10));
        Preferences whereToSave = context.getPrefs();
        whereToSave.put(ATTR_TARGET, this.target);
        whereToSave.putBoolean(ATTR_CREATION, this.isCreation);
    }

    public String getAfterLinkTarget(SubMonitor monitor) throws TeamRepositoryException {
        return this.target;
    }

    public boolean isCreate() {
        return this.isCreation;
    }

    public PatchOp copy() {
        return new ApplyLinkStateChangeOp(this.target, this.isCreation, this.getBeforeState(), this.getAfterState(), this.getKnownPathSegments());
    }

    public void dispose() {
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.target == null ? 0 : this.target.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ApplyLinkStateChangeOp other = (ApplyLinkStateChangeOp)obj;
        return !(this.target == null ? other.target != null : !this.target.equals(other.target));
    }
}

