/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.rcp.core.internal.patches;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.common.IFileItem;
import com.ibm.team.filesystem.common.changemodel.VersionablePath;
import com.ibm.team.filesystem.rcp.core.internal.InternalPreferencesUtil;
import com.ibm.team.filesystem.rcp.core.internal.patches.FilePatchResult;
import com.ibm.team.filesystem.rcp.core.internal.patches.Hunk;
import com.ibm.team.filesystem.rcp.core.internal.patches.MovableResource;
import com.ibm.team.filesystem.rcp.core.internal.patches.ParsedFilePatch;
import com.ibm.team.filesystem.rcp.core.internal.streams.HunkInputStream;
import com.ibm.team.filesystem.rcp.core.patches.PatchConflictException;
import com.ibm.team.filesystem.rcp.core.patches.PatchOp;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.utils.IInputStreamProvider;
import com.ibm.team.repository.common.utils.TemporaryOutputStream;
import com.ibm.team.repository.rcp.core.preferences.SerializationContext;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import com.ibm.team.repository.rcp.core.utils.StreamReference;
import com.ibm.team.scm.common.internal.util.ItemId;
import com.ibm.team.scm.common.internal.util.StateId;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.osgi.service.prefs.Preferences;

public class ApplyHunkOp
extends PatchOp {
    private static final String ITEM_ID = "itemId";
    private static final String ATTR_HUNK = "hunk";
    private static final String ATTR_HUNKDATA = "hunkdata";
    private static final String ATTR_LINE_COUNT = "linecount";
    private static final String ATTR_IS_DELETION = "deletion";
    private static final String ATTR_IS_CREATION = "creation";
    private static final String VERSIONABLE_PATH_ID = "versionablePath";
    private int patchedLineCount;
    private boolean isCreation;
    private boolean isDeletion;
    private StreamReference hunkData;
    private VersionablePath versionablePath;

    public ApplyHunkOp(Hunk toApply, VersionablePath optionalItemId, IProgressMonitor monitor) throws CoreException {
        this.versionablePath = optionalItemId;
        this.initialize(toApply, monitor);
    }

    private void initialize(Hunk toApply, IProgressMonitor monitor) throws CoreException {
        InputStream input = toApply.getPatchedContents();
        try {
            SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
            try {
                this.patchedLineCount = Hunk.parseAsText(Hunk.getCharset(toApply), input, (IProgressMonitor)progress.newChild(50)).size();
            }
            finally {
                input.close();
            }
            this.isCreation = Hunk.isCreation(toApply, (IProgressMonitor)progress.newChild(30));
            this.isDeletion = Hunk.isDeletion(toApply, (IProgressMonitor)progress.newChild(30));
            TemporaryOutputStream outputStream = TemporaryOutputStream.getEstimatedSizeTemporaryOutputStream((long)-1L);
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)outputStream, "UTF-8");
            Hunk.store(toApply, writer, (IProgressMonitor)progress.newChild(40));
            writer.close();
            outputStream.close();
            this.hunkData = StreamReference.create((IInputStreamProvider)outputStream);
        }
        catch (Exception e) {
            throw new CoreException(StatusUtil.newStatus((Object)this, (Throwable)e));
        }
    }

    private ApplyHunkOp(int patchedLineCount, boolean isCreation, boolean isDeletion, StreamReference hunkData, VersionablePath optionalItemId) {
        this.patchedLineCount = patchedLineCount;
        this.isCreation = isCreation;
        this.isDeletion = isDeletion;
        this.hunkData = hunkData;
        this.versionablePath = optionalItemId;
    }

    public ApplyHunkOp(SerializationContext savedState, IProgressMonitor monitor) throws CoreException {
        Preferences prefs = savedState.getPrefs();
        String hunkData = prefs.get(ATTR_HUNK, "");
        if (hunkData.equals("")) {
            this.isCreation = prefs.getBoolean(ATTR_IS_CREATION, false);
            this.isDeletion = prefs.getBoolean(ATTR_IS_DELETION, false);
            this.patchedLineCount = prefs.getInt(ATTR_LINE_COUNT, 0);
            this.hunkData = StreamReference.create((IInputStreamProvider)savedState.getFileStore().loadStream(prefs.get(ATTR_HUNKDATA, ""), monitor));
        } else {
            StringReader reader = new StringReader(hunkData);
            Hunk theHunk = ApplyHunkOp.parseHunk(reader, monitor);
            this.initialize(theHunk, monitor);
        }
        this.versionablePath = InternalPreferencesUtil.getVersionablePath(prefs, VERSIONABLE_PATH_ID, VersionablePath.getNullPath());
        if (this.versionablePath.getItemId().isNull()) {
            ItemId itemId = InternalPreferencesUtil.getItemId(prefs, ITEM_ID, ItemId.getNullItem((IItemType)IFileItem.ITEM_TYPE));
            this.versionablePath = VersionablePath.getUnresolvedPath(itemId);
        }
    }

    private static Hunk parseHunk(Reader reader, IProgressMonitor monitor) throws FileSystemClientException {
        Hunk theHunk;
        BufferedReader bufferedReader = new BufferedReader(reader);
        try {
            theHunk = Hunk.load(bufferedReader, monitor);
        }
        catch (IOException e) {
            throw new FileSystemClientException(StatusUtil.newStatus(ApplyHunkOp.class, (Throwable)e));
        }
        return theHunk;
    }

    public int getPatchedLineCount() {
        return this.patchedLineCount;
    }

    public void autoResolve(MovableResource moveResource, IProgressMonitor monitor) throws FileSystemClientException, PatchConflictException, TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        FilePatchResult result = this.computeResolve(moveResource, (IProgressMonitor)progress.newChild(50));
        moveResource.autoResolve(result, this.versionablePath, this.isDeletion, this.isCreation, (IProgressMonitor)progress.newChild(50));
    }

    public FilePatchResult computeResolve(MovableResource moveResource, IProgressMonitor monitor) throws PatchConflictException, FileSystemClientException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        Hunk hunk = this.getHunk((IProgressMonitor)progress.newChild(30));
        return moveResource.computeResolve(hunk, this.versionablePath, this.isDeletion, this.isCreation, (IProgressMonitor)progress.newChild(70));
    }

    public Hunk getHunk(IProgressMonitor monitor) throws FileSystemClientException {
        Hunk hunk;
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)40);
        InputStream inputStream = this.hunkData.getInputStream((IProgressMonitor)progress.newChild(20));
        try {
            InputStreamReader reader = new InputStreamReader(inputStream, "UTF-8");
            hunk = ApplyHunkOp.parseHunk(reader, (IProgressMonitor)progress.newChild(20));
        }
        catch (Throwable throwable) {
            try {
                inputStream.close();
                throw throwable;
            }
            catch (IOException e) {
                throw new FileSystemClientException(StatusUtil.newStatus((Object)this, (Throwable)e));
            }
        }
        inputStream.close();
        return hunk;
    }

    protected void doVerify(MovableResource path, IProgressMonitor monitor) throws PatchConflictException, FileSystemClientException {
        this.computeResolve(path, monitor);
    }

    public void save(SerializationContext context, IProgressMonitor monitor) throws CoreException {
        Preferences whereToSave = context.getPrefs();
        whereToSave.put(ATTR_HUNKDATA, context.getFileStore().saveStream((IInputStreamProvider)this.hunkData, monitor));
        whereToSave.putBoolean(ATTR_IS_CREATION, this.isCreation);
        whereToSave.putBoolean(ATTR_IS_DELETION, this.isDeletion);
        whereToSave.putInt(ATTR_LINE_COUNT, this.patchedLineCount);
        InternalPreferencesUtil.putVersionablePath(whereToSave, VERSIONABLE_PATH_ID, this.versionablePath);
    }

    public boolean isCreate() {
        return this.isCreation;
    }

    public boolean isDelete() {
        return this.isDeletion;
    }

    public boolean isModify() {
        return !this.isCreation && !this.isDeletion;
    }

    public PatchOp copy() {
        return new ApplyHunkOp(this.patchedLineCount, this.isCreation, this.isDeletion, this.hunkData.incRef(), this.versionablePath);
    }

    public void dispose() {
        try {
            this.hunkData.dispose();
        }
        catch (IOException e) {
            StatusUtil.log((Object)this, (Throwable)e);
        }
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.hunkData == null ? 0 : this.hunkData.hashCode());
        result = 31 * result + (this.isCreation ? 1231 : 1237);
        result = 31 * result + (this.isDeletion ? 1231 : 1237);
        result = 31 * result + (this.versionablePath == null ? 0 : this.versionablePath.hashCode());
        result = 31 * result + this.patchedLineCount;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ApplyHunkOp other = (ApplyHunkOp)obj;
        if (this.hunkData == null ? other.hunkData != null : !this.hunkData.equals((Object)other.hunkData)) {
            return false;
        }
        if (this.isCreation != other.isCreation) {
            return false;
        }
        if (this.isDeletion != other.isDeletion) {
            return false;
        }
        if (this.versionablePath == null ? other.versionablePath != null : !this.versionablePath.equals((Object)other.versionablePath)) {
            return false;
        }
        return this.patchedLineCount == other.patchedLineCount;
    }

    public StateId getAfterState() {
        return ParsedFilePatch.UNKNOWN_STATE;
    }

    public StateId getBeforeState() {
        return ParsedFilePatch.UNKNOWN_STATE;
    }

    public IInputStreamProvider getAfterStream(IProgressMonitor monitor) throws FileSystemClientException {
        Hunk hunk;
        try {
            hunk = this.getHunk(monitor);
        }
        catch (CoreException e) {
            throw new FileSystemClientException(StatusUtil.newStatus((Object)this, (Throwable)e));
        }
        return new HunkInputStream(hunk, true);
    }

    public IInputStreamProvider getBeforeStream(IProgressMonitor monitor) throws FileSystemClientException {
        Hunk hunk;
        try {
            hunk = this.getHunk(monitor);
        }
        catch (CoreException e) {
            throw new FileSystemClientException(StatusUtil.newStatus((Object)this, (Throwable)e));
        }
        return new HunkInputStream(hunk, false);
    }

    public int getStartLine(IProgressMonitor monitor) throws FileSystemClientException {
        Hunk hunk;
        try {
            hunk = this.getHunk(monitor);
        }
        catch (CoreException e) {
            throw new FileSystemClientException(StatusUtil.newStatus((Object)this, (Throwable)e));
        }
        return hunk.getStartPosition();
    }
}

