/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.rcp.core.internal.patches;

import com.ibm.team.filesystem.common.FileLineDelimiter;
import com.ibm.team.filesystem.common.changemodel.VersionablePath;
import com.ibm.team.filesystem.rcp.core.internal.patches.AbstractFileStateChangeOp;
import com.ibm.team.filesystem.rcp.core.patches.PatchOp;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.utils.IInputStreamProvider;
import com.ibm.team.repository.rcp.core.preferences.PreferencesUtil;
import com.ibm.team.repository.rcp.core.preferences.SerializationContext;
import com.ibm.team.repository.rcp.core.preferences.StreamStore;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import com.ibm.team.repository.rcp.core.utils.StreamReference;
import com.ibm.team.scm.common.internal.util.StateId;
import java.io.IOException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.osgi.service.prefs.Preferences;

public class ApplyFileStateChangeOp
extends AbstractFileStateChangeOp {
    private static final String ATTR_AFTER_CHARSET = "afterCharset";
    private static final String ATTR_BEFORE_CHARSET = "beforeCharset";
    private static final String ATTR_BEFORE_STATE_FILE = "beforeFile";
    private static final String ATTR_AFTER_STATE_FILE = "afterFile";
    private static final String ATTR_AFTER_LINE_DELIMITER = "afterLineDelimiter";
    private static final String ATTR_BEFORE_LINE_DELIMITER = "beforeLineDelimiter";
    private StreamReference beforeStream;
    private StreamReference afterStream;
    private final String beforeCharset;
    private final String afterCharset;
    private final FileLineDelimiter beforeLineDelimiter;
    private final FileLineDelimiter afterLineDelimiter;

    public ApplyFileStateChangeOp(StateId beforeState, StateId afterState, StreamReference beforeStream, String beforeCharset, FileLineDelimiter beforeLineDelimiter, StreamReference afterStream, String afterCharset, FileLineDelimiter afterLineDelimiter, VersionablePath knownPathSegments) {
        super(beforeState, afterState, knownPathSegments);
        this.beforeStream = beforeStream != null ? beforeStream.incRef() : null;
        this.afterStream = afterStream != null ? afterStream.incRef() : null;
        this.beforeCharset = beforeCharset;
        this.afterCharset = afterCharset;
        this.beforeLineDelimiter = beforeLineDelimiter;
        this.afterLineDelimiter = afterLineDelimiter;
    }

    public ApplyFileStateChangeOp(SerializationContext ctxt, IProgressMonitor monitor) throws CoreException {
        super(ctxt);
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        Preferences savedState = ctxt.getPrefs();
        StreamStore fileStore = ctxt.getFileStore();
        this.beforeCharset = PreferencesUtil.getString((Preferences)savedState, (String)ATTR_BEFORE_CHARSET);
        this.afterCharset = PreferencesUtil.getString((Preferences)savedState, (String)ATTR_AFTER_CHARSET);
        String beforeStateFile = PreferencesUtil.getString((Preferences)savedState, (String)ATTR_BEFORE_STATE_FILE);
        String afterStateFile = PreferencesUtil.getString((Preferences)savedState, (String)ATTR_AFTER_STATE_FILE);
        this.beforeStream = StreamReference.create((IInputStreamProvider)fileStore.loadStream(beforeStateFile, (IProgressMonitor)progress.newChild(50)));
        this.afterStream = StreamReference.create((IInputStreamProvider)fileStore.loadStream(afterStateFile, (IProgressMonitor)progress.newChild(50)));
        String bld = savedState.get(ATTR_BEFORE_LINE_DELIMITER, null);
        this.beforeLineDelimiter = bld == null ? null : FileLineDelimiter.fromString((String)bld);
        String ald = savedState.get(ATTR_AFTER_LINE_DELIMITER, null);
        this.afterLineDelimiter = ald == null ? null : FileLineDelimiter.fromString((String)ald);
    }

    public void save(SerializationContext context, IProgressMonitor monitor) throws CoreException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)110);
        super.save(context, (IProgressMonitor)progress.newChild(10));
        Preferences whereToSave = context.getPrefs();
        whereToSave.put(ATTR_BEFORE_CHARSET, this.beforeCharset);
        whereToSave.put(ATTR_AFTER_CHARSET, this.afterCharset);
        String beforeHandle = context.getFileStore().saveStream((IInputStreamProvider)this.beforeStream, (IProgressMonitor)progress.newChild(50));
        String afterHandle = context.getFileStore().saveStream((IInputStreamProvider)this.afterStream, (IProgressMonitor)progress.newChild(50));
        whereToSave.put(ATTR_BEFORE_STATE_FILE, beforeHandle);
        whereToSave.put(ATTR_AFTER_STATE_FILE, afterHandle);
        if (this.beforeLineDelimiter != null) {
            whereToSave.put(ATTR_BEFORE_LINE_DELIMITER, this.beforeLineDelimiter.toString());
        }
        if (this.afterLineDelimiter != null) {
            whereToSave.put(ATTR_AFTER_LINE_DELIMITER, this.afterLineDelimiter.toString());
        }
    }

    public IInputStreamProvider getBeforeStream(IProgressMonitor monitor) {
        return this.beforeStream;
    }

    public IInputStreamProvider getAfterStream(IProgressMonitor monitor) {
        return this.afterStream;
    }

    public String getBeforeCharset() {
        return this.beforeCharset;
    }

    public String getAfterCharset() {
        return this.afterCharset;
    }

    public String getAfterCharset(IProgressMonitor monitor) throws TeamRepositoryException {
        return this.afterCharset;
    }

    public String getBeforeCharset(IProgressMonitor monitor) throws TeamRepositoryException {
        return this.beforeCharset;
    }

    public PatchOp copy() {
        return new ApplyFileStateChangeOp(this.getBeforeState(), this.getAfterState(), this.beforeStream, this.beforeCharset, this.beforeLineDelimiter, this.afterStream, this.afterCharset, this.afterLineDelimiter, this.getKnownPathSegments());
    }

    public void dispose() {
        try {
            if (this.beforeStream != null) {
                this.beforeStream.dispose();
            }
            if (this.afterStream != null) {
                this.afterStream.dispose();
            }
        }
        catch (IOException e) {
            StatusUtil.log((Object)this, (Throwable)e);
        }
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.afterCharset == null ? 0 : this.afterCharset.hashCode());
        result = 31 * result + (this.afterStream == null ? 0 : this.afterStream.hashCode());
        result = 31 * result + (this.beforeCharset == null ? 0 : this.beforeCharset.hashCode());
        result = 31 * result + (this.beforeStream == null ? 0 : this.beforeStream.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ApplyFileStateChangeOp other = (ApplyFileStateChangeOp)obj;
        if (this.afterCharset == null ? other.afterCharset != null : !this.afterCharset.equals(other.afterCharset)) {
            return false;
        }
        if (this.afterStream == null ? other.afterStream != null : !this.afterStream.equals((Object)other.afterStream)) {
            return false;
        }
        if (this.beforeCharset == null ? other.beforeCharset != null : !this.beforeCharset.equals(other.beforeCharset)) {
            return false;
        }
        return !(this.beforeStream == null ? other.beforeStream != null : !this.beforeStream.equals((Object)other.beforeStream));
    }

    public int getStartLine(IProgressMonitor monitor) {
        return 0;
    }

    protected FileLineDelimiter getBeforeLineDelimiter(IProgressMonitor monitor) throws TeamRepositoryException {
        return this.beforeLineDelimiter;
    }

    protected FileLineDelimiter getAfterLineDelimiter(IProgressMonitor monitor) throws TeamRepositoryException {
        return this.afterLineDelimiter;
    }
}

