/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.rcp.core.internal.patches;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.ILocalChange;
import com.ibm.team.filesystem.client.IShare;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.internal.localchanges.LocalChangeManager;
import com.ibm.team.filesystem.common.changemodel.VersionablePath;
import com.ibm.team.filesystem.rcp.core.internal.InternalPreferencesUtil;
import com.ibm.team.filesystem.rcp.core.internal.Messages;
import com.ibm.team.filesystem.rcp.core.internal.patches.MovableResource;
import com.ibm.team.filesystem.rcp.core.internal.patches.ParsedFilePatch;
import com.ibm.team.filesystem.rcp.core.patches.PatchConflictException;
import com.ibm.team.filesystem.rcp.core.patches.PatchOp;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.rcp.core.preferences.SerializationContext;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.internal.util.ItemId;
import com.ibm.team.scm.common.internal.util.StateId;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.osgi.util.NLS;
import org.osgi.service.prefs.Preferences;

public abstract class AbstractStateChangeOp
extends PatchOp {
    private static final String ATTR_AFTER = "after";
    private static final String ATTR_BEFORE = "before";
    private static final String ATTR_PATH = "path";
    private final VersionablePath knownPathSegments;
    private final StateId beforeState;
    private final StateId afterState;

    protected AbstractStateChangeOp(StateId beforeState, StateId afterState, VersionablePath knownPathSegments) {
        this.beforeState = beforeState;
        this.afterState = afterState;
        this.knownPathSegments = knownPathSegments;
    }

    public AbstractStateChangeOp(SerializationContext ctxt) throws CoreException {
        Preferences savedState = ctxt.getPrefs();
        this.beforeState = InternalPreferencesUtil.getStateId(savedState, ATTR_BEFORE);
        this.afterState = InternalPreferencesUtil.getStateId(savedState, ATTR_AFTER);
        this.knownPathSegments = InternalPreferencesUtil.getVersionablePath(savedState, ATTR_PATH, VersionablePath.getUnresolvedPath((ItemId)this.afterState.getItemId()));
    }

    public void save(SerializationContext context, IProgressMonitor monitor) throws CoreException {
        Preferences whereToSave = context.getPrefs();
        InternalPreferencesUtil.putStateId(whereToSave, ATTR_BEFORE, this.getBeforeState());
        InternalPreferencesUtil.putStateId(whereToSave, ATTR_AFTER, this.getAfterState());
        InternalPreferencesUtil.putVersionablePath(whereToSave, ATTR_PATH, this.getKnownPathSegments());
    }

    protected VersionablePath getKnownPathSegments() {
        return this.knownPathSegments;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.afterState == null ? 0 : this.afterState.hashCode());
        result = 31 * result + (this.beforeState == null ? 0 : this.beforeState.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractStateChangeOp other = (AbstractStateChangeOp)obj;
        if (this.afterState == null ? other.afterState != null : !this.afterState.equals((Object)other.afterState)) {
            return false;
        }
        return !(this.beforeState == null ? other.beforeState != null : !this.beforeState.equals((Object)other.beforeState));
    }

    public boolean isDelete() {
        StateId afterState = this.getAfterState();
        return !afterState.equals((Object)ParsedFilePatch.UNKNOWN_STATE) && afterState.isDeleted();
    }

    public boolean isCreate() {
        StateId beforeState = this.getBeforeState();
        return !beforeState.equals((Object)ParsedFilePatch.UNKNOWN_STATE) && beforeState.isDeleted();
    }

    public final StateId getBeforeState() {
        return this.beforeState;
    }

    public final StateId getAfterState() {
        return this.afterState;
    }

    public boolean isModify() {
        return true;
    }

    protected boolean isMergeRequired(MovableResource resource, SubMonitor progress) throws FileSystemClientException, PatchConflictException {
        progress.setWorkRemaining(5);
        IShareable shareable = resource.getShareable((IProgressMonitor)progress.newChild(1));
        StateId beforeState = this.getBeforeState();
        StateId afterState = this.getAfterState();
        if (!beforeState.equals((Object)ParsedFilePatch.UNKNOWN_STATE)) {
            StateId remoteState;
            ILocalChange change;
            IVersionableHandle remoteHandle;
            if (beforeState.isDeleted()) {
                if (!resource.exists((IProgressMonitor)progress.newChild(1))) {
                    return false;
                }
                throw new PatchConflictException(StatusUtil.newStatus((Object)this, (String)Messages.AbstractStateChangeOp_0));
            }
            if (shareable == null) {
                throw new PatchConflictException(StatusUtil.newStatus((Object)this, (String)NLS.bind((String)Messages.AbstractStateChangeOp_1, (Object)resource.getFullPath((IProgressMonitor)progress.newChild(1)))));
            }
            IShare share = shareable.getShare((IProgressMonitor)progress.newChild(1));
            if (share != null && (remoteHandle = shareable.getRemote((IProgressMonitor)progress.newChild(1))) != null && (change = LocalChangeManager.getInstance().getPendingChange(share, remoteHandle)).getType() == 0 && (remoteState = new StateId((IItemHandle)remoteHandle)).equals((Object)beforeState)) {
                return false;
            }
        }
        if (!afterState.equals((Object)ParsedFilePatch.UNKNOWN_STATE) && afterState.isDeleted()) {
            return false;
        }
        if (!resource.exists((IProgressMonitor)progress.newChild(1))) {
            throw new PatchConflictException(StatusUtil.newStatus((Object)this, (String)Messages.ApplyStateChangeOp_6));
        }
        return true;
    }
}

