/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.rcp.core.internal.patches;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.ResourceType;
import com.ibm.team.filesystem.common.ISymbolicLink;
import com.ibm.team.filesystem.common.changemodel.VersionablePath;
import com.ibm.team.filesystem.rcp.core.internal.patches.AbstractStateChangeOp;
import com.ibm.team.filesystem.rcp.core.internal.patches.MovableResource;
import com.ibm.team.filesystem.rcp.core.internal.patches.ParsedFilePatch;
import com.ibm.team.filesystem.rcp.core.patches.PatchConflictException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.core.preferences.SerializationContext;
import com.ibm.team.scm.common.internal.util.StateId;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

public abstract class AbstractLinkStateChangeOp
extends AbstractStateChangeOp {
    public AbstractLinkStateChangeOp(SerializationContext ctxt) throws CoreException {
        super(ctxt);
    }

    public AbstractLinkStateChangeOp(StateId beforeState, StateId afterState, VersionablePath knownPathSegments) {
        super(beforeState, afterState, knownPathSegments);
    }

    public void autoResolve(MovableResource resource, IProgressMonitor monitor) throws FileSystemClientException, PatchConflictException, TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        ResourceType resourceType = resource.getResourceType((IProgressMonitor)progress.newChild(1));
        if (this.isSymbolicLink(resourceType)) {
            if (this.isCreate()) {
                resource.createLink(this.getAfterLinkTarget(progress.newChild(5)), this.getKnownPathSegments(), (IProgressMonitor)progress.newChild(20));
            } else {
                resource.setLink(this.getAfterLinkTarget(progress.newChild(5)), this.getKnownPathSegments(), (IProgressMonitor)progress.newChild(20));
            }
        }
    }

    public abstract String getAfterLinkTarget(SubMonitor var1) throws TeamRepositoryException;

    protected void doVerify(MovableResource resource, IProgressMonitor monitor) throws PatchConflictException, FileSystemClientException {
    }

    private boolean isSymbolicLink(ResourceType resourceType) {
        if (resourceType == null) {
            StateId afterState = this.getAfterState();
            if (!afterState.equals((Object)ParsedFilePatch.UNKNOWN_STATE) && !afterState.isDeleted()) {
                return afterState.getItemType().equals(ISymbolicLink.ITEM_TYPE);
            }
            StateId beforeState = this.getBeforeState();
            if (!beforeState.equals((Object)ParsedFilePatch.UNKNOWN_STATE) && !beforeState.isDeleted()) {
                return beforeState.getItemType().equals(ISymbolicLink.ITEM_TYPE);
            }
            return true;
        }
        return resourceType == ResourceType.SYMBOLIC_LINK;
    }
}

