/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.rcp.core.internal.patches;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.ResourceType;
import com.ibm.team.filesystem.client.internal.utils.CancellationMonitor;
import com.ibm.team.filesystem.common.FileLineDelimiter;
import com.ibm.team.filesystem.common.IFileItem;
import com.ibm.team.filesystem.common.changemodel.FileState;
import com.ibm.team.filesystem.common.changemodel.VersionablePath;
import com.ibm.team.filesystem.common.changemodel.VersionablePathSegment;
import com.ibm.team.filesystem.rcp.core.internal.Messages;
import com.ibm.team.filesystem.rcp.core.internal.operations.merge.FileContentMerger;
import com.ibm.team.filesystem.rcp.core.internal.patches.AbstractStateChangeOp;
import com.ibm.team.filesystem.rcp.core.internal.patches.MovableResource;
import com.ibm.team.filesystem.rcp.core.internal.patches.ParsedFilePatch;
import com.ibm.team.filesystem.rcp.core.internal.streams.InputStreamStorage;
import com.ibm.team.filesystem.rcp.core.patches.PatchConflictException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.utils.IInputStreamProvider;
import com.ibm.team.repository.common.utils.TemporaryOutputStream;
import com.ibm.team.repository.rcp.core.preferences.SerializationContext;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import com.ibm.team.repository.rcp.core.utils.StreamReference;
import com.ibm.team.scm.common.internal.util.StateId;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.team.core.mapping.IStorageMerger;

public abstract class AbstractFileStateChangeOp
extends AbstractStateChangeOp {
    public AbstractFileStateChangeOp(StateId beforeState, StateId afterState, VersionablePath knownPathSegments) {
        super(beforeState, afterState, knownPathSegments);
    }

    public AbstractFileStateChangeOp(SerializationContext ctxt) throws CoreException {
        super(ctxt);
    }

    public void autoResolve(MovableResource resource, IProgressMonitor monitor) throws FileSystemClientException, PatchConflictException, TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        StateId beforeState = this.getBeforeState();
        StateId afterState = this.getAfterState();
        ResourceType resourceType = resource.getResourceType((IProgressMonitor)progress.newChild(1));
        if (this.isFile(resourceType)) {
            try {
                if (!afterState.equals((Object)ParsedFilePatch.UNKNOWN_STATE) && afterState.isDeleted()) {
                    if (resource.exists((IProgressMonitor)progress.newChild(1))) {
                        resource.delete((IProgressMonitor)progress.newChild(98));
                    }
                    return;
                }
                if (!beforeState.equals((Object)ParsedFilePatch.UNKNOWN_STATE) && beforeState.isDeleted()) {
                    resource.createFile(this.getAfterStream((IProgressMonitor)progress.newChild(5)), this.getKnownPathSegments(), (IProgressMonitor)progress.newChild(20));
                    return;
                }
                IInputStreamProvider mergeResult = this.doMerge(resource, (IProgressMonitor)progress);
                InputStream input = mergeResult.getInputStream((IProgressMonitor)progress.newChild(1));
                try {
                    resource.setContents(input, (IProgressMonitor)progress.newChild(4));
                }
                finally {
                    input.close();
                }
            }
            catch (IOException e) {
                throw new FileSystemClientException(StatusUtil.newStatus((Object)this, (Throwable)e));
            }
            catch (PatchConflictException e) {
                throw e;
            }
        }
    }

    protected boolean isFile(ResourceType resourceType) {
        if (resourceType == null) {
            StateId afterState = this.getAfterState();
            if (!afterState.equals((Object)ParsedFilePatch.UNKNOWN_STATE) && !afterState.isDeleted()) {
                return afterState.getItemType().equals(IFileItem.ITEM_TYPE);
            }
            StateId beforeState = this.getBeforeState();
            if (!beforeState.equals((Object)ParsedFilePatch.UNKNOWN_STATE) && beforeState.isDeleted()) {
                return beforeState.getItemType().equals(IFileItem.ITEM_TYPE);
            }
        }
        return resourceType == ResourceType.FILE;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private IInputStreamProvider doMerge(MovableResource resource, IProgressMonitor monitor) throws FileSystemClientException, PatchConflictException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        try {
            if (!this.isMergeRequired(resource, progress.newChild(5))) return this.getAfterStream(null);
            try {
                TemporaryOutputStream outputStream = TemporaryOutputStream.getEstimatedSizeTemporaryOutputStream((long)-1L);
                try {
                    IStorageMerger storageMerger = this.getStorageMerger(resource, progress.newChild(2));
                    CancellationMonitor cMon = new CancellationMonitor((IProgressMonitor)progress);
                    IStatus status = FileContentMerger.performMerge(storageMerger, (OutputStream)outputStream, resource.getCharset((IProgressMonitor)progress.newChild(5)), new InputStreamStorage(this.getBeforeStream((IProgressMonitor)cMon), this.getBeforeCharset((IProgressMonitor)cMon)), resource.asEncodedStorage((IProgressMonitor)progress.newChild(1)), new InputStreamStorage(this.getAfterStream((IProgressMonitor)cMon), this.getAfterCharset((IProgressMonitor)cMon)), (IProgressMonitor)progress.newChild(45));
                    if (!status.isOK()) {
                        throw new PatchConflictException(StatusUtil.newStatus((Object)this, (String)Messages.ApplyStateChangeOp_8));
                    }
                    TemporaryOutputStream temporaryOutputStream = outputStream;
                    return temporaryOutputStream;
                }
                catch (PatchConflictException e) {
                    throw e;
                }
                catch (FileSystemClientException e) {
                    throw e;
                }
                catch (CoreException e) {
                    throw new FileSystemClientException(StatusUtil.newStatus((Object)this, (Throwable)e));
                }
                finally {
                    outputStream.close();
                }
            }
            catch (IOException e) {
                throw new FileSystemClientException(StatusUtil.newStatus((Object)this, (Throwable)e));
            }
        }
        catch (TeamRepositoryException e) {
            throw new PatchConflictException(StatusUtil.newStatus((Object)this, (Throwable)e));
        }
    }

    private IStorageMerger getStorageMerger(MovableResource resource, SubMonitor progress) throws FileSystemClientException, PatchConflictException {
        progress.setWorkRemaining(2);
        IShareable shareable = resource.getShareable((IProgressMonitor)progress.newChild(1));
        IStorageMerger storageMerger = FileContentMerger.getStorageMerger(shareable, null, true, (IProgressMonitor)progress.newChild(1));
        if (storageMerger == null) {
            throw new PatchConflictException(StatusUtil.newStatus((Object)this, (String)Messages.ApplyStateChangeOp_7));
        }
        return storageMerger;
    }

    public abstract String getAfterCharset(IProgressMonitor var1) throws TeamRepositoryException;

    public abstract String getBeforeCharset(IProgressMonitor var1) throws TeamRepositoryException;

    protected FileLineDelimiter getBeforeLineDelimiter(IProgressMonitor monitor) throws TeamRepositoryException {
        return null;
    }

    protected FileLineDelimiter getAfterLineDelimiter(IProgressMonitor monitor) throws TeamRepositoryException {
        return null;
    }

    protected void doVerify(MovableResource path, IProgressMonitor monitor) throws FileSystemClientException, PatchConflictException {
        this.doMerge(path, monitor);
    }

    public FileState getBeforeState(FileState currentState, IProgressMonitor monitor) throws FileSystemClientException, TeamRepositoryException {
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)20);
        FileLineDelimiter lineDelimiter = this.getBeforeLineDelimiter((IProgressMonitor)sub.newChild(20));
        if (lineDelimiter == null) {
            lineDelimiter = currentState.getLineDelimiter();
        }
        return FileState.create((VersionablePathSegment)currentState.getPath(), (Date)currentState.getTimestamp(), (IInputStreamProvider)StreamReference.create((IInputStreamProvider)this.getBeforeStream((IProgressMonitor)sub.newChild(20))), (boolean)currentState.isExectuable(), (String)currentState.getContentType(), (FileLineDelimiter)lineDelimiter, (boolean)currentState.isTextType(), (String)this.getBeforeCharset((IProgressMonitor)sub.newChild(20)), (boolean)this.getBeforeState().isDeleted(), (StateId)this.getBeforeState());
    }

    public FileState getAfterState(FileState currentState, IProgressMonitor monitor) throws FileSystemClientException, TeamRepositoryException {
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)40);
        FileLineDelimiter lineDelimiter = this.getAfterLineDelimiter((IProgressMonitor)sub.newChild(20));
        if (lineDelimiter == null) {
            lineDelimiter = currentState.getLineDelimiter();
        }
        return FileState.create((VersionablePathSegment)currentState.getPath(), (Date)currentState.getTimestamp(), (IInputStreamProvider)StreamReference.create((IInputStreamProvider)this.getAfterStream((IProgressMonitor)sub.newChild(20))), (boolean)currentState.isExectuable(), (String)currentState.getContentType(), (FileLineDelimiter)lineDelimiter, (boolean)currentState.isTextType(), (String)this.getAfterCharset((IProgressMonitor)sub.newChild(20)), (boolean)this.getAfterState().isDeleted(), (StateId)this.getAfterState());
    }
}

