/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.rcp.core.internal.operations.merge;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.IContentExaminer;
import com.ibm.team.filesystem.client.IContentProperties;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.internal.Shareable;
import com.ibm.team.filesystem.client.internal.SharingManager;
import com.ibm.team.filesystem.client.internal.TempHelper;
import java.io.InputStream;
import org.eclipse.core.resources.IEncodedStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.PlatformObject;

public class ShareableStorage
extends PlatformObject
implements IEncodedStorage {
    private Shareable shareable;
    private IContentProperties properties;

    public ShareableStorage(IShareable shareable, IProgressMonitor progress) throws FileSystemClientException {
        this.shareable = (Shareable)shareable;
        IContentExaminer contentExaminer = SharingManager.getInstance().getContentExaminer();
        this.properties = contentExaminer.findStoredProperties(shareable, progress);
    }

    public String getCharset() throws CoreException {
        return this.properties.getEncoding();
    }

    public InputStream getContents() throws CoreException {
        return this.shareable.getFileStorage().getContents();
    }

    public IPath getFullPath() {
        return this.shareable.getFullPath();
    }

    public String getName() {
        return this.shareable.getLocalPath().lastSegment();
    }

    public boolean isReadOnly() {
        try {
            return this.shareable.getFileStorage().isReadOnly((IProgressMonitor)TempHelper.MONITOR);
        }
        catch (FileSystemClientException fileSystemClientException) {
            return true;
        }
    }
}

