/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.rcp.core.internal.operations.merge;

import com.ibm.team.filesystem.client.internal.utils.FileContentInputStream;
import com.ibm.team.filesystem.common.FileLineDelimiter;
import com.ibm.team.filesystem.common.IFileContent;
import com.ibm.team.filesystem.common.IFileItemHandle;
import com.ibm.team.repository.client.ITeamRepository;
import java.io.InputStream;
import org.eclipse.core.resources.IEncodedStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.PlatformObject;

public class FileContentStorage
extends PlatformObject
implements IEncodedStorage {
    private IFileItemHandle item;
    private IFileContent content;
    private ITeamRepository repository;
    private IPath path;
    private final FileLineDelimiter lineDelimeter;
    private final IProgressMonitor monitor;

    public FileContentStorage(ITeamRepository repository, IFileItemHandle item, IFileContent content, IPath path, IProgressMonitor monitor) {
        this(repository, item, content, path, content.getLineDelimiter(), monitor);
    }

    public FileContentStorage(ITeamRepository repository, IFileItemHandle item, IFileContent content, IPath path, FileLineDelimiter lineDelimeter, IProgressMonitor monitor) {
        this.repository = repository;
        this.item = item;
        this.content = content;
        this.path = path;
        this.lineDelimeter = lineDelimeter;
        this.monitor = monitor;
    }

    public String getCharset() throws CoreException {
        return this.content.getCharacterEncoding();
    }

    public InputStream getContents() throws CoreException {
        return new FileContentInputStream(this.repository, this.item, this.content, this.lineDelimeter, this.monitor);
    }

    public IPath getFullPath() {
        return this.path;
    }

    public String getName() {
        return this.path.lastSegment();
    }

    public boolean isReadOnly() {
        return true;
    }
}

