/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.rcp.core.internal.operations.merge;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.IContentProperties;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.internal.FileSystemStatus;
import com.ibm.team.filesystem.client.internal.IFileContentMerger;
import com.ibm.team.filesystem.client.internal.Shareable;
import com.ibm.team.filesystem.client.internal.SharingManager;
import com.ibm.team.filesystem.client.internal.Shed;
import com.ibm.team.filesystem.common.FileLineDelimiter;
import com.ibm.team.filesystem.common.IFileContent;
import com.ibm.team.filesystem.common.IFileItem;
import com.ibm.team.filesystem.common.IFileItemHandle;
import com.ibm.team.filesystem.rcp.core.internal.Messages;
import com.ibm.team.filesystem.rcp.core.internal.operations.merge.EmptyStorage;
import com.ibm.team.filesystem.rcp.core.internal.operations.merge.FileContentStorage;
import com.ibm.team.filesystem.rcp.core.internal.operations.merge.ShareableStorage;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.utils.IInputStreamProvider;
import com.ibm.team.repository.common.utils.TemporaryOutputStream;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.eclipse.core.resources.IEncodedStorage;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.osgi.util.NLS;
import org.eclipse.team.core.Team;
import org.eclipse.team.core.mapping.IStorageMerger;

public class FileContentMerger
implements IFileContentMerger {
    private static FileContentMerger instance;

    public static IFileContentMerger getInstance() {
        if (instance == null) {
            instance = new FileContentMerger();
        }
        return instance;
    }

    private FileContentMerger() {
    }

    public IStatus performAutoMerge(ITeamRepository repository, IFileItem commonAncestorItem, IFileItem proposedItem, IShareable shareable, String contentTypeForMerge, Shed backupShed, IProgressMonitor progress) throws FileSystemClientException, IOException, TeamRepositoryException {
        IStorageMerger storageMerger;
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)100);
        try {
            storageMerger = FileContentMerger.getStorageMerger(shareable, contentTypeForMerge, false, (IProgressMonitor)monitor.newChild(5));
        }
        catch (FileSystemClientException e) {
            return e.getStatus();
        }
        return FileContentMerger.performAutoMerge(repository, commonAncestorItem, proposedItem, shareable, storageMerger, backupShed, (IProgressMonitor)monitor.newChild(95));
    }

    public static IStorageMerger getStorageMerger(IShareable shareable, String contentTypeForMerge, boolean fallbackToText, IProgressMonitor progress) throws FileSystemClientException {
        IStorageMerger storageMerger;
        IStorageMerger storageMerger2;
        IContentType contentType = null;
        IContentProperties properties = SharingManager.getInstance().getContentExaminer().findStoredProperties(shareable, progress);
        if (contentTypeForMerge != null) {
            contentType = Platform.getContentTypeManager().getContentType(contentTypeForMerge);
        } else if (properties.getContentTypeForMerge() != null) {
            contentType = Platform.getContentTypeManager().getContentType(properties.getContentTypeForMerge());
        }
        if (contentType != null && (storageMerger2 = new Team().createStorageMerger(contentType)) != null) {
            return storageMerger2;
        }
        String type = FileContentMerger.getFileExtension(shareable.getLocalPath().lastSegment());
        if (type != null && (storageMerger = new Team().createStorageMerger(type)) != null) {
            return storageMerger;
        }
        if ((properties.isText() || fallbackToText) && (storageMerger = new Team().createStorageMerger(contentType = Platform.getContentTypeManager().getContentType("org.eclipse.core.runtime.text"))) != null) {
            return storageMerger;
        }
        if (contentType == null && "application/unknown".equals(properties.getMimeType()) && FileLineDelimiter.LINE_DELIMITER_NONE == properties.getLineDelimiter()) {
            throw new FileSystemClientException((IStatus)new FileSystemStatus(4, 1002, NLS.bind((String)Messages.FileContentMerger_0, (Object)shareable.getFullPath())));
        }
        throw new FileSystemClientException((IStatus)new FileSystemStatus(4, 1001, NLS.bind((String)Messages.FileContentMerger_1, (Object)shareable.getFullPath())));
    }

    private static String getFileExtension(String name) {
        int index = name.lastIndexOf(46);
        if (index == -1) {
            return null;
        }
        if (index == name.length() - 1) {
            return "";
        }
        return name.substring(index + 1);
    }

    private static IStatus performAutoMerge(ITeamRepository repository, IFileItem commonAncestorItem, IFileItem proposedItem, IShareable file, IStorageMerger storageMerger, Shed backupShed, IProgressMonitor monitor) throws FileSystemClientException, IOException, TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        OutputStream outputStream = FileContentMerger.getTempOutputStream(proposedItem.getContent().getRawLength());
        try {
            IStatus mergeResult;
            try {
                mergeResult = FileContentMerger.performAutoMerge(repository, outputStream, storageMerger, file, commonAncestorItem, proposedItem, progress.newChild(50));
            }
            finally {
                outputStream.close();
            }
            if (mergeResult.getSeverity() == 0) {
                InputStream newContents = FileContentMerger.getTempInputStream(outputStream, (IProgressMonitor)progress.newChild(1));
                try {
                    ((Shareable)file).getFileStorage().setContents(newContents, backupShed, (IProgressMonitor)progress.newChild(5));
                }
                catch (Throwable throwable) {
                    try {
                        newContents.close();
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
                try {
                    newContents.close();
                }
                catch (IOException iOException) {}
                IStatus iStatus = Status.OK_STATUS;
                return iStatus;
            }
            IStatus iStatus = mergeResult;
            return iStatus;
        }
        finally {
            FileContentMerger.cleanUpTempStreams(outputStream);
        }
    }

    private static OutputStream getTempOutputStream(long estimatedSize) {
        try {
            return TemporaryOutputStream.getEstimatedSizeTemporaryOutputStream((long)estimatedSize);
        }
        catch (IOException e) {
            StatusUtil.log((Object)"com.ibm.team.filesystem.rcp.core", (Throwable)e);
            return new ByteArrayOutputStream();
        }
    }

    private static InputStream getTempInputStream(OutputStream out, IProgressMonitor monitor) throws IOException {
        if (out instanceof ByteArrayOutputStream) {
            ByteArrayOutputStream baos = (ByteArrayOutputStream)out;
            baos.close();
            return new ByteArrayInputStream(baos.toByteArray());
        }
        if (out instanceof IInputStreamProvider) {
            IInputStreamProvider isp = (IInputStreamProvider)out;
            return isp.getInputStream(monitor);
        }
        throw new IllegalStateException();
    }

    private static void cleanUpTempStreams(OutputStream outputStream) {
        if (outputStream instanceof TemporaryOutputStream) {
            TemporaryOutputStream tos = (TemporaryOutputStream)outputStream;
            try {
                tos.dispose();
            }
            catch (IOException e) {
                StatusUtil.log((Object)"com.ibm.team.filesystem.rcp.core", (Throwable)e);
            }
        }
    }

    private static IStatus performAutoMerge(ITeamRepository repo, OutputStream outputStream, IStorageMerger storageMerger, IShareable shareable, IFileItem commonAncestorItem, IFileItem proposedItem, SubMonitor progress) throws FileSystemClientException {
        String encoding;
        progress.setWorkRemaining(100);
        IFileContent proposedContent = proposedItem.getContent();
        FileLineDelimiter lineDelimeter = proposedContent.getLineDelimiter();
        if (shareable.exists((IProgressMonitor)progress.newChild(1))) {
            lineDelimeter = shareable.getLineDelimiter((IProgressMonitor)progress.newChild(1));
        }
        IPath path = shareable.getFullPath();
        PlatformObject ancestorStorage = commonAncestorItem != null ? new FileContentStorage(repo, (IFileItemHandle)commonAncestorItem, commonAncestorItem.getContent(), path, (IProgressMonitor)progress.newChild(1)) : new EmptyStorage(path);
        FileContentStorage otherStorage = new FileContentStorage(repo, (IFileItemHandle)proposedItem, proposedContent, path, lineDelimeter, (IProgressMonitor)progress.newChild(1));
        ShareableStorage shareableStorage = new ShareableStorage(shareable, (IProgressMonitor)progress.newChild(1));
        try {
            encoding = shareableStorage.getCharset();
        }
        catch (CoreException e) {
            throw new FileSystemClientException(FileSystemStatus.getStatusFor((Throwable)e));
        }
        return FileContentMerger.performMerge(storageMerger, outputStream, encoding, (IStorage)ancestorStorage, shareableStorage, otherStorage, (IProgressMonitor)progress.newChild(96));
    }

    public static IStatus performMerge(IStorageMerger storageMerger, OutputStream outputStream, String charset, IStorage ancestorStorage, IEncodedStorage file, IEncodedStorage otherStorage, IProgressMonitor monitor) throws FileSystemClientException {
        try {
            return storageMerger.merge(outputStream, charset, ancestorStorage, (IStorage)file, (IStorage)otherStorage, monitor);
        }
        catch (CoreException e) {
            throw new FileSystemClientException(FileSystemStatus.getStatusFor((Throwable)e));
        }
    }
}

