/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.rcp.core.internal.operations;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.FileSystemCore;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.ResourceType;
import com.ibm.team.filesystem.client.internal.operations.FileSystemOperation;
import com.ibm.team.filesystem.client.internal.snapshot.SnapshotId;
import com.ibm.team.filesystem.client.internal.utils.PathUtils;
import com.ibm.team.filesystem.client.operations.DilemmaHandler;
import com.ibm.team.filesystem.common.IFileItem;
import com.ibm.team.filesystem.common.changemodel.IPathResolver;
import com.ibm.team.filesystem.common.changemodel.VersionablePath;
import com.ibm.team.filesystem.rcp.core.internal.CoreShareablesUtil;
import com.ibm.team.filesystem.rcp.core.internal.Messages;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.CopyFileAreaPathResolver;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.FallbackPathResolver;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.SnapshotPathResolver;
import com.ibm.team.filesystem.rcp.core.internal.operations.FilesystemUtil;
import com.ibm.team.filesystem.rcp.core.internal.operations.LoadFileRequest;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.internal.util.ItemId;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RestoreFileOperation
extends FileSystemOperation {
    private final List<LoadFileRequest> toLoad = new ArrayList<LoadFileRequest>();
    private final IPathResolver pathResolver;
    private Map<VersionablePath, VersionablePath> resolvedPaths;

    public RestoreFileOperation(IPathResolver pathResolver, RestoreFileDilemmaHandler dilemmaHandler) {
        super((DilemmaHandler)dilemmaHandler);
        this.pathResolver = pathResolver;
    }

    public RestoreFileOperation(SnapshotId context, RestoreFileDilemmaHandler dilemmaHandler) {
        this(RestoreFileOperation.getPathResolver(context), dilemmaHandler);
    }

    private static IPathResolver getPathResolver(SnapshotId context) {
        ArrayList<IPathResolver> pathResolvers = new ArrayList<IPathResolver>();
        pathResolvers.add(CopyFileAreaPathResolver.create());
        if (context != null) {
            pathResolvers.add(SnapshotPathResolver.create(context));
        }
        FallbackPathResolver pathResolver = new FallbackPathResolver(pathResolvers);
        return pathResolver;
    }

    protected void execute(IProgressMonitor monitor) throws FileSystemClientException, TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        this.resolvePaths((IProgressMonitor)progress.newChild(50));
        Map<LoadFileRequest, IStatus> results = this.load((IProgressMonitor)progress.newChild(50));
        ((RestoreFileDilemmaHandler)this.getDilemmaHandler()).loadCompleted(results);
    }

    private void resolvePaths(IProgressMonitor monitor) throws TeamRepositoryException {
        this.resolvedPaths = FilesystemUtil.resolvePaths(this.pathResolver, RestoreFileOperation.getPaths(this.toLoad), monitor);
    }

    private static Collection<VersionablePath> getPaths(Collection<LoadFileRequest> requestedFiles) {
        ArrayList<VersionablePath> result = new ArrayList<VersionablePath>();
        for (LoadFileRequest next : requestedFiles) {
            result.add(next.getPath());
        }
        return result;
    }

    private Map<LoadFileRequest, IStatus> load(IProgressMonitor monitor) throws TeamRepositoryException, OperationCanceledException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)this.toLoad.size());
        HashMap<LoadFileRequest, IStatus> failures = new HashMap<LoadFileRequest, IStatus>();
        for (LoadFileRequest next : this.toLoad) {
            IStatus result = this.load(next, progress.newChild(1));
            if (result.isOK()) continue;
            failures.put(next, result);
        }
        return failures;
    }

    private IStatus load(LoadFileRequest request, SubMonitor monitor) {
        IFileItem file = request.getFile();
        if (file == null) {
            return StatusUtil.newStatus(LoadFileRequest.class, (String)Messages.LoadFileUtil_0);
        }
        IStatus result = Status.OK_STATUS;
        try {
            if (request.getLocation() != null) {
                return this.load(request, request.getLocation(), (IProgressMonitor)monitor);
            }
            monitor.setWorkRemaining(100);
            result = this.updateLocation(request, monitor.newChild(20));
            if (request.getLocation() != null) {
                return this.load(request, request.getLocation(), (IProgressMonitor)monitor);
            }
        }
        catch (TeamRepositoryException e) {
            result = StatusUtil.newStatus(LoadFileRequest.class, (Throwable)e);
            StatusUtil.log((IStatus)result);
        }
        catch (CoreException e) {
            result = StatusUtil.newStatus(LoadFileRequest.class, (Throwable)e);
            StatusUtil.log((IStatus)result);
        }
        return result;
    }

    private IStatus updateLocation(LoadFileRequest request, SubMonitor monitor) throws TeamRepositoryException, FileSystemClientException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        VersionablePath path = request.getPath();
        if (this.resolvedPaths.containsKey(path)) {
            path = this.resolvedPaths.get(path);
        }
        IStatus result = Status.OK_STATUS;
        if (!path.isResolved()) {
            result = StatusUtil.newStatus(LoadFileRequest.class, (int)2, (String)Messages.LoadFileUtil_1);
        }
        Collection<IShareable> shareables = CoreShareablesUtil.getShareablesFor(path, (IProgressMonitor)progress.newChild(10));
        if ((shareables = this.filterShareables(shareables, (IProgressMonitor)progress.newChild(5))).size() > 1) {
            int rc = ((RestoreFileDilemmaHandler)this.getDilemmaHandler()).multipleValidLocationsFound(request, shareables);
            switch (rc) {
                case 1: {
                    throw new OperationCanceledException();
                }
                case 0: {
                    if (request.getLocation() != null) break;
                }
                case 3: {
                    List<IStatus> infos = this.getStatusForShareables(shareables, 1);
                    result = StatusUtil.newStatus((Object)((Object)this), (String)NLS.bind((String)Messages.RestoreFileOperation_0, (Object)path.toString()), infos);
                    break;
                }
                default: {
                    List<IStatus> errors = this.getStatusForShareables(shareables, 4);
                    result = StatusUtil.newStatus((Object)((Object)this), (String)NLS.bind((String)Messages.RestoreFileOperation_1, (Object)path.toString()), errors);
                    break;
                }
            }
        } else {
            boolean consultHandler = true;
            if (shareables.size() == 1) {
                IShareable shareable = shareables.iterator().next();
                ResourceType resourceType = shareable.getResourceType((IProgressMonitor)progress.newChild(5));
                if (resourceType == ResourceType.FOLDER) {
                    result = StatusUtil.newStatus((Object)((Object)this), (String)NLS.bind((String)Messages.LoadFileUtil_3, (Object)path.toString()));
                } else if (resourceType == ResourceType.SYMBOLIC_LINK) {
                    result = StatusUtil.newStatus((Object)((Object)this), (String)NLS.bind((String)Messages.LoadFileUtil_PATH_IS_SYMBOLIC_LINK, (Object)path.toString()));
                } else {
                    request.setLocation(shareable.getFullPath());
                    consultHandler = false;
                }
            } else {
                result = StatusUtil.newStatus((Object)((Object)this), (String)NLS.bind((String)Messages.RestoreFileOperation_2, (Object)path.toString()));
            }
            if (consultHandler) {
                int rc = ((RestoreFileDilemmaHandler)this.getDilemmaHandler()).restoreLocationNotFound(request, result);
                switch (rc) {
                    case 1: {
                        throw new OperationCanceledException();
                    }
                    case 0: {
                        if (request.getLocation() != null) {
                            result = Status.OK_STATUS;
                            break;
                        }
                    }
                    case 3: {
                        result = StatusUtil.newStatus((Object)((Object)this), (int)1, (String)result.getMessage());
                        break;
                    }
                }
            }
        }
        return result;
    }

    private List<IStatus> getStatusForShareables(Collection<IShareable> shareables, int severity) {
        ArrayList<IStatus> result = new ArrayList<IStatus>(shareables.size());
        for (IShareable shareable : shareables) {
            result.add(StatusUtil.newStatus((Object)((Object)this), (int)severity, (String)NLS.bind((String)Messages.RestoreFileOperation_3, (Object)shareable.getFullPath().toOSString())));
        }
        return result;
    }

    private Collection<IShareable> filterShareables(Collection<IShareable> shareables, IProgressMonitor monitor) throws FileSystemClientException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)shareables.size());
        if (shareables.size() > 1) {
            ArrayList<IShareable> filtered = new ArrayList<IShareable>();
            for (IShareable shareable : shareables) {
                if (shareable.getResourceType((IProgressMonitor)progress.newChild(1)) != ResourceType.FILE) continue;
                filtered.add(shareable);
            }
            if (filtered.isEmpty()) {
                filtered.add(shareables.iterator().next());
            }
            return filtered;
        }
        return shareables;
    }

    private IStatus load(LoadFileRequest request, IPath location, IProgressMonitor monitor) throws FileSystemClientException, CoreException, TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        IShareable shareable = FileSystemCore.getSharingManager().findShareable(location, ResourceType.FILE);
        if (shareable == null) {
            IFile[] files = ResourcesPlugin.getWorkspace().getRoot().findFilesForLocation(location);
            if (files.length > 0 && files[0].getProject().isAccessible()) {
                IFile eclipseFile = files[0];
                this.ensureExists(eclipseFile.getParent(), progress.newChild(1));
                InputStream inputStream = null;
                try {
                    try {
                        inputStream = new BufferedInputStream(FilesystemUtil.getFileInputStream(request.getRepo(), request.getFile(), (IProgressMonitor)progress.newChild(80)));
                        if (eclipseFile.exists()) {
                            eclipseFile.setContents(inputStream, false, true, (IProgressMonitor)progress.newChild(1));
                        } else {
                            eclipseFile.create(inputStream, false, (IProgressMonitor)progress.newChild(1));
                        }
                    }
                    catch (CoreException e) {
                        IStatus iStatus = StatusUtil.newStatus((Object)((Object)this), (Throwable)e);
                        if (inputStream != null) {
                            try {
                                inputStream.close();
                            }
                            catch (IOException iOException) {}
                        }
                        return iStatus;
                    }
                }
                catch (Throwable throwable) {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (IOException iOException) {}
                    }
                    throw throwable;
                }
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException) {}
                }
            } else {
                ResourceType resourceType = PathUtils.getResourceType((IPath)location, (IProgressMonitor)progress.newChild(1));
                if (resourceType == ResourceType.FOLDER) {
                    return StatusUtil.newStatus(LoadFileRequest.class, (String)NLS.bind((String)Messages.LoadFileUtil_3, (Object)location.toString()));
                }
                if (resourceType == ResourceType.SYMBOLIC_LINK) {
                    return StatusUtil.newStatus((Object)((Object)this), (String)NLS.bind((String)Messages.LoadFileUtil_PATH_IS_SYMBOLIC_LINK, (Object)location.toString()));
                }
                File file = location.toFile();
                File parent = file.getParentFile();
                if (!parent.exists()) {
                    parent.mkdirs();
                }
                InputStream inputStream = null;
                OutputStream outputStream = null;
                try {
                    try {
                        inputStream = new BufferedInputStream(FilesystemUtil.getFileInputStream(request.getRepo(), request.getFile(), (IProgressMonitor)progress.newChild(79)));
                        outputStream = new BufferedOutputStream(new FileOutputStream(file));
                        this.transferStreams(inputStream, outputStream);
                    }
                    catch (IOException e) {
                        IStatus iStatus = StatusUtil.newStatus((Object)((Object)this), (Throwable)e);
                        try {
                            if (inputStream != null) {
                                try {
                                    inputStream.close();
                                }
                                catch (IOException iOException) {}
                            }
                        }
                        catch (Throwable throwable) {
                            if (outputStream != null) {
                                try {
                                    outputStream.close();
                                }
                                catch (IOException iOException) {}
                            }
                            throw throwable;
                        }
                        if (outputStream != null) {
                            try {
                                outputStream.close();
                            }
                            catch (IOException iOException) {}
                        }
                        return iStatus;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        if (inputStream != null) {
                            try {
                                inputStream.close();
                            }
                            catch (IOException iOException) {}
                        }
                    }
                    catch (Throwable throwable2) {
                        if (outputStream != null) {
                            try {
                                outputStream.close();
                            }
                            catch (IOException iOException) {}
                        }
                        throw throwable2;
                    }
                    if (outputStream != null) {
                        try {
                            outputStream.close();
                        }
                        catch (IOException iOException) {}
                    }
                    throw throwable;
                }
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
                catch (Throwable throwable) {
                    if (outputStream != null) {
                        try {
                            outputStream.close();
                        }
                        catch (IOException iOException) {}
                    }
                    throw throwable;
                }
                if (outputStream != null) {
                    try {
                        outputStream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        } else {
            ResourceType resourceType = shareable.getResourceType((IProgressMonitor)progress.newChild(1));
            if (resourceType == ResourceType.FILE || resourceType == null) {
                FilesystemUtil.createFile(shareable, request.getRepo(), request.getPath().getSiloedItemId().getComponentHandle(), request.getFile(), (IProgressMonitor)progress.newChild(80));
            } else {
                if (resourceType == ResourceType.FOLDER) {
                    return StatusUtil.newStatus(LoadFileRequest.class, (String)NLS.bind((String)Messages.LoadFileUtil_3, (Object)location.toString()));
                }
                if (resourceType == ResourceType.SYMBOLIC_LINK) {
                    return StatusUtil.newStatus((Object)((Object)this), (String)NLS.bind((String)Messages.LoadFileUtil_PATH_IS_SYMBOLIC_LINK, (Object)location.toString()));
                }
                return StatusUtil.newStatus((Object)((Object)this), (String)(resourceType + location.toString()));
            }
        }
        return Status.OK_STATUS;
    }

    private void ensureExists(IContainer parent, SubMonitor monitor) throws CoreException {
        monitor.setWorkRemaining(2);
        if (!parent.exists() && parent instanceof IFolder) {
            this.ensureExists(parent.getParent(), monitor.newChild(1));
            ((IFolder)parent).create(false, true, (IProgressMonitor)monitor.newChild(1));
        }
    }

    private void transferStreams(InputStream inputStream, OutputStream outputStream) throws IOException {
        int count;
        byte[] buffer = new byte[1024];
        while ((count = inputStream.read(buffer)) != -1) {
            outputStream.write(buffer, 0, count);
        }
    }

    public LoadFileRequest requestRestore(VersionablePath path, IFileItem file, ITeamRepository repo) {
        LoadFileRequest request = LoadFileRequest.create(path, file, repo);
        return this.add(request);
    }

    public LoadFileRequest requestRestore(IFileItem fileItem, ItemId<IComponent> component, ITeamRepository repository) {
        LoadFileRequest request = LoadFileRequest.create(fileItem, component, repository);
        return this.add(request);
    }

    public LoadFileRequest requestRestore(IPath location, IFileItem file, ITeamRepository repo) {
        return this.add(LoadFileRequest.create(location, file, repo));
    }

    private LoadFileRequest add(LoadFileRequest request) {
        this.toLoad.add(request);
        return request;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RestoreFileDilemmaHandler
    extends DilemmaHandler {
        public void loadCompleted(Map<LoadFileRequest, IStatus> results) {
        }

        public int restoreLocationNotFound(LoadFileRequest request, IStatus status) {
            return 0;
        }

        public int multipleValidLocationsFound(LoadFileRequest request, Collection<IShareable> shareables) {
            return 0;
        }
    }
}

