/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.rcp.core.internal.operations;

import com.ibm.team.filesystem.common.IFileItem;
import com.ibm.team.filesystem.common.changemodel.IPathResolver;
import com.ibm.team.filesystem.common.changemodel.VersionablePath;
import com.ibm.team.filesystem.common.changemodel.VersionablePathSegment;
import com.ibm.team.filesystem.rcp.core.internal.operations.FilesystemUtil;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IVersionable;
import com.ibm.team.scm.common.internal.util.ItemId;
import com.ibm.team.scm.common.internal.util.SiloedItemId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LoadFileRequest {
    private VersionablePath path;
    private IFileItem file;
    private ITeamRepository repo;
    private IPath location;

    private LoadFileRequest(VersionablePath path, IFileItem file, ITeamRepository repo) {
        if (file != null && !file.hasStateId()) {
            throw new IllegalArgumentException();
        }
        this.path = path;
        this.file = file;
        this.repo = repo;
    }

    public static LoadFileRequest create(VersionablePath path, IFileItem file, ITeamRepository repo) {
        return new LoadFileRequest(path, file, repo);
    }

    public static LoadFileRequest create(IPath path, IFileItem file, ITeamRepository repo) {
        SiloedItemId itemId = SiloedItemId.create((ItemId)ItemId.forItem((IItem)file), (ItemId)ItemId.getNullItem((IItemType)IComponent.ITEM_TYPE));
        LoadFileRequest request = LoadFileRequest.create(VersionablePath.create((VersionablePathSegment[])new VersionablePathSegment[0], (SiloedItemId)itemId, (boolean)false, (boolean)false), file, repo);
        request.setLocation(path.makeAbsolute());
        return request;
    }

    public static LoadFileRequest create(IFileItem file, ItemId<IComponent> component, ITeamRepository repo) {
        return LoadFileRequest.create(VersionablePath.getUnresolvedPath((IVersionable)file, component), file, repo);
    }

    public VersionablePath getPath() {
        return this.path;
    }

    public IFileItem getFile() {
        return this.file;
    }

    public ITeamRepository getRepo() {
        return this.repo;
    }

    private static Collection<VersionablePath> getPaths(Collection<LoadFileRequest> requestedFiles) {
        ArrayList<VersionablePath> result = new ArrayList<VersionablePath>();
        for (LoadFileRequest next : requestedFiles) {
            result.add(next.getPath());
        }
        return result;
    }

    public static List<LoadFileRequest> resolvePaths(Collection<LoadFileRequest> requestedFiles, IPathResolver pathResolver, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        Map<VersionablePath, VersionablePath> resolvedPaths = FilesystemUtil.resolvePaths(pathResolver, LoadFileRequest.getPaths(requestedFiles), (IProgressMonitor)progress.newChild(20));
        ArrayList<LoadFileRequest> result = new ArrayList<LoadFileRequest>();
        for (LoadFileRequest next : requestedFiles) {
            VersionablePath resolved = resolvedPaths.get(next.getPath());
            result.add(new LoadFileRequest(resolved, next.getFile(), next.getRepo()));
        }
        return result;
    }

    public void setLocation(IPath location) {
        this.location = location;
    }

    public IPath getLocation() {
        return this.location;
    }
}

