/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.rcp.core.internal.operations;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.FileSystemCore;
import com.ibm.team.filesystem.client.IOperationFactory;
import com.ibm.team.filesystem.client.ISandbox;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.internal.FileSystemStatus;
import com.ibm.team.filesystem.client.internal.IFileStorage;
import com.ibm.team.filesystem.client.internal.utils.CancellationMonitor;
import com.ibm.team.filesystem.client.operations.ChangePropertiesDilemmaHandler;
import com.ibm.team.filesystem.client.operations.IChangeFilePropertiesOperation;
import com.ibm.team.filesystem.common.IFileContent;
import com.ibm.team.filesystem.common.IFileItem;
import com.ibm.team.filesystem.common.IFileItemHandle;
import com.ibm.team.filesystem.common.changemodel.IPathResolver;
import com.ibm.team.filesystem.common.changemodel.VersionablePath;
import com.ibm.team.filesystem.rcp.core.internal.CoreShareablesUtil;
import com.ibm.team.filesystem.rcp.core.internal.Messages;
import com.ibm.team.internal.repository.rcp.streams.EmptyInputStreamProvider;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.NotLoggedInException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.utils.DisposableInputStreamProvider;
import com.ibm.team.repository.common.utils.TemporaryOutputStream;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import com.ibm.team.scm.client.internal.RepoFetcher;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IVersionable;
import com.ibm.team.scm.common.internal.util.ItemId;
import com.ibm.team.scm.common.internal.util.SiloedItemId;
import com.ibm.team.scm.common.internal.util.StateId;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilesystemUtil {
    public static void createFile(IShareable shareable, ITeamRepository repository, IComponentHandle component, IFileItem item, IProgressMonitor monitor) throws CoreException, TeamRepositoryException, FileSystemClientException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        IFileStorage fileStorage = CoreShareablesUtil.getFileStorage(shareable);
        InputStream input = null;
        try {
            try {
                if (!shareable.exists((IProgressMonitor)progress.newChild(1))) {
                    FilesystemUtil.createPath(shareable.getLocalPath().removeLastSegments(1), shareable.getSandbox(), progress.newChild(10));
                    input = FilesystemUtil.getFileInputStream(repository, item, (IProgressMonitor)progress.newChild(54));
                    CoreShareablesUtil.createFile(fileStorage, input, VersionablePath.getUnresolvedPath((IVersionable)item, (ItemId)ItemId.create((IItemHandle)component)), (IProgressMonitor)progress.newChild(5));
                } else {
                    input = FilesystemUtil.getFileInputStream(repository, item, (IProgressMonitor)progress.newChild(70));
                    fileStorage.setContents(input, true, (IProgressMonitor)new CancellationMonitor((IProgressMonitor)progress));
                }
                if (item != null && shareable.getShare((IProgressMonitor)progress.newChild(5)) != null) {
                    try {
                        ChangePropertiesDilemmaHandler dilemmaHandler = new ChangePropertiesDilemmaHandler();
                        IChangeFilePropertiesOperation changePropertiesOp = IOperationFactory.instance.getChangeFilePropertiesOperation(dilemmaHandler);
                        changePropertiesOp.setContentType(shareable, item.getContentType());
                        changePropertiesOp.setLineDelimiter(shareable, item.getContent().getLineDelimiter());
                        changePropertiesOp.run((IProgressMonitor)progress.newChild(25));
                    }
                    catch (NotLoggedInException notLoggedInException) {}
                }
                input.close();
                input = null;
            }
            catch (IOException e) {
                throw new FileSystemClientException(StatusUtil.newStatus(FilesystemUtil.class, (Throwable)e));
            }
        }
        catch (Throwable throwable) {
            if (input != null) {
                try {
                    input.close();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        if (input != null) {
            try {
                input.close();
            }
            catch (IOException iOException) {}
        }
    }

    private static void createPath(IPath localPath, ISandbox sandbox, SubMonitor newChild) throws FileSystemClientException {
        File file = new File(sandbox.getRoot().toOSString(), localPath.toString());
        if (!file.exists() && !file.mkdirs()) {
            throw new FileSystemClientException((IStatus)new FileSystemStatus(NLS.bind((String)Messages.FilesystemUtil_CouldNotCreateFolder, (Object)file.getAbsolutePath())));
        }
    }

    public static InputStream getFileInputStream(ITeamRepository server, IFileItem item, IProgressMonitor mon) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)mon, (int)100);
        if (item == null) {
            return new ByteArrayInputStream(new byte[0]);
        }
        IFileContent content = item.getContent();
        return FileSystemCore.getContentManager((ITeamRepository)server).retrieveContentStream((IFileItemHandle)item, content, (IProgressMonitor)progress.newChild(50));
    }

    public static DisposableInputStreamProvider openFileContents(ITeamRepository server, StateId<IFileItem> fileState, IProgressMonitor mon) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)mon, (int)100);
        if (fileState.isDeleted()) {
            return new EmptyInputStreamProvider();
        }
        IFileItem item = (IFileItem)RepoFetcher.fetchItem((ITeamRepository)server, fileState, (IProgressMonitor)progress.newChild(50));
        return FilesystemUtil.openFileContents(server, item, (IProgressMonitor)progress);
    }

    public static DisposableInputStreamProvider openFileContents(ITeamRepository server, IFileItem item, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        try {
            IFileContent content = item.getContent();
            TemporaryOutputStream out = TemporaryOutputStream.getTemporaryOutputStream((long)content.getEstimatedConvertedLength());
            boolean success = false;
            try {
                FileSystemCore.getContentManager((ITeamRepository)server).retrieveContent((IFileItemHandle)item, content, (OutputStream)out, (IProgressMonitor)progress.newChild(100));
                success = true;
            }
            catch (Throwable throwable) {
                if (!success) {
                    try {
                        out.dispose();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (!success) {
                try {
                    out.dispose();
                }
                catch (IOException iOException) {}
            }
            return out;
        }
        catch (IOException e) {
            throw new TeamRepositoryException((Throwable)e);
        }
    }

    public static Map<VersionablePath, VersionablePath> resolvePaths(IPathResolver pathResolver, Collection<VersionablePath> unresolved, IProgressMonitor monitor) throws TeamRepositoryException {
        HashSet<SiloedItemId> toResolve = new HashSet<SiloedItemId>();
        for (VersionablePath next : unresolved) {
            if (next.isResolved()) continue;
            toResolve.add(next.getSiloedRoot());
        }
        Map resolved = pathResolver.resolve(toResolve, monitor);
        HashMap<VersionablePath, VersionablePath> result = new HashMap<VersionablePath, VersionablePath>();
        for (VersionablePath next : unresolved) {
            if (!next.isResolved()) {
                VersionablePath nextResolved = (VersionablePath)resolved.get(next.getSiloedRoot());
                VersionablePath fullResolved = nextResolved.append(next);
                result.put(next, fullResolved);
                continue;
            }
            result.put(next, next);
        }
        return result;
    }
}

