/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.rcp.core.internal.operations;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.IShare;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.internal.FileItemInfo;
import com.ibm.team.filesystem.client.internal.FileItemInfoProxy;
import com.ibm.team.filesystem.client.internal.IRepositoryResolver;
import com.ibm.team.filesystem.client.internal.Share;
import com.ibm.team.filesystem.client.internal.Shareable;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileArea;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileAreaManager;
import com.ibm.team.filesystem.client.internal.localchanges.LocalChangeTracker;
import com.ibm.team.filesystem.client.internal.operations.UpdateOperation;
import com.ibm.team.filesystem.client.internal.utils.ConfigurationDescriptor;
import com.ibm.team.filesystem.common.FileLineDelimiter;
import com.ibm.team.filesystem.rcp.core.internal.Messages;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.IWorkspaceManager;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.common.IChange;
import com.ibm.team.scm.common.IChangeSet;
import com.ibm.team.scm.common.IChangeSetHandle;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IContextHandle;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.IWorkspaceHandle;
import com.ibm.team.scm.common.dto.IUpdateReport;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CancelRemoteChangesOperation {
    List<Cancelable> toCancel = new LinkedList<Cancelable>();
    private final IRepositoryResolver resolver;

    public CancelRemoteChangesOperation(IRepositoryResolver resolver) {
        this.resolver = resolver;
    }

    public CancelRemoteChangesOperation() {
        this(null);
    }

    public void execute(IProgressMonitor progress) throws FileSystemClientException, TeamRepositoryException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (String)Messages.CancelRemoteChangesOperation_0, (int)2);
        this.cancelChanges(monitor.newChild(1));
        this.refreshFilesystem(monitor.newChild(1));
        monitor.done();
    }

    private void cancelChanges(SubMonitor monitor) throws TeamRepositoryException, FileSystemClientException {
        monitor.beginTask(Messages.CancelRemoteChangesOperation_0, 100);
        HashMap groupedIgnoreables = new HashMap();
        for (Cancelable cancelable : this.toCancel) {
            IWorkspaceConnection connection;
            if (!cancelable.shouldCancelChange() || (connection = cancelable.getConnection()) == null) continue;
            if (!groupedIgnoreables.containsKey(connection)) {
                groupedIgnoreables.put(connection, new ArrayList(1));
            }
            ((List)groupedIgnoreables.get(connection)).add(cancelable);
        }
        try {
            for (Map.Entry entry : groupedIgnoreables.entrySet()) {
                this.cancelChange((IWorkspaceConnection)entry.getKey(), (List)entry.getValue(), monitor.newChild(1));
            }
        }
        finally {
            monitor.done();
        }
    }

    private void cancelChange(IWorkspaceConnection connection, List<Cancelable> ignoreables, SubMonitor monitor) throws TeamRepositoryException, FileSystemClientException {
        if (connection == null) {
            throw new IllegalArgumentException("Connection may not be null");
        }
        monitor = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        monitor.setTaskName(Messages.CancelRemoteChangesOperation_0);
        HashMap<UUID, IChangeSetHandle> uuidToChangeSetHandle = new HashMap<UUID, IChangeSetHandle>();
        HashMap changes = new HashMap();
        HashMap<IPath, Object> props = new HashMap<IPath, Object>();
        SubMonitor iterProgress = monitor.newChild(25).setWorkRemaining(ignoreables.size());
        for (Cancelable cancelable : ignoreables) {
            Object sp;
            SubMonitor subMonitor;
            IShareable shareable = cancelable.getShareable((IProgressMonitor)(subMonitor = iterProgress.newChild(1).setWorkRemaining(5)).newChild(1));
            if (shareable != null) {
                this.cancelPendingChanges(shareable, (IProgressMonitor)subMonitor.newChild(1));
            }
            if (!cancelable.shouldCancelChange()) continue;
            ChangeSetUndoList undo = cancelable.getUndoList(subMonitor.newChild(1));
            if (undo.handle == null) continue;
            this.ensureActive(connection, cancelable, undo, subMonitor.newChild(1));
            IChangeSetHandle handle = (IChangeSetHandle)uuidToChangeSetHandle.get(undo.handle.getItemId());
            if (handle == null) {
                handle = undo.handle;
                uuidToChangeSetHandle.put(handle.getItemId(), handle);
            }
            if (!changes.containsKey(handle)) {
                changes.put(handle, new ArrayList());
            }
            ((List)changes.get(handle)).addAll(undo.toUndo);
            if (shareable == null || (sp = ShareableProperties.create(shareable, (IProgressMonitor)subMonitor.newChild(1))) == null) continue;
            props.put(shareable.getLocalPath(), sp);
        }
        ArrayList<IChangeSetHandle> changeSets = new ArrayList<IChangeSetHandle>(changes.size());
        ArrayList configOps = new ArrayList(changes.size());
        for (Map.Entry entry : changes.entrySet()) {
            changeSets.add((IChangeSetHandle)entry.getKey());
            ArrayList<IWorkspaceConnection.IUndoOp> ops = new ArrayList<IWorkspaceConnection.IUndoOp>(((List)entry.getValue()).size());
            configOps.add(ops);
            for (IVersionableHandle toUndo : (List)entry.getValue()) {
                ops.add(connection.configurationOpFactory().undo(toUndo));
            }
        }
        if (!changeSets.isEmpty()) {
            IUpdateReport iUpdateReport = connection.commit(changeSets, configOps, (IProgressMonitor)monitor.newChild(25));
            this.processUndoUpdates(connection, ignoreables, iUpdateReport, monitor.newChild(25));
            iterProgress = monitor.newChild(25).setWorkRemaining(ignoreables.size());
            for (Cancelable cancelable : ignoreables) {
                ShareableProperties sp;
                SubMonitor subProgress;
                IShareable shareable = cancelable.getShareable((IProgressMonitor)(subProgress = iterProgress.newChild(1).setWorkRemaining(2)).newChild(1));
                if (shareable == null || (sp = (ShareableProperties)props.get(shareable.getLocalPath())) == null) continue;
                this.unsetLocalModificationStamp(shareable, sp, subProgress.newChild(1));
            }
        }
        monitor.done();
    }

    private void unsetLocalModificationStamp(IShareable shareable, ShareableProperties props, SubMonitor monitor) throws FileSystemClientException {
        ICopyFileArea cfa = ICopyFileAreaManager.instance.getExistingCopyFileArea(shareable.getSandbox().getRoot());
        FileItemInfo oldInfo = cfa.getItemInfo(shareable.getLocalPath());
        if (oldInfo == null) {
            return;
        }
        FileItemInfoProxy newInfo = new FileItemInfoProxy(oldInfo);
        newInfo.changeProperties(false, -1L, props.currentLineDelim, props.contentType, props.executable);
        cfa.setItemMetaData(shareable.getLocalPath(), newInfo.getFileItemInfo(), (IProgressMonitor)monitor);
    }

    private void processUndoUpdates(IWorkspaceConnection connection, List<Cancelable> cancelables, IUpdateReport updateReport, SubMonitor monitor) throws FileSystemClientException, TeamRepositoryException {
        UpdateOperation op = new UpdateOperation(connection, Collections.singletonList(updateReport), 3, null, null);
        HashMap fullCancelPaths = new HashMap();
        monitor = SubMonitor.convert((IProgressMonitor)monitor, (int)(100 * cancelables.size()));
        for (Cancelable cancelable : cancelables) {
            IShare share;
            ConfigurationDescriptor desc;
            HashSet<UUID> items;
            IShareable s = cancelable.getShareable((IProgressMonitor)monitor.newChild(1));
            if (s == null) continue;
            IPath cfaRoot = s.getSandbox().getRoot();
            HashMap<ConfigurationDescriptor, HashSet<UUID>> cfaCancelPath = (HashMap<ConfigurationDescriptor, HashSet<UUID>>)fullCancelPaths.get(cfaRoot);
            if (cfaCancelPath == null) {
                cfaCancelPath = new HashMap<ConfigurationDescriptor, HashSet<UUID>>();
                fullCancelPaths.put(cfaRoot, cfaCancelPath);
            }
            if ((items = (HashSet<UUID>)cfaCancelPath.get(desc = new ConfigurationDescriptor((IConnection)connection, (share = s.getShare((IProgressMonitor)monitor.newChild(1))).getSharingDescriptor().getComponent()))) == null) {
                items = new HashSet<UUID>();
                cfaCancelPath.put(desc, items);
            }
            items.add(cancelable.getUUID());
        }
        op.setIgnoreList(fullCancelPaths);
        monitor.setWorkRemaining(1);
        op.run((IProgressMonitor)monitor.newChild(1));
    }

    private void ensureActive(IWorkspaceConnection connection, Cancelable ignoreable, ChangeSetUndoList undo, SubMonitor monitor) throws FileSystemClientException, TeamRepositoryException {
        List activeChangeSets = connection.activeChangeSets(undo.component);
        for (IChangeSetHandle active : activeChangeSets) {
            if (!active.sameItemId((IItemHandle)undo.handle)) continue;
            return;
        }
        IShareable shareable = ignoreable.getShareable((IProgressMonitor)(monitor = SubMonitor.convert((IProgressMonitor)monitor, (int)1)));
        String path = shareable == null ? Messages.CancelRemoteChangesOperation_6 : shareable.getLocalPath().toString();
        throw new FileSystemClientException((IStatus)new Status(4, "com.ibm.team.filesystem.rcp.core", NLS.bind((String)Messages.CancelRemoteChangesOperation_3, (Object)path, (Object[])new Object[0])));
    }

    private void cancelPendingChanges(IShareable shareable, IProgressMonitor monitor) throws FileSystemClientException {
        LocalChangeTracker tracker = ((Share)shareable.getShare(monitor)).getTracker();
        tracker.cancelChanges(shareable);
    }

    private void refreshFilesystem(SubMonitor monitor) throws FileSystemClientException, TeamRepositoryException {
        monitor.beginTask(Messages.CancelRemoteChangesOperation_4, this.toCancel.size());
        for (Cancelable cancelable : this.toCancel) {
            SubMonitor iterProgress = monitor.newChild(1).setWorkRemaining(2);
            Collection<IShareable> toRefresh = cancelable.getRefreshShareables((IProgressMonitor)iterProgress.newChild(1));
            iterProgress.setWorkRemaining(toRefresh.size());
            for (IShareable shareable : toRefresh) {
                SubMonitor subProgress = iterProgress.newChild(1).setWorkRemaining(100);
                Share s = (Share)shareable.getShare((IProgressMonitor)subProgress.newChild(1));
                s.refreshChanges(shareable, (IProgressMonitor)subProgress.newChild(99));
            }
        }
        monitor.done();
    }

    public void addCancelable(IWorkspaceConnection conn, IShareable shareable, IProgressMonitor monitor) throws FileSystemClientException {
        IVersionableHandle remote = shareable.getRemote(monitor);
        if (remote == null) {
            this.toCancel.add(new CancelablePendingShareable(conn, shareable));
        } else {
            this.toCancel.add(new CancelableVersionedShareable(this.resolver, conn, shareable, remote));
        }
    }

    public void addCancelables(List<? extends Cancelable> toCancel) {
        this.toCancel.addAll(toCancel);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Cancelable {
        public boolean shouldCancelChange();

        public IWorkspaceConnection getConnection();

        public IShareable getShareable(IProgressMonitor var1) throws FileSystemClientException, TeamRepositoryException;

        public ChangeSetUndoList getUndoList(SubMonitor var1) throws TeamRepositoryException, FileSystemClientException;

        public UUID getUUID();

        public Collection<IShareable> getRefreshShareables(IProgressMonitor var1) throws FileSystemClientException, TeamRepositoryException;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CancelablePendingShareable
    implements Cancelable {
        private IShareable shareable;
        private IWorkspaceConnection connection;

        public CancelablePendingShareable(IWorkspaceConnection connection, IShareable shareable) {
            this.connection = connection;
            this.shareable = shareable;
        }

        @Override
        public IWorkspaceConnection getConnection() {
            return this.connection;
        }

        @Override
        public IShareable getShareable(IProgressMonitor mon) throws FileSystemClientException, TeamRepositoryException {
            return this.shareable;
        }

        @Override
        public UUID getUUID() {
            throw new UnsupportedOperationException("Must be committed");
        }

        @Override
        public ChangeSetUndoList getUndoList(SubMonitor monitor) throws TeamRepositoryException {
            throw new UnsupportedOperationException("Must be committed");
        }

        @Override
        public Collection<IShareable> getRefreshShareables(IProgressMonitor progress) throws FileSystemClientException, TeamRepositoryException {
            return Collections.singletonList(this.getShareable(progress));
        }

        @Override
        public boolean shouldCancelChange() {
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class CancelableVersionedShareable
    implements Cancelable {
        final IRepositoryResolver resolver;
        final IWorkspaceConnection wsConn;
        final IShareable shareable;
        final IVersionableHandle remote;

        public CancelableVersionedShareable(IRepositoryResolver resolver, final IWorkspaceConnection wsConn, IShareable shareable, IVersionableHandle remote) {
            if (resolver == null) {
                resolver = new IRepositoryResolver(){

                    public ITeamRepository getRepoFor(String uri, UUID id) {
                        return wsConn.teamRepository();
                    }
                };
            }
            this.resolver = resolver;
            this.wsConn = wsConn;
            this.shareable = shareable;
            this.remote = remote;
        }

        @Override
        public IWorkspaceConnection getConnection() {
            return this.wsConn;
        }

        @Override
        public Collection<IShareable> getRefreshShareables(IProgressMonitor newChild) {
            return Collections.singletonList(this.shareable);
        }

        @Override
        public IShareable getShareable(IProgressMonitor newChild) {
            return this.shareable;
        }

        @Override
        public UUID getUUID() {
            return this.remote.getItemId();
        }

        @Override
        public ChangeSetUndoList getUndoList(SubMonitor monitor) throws TeamRepositoryException, FileSystemClientException {
            monitor.subTask(Messages.CancelRemoteChangesOperation_5);
            monitor.setWorkRemaining(100);
            Share share = (Share)this.shareable.getShare((IProgressMonitor)monitor.newChild(5));
            IContextHandle cHandle = share.getSharingDescriptor().getConnectionHandle();
            IComponentHandle component = share.getSharingDescriptor().getComponent();
            ITeamRepository repo = this.resolver.getRepoFor(share.getSharingDescriptor().getRepositoryUri(), share.getSharingDescriptor().getRepositoryId());
            IWorkspaceManager wsMan = SCMPlatform.getWorkspaceManager((ITeamRepository)repo);
            IWorkspaceConnection connection = wsMan.getWorkspaceConnection((IWorkspaceHandle)cHandle, (IProgressMonitor)monitor.newChild(5));
            List changesets = connection.activeChangeSets();
            monitor.setWorkRemaining(changesets.size());
            IChangeSet changesetHandle = null;
            LinkedList<IVersionableHandle> toUndo = new LinkedList<IVersionableHandle>();
            block0: for (IChangeSetHandle csHandle : changesets) {
                if (monitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
                IChangeSet changeSet = (IChangeSet)connection.teamRepository().itemManager().fetchCompleteItem((IItemHandle)csHandle, 0, (IProgressMonitor)monitor.newChild(1));
                for (IChange c : changeSet.changes()) {
                    if (!this.remote.getItemId().equals((Object)c.item().getItemId())) continue;
                    toUndo.add(c.item());
                    changesetHandle = changeSet;
                    continue block0;
                }
            }
            return new ChangeSetUndoList(component, (IChangeSetHandle)changesetHandle, (List<IVersionableHandle>)toUndo);
        }

        @Override
        public boolean shouldCancelChange() {
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ChangeSetUndoList {
        public final IComponentHandle component;
        public final IChangeSetHandle handle;
        public final List<IVersionableHandle> toUndo;

        public ChangeSetUndoList(IComponentHandle component, IChangeSetHandle handle, List<IVersionableHandle> toUndo) {
            if (handle == null && !toUndo.isEmpty()) {
                throw new IllegalArgumentException("Cannot have an undo list without a change set");
            }
            if (component == null) {
                throw new IllegalArgumentException("component may not be null");
            }
            this.component = component;
            this.handle = handle;
            this.toUndo = toUndo;
        }
    }

    private static class ShareableProperties {
        private final boolean executable;
        private final FileLineDelimiter currentLineDelim;
        private final String contentType;

        public static ShareableProperties create(IShareable shareable, IProgressMonitor monitor) throws FileSystemClientException {
            FileItemInfo info = ((Shareable)shareable).getFileItemInfo(monitor);
            if (info == null) {
                return null;
            }
            return new ShareableProperties(info);
        }

        public ShareableProperties(FileItemInfo info) {
            this.executable = info.isExecutable();
            this.currentLineDelim = info.getLineDelimiter();
            this.contentType = info.getContentType();
        }
    }
}

