/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.rcp.core.internal.externalcompare;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.common.changemodel.FileState;
import com.ibm.team.filesystem.rcp.core.internal.Messages;
import com.ibm.team.filesystem.rcp.core.internal.externalcompare.AbstractOpenInExternalCompareOperation;
import com.ibm.team.filesystem.rcp.core.internal.externalcompare.ExternalCompareToolsUtil;
import com.ibm.team.filesystem.rcp.core.internal.externalcompare.OpenInExternalCompareDilemmaHandler;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.util.NLS;
import java.io.File;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

public class OpenShareableInExternalCompareOperation
extends AbstractOpenInExternalCompareOperation {
    private IShareable shareable;
    private FileState remoteFileState;

    public OpenShareableInExternalCompareOperation(String commandLine, IShareable shareable, FileState remoteFileState, OpenInExternalCompareDilemmaHandler dilemmaHandler) {
        super(commandLine, dilemmaHandler);
        this.shareable = shareable;
        this.remoteFileState = remoteFileState;
    }

    protected void exec(String[] execCommands, File[] directoriesToDelete) {
        ExternalCompareToolsUtil.exec(execCommands, directoriesToDelete, true);
    }

    protected void execAndRefresh(String[] execCommands, IShareable shareable, File[] directoriesToDelete) {
        ExternalCompareToolsUtil.execAndRefresh(execCommands, shareable, directoriesToDelete, true);
    }

    protected String getName() {
        if (this.shareable != null) {
            return this.shareable.getFullPath().lastSegment();
        }
        return this.remoteFileState.getPath().getName();
    }

    protected IShareable getShareable(IProgressMonitor monitor) {
        return this.shareable;
    }

    protected FileState getFile1State(IProgressMonitor monitor) throws TeamRepositoryException, FileSystemClientException {
        return null;
    }

    protected String getFile2Label(FileState fileState, IProgressMonitor monitor) throws FileSystemClientException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
        String label = super.getFile2Label(fileState, (IProgressMonitor)progress.newChild(1));
        String contextName = this.shareable.getShare((IProgressMonitor)progress.newChild(1)).getSharingDescriptor().getConnectionName();
        return NLS.bind((String)Messages.OpenShareableInExternalCompareOperation_5, (Object)label, (Object[])new Object[]{contextName});
    }

    protected FileState getFile2State(IProgressMonitor monitor) throws TeamRepositoryException, FileSystemClientException {
        return this.remoteFileState;
    }

    protected FileState getAncestorState(IProgressMonitor monitor) throws TeamRepositoryException, FileSystemClientException {
        return null;
    }

    protected int nonExistantLocalFile(Object file1, String errorMessage) {
        if (file1 instanceof IShareable) {
            IShareable shareable = (IShareable)file1;
            OpenInExternalCompareDilemmaHandler dilemmaHandler = (OpenInExternalCompareDilemmaHandler)this.getDilemmaHandler();
            return dilemmaHandler.localFileDoesNotExistInLocalCompare(shareable, errorMessage);
        }
        return 2;
    }

    protected int nonExistantRemoteFile1(FileState file1, String errorMessage) {
        return 2;
    }

    protected int nonExistantRemoteFile2(FileState file2, String errorMessage) {
        OpenInExternalCompareDilemmaHandler dilemmaHandler = (OpenInExternalCompareDilemmaHandler)this.getDilemmaHandler();
        return dilemmaHandler.remoteFileDoesNotExistInLocalCompare(file2, errorMessage);
    }

    protected int folderNotSupported(Object file, String errorMessage) {
        if (file instanceof IShareable) {
            IShareable shareable = (IShareable)file;
            OpenInExternalCompareDilemmaHandler dilemmaHandler = (OpenInExternalCompareDilemmaHandler)this.getDilemmaHandler();
            return dilemmaHandler.foldersNotSupportedInLocalCompare(shareable, errorMessage);
        }
        return 2;
    }

    protected int differentContentTypes(Object file1, FileState file2, FileState ancestor, String errorMessage) throws TeamRepositoryException {
        OpenInExternalCompareDilemmaHandler dilemmaHandler = (OpenInExternalCompareDilemmaHandler)this.getDilemmaHandler();
        return dilemmaHandler.differentContentTypeInLocalCompare(this.shareable, file2, errorMessage);
    }

    protected int differentLineDelimiters(Object file1, FileState file2, FileState ancestor, String errorMessage) throws TeamRepositoryException {
        OpenInExternalCompareDilemmaHandler dilemmaHandler = (OpenInExternalCompareDilemmaHandler)this.getDilemmaHandler();
        return dilemmaHandler.differentLineDelimitersInLocalCompare(this.shareable, file2, errorMessage);
    }

    protected String[] getCommand(String command, String localFilePath, String localLabel, String file2FilePath, String file2Label, String ancestorFilePath, String ancestorLabel, String mergeFilePath, String mergeLabel) {
        return ExternalCompareToolsUtil.get2WayCommand(command, localFilePath, localLabel, file2FilePath, file2Label);
    }
}

