/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.rcp.core.internal.externalcompare;

import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.operations.DilemmaHandler;
import com.ibm.team.filesystem.common.changemodel.FileState;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IComponentSyncContext;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IConflictItem;
import com.ibm.team.repository.common.TeamRepositoryException;

public class OpenInExternalCompareDilemmaHandler
extends DilemmaHandler {
    private final boolean TRACE = Boolean.getBoolean(System.getProperty("jazz.scm.externalCompare.trace", Boolean.toString(false)));
    private static OpenInExternalCompareDilemmaHandler instance;

    public static OpenInExternalCompareDilemmaHandler getDefault() {
        if (instance == null) {
            instance = new OpenInExternalCompareDilemmaHandler();
        }
        return instance;
    }

    public int foldersNotSupportedInLocalCompare(IShareable shareable, String errorMessage) {
        this.TRACE(errorMessage);
        return 1;
    }

    public int localFileDoesNotExistInLocalCompare(IShareable shareable, String errorMessage) {
        this.TRACE(errorMessage);
        return 0;
    }

    public int remoteFileDoesNotExistInLocalCompare(FileState remoteFileState, String errorMessage) {
        this.TRACE(errorMessage);
        return 0;
    }

    public int differentContentTypeInLocalCompare(IShareable shareable, FileState remoteFileState, String errorMessage) throws TeamRepositoryException {
        this.TRACE(errorMessage);
        return 0;
    }

    public int differentLineDelimitersInLocalCompare(IShareable shareable, FileState remoteFileState, String errorMessage) throws TeamRepositoryException {
        this.TRACE(errorMessage);
        return 0;
    }

    public int foldersNotSupportedInRemoteCompare(FileState filestate, String errorMessage) {
        this.TRACE(errorMessage);
        return 1;
    }

    public int deletedLeftFileStateInRemoteCompare(FileState filestate, String errorMessage) {
        this.TRACE(errorMessage);
        return 0;
    }

    public int deletedRightFileStateInRemoteCompare(FileState filestate, String errorMessage) {
        this.TRACE(errorMessage);
        return 0;
    }

    public int filesMovedButDidNotChangeStatesInRemoteCompare(FileState leftState, FileState rightState, String errorMessage) throws TeamRepositoryException {
        this.TRACE(errorMessage);
        return 1;
    }

    public int differentContentTypeInRemoteCompare(FileState leftFileState, String givenLeftLabel, FileState rightFileState, String givenRightLabel, String errorMessage) throws TeamRepositoryException {
        this.TRACE(errorMessage);
        return 0;
    }

    public int differentLineDelimitersInRemoteCompare(FileState leftFileState, String givenLeftLabel, FileState rightFileState, String givenRightLabel, String errorMessage) throws TeamRepositoryException {
        this.TRACE(errorMessage);
        return 0;
    }

    public int mergeDoesNotSupportFolders(IConflictItem conflict, String errorMessage) {
        this.TRACE(errorMessage);
        return 1;
    }

    public int mergeIsAMoveConflict(IConflictItem conflict, String errorMessage) throws TeamRepositoryException {
        this.TRACE(errorMessage);
        return 1;
    }

    public int mergeHasUnloadedComponent(IComponentSyncContext context, String errorMessage) throws TeamRepositoryException {
        this.TRACE(errorMessage);
        return 1;
    }

    public int mergeIsDeleteToDeleteConflict(IConflictItem conflict, String errorMessage) throws TeamRepositoryException {
        this.TRACE(errorMessage);
        return 1;
    }

    public int mergeHasNULLShareable(IConflictItem conflict, String errorMessage) {
        this.TRACE(errorMessage);
        return 2;
    }

    public int mergeHasNonExistantLocalFile(IShareable shareable, String errorMessage) {
        this.TRACE(errorMessage);
        return 0;
    }

    public int mergeInvolesAnEvilTwin(IConflictItem conflict, String errorMessage) {
        this.TRACE(errorMessage);
        return 0;
    }

    public int mergeHasNonExistantRemoteFile(FileState fileState, String errorMessage) {
        this.TRACE(errorMessage);
        return 0;
    }

    public int mergeHasNonExistantAncestorFile(FileState fileState, String errorMessage) {
        this.TRACE(errorMessage);
        return 0;
    }

    public int mergeFilesHaveDifferentContentTypes(IShareable local, FileState file2, FileState ancestor, String errorMessage) throws TeamRepositoryException {
        this.TRACE(errorMessage);
        return 0;
    }

    public int mergeFilesHaveDifferentLineDelimiters(IShareable local, FileState file2, FileState ancestor, String errorMessage) throws TeamRepositoryException {
        this.TRACE(errorMessage);
        return 0;
    }

    private void TRACE(String message) {
        if (this.TRACE) {
            System.out.println("OpenInExternalCompareDilemmaHandler dilemma message: " + message);
        }
    }
}

