/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.rcp.core.internal.externalcompare;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.common.changemodel.FileState;
import com.ibm.team.filesystem.rcp.core.internal.Messages;
import com.ibm.team.filesystem.rcp.core.internal.externalcompare.AbstractOpenInExternalCompareOperation;
import com.ibm.team.filesystem.rcp.core.internal.externalcompare.ExternalCompareToolsUtil;
import com.ibm.team.filesystem.rcp.core.internal.externalcompare.OpenInExternalCompareDilemmaHandler;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.util.NLS;
import org.eclipse.core.runtime.IProgressMonitor;

public class OpenFileItemInExternalCompareOperation
extends AbstractOpenInExternalCompareOperation {
    private FileState leftFileState;
    private FileState rightFileState;
    private String givenLeftLabel;
    private String givenRightLabel;

    public OpenFileItemInExternalCompareOperation(String commandLine, FileState leftFileState, FileState rightFileState, OpenInExternalCompareDilemmaHandler dilemmaHandler) {
        this(commandLine, leftFileState, null, rightFileState, null, dilemmaHandler);
    }

    public OpenFileItemInExternalCompareOperation(String commandLine, FileState leftFileState, String givenLeftLabel, FileState rightFileState, String givenRightLable, OpenInExternalCompareDilemmaHandler dilemmaHandler) {
        super(commandLine, dilemmaHandler);
        this.leftFileState = leftFileState;
        this.rightFileState = rightFileState;
        this.givenLeftLabel = givenLeftLabel;
        this.givenRightLabel = givenRightLable;
    }

    protected String getFile1Label(FileState fileState, IProgressMonitor monitor) throws FileSystemClientException {
        String label = super.getFile1Label(fileState, monitor);
        label = this.givenLeftLabel == null || this.givenLeftLabel.equals("") ? NLS.bind((String)Messages.OpenFileItemInExternalCompareOperation_4, (Object)label, (Object[])new Object[0]) : NLS.bind((String)Messages.OpenFileItemInExternalCompareOperation_4, (Object)(String.valueOf(label) + this.givenLeftLabel), (Object[])new Object[0]);
        return label;
    }

    protected String getFile2Label(FileState fileState, IProgressMonitor monitor) throws FileSystemClientException {
        String label = super.getFile2Label(fileState, monitor);
        label = this.givenRightLabel == null || this.givenRightLabel.equals("") ? NLS.bind((String)Messages.OpenFileItemInExternalCompareOperation_4, (Object)label, (Object[])new Object[0]) : NLS.bind((String)Messages.OpenFileItemInExternalCompareOperation_4, (Object)(String.valueOf(label) + this.givenRightLabel), (Object[])new Object[0]);
        return label;
    }

    protected FileState getFile1State(IProgressMonitor monitor) throws TeamRepositoryException, FileSystemClientException {
        return this.leftFileState;
    }

    protected FileState getFile2State(IProgressMonitor monitor) throws TeamRepositoryException, FileSystemClientException {
        return this.rightFileState;
    }

    protected FileState getAncestorState(IProgressMonitor monitor) throws TeamRepositoryException, FileSystemClientException {
        return null;
    }

    protected String getName() {
        String name = this.leftFileState.getPath().getName();
        if (name.length() == 0) {
            name = this.rightFileState.getPath().getName();
        }
        if (name.length() == 0) {
            name = Messages.OpenFileItemInExternalCompareOperation_1;
        }
        return name;
    }

    protected IShareable getShareable(IProgressMonitor monitor) {
        return null;
    }

    protected int nonExistantLocalFile(Object file1, String errorMessage) {
        return 2;
    }

    protected int nonExistantRemoteFile1(FileState file1, String errorMessage) {
        OpenInExternalCompareDilemmaHandler dilemmaHandler = (OpenInExternalCompareDilemmaHandler)this.getDilemmaHandler();
        return dilemmaHandler.deletedLeftFileStateInRemoteCompare(file1, errorMessage);
    }

    protected int nonExistantRemoteFile2(FileState file2, String errorMessage) {
        OpenInExternalCompareDilemmaHandler dilemmaHandler = (OpenInExternalCompareDilemmaHandler)this.getDilemmaHandler();
        return dilemmaHandler.deletedRightFileStateInRemoteCompare(file2, errorMessage);
    }

    protected int differentContentTypes(Object file1, FileState file2, FileState ancestor, String errorMessage) throws TeamRepositoryException {
        if (file1 instanceof FileState) {
            FileState file1State = (FileState)file1;
            OpenInExternalCompareDilemmaHandler dilemmaHandler = (OpenInExternalCompareDilemmaHandler)this.getDilemmaHandler();
            return dilemmaHandler.differentContentTypeInRemoteCompare(file1State, this.givenLeftLabel, file2, this.givenLeftLabel, errorMessage);
        }
        return 2;
    }

    protected int differentLineDelimiters(Object file1, FileState file2, FileState ancestor, String errorMessage) throws TeamRepositoryException {
        if (file1 instanceof FileState) {
            FileState file1State = (FileState)file1;
            OpenInExternalCompareDilemmaHandler dilemmaHandler = (OpenInExternalCompareDilemmaHandler)this.getDilemmaHandler();
            return dilemmaHandler.differentLineDelimitersInRemoteCompare(file1State, this.givenLeftLabel, file2, this.givenLeftLabel, errorMessage);
        }
        return 2;
    }

    protected int folderNotSupported(Object file, String errorMessage) {
        if (file instanceof FileState) {
            FileState fileState = (FileState)file;
            OpenInExternalCompareDilemmaHandler dilemmaHandler = (OpenInExternalCompareDilemmaHandler)this.getDilemmaHandler();
            return dilemmaHandler.foldersNotSupportedInRemoteCompare(fileState, errorMessage);
        }
        return 2;
    }

    protected String[] getCommand(String command, String localFilePath, String localLabel, String file2FilePath, String file2Label, String ancestorFilePath, String ancestorLabel, String mergeFilePath, String mergeLabel) {
        return ExternalCompareToolsUtil.get2WayCommand(command, localFilePath, localLabel, file2FilePath, file2Label);
    }
}

