/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.rcp.core.internal.externalcompare;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.internal.ClientFileStateFactory;
import com.ibm.team.filesystem.client.internal.FileSystemStatus;
import com.ibm.team.filesystem.common.changemodel.FileState;
import com.ibm.team.filesystem.rcp.core.internal.Messages;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.ComponentSyncUtil;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IComponentSyncContext;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IConflictItem;
import com.ibm.team.filesystem.rcp.core.internal.externalcompare.AbstractOpenInExternalCompareOperation;
import com.ibm.team.filesystem.rcp.core.internal.externalcompare.ExternalCompareToolsUtil;
import com.ibm.team.filesystem.rcp.core.internal.externalcompare.OpenInExternalCompareDilemmaHandler;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.common.IVersionable;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.dto.IItemConflictReport;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.osgi.util.NLS;

public class OpenConflictInExternalCompareOperation
extends AbstractOpenInExternalCompareOperation {
    private IConflictItem conflict;

    public OpenConflictInExternalCompareOperation(String commandLine, IConflictItem conflict, OpenInExternalCompareDilemmaHandler dilemmaHandler) {
        super(commandLine, dilemmaHandler);
        this.conflict = conflict;
        if (conflict == null) {
            throw new IllegalArgumentException();
        }
    }

    protected String getName() {
        return this.conflict.getName(false);
    }

    protected FileState getAncestorState(IProgressMonitor monitor) throws TeamRepositoryException {
        return this.getFileState(false, monitor);
    }

    protected FileState getFile2State(IProgressMonitor monitor) throws TeamRepositoryException, FileSystemClientException {
        return this.getFileState(true, monitor);
    }

    private FileState getFileState(boolean isFile2, IProgressMonitor monitor) throws TeamRepositoryException {
        IItemConflictReport conflictReport = this.conflict.getItemConflictReport();
        ITeamRepository repo = this.conflict.getOutgoingActivitySource().getModel().teamRepository();
        IVersionableHandle versionableHandle = isFile2 ? conflictReport.getProposedContributorState() : conflictReport.getCommonAncestorState();
        IVersionable versionable = null;
        if (versionableHandle != null) {
            versionable = SCMPlatform.getWorkspaceManager((ITeamRepository)repo).versionableManager().fetchCompleteState(versionableHandle, monitor);
        }
        return ClientFileStateFactory.create((ITeamRepository)repo, (IItemType)conflictReport.item().getItemType(), versionable);
    }

    protected String getFile2Label(FileState remoteFileState, IProgressMonitor monitor) throws FileSystemClientException {
        String fileName = super.getFile2Label(remoteFileState, monitor);
        return NLS.bind((String)Messages.OpenConflictInExternalCompareOperation_10, (Object)fileName, (Object)this.conflict.getOutgoingActivitySource().getWorkspace().getName());
    }

    protected String getAncestorLabel(FileState ancestorFileState, IProgressMonitor monitor) throws FileSystemClientException {
        String fileName = null;
        fileName = ancestorFileState.isDeleted() ? this.getName() : super.getAncestorLabel(ancestorFileState, monitor);
        return ancestorFileState.isDeleted() ? NLS.bind((String)Messages.OpenConflictInExternalCompareOperation_13, (Object)fileName) : NLS.bind((String)Messages.OpenConflictInExternalCompareOperation_12, (Object)fileName);
    }

    protected IShareable getShareable(IProgressMonitor monitor) {
        return ComponentSyncUtil.findShareable(this.conflict, true, monitor);
    }

    protected FileState getFile1State(IProgressMonitor monitor) throws TeamRepositoryException, FileSystemClientException {
        return null;
    }

    protected void execute(IProgressMonitor monitor) throws FileSystemClientException, TeamRepositoryException {
        int result;
        OpenInExternalCompareDilemmaHandler dilemmaHandler = (OpenInExternalCompareDilemmaHandler)this.getDilemmaHandler();
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        String fileName = this.getName();
        if (this.conflict.getItemConflictReport() == null || this.conflict.getLogicalChange().isChangeType(8)) {
            int result2 = dilemmaHandler.mergeIsAMoveConflict(this.conflict, NLS.bind((String)Messages.OpenConflictInExternalCompareOperation_1, (Object)fileName));
            if (result2 == 0 || result2 == 3) {
                return;
            }
            if (result2 == 1) {
                throw new OperationCanceledException();
            }
            throw new FileSystemClientException(FileSystemStatus.getStatusFor((int)4, (int)0, (String)NLS.bind((String)Messages.OpenConflictInExternalCompareOperation_1, (Object)fileName), null));
        }
        IComponentSyncContext context = this.conflict.getOutgoingActivitySource().getModel();
        if (ComponentSyncUtil.isDisconnected(context)) {
            int result3 = dilemmaHandler.mergeHasUnloadedComponent(context, NLS.bind((String)Messages.OpenConflictInExternalCompareOperation_2, (Object)context.getComponent().getName()));
            if (result3 == 0 || result3 == 3) {
                return;
            }
            if (result3 == 1) {
                throw new OperationCanceledException();
            }
            throw new FileSystemClientException(FileSystemStatus.getStatusFor((int)4, (int)0, (String)NLS.bind((String)Messages.OpenConflictInExternalCompareOperation_2, (Object)context.getComponent().getName()), null));
        }
        if (this.conflict.getItemConflictReport().getProposedContributorState() == null && this.conflict.getItemConflictReport().getSelectedContributorState() == null && (result = dilemmaHandler.mergeIsDeleteToDeleteConflict(this.conflict, NLS.bind((String)Messages.OpenConflictInExternalCompareOperation_3, (Object)fileName))) != 0) {
            if (result == 3) {
                return;
            }
            if (result == 1) {
                throw new OperationCanceledException();
            }
            throw new FileSystemClientException(FileSystemStatus.getStatusFor((int)4, (int)0, (String)NLS.bind((String)Messages.OpenConflictInExternalCompareOperation_3, (Object)fileName), null));
        }
        IShareable shareable = this.getShareable((IProgressMonitor)progress.newChild(10));
        if (shareable != null) {
            int result4;
            boolean isEvilTwin;
            IVersionableHandle remote = shareable.getRemote((IProgressMonitor)progress.newChild(5));
            boolean bl = isEvilTwin = remote == null || !remote.sameItemId((IItemHandle)this.conflict.getItem());
            if (isEvilTwin && (result4 = dilemmaHandler.mergeInvolesAnEvilTwin(this.conflict, Messages.OpenConflictInExternalCompareOperation_17)) != 0) {
                if (result4 == 3) {
                    return;
                }
                if (result4 == 1) {
                    throw new OperationCanceledException();
                }
                throw new FileSystemClientException(FileSystemStatus.getStatusFor((int)4, (int)3, (String)Messages.OpenConflictInExternalCompareOperation_17, null));
            }
        }
        super.execute(monitor);
    }

    protected int differentContentTypes(Object file1, FileState file2, FileState ancestor, String errorMessage) throws TeamRepositoryException {
        if (file1 instanceof IShareable) {
            IShareable shareable = (IShareable)file1;
            OpenInExternalCompareDilemmaHandler dilemmaHandler = (OpenInExternalCompareDilemmaHandler)this.getDilemmaHandler();
            return dilemmaHandler.mergeFilesHaveDifferentContentTypes(shareable, file2, ancestor, errorMessage);
        }
        return 2;
    }

    protected int differentLineDelimiters(Object file1, FileState file2, FileState ancestor, String errorMessage) throws TeamRepositoryException {
        if (file1 instanceof IShareable) {
            IShareable shareable = (IShareable)file1;
            OpenInExternalCompareDilemmaHandler dilemmaHandler = (OpenInExternalCompareDilemmaHandler)this.getDilemmaHandler();
            return dilemmaHandler.mergeFilesHaveDifferentLineDelimiters(shareable, file2, ancestor, errorMessage);
        }
        return 2;
    }

    protected int folderNotSupported(Object file, String errorMessage) {
        OpenInExternalCompareDilemmaHandler dilemmaHandler = (OpenInExternalCompareDilemmaHandler)this.getDilemmaHandler();
        return dilemmaHandler.mergeDoesNotSupportFolders(this.conflict, errorMessage);
    }

    protected int nonExistantLocalFile(Object file1, String errorMessage) {
        OpenInExternalCompareDilemmaHandler dilemmaHandler = (OpenInExternalCompareDilemmaHandler)this.getDilemmaHandler();
        return dilemmaHandler.mergeHasNULLShareable(this.conflict, errorMessage);
    }

    protected int nonExistantRemoteFile1(FileState file1, String errorMessage) {
        return 2;
    }

    protected int nonExistantRemoteFile2(FileState file2, String errorMessage) {
        OpenInExternalCompareDilemmaHandler dilemmaHandler = (OpenInExternalCompareDilemmaHandler)this.getDilemmaHandler();
        return dilemmaHandler.mergeHasNonExistantRemoteFile(file2, errorMessage);
    }

    protected String[] getCommand(String command, String localFilePath, String localLabel, String file2FilePath, String file2Label, String ancestorFilePath, String ancestorLabel, String mergeFilePath, String mergeLabel) {
        return ExternalCompareToolsUtil.get3WayCommand(command, localFilePath, localLabel, file2FilePath, file2Label, ancestorFilePath, ancestorLabel, mergeFilePath, mergeLabel);
    }
}

