/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.rcp.core.internal.externalcompare;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.common.changemodel.FileState;
import com.ibm.team.filesystem.rcp.core.internal.externalcompare.AbstractOpenInExternalCompareOperation;
import com.ibm.team.filesystem.rcp.core.internal.externalcompare.ExternalCompareToolsUtil;
import com.ibm.team.filesystem.rcp.core.internal.externalcompare.OpenInExternalCompareDilemmaHandler;
import com.ibm.team.repository.common.TeamRepositoryException;
import org.eclipse.core.runtime.IProgressMonitor;

public class Open3WayMergeInExternalCompareOperation
extends AbstractOpenInExternalCompareOperation {
    private IShareable shareable;
    private FileState file2State;
    private FileState ancestorState;

    public Open3WayMergeInExternalCompareOperation(IShareable shareable, FileState file2State, FileState ancestorState, String commandLine, OpenInExternalCompareDilemmaHandler dilemmaHandler) {
        super(commandLine, dilemmaHandler);
        this.shareable = shareable;
        this.file2State = file2State;
        this.ancestorState = ancestorState;
    }

    protected FileState getAncestorState(IProgressMonitor monitor) throws TeamRepositoryException, FileSystemClientException {
        return this.ancestorState;
    }

    protected FileState getFile2State(IProgressMonitor monitor) throws TeamRepositoryException, FileSystemClientException {
        return this.file2State;
    }

    protected FileState getFile1State(IProgressMonitor monitor) throws TeamRepositoryException, FileSystemClientException {
        return null;
    }

    protected String getName() {
        if (this.shareable != null) {
            return this.shareable.getFullPath().lastSegment();
        }
        return this.file2State.getPath().getName();
    }

    protected IShareable getShareable(IProgressMonitor monitor) {
        return this.shareable;
    }

    protected int differentContentTypes(Object file1, FileState file2, FileState ancestor, String errorMessage) throws TeamRepositoryException {
        if (file1 instanceof IShareable) {
            IShareable shareable = (IShareable)file1;
            OpenInExternalCompareDilemmaHandler dilemmaHandler = (OpenInExternalCompareDilemmaHandler)this.getDilemmaHandler();
            return dilemmaHandler.mergeFilesHaveDifferentContentTypes(shareable, file2, ancestor, errorMessage);
        }
        return 2;
    }

    protected int differentLineDelimiters(Object file1, FileState file2, FileState ancestor, String errorMessage) throws TeamRepositoryException {
        if (file1 instanceof IShareable) {
            IShareable shareable = (IShareable)file1;
            OpenInExternalCompareDilemmaHandler dilemmaHandler = (OpenInExternalCompareDilemmaHandler)this.getDilemmaHandler();
            return dilemmaHandler.mergeFilesHaveDifferentLineDelimiters(shareable, file2, ancestor, errorMessage);
        }
        return 2;
    }

    protected int folderNotSupported(Object file, String errorMessage) {
        if (file instanceof IShareable) {
            IShareable shareable = (IShareable)file;
            OpenInExternalCompareDilemmaHandler dilemmaHandler = (OpenInExternalCompareDilemmaHandler)this.getDilemmaHandler();
            return dilemmaHandler.mergeHasNonExistantLocalFile(shareable, errorMessage);
        }
        return 2;
    }

    protected int nonExistantLocalFile(Object file1, String errorMessage) {
        if (file1 instanceof IShareable) {
            IShareable shareable = (IShareable)file1;
            OpenInExternalCompareDilemmaHandler dilemmaHandler = (OpenInExternalCompareDilemmaHandler)this.getDilemmaHandler();
            return dilemmaHandler.mergeHasNonExistantLocalFile(shareable, errorMessage);
        }
        return 2;
    }

    protected int nonExistantRemoteFile1(FileState file1, String errorMessage) {
        return 2;
    }

    protected int nonExistantRemoteFile2(FileState file2, String errorMessage) {
        OpenInExternalCompareDilemmaHandler dilemmaHandler = (OpenInExternalCompareDilemmaHandler)this.getDilemmaHandler();
        return dilemmaHandler.mergeHasNonExistantRemoteFile(file2, errorMessage);
    }

    protected String[] getCommand(String command, String localFilePath, String localLabel, String file2FilePath, String file2Label, String ancestorFilePath, String ancestorLabel, String mergeFilePath, String mergeLabel) {
        return ExternalCompareToolsUtil.get3WayCommand(command, localFilePath, localLabel, file2FilePath, file2Label, ancestorFilePath, ancestorLabel, mergeFilePath, mergeLabel);
    }
}

