/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.rcp.core.internal.externalcompare;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.ResourceType;
import com.ibm.team.filesystem.client.internal.FileSystemStatus;
import com.ibm.team.filesystem.client.internal.IFileStorage;
import com.ibm.team.filesystem.client.internal.operations.FileSystemOperation;
import com.ibm.team.filesystem.client.operations.DilemmaHandler;
import com.ibm.team.filesystem.common.FileLineDelimiter;
import com.ibm.team.filesystem.common.changemodel.FileState;
import com.ibm.team.filesystem.rcp.core.internal.CoreShareablesUtil;
import com.ibm.team.filesystem.rcp.core.internal.Messages;
import com.ibm.team.filesystem.rcp.core.internal.externalcompare.ExternalCompareToolsUtil;
import com.ibm.team.filesystem.rcp.core.internal.externalcompare.OpenInExternalCompareDilemmaHandler;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.utils.DisposableInputStreamProvider;
import com.ibm.team.repository.common.utils.IInputStreamProvider;
import com.ibm.team.repository.common.utils.TemporaryOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.osgi.util.NLS;

public abstract class AbstractOpenInExternalCompareOperation
extends FileSystemOperation {
    private String commandLine;
    private static final int ANCESTOR_FILE = 0;
    private static final int FILE1 = 1;
    private static final int FILE2 = 2;

    protected AbstractOpenInExternalCompareOperation(String commandLine, OpenInExternalCompareDilemmaHandler dilemmaHandler) {
        super((DilemmaHandler)(dilemmaHandler == null ? OpenInExternalCompareDilemmaHandler.getDefault() : dilemmaHandler));
        if (commandLine == null) {
            throw new IllegalArgumentException();
        }
        this.commandLine = commandLine;
    }

    protected abstract String getName();

    protected abstract IShareable getShareable(IProgressMonitor var1);

    protected abstract FileState getFile1State(IProgressMonitor var1) throws TeamRepositoryException, FileSystemClientException;

    protected abstract FileState getFile2State(IProgressMonitor var1) throws TeamRepositoryException, FileSystemClientException;

    protected abstract FileState getAncestorState(IProgressMonitor var1) throws TeamRepositoryException, FileSystemClientException;

    private static String getLabel(FileState remoteFileState) {
        String remoteFileName;
        if (!remoteFileState.isDeleted()) {
            remoteFileName = remoteFileState.getPath().getName();
            if (remoteFileName.equals("")) {
                remoteFileName = Messages.OpenConflictInExternalCompareOperation_19;
            }
        } else {
            remoteFileName = Messages.OpenConflictInExternalCompareOperation_19;
        }
        return remoteFileName;
    }

    protected String getFile1Label(FileState fileState, IProgressMonitor monitor) throws FileSystemClientException {
        return AbstractOpenInExternalCompareOperation.getLabel(fileState);
    }

    protected String getFile2Label(FileState fileState, IProgressMonitor monitor) throws FileSystemClientException {
        return AbstractOpenInExternalCompareOperation.getLabel(fileState);
    }

    protected String getAncestorLabel(FileState fileState, IProgressMonitor monitor) throws FileSystemClientException {
        return AbstractOpenInExternalCompareOperation.getLabel(fileState);
    }

    private RemoteFile getRemoteFile(int fileSwitch, FileState fileState, IProgressMonitor monitor) throws FileSystemClientException {
        String message;
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        String label = null;
        switch (fileSwitch) {
            case 0: {
                label = this.getAncestorLabel(fileState, (IProgressMonitor)progress.newChild(5));
                break;
            }
            case 2: {
                label = this.getFile2Label(fileState, (IProgressMonitor)progress.newChild(5));
                break;
            }
            default: {
                label = this.getFile1Label(fileState, (IProgressMonitor)progress.newChild(5));
            }
        }
        String fileName = this.getName();
        if (fileState.isDeleted()) {
            int result = 2;
            String message2 = null;
            switch (fileSwitch) {
                case 0: {
                    OpenInExternalCompareDilemmaHandler dilemmaHandler = (OpenInExternalCompareDilemmaHandler)this.getDilemmaHandler();
                    message2 = NLS.bind((String)Messages.OpenConflictInExternalCompareOperation_20, (Object)fileName);
                    result = dilemmaHandler.mergeHasNonExistantAncestorFile(fileState, message2);
                    break;
                }
                case 2: {
                    message2 = NLS.bind((String)Messages.OpenConflictInExternalCompareOperation_9, (Object)fileName);
                    result = this.nonExistantRemoteFile2(fileState, message2);
                    break;
                }
                default: {
                    message2 = NLS.bind((String)Messages.OpenConflictInExternalCompareOperation_9, (Object)fileName);
                    result = this.nonExistantRemoteFile1(fileState, message2);
                }
            }
            if (result != 0) {
                if (result == 1) {
                    throw new OperationCanceledException();
                }
                throw new FileSystemClientException(FileSystemStatus.getStatusFor((int)4, (int)0, (String)NLS.bind((String)Messages.OpenConflictInExternalCompareOperation_9, (Object)fileName), null));
            }
        }
        File tempSavedDir = new File(ExternalCompareToolsUtil.getNewTempDirectoryPath());
        File savedFile = new File(tempSavedDir, fileName);
        if (!fileState.isDeleted()) {
            DisposableInputStreamProvider fileBuffer = null;
            try {
                try {
                    fileBuffer = TemporaryOutputStream.createLocalBuffer((IInputStreamProvider)fileState.getContents(), (IProgressMonitor)progress.newChild(5));
                    InputStream inputStream = fileBuffer.getInputStream((IProgressMonitor)progress.newChild(4));
                    ExternalCompareToolsUtil.writeFileFromStream(inputStream, savedFile, (IProgressMonitor)progress.newChild(10));
                }
                catch (IOException e) {
                    String message3 = fileSwitch == 0 ? Messages.OpenConflictInExternalCompareOperation_14 : Messages.OpenConflictInExternalCompareOperation_11;
                    throw new FileSystemClientException(FileSystemStatus.getStatusFor((int)4, (int)0, (String)NLS.bind((String)message3, (Object)savedFile.getAbsoluteFile()), (Throwable)e));
                }
            }
            catch (Throwable throwable) {
                if (fileBuffer != null) {
                    try {
                        fileBuffer.dispose();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (fileBuffer != null) {
                try {
                    fileBuffer.dispose();
                }
                catch (IOException iOException) {}
            }
        } else {
            try {
                savedFile.createNewFile();
            }
            catch (IOException iOException) {
                message = fileSwitch == 0 ? Messages.OpenConflictInExternalCompareOperation_15 : Messages.OpenConflictInExternalCompareOperation_11;
                throw new FileSystemClientException(FileSystemStatus.getStatusFor((int)4, (int)0, (String)NLS.bind((String)message, (Object)savedFile.getAbsoluteFile()), null));
            }
        }
        if (!savedFile.exists()) {
            message = fileSwitch == 0 ? Messages.OpenConflictInExternalCompareOperation_15 : Messages.OpenConflictInExternalCompareOperation_11;
            throw new FileSystemClientException(FileSystemStatus.getStatusFor((int)4, (int)0, (String)NLS.bind((String)message, (Object)savedFile.getAbsoluteFile()), null));
        }
        savedFile.setReadOnly();
        return new RemoteFile(label, tempSavedDir, savedFile);
    }

    protected void execute(IProgressMonitor monitor) throws FileSystemClientException, TeamRepositoryException {
        int result;
        boolean compareFile1Properties = false;
        IShareable file1 = null;
        String localContentType = null;
        FileLineDelimiter localLineDelimiter = null;
        File localTempSavedDir = null;
        String localFilePath = null;
        String localLabel = null;
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        IShareable shareable = null;
        FileState file1State = this.getFile1State((IProgressMonitor)progress.newChild(5));
        if (file1State != null) {
            RemoteFile remoteFile1 = this.getRemoteFile(1, file1State, (IProgressMonitor)progress.newChild(30));
            localLabel = remoteFile1.getLabel();
            localTempSavedDir = remoteFile1.getTempSavedDir();
            localFilePath = remoteFile1.getSavedFile().getAbsolutePath();
            localContentType = file1State.getContentType();
            localLineDelimiter = file1State.getLineDelimiter();
            file1 = file1State;
            compareFile1Properties = !file1State.isDeleted();
        } else {
            File localFile;
            file1 = shareable = this.getShareable((IProgressMonitor)progress.newChild(5));
            ResourceType resourceType = null;
            if (shareable != null) {
                resourceType = shareable.getResourceType((IProgressMonitor)progress.newChild(5));
            }
            String fileName = this.getName();
            if (resourceType == null) {
                String message = NLS.bind((String)Messages.OpenConflictInExternalCompareOperation_6, (Object)fileName);
                int result2 = this.nonExistantLocalFile(shareable, message);
                if (result2 != 0) {
                    if (result2 == 3) {
                        return;
                    }
                    if (result2 == 1) {
                        throw new OperationCanceledException();
                    }
                    throw new FileSystemClientException(FileSystemStatus.getStatusFor((int)4, (int)0, (String)message, null));
                }
                localTempSavedDir = new File(ExternalCompareToolsUtil.getNewTempDirectoryPath());
                localFile = new File(localTempSavedDir, shareable.getFullPath().lastSegment());
                localFilePath = localFile.getAbsolutePath();
                try {
                    localFile.createNewFile();
                }
                catch (IOException iOException) {
                    throw new FileSystemClientException(FileSystemStatus.getStatusFor((int)4, (int)0, (String)NLS.bind((String)Messages.OpenShareableInExternalCompareOperation_8, (Object)localFilePath), null));
                }
                localFile.setReadOnly();
                localLabel = message;
            } else if (resourceType == ResourceType.FILE) {
                localTempSavedDir = null;
                localFilePath = shareable.getFullPath().toOSString();
                localLabel = NLS.bind((String)Messages.OpenShareableInExternalCompareOperation_3, (Object)shareable.getFullPath().lastSegment());
                localContentType = shareable.getContentType((IProgressMonitor)progress.newChild(5));
                localLineDelimiter = shareable.getLineDelimiter((IProgressMonitor)progress.newChild(5));
                compareFile1Properties = true;
            } else {
                if (resourceType == ResourceType.FOLDER) {
                    int result3 = this.folderNotSupported(shareable, Messages.OpenShareableInExternalCompareOperation_1);
                    if (result3 == 0 || result3 == 3) {
                        return;
                    }
                    if (result3 == 1) {
                        throw new OperationCanceledException();
                    }
                    throw new FileSystemClientException(FileSystemStatus.getStatusFor((int)4, (int)0, (String)Messages.OpenShareableInExternalCompareOperation_1, null));
                }
                if (resourceType == ResourceType.SYMBOLIC_LINK) {
                    IFileStorage fileStorage = CoreShareablesUtil.getFileStorage(shareable);
                    ByteArrayInputStream inputStream = new ByteArrayInputStream(fileStorage.getTarget((IProgressMonitor)progress.newChild(1)).getBytes());
                    localTempSavedDir = new File(ExternalCompareToolsUtil.getNewTempDirectoryPath());
                    localFile = new File(localTempSavedDir, shareable.getFullPath().lastSegment());
                    localFilePath = localFile.getAbsolutePath();
                    try {
                        try {
                            ExternalCompareToolsUtil.writeFileFromStream(inputStream, localFile, (IProgressMonitor)progress.newChild(1));
                        }
                        catch (IOException iOException) {
                            throw new FileSystemClientException(FileSystemStatus.getStatusFor((int)4, (int)0, (String)NLS.bind((String)Messages.OpenShareableInExternalCompareOperation_8, (Object)localFilePath), null));
                        }
                    }
                    catch (Throwable throwable) {
                        try {
                            ((InputStream)inputStream).close();
                        }
                        catch (IOException iOException) {}
                        throw throwable;
                    }
                    try {
                        ((InputStream)inputStream).close();
                    }
                    catch (IOException iOException) {}
                    localFile.setReadOnly();
                    localLabel = shareable.getFullPath().lastSegment();
                } else {
                    throw new FileSystemClientException(FileSystemStatus.getStatusFor((int)4, (int)0, (String)NLS.bind((String)Messages.OpenConflictInExternalCompareOperation_6, (Object)resourceType.toString()), null));
                }
            }
        }
        FileState remoteState = this.getFile2State((IProgressMonitor)progress.newChild(5));
        RemoteFile file2 = this.getRemoteFile(2, remoteState, (IProgressMonitor)progress.newChild(10));
        String file2Label = file2.getLabel();
        File file2TempSavedDir = file2.getTempSavedDir();
        String file2FilePath = file2.getSavedFile().getAbsolutePath();
        FileState ancestorState = this.getAncestorState((IProgressMonitor)progress.newChild(5));
        String ancestorLabel = null;
        File ancestorTempSavedDir = null;
        String ancestorFilePath = null;
        if (ancestorState != null) {
            RemoteFile ancestorFile = this.getRemoteFile(0, ancestorState, (IProgressMonitor)progress.newChild(10));
            ancestorLabel = ancestorFile.getLabel();
            ancestorTempSavedDir = ancestorFile.getTempSavedDir();
            ancestorFilePath = ancestorFile.getSavedFile().getAbsolutePath();
        }
        String mergeLabel = Messages.OpenConflictInExternalCompareOperation_16;
        String mergeFilePath = localFilePath;
        boolean openedInternalPropertyCompare = false;
        boolean differentContentTypes = false;
        boolean differentLineDelimiters = false;
        boolean remoteFileExists = !remoteState.isDeleted();
        String remoteContentType = remoteState.getContentType();
        if (compareFile1Properties && localContentType != null && remoteFileExists && remoteContentType != null && !localContentType.equals(remoteContentType)) {
            differentContentTypes = true;
        }
        if (ancestorState != null) {
            boolean ancestorFileExists = !ancestorState.isDeleted();
            String ancestorContentType = ancestorState.getContentType();
            if (compareFile1Properties && localContentType != null && ancestorFileExists && ancestorContentType != null && !localContentType.equals(ancestorContentType)) {
                differentContentTypes = true;
            }
            if (remoteFileExists && remoteContentType != null && ancestorFileExists && ancestorContentType != null && !remoteContentType.equals(ancestorContentType)) {
                differentContentTypes = true;
            }
        }
        if (differentContentTypes) {
            int result4 = this.differentContentTypes(file1, remoteState, ancestorState, Messages.OpenConflictInExternalCompareOperation_8);
            if (result4 == 0 || result4 == 3) {
                openedInternalPropertyCompare = true;
            } else {
                if (result4 == 1) {
                    throw new OperationCanceledException();
                }
                throw new FileSystemClientException(FileSystemStatus.getStatusFor((int)4, (int)0, (String)Messages.OpenConflictInExternalCompareOperation_8, null));
            }
        }
        FileLineDelimiter remoteLineDelimiter = remoteState.getLineDelimiter();
        if (compareFile1Properties && localLineDelimiter != null && remoteFileExists && remoteLineDelimiter != null && !localLineDelimiter.equals((Object)remoteLineDelimiter)) {
            differentLineDelimiters = true;
        }
        if (ancestorState != null) {
            boolean ancestorFileExists = !ancestorState.isDeleted();
            FileLineDelimiter ancestorLineDelimiter = ancestorState.getLineDelimiter();
            if (compareFile1Properties && localLineDelimiter != null && ancestorFileExists && ancestorLineDelimiter != null && !localLineDelimiter.equals((Object)ancestorLineDelimiter)) {
                differentLineDelimiters = true;
            }
            if (remoteFileExists && remoteLineDelimiter != null && ancestorFileExists && ancestorLineDelimiter != null && !remoteLineDelimiter.equals((Object)ancestorLineDelimiter)) {
                differentLineDelimiters = true;
            }
        }
        if (differentLineDelimiters && !openedInternalPropertyCompare && (result = this.differentLineDelimiters(file1, remoteState, ancestorState, Messages.OpenConflictInExternalCompareOperation_21)) != 0 && result != 3) {
            if (result == 1) {
                throw new OperationCanceledException();
            }
            throw new FileSystemClientException(FileSystemStatus.getStatusFor((int)4, (int)0, (String)Messages.OpenConflictInExternalCompareOperation_21, null));
        }
        String[] execCommands = this.getCommand(this.commandLine, localFilePath, localLabel, file2FilePath, file2Label, ancestorFilePath, ancestorLabel, mergeFilePath, mergeLabel);
        ArrayList<File> directoriesToDelete = new ArrayList<File>(3);
        if (localTempSavedDir != null) {
            directoriesToDelete.add(localTempSavedDir);
        }
        if (file2TempSavedDir != null) {
            directoriesToDelete.add(file2TempSavedDir);
        }
        if (ancestorTempSavedDir != null) {
            directoriesToDelete.add(ancestorTempSavedDir);
        }
        if (shareable != null) {
            this.execAndRefresh(execCommands, shareable, directoriesToDelete.toArray(new File[directoriesToDelete.size()]));
        } else {
            this.exec(execCommands, directoriesToDelete.toArray(new File[directoriesToDelete.size()]));
        }
    }

    protected void execAndRefresh(String[] execCommands, IShareable shareable, File[] directoriesToDelete) {
        ExternalCompareToolsUtil.execAndRefresh(execCommands, shareable, directoriesToDelete, true);
    }

    protected void exec(String[] execCommands, File[] directoriesToDelete) {
        ExternalCompareToolsUtil.exec(execCommands, directoriesToDelete, true);
    }

    protected abstract int nonExistantLocalFile(Object var1, String var2);

    protected abstract int nonExistantRemoteFile1(FileState var1, String var2);

    protected abstract int nonExistantRemoteFile2(FileState var1, String var2);

    protected abstract int folderNotSupported(Object var1, String var2);

    protected abstract int differentContentTypes(Object var1, FileState var2, FileState var3, String var4) throws TeamRepositoryException;

    protected abstract int differentLineDelimiters(Object var1, FileState var2, FileState var3, String var4) throws TeamRepositoryException;

    protected abstract String[] getCommand(String var1, String var2, String var3, String var4, String var5, String var6, String var7, String var8, String var9);

    private static class RemoteFile {
        private String label;
        private File tempSavedDir;
        private File savedFile;

        public RemoteFile(String label, File tempSavedDir, File savedFile) {
            this.label = label;
            this.tempSavedDir = tempSavedDir;
            this.savedFile = savedFile;
        }

        public String getLabel() {
            return this.label;
        }

        public File getTempSavedDir() {
            return this.tempSavedDir;
        }

        public File getSavedFile() {
            return this.savedFile;
        }
    }
}

