/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.rcp.core.internal.changes.util.listeners;

import com.ibm.team.filesystem.client.FileSystemCore;
import com.ibm.team.filesystem.client.ILocalChangeEvent;
import com.ibm.team.filesystem.client.ILocalChangeListener;
import com.ibm.team.filesystem.client.IOperationFactory;
import com.ibm.team.filesystem.client.internal.LoggingHelper;
import com.ibm.team.filesystem.client.internal.OperationFactory;
import com.ibm.team.filesystem.client.operations.OperationOptions;
import com.ibm.team.filesystem.rcp.core.internal.FileSystemResourcesPlugin;
import com.ibm.team.filesystem.rcp.core.internal.Messages;
import com.ibm.team.filesystem.rcp.core.internal.changes.ComponentSyncInfo;
import com.ibm.team.filesystem.rcp.core.internal.changes.IActiveWorkspaceManager;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.ComponentBaselineUtil;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.ComponentSyncUtil;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IBaselineGroup;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IComponentSyncContext;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IOutgoingRemoteActivity;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IRemoteActivity;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IUnresolvedItemProvider;
import com.ibm.team.filesystem.rcp.core.internal.changes.util.ComponentSyncModel;
import com.ibm.team.filesystem.rcp.core.internal.changes.util.mutator.IMutate;
import com.ibm.team.links.client.ILinkEvent;
import com.ibm.team.links.client.ILinkManager;
import com.ibm.team.links.common.ILink;
import com.ibm.team.links.common.IReference;
import com.ibm.team.repository.client.IItemManager;
import com.ibm.team.repository.client.ISharedItemChangeEvent;
import com.ibm.team.repository.client.ISharedItemChangeListener;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.ITeamRepositoryService;
import com.ibm.team.repository.client.TeamPlatform;
import com.ibm.team.repository.client.util.EventSource;
import com.ibm.team.repository.client.util.IEvent;
import com.ibm.team.repository.client.util.IEventSource;
import com.ibm.team.repository.client.util.IListener;
import com.ibm.team.repository.client.util.IPropertyChangeEvent;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.IWorkspaceManager;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.client.events.IChangeHistoryEvent;
import com.ibm.team.scm.client.events.ICommitEvent;
import com.ibm.team.scm.client.events.IConfigurationUpdateEvent;
import com.ibm.team.scm.common.IBaselineHandle;
import com.ibm.team.scm.common.IChangeSet;
import com.ibm.team.scm.common.IChangeSetHandle;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IContextHandle;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.WorkspaceComparisonFlags;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.jobs.Job;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventManager
implements IListener,
Preferences.IPropertyChangeListener,
ITeamRepositoryService.IRepositoryServiceListener {
    public static final Object COLLABORATION_UPDATE_OPERATION = new Object();
    public static final Object CONTEXT_DIRTY_ITEMS_OPERATION = new Object();
    public static final Object CONTEXT_FULL_REFRESH_OPERATION = new Object();
    public static final Object CONTEXT_REFRESH_OPERATION = new Object();
    public static final Object CONTEXT_REFRESH_COMPARE_OPERATION = new Object();
    public static final Object CONTEXT_REFRESH_COMPARE_NOTIFY_ACCEPT_OPERATION = new Object();
    public static final Object CONTEXT_REFRESH_SUSPEND_OPERATION = new Object();
    public static final Object CONTEXT_REFRESH_LOCAL_CHANGES_OPERATION = new Object();
    public static final Object CONTEXT_REFRESH_UNRESOLVED_CHANGES_OPERATION = new Object();
    public static final Object ACTIVE_WORKSPACE_MANAGER_DELETED_WORKSPACE_OPERATION = new Object();
    public static final Object CONTEXT_REFRESHED_REMOTE_PROGRESS_OPERATION = new Object();
    public static final Object CONTEXT_CURRENT_ACTIVITY_OPERATION = new Object();
    public static final Object COMPONENT_SYNC_MODEL_UPDATE_OPERATION = new Object();
    public static final Object COMPONENT_SYNC_MANAGER_UPDATE_OPERATION = new Object();
    public static final Object MODEL_ALL_CONTEXTS_REFRESH_COMPARE_OPERATION = new Object();
    public static final Object MODEL_ALL_CONTEXTS_MAX_CHANGES_PER_CHANGESET = new Object();
    ComponentSyncModel model;
    Set contexts = new HashSet();
    public UpdateChangesJob updateChangesJob;
    Hashtable<IComponentSyncContext, ISharedItemChangeListener> sharedItemChangeListeners = new Hashtable();
    Hashtable<IComponentSyncContext, ILocalChangeListener> localChangeListeners = new Hashtable();
    Set<IUnresolvedItemProvider> providers = new HashSet<IUnresolvedItemProvider>();
    IActiveWorkspaceManager manager;
    Set<ITeamRepository> stateRepos = new HashSet<ITeamRepository>();
    Set<IEventSource> eventSourceTracked = Collections.synchronizedSet(new HashSet());
    boolean isDisposed;

    public EventManager(ComponentSyncModel model, IActiveWorkspaceManager manager) {
        this.model = model;
        this.updateChangesJob = new UpdateChangesJob();
        this.manager = manager;
        if (manager != null) {
            manager.addGenericListener("activeWorkspaces", this);
            manager.addGenericListener("workspaceCollaboration", this);
            manager.addGenericListener("componentCollaboration", this);
            this.eventSourceTracked.add(manager);
        }
        FileSystemResourcesPlugin.getDefault().getPluginPreferences().addPropertyChangeListener((Preferences.IPropertyChangeListener)this);
        model.addGenericListener("requestInit", this);
        model.getComponentSyncManager().addGenericListener("loadedWorkspaces", this);
        model.getComponentSyncManager().addGenericListener("componentSyncs", this);
        TeamPlatform.getTeamRepositoryService().addRepositoryServiceListener((ITeamRepositoryService.IRepositoryServiceListener)this);
        ITeamRepository[] iTeamRepositoryArray = TeamPlatform.getTeamRepositoryService().getTeamRepositories();
        int n = iTeamRepositoryArray.length;
        int n2 = 0;
        while (n2 < n) {
            ITeamRepository repository = iTeamRepositoryArray[n2];
            this.addedRepository(repository);
            ++n2;
        }
        this.setOperationOptionPreference();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        this.isDisposed = true;
        if (this.manager != null) {
            this.manager.removeGenericListener("activeWorkspaces", this);
            this.manager.removeGenericListener("workspaceCollaboration", this);
            this.manager.removeGenericListener("componentCollaboration", this);
            this.eventSourceTracked.remove(this.manager);
        }
        FileSystemResourcesPlugin.getDefault().getPluginPreferences().removePropertyChangeListener((Preferences.IPropertyChangeListener)this);
        this.model.removeGenericListener("requestInit", this);
        this.model.getComponentSyncManager().removeGenericListener("loadedWorkspaces", this);
        this.model.getComponentSyncManager().removeGenericListener("componentSyncs", this);
        TeamPlatform.getTeamRepositoryService().removeRepositoryServiceListener((ITeamRepositoryService.IRepositoryServiceListener)this);
        Set<ITeamRepository> set = this.stateRepos;
        synchronized (set) {
            for (ITeamRepository repo : this.stateRepos) {
                repo.removeGenericListener((Object)"state", (IListener)this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addItemProvider(IUnresolvedItemProvider provider) {
        Set<IUnresolvedItemProvider> set = this.providers;
        synchronized (set) {
            this.providers.add(provider);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<IUnresolvedItemProvider> getItemProviders() {
        ArrayList<IUnresolvedItemProvider> result = null;
        Set<IUnresolvedItemProvider> set = this.providers;
        synchronized (set) {
            result = new ArrayList<IUnresolvedItemProvider>(this.providers);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(final IComponentSyncContext context) {
        if (this.isDisposed) {
            return;
        }
        Set set = this.contexts;
        synchronized (set) {
            this.contexts.add(context);
        }
        if (context.getOutgoingTeamPlace() != null) {
            IWorkspaceConnection from = context.getOutgoingTeamPlace();
            from.addGenericListener((Object)"com.ibm.team.scm.Commit", (IListener)this);
            from.addGenericListener((Object)"com.ibm.team.scm.ChangeHistoryEvent.Deliver", (IListener)this);
            from.addGenericListener((Object)"com.ibm.team.scm.ChangeHistoryEvent.AcceptChangeSets", (IListener)this);
            from.addGenericListener((Object)"com.ibm.team.scm.ChangeHistoryEvent.AcceptCombined", (IListener)this);
            from.addGenericListener((Object)"com.ibm.team.scm.ChangeHistoryEvent.CreateChangeSet", (IListener)this);
            from.addGenericListener((Object)"com.ibm.team.scm.ChangeHistoryEvent.DiscardChangeSet", (IListener)this);
            from.addGenericListener((Object)"com.ibm.team.scm.ChangeHistoryEvent.CloseChangeSets", (IListener)this);
            from.addGenericListener((Object)"bases", (IListener)this);
            from.addGenericListener((Object)"flow table", (IListener)this);
            from.addGenericListener((Object)"components", (IListener)this);
            from.addGenericListener((Object)"com.ibm.team.scm.CurrentChangeSet", (IListener)this);
            from.addGenericListener((Object)"com.ibm.team.scm.ConfigurationUpdate", (IListener)this);
            this.eventSourceTracked.add((IEventSource)from);
        }
        if (context.getIncomingTeamPlace() != null && context.getIncomingTeamPlace() != context.getOutgoingTeamPlace()) {
            IWorkspaceConnection to = context.getIncomingTeamPlace();
            to.addGenericListener((Object)"com.ibm.team.scm.Commit", (IListener)this);
            to.addGenericListener((Object)"com.ibm.team.scm.ChangeHistoryEvent.Deliver", (IListener)this);
            to.addGenericListener((Object)"com.ibm.team.scm.ChangeHistoryEvent.AcceptChangeSets", (IListener)this);
            to.addGenericListener((Object)"com.ibm.team.scm.ChangeHistoryEvent.AcceptCombined", (IListener)this);
            to.addGenericListener((Object)"components", (IListener)this);
            to.addGenericListener((Object)"com.ibm.team.scm.ChangeHistoryEvent.CreateChangeSet", (IListener)this);
            to.addGenericListener((Object)"com.ibm.team.scm.ChangeHistoryEvent.DiscardChangeSet", (IListener)this);
            to.addGenericListener((Object)"bases", (IListener)this);
            to.addGenericListener((Object)"com.ibm.team.scm.ConfigurationUpdate", (IListener)this);
            this.eventSourceTracked.add((IEventSource)to);
        }
        ISharedItemChangeListener sharedItemChangeListener = new ISharedItemChangeListener(){

            public void itemsChanged(List events) {
                for (ISharedItemChangeEvent event : events) {
                    if (event.getBeforeState() == null) continue;
                    if (event.getSharedItem().getItemType() == IWorkspace.ITEM_TYPE && event.getAfterState() == null) {
                        EventManager.this.updateChangesJob.requestUpdate(Collections.singleton(event.getSharedItem()), ACTIVE_WORKSPACE_MANAGER_DELETED_WORKSPACE_OPERATION);
                        continue;
                    }
                    if (this.shouldIgnore(event)) continue;
                    EventManager.this.updateChangesJob.requestUpdate(Collections.singleton(context), CONTEXT_REFRESHED_REMOTE_PROGRESS_OPERATION);
                    break;
                }
            }

            boolean shouldIgnore(ISharedItemChangeEvent event) {
                IItem item = event.getSharedItem();
                if (item instanceof IChangeSet) {
                    IChangeSet after = (IChangeSet)event.getAfterState();
                    if (!after.getComponent().sameItemId((IItemHandle)context.getComponent())) {
                        return true;
                    }
                    IChangeSet before = (IChangeSet)event.getBeforeState();
                    return before.getComment().equals(after.getComment());
                }
                if (item != context.getIncomingActivitySource().getWorkspace() && item != context.getOutgoingActivitySource().getWorkspace() && item != context.getComponent()) {
                    return true;
                }
                if (item instanceof IWorkspace) {
                    IWorkspace before = (IWorkspace)event.getBeforeState();
                    IWorkspace after = (IWorkspace)event.getAfterState();
                    return before != null && after != null && before.getName().equals(after.getName()) && before.getOwner().sameItemId((IItemHandle)after.getOwner());
                }
                return false;
            }
        };
        IItemManager itemManager = context.teamRepository().itemManager();
        itemManager.addItemChangeListener(IWorkspace.ITEM_TYPE, sharedItemChangeListener);
        itemManager.addItemChangeListener(IComponent.ITEM_TYPE, sharedItemChangeListener);
        itemManager.addItemChangeListener(IChangeSet.ITEM_TYPE, sharedItemChangeListener);
        ILinkManager linkManager = (ILinkManager)context.teamRepository().getClientLibrary(ILinkManager.class);
        linkManager.addGenericListener((Object)"com.ibm.team.links.LinkSaveEvent", (IListener)this);
        linkManager.addGenericListener((Object)"com.ibm.team.links.LinkDeletedEvent", (IListener)this);
        this.sharedItemChangeListeners.put(context, sharedItemChangeListener);
        this.model.addGenericListener("patchChange", this);
        if (context.getLocalChangeSource() != null && context.getOutgoingTeamPlace() != null) {
            ILocalChangeListener localChangeListener = new ILocalChangeListener(){

                public void changeOccurred(ILocalChangeEvent event) {
                    IComponent component;
                    IWorkspace workspace = context.getOutgoingTeamPlace().getResolvedWorkspace();
                    if (!(event.hasChanges((IContextHandle)workspace, (IComponentHandle)(component = context.getComponent()), 2) || event.hasChanges((IContextHandle)workspace, (IComponentHandle)component, 3) || event.hasChanges((IContextHandle)workspace, (IComponentHandle)component, 1))) {
                        return;
                    }
                    EventManager.this.updateChangesJob.requestUpdate(Collections.singleton(context), CONTEXT_REFRESH_LOCAL_CHANGES_OPERATION);
                }
            };
            FileSystemCore.getSharingManager().getLocalChangeManager().addLocalChangeListener(localChangeListener);
            this.localChangeListeners.put(context, localChangeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(IComponentSyncContext context) {
        ILocalChangeListener localChangeListener;
        boolean hasConnectionTo;
        boolean hasConnectionFrom;
        IWorkspaceConnection from = context.getOutgoingTeamPlace();
        IWorkspaceConnection to = context.getIncomingTeamPlace();
        Set set = this.contexts;
        synchronized (set) {
            if (!this.contexts.remove(context)) {
                return;
            }
            hasConnectionFrom = from != null && !this.hasConnection(this.contexts, from);
            boolean bl = hasConnectionTo = to != null && to != from && !this.hasConnection(this.contexts, to);
            if (this.contexts.isEmpty()) {
                ILinkManager linkManager = (ILinkManager)context.teamRepository().getClientLibrary(ILinkManager.class);
                linkManager.removeGenericListener((Object)"com.ibm.team.links.LinkSaveEvent", (IListener)this);
                linkManager.removeGenericListener((Object)"com.ibm.team.links.LinkDeletedEvent", (IListener)this);
                this.model.removeGenericListener("patchChange", this);
            }
        }
        if (hasConnectionFrom) {
            from.removeGenericListener((Object)"com.ibm.team.scm.Commit", (IListener)this);
            from.removeGenericListener((Object)"com.ibm.team.scm.ChangeHistoryEvent.Deliver", (IListener)this);
            from.removeGenericListener((Object)"com.ibm.team.scm.ChangeHistoryEvent.AcceptChangeSets", (IListener)this);
            from.removeGenericListener((Object)"com.ibm.team.scm.ChangeHistoryEvent.AcceptCombined", (IListener)this);
            from.removeGenericListener((Object)"components", (IListener)this);
            from.removeGenericListener((Object)"com.ibm.team.scm.ChangeHistoryEvent.CreateChangeSet", (IListener)this);
            from.removeGenericListener((Object)"com.ibm.team.scm.CurrentChangeSet", (IListener)this);
            from.removeGenericListener((Object)"com.ibm.team.scm.ChangeHistoryEvent.DiscardChangeSet", (IListener)this);
            from.removeGenericListener((Object)"com.ibm.team.scm.ChangeHistoryEvent.CloseChangeSets", (IListener)this);
            from.removeGenericListener((Object)"flow table", (IListener)this);
            from.removeGenericListener((Object)"bases", (IListener)this);
            from.removeGenericListener((Object)"com.ibm.team.scm.ConfigurationUpdate", (IListener)this);
        }
        if (hasConnectionTo) {
            to.removeGenericListener((Object)"com.ibm.team.scm.Commit", (IListener)this);
            to.removeGenericListener((Object)"com.ibm.team.scm.ChangeHistoryEvent.Deliver", (IListener)this);
            to.removeGenericListener((Object)"com.ibm.team.scm.ChangeHistoryEvent.AcceptChangeSets", (IListener)this);
            to.removeGenericListener((Object)"com.ibm.team.scm.ChangeHistoryEvent.AcceptCombined", (IListener)this);
            to.removeGenericListener((Object)"components", (IListener)this);
            to.removeGenericListener((Object)"com.ibm.team.scm.ChangeHistoryEvent.CreateChangeSet", (IListener)this);
            to.removeGenericListener((Object)"com.ibm.team.scm.ChangeHistoryEvent.DiscardChangeSet", (IListener)this);
            to.removeGenericListener((Object)"bases", (IListener)this);
            to.removeGenericListener((Object)"com.ibm.team.scm.ConfigurationUpdate", (IListener)this);
        }
        ISharedItemChangeListener sharedItemChangeListener = this.sharedItemChangeListeners.remove(context);
        IItemManager itemManager = context.teamRepository().itemManager();
        if (sharedItemChangeListener != null) {
            itemManager.removeItemChangeListener(IWorkspace.ITEM_TYPE, sharedItemChangeListener);
            itemManager.removeItemChangeListener(IComponent.ITEM_TYPE, sharedItemChangeListener);
            itemManager.removeItemChangeListener(IChangeSet.ITEM_TYPE, sharedItemChangeListener);
        }
        if ((localChangeListener = this.localChangeListeners.remove(context)) != null) {
            FileSystemCore.getSharingManager().getLocalChangeManager().removeLocalChangeListener(localChangeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addedRepository(ITeamRepository repository) {
        Set<ITeamRepository> set = this.stateRepos;
        synchronized (set) {
            this.stateRepos.add(repository);
            repository.addGenericListener((Object)"state", (IListener)this);
        }
        SCMPlatform.getWorkspaceManager((ITeamRepository)repository).addGenericListener((Object)"suspended", (IListener)this);
    }

    public void removedRepository(ITeamRepository repository) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleEvents(List events) {
        HashSet<IComponentSyncContext> contexts = null;
        Set set = this.contexts;
        synchronized (set) {
            contexts = new HashSet<IComponentSyncContext>(this.contexts);
        }
        for (IEvent event : events) {
            Set<IComponentSyncContext> filteredContexts;
            String type = event.getEventType();
            if (event instanceof IPropertyChangeEvent) {
                IPropertyChangeEvent pce = (IPropertyChangeEvent)event;
                if (pce.getProperty().equals("loadedWorkspaces") || pce.getProperty().equals("componentSyncs")) {
                    this.updateChangesJob.requestModelUpdate(COMPONENT_SYNC_MODEL_UPDATE_OPERATION, null);
                    continue;
                }
                if (pce.getProperty().equals("activeWorkspaces") || pce.getProperty().equals("workspaceCollaboration")) {
                    this.updateChangesJob.requestModelUpdate(COLLABORATION_UPDATE_OPERATION, null);
                    continue;
                }
                if (pce.getProperty().equals("state")) {
                    ITeamRepository server = (ITeamRepository)pce.getObject();
                    if (server.getState() != 1 || server.getErrorState() != 0) continue;
                    this.updateChangesJob.requestModelUpdate(COMPONENT_SYNC_MANAGER_UPDATE_OPERATION, null);
                    continue;
                }
                if (pce.getProperty().equals("suspended")) {
                    IWorkspaceManager wm = (IWorkspaceManager)pce.getEventSource();
                    filteredContexts = this.filterContexts(contexts, wm.teamRepository());
                    this.updateChangesJob.requestUpdate(filteredContexts, CONTEXT_REFRESH_SUSPEND_OPERATION);
                    continue;
                }
            }
            if (type.equals("requestInit")) {
                this.updateChangesJob.requestModelUpdate("requestInit", null);
                continue;
            }
            if (type.equals("componentCollaboration")) {
                this.updateChangesJob.requestModelUpdate(COLLABORATION_UPDATE_OPERATION, null);
                continue;
            }
            if (type.equals("patchChange")) {
                this.updateChangesJob.requestUpdate(contexts, CONTEXT_REFRESH_UNRESOLVED_CHANGES_OPERATION);
                continue;
            }
            if (event instanceof ILinkEvent) {
                ILink link = ((ILinkEvent)event).getLink();
                IReference sourceRef = link.getSourceRef();
                Object sourceRefObject = sourceRef.resolve();
                if (!(sourceRefObject instanceof IChangeSetHandle)) continue;
                IChangeSetHandle changeSetHandle = (IChangeSetHandle)sourceRefObject;
                List<IRemoteActivity> relatedActivities = ComponentSyncUtil.getAllActivitiesFor(this.model, Collections.singletonList(changeSetHandle));
                for (IRemoteActivity iRemoteActivity : relatedActivities) {
                    this.updateChangesJob.requestUpdate(iRemoteActivity.getActivitySource().getModel(), (IMutate)((Object)iRemoteActivity));
                }
                this.updateChangesJob.requestUpdate(ComponentSyncUtil.getContexts(relatedActivities), CONTEXT_REFRESH_OPERATION);
                continue;
            }
            IWorkspaceConnection wc = (IWorkspaceConnection)event.getEventSource();
            List changeSets = Collections.EMPTY_LIST;
            IComponentHandle component = null;
            if (event instanceof ICommitEvent) {
                ICommitEvent commitEvent = (ICommitEvent)event;
                changeSets = Collections.singletonList(commitEvent.getChangeSet());
                filteredContexts = this.filterContexts(contexts, wc, changeSets);
                for (IComponentSyncContext context : filteredContexts) {
                    IChangeSetHandle changeSet;
                    IOutgoingRemoteActivity activity = ComponentSyncUtil.find(context, changeSet = commitEvent.getChangeSet());
                    if (activity == null) continue;
                    this.updateChangesJob.requestUpdate(context, (IMutate)((Object)activity));
                }
                this.updateChangesJob.requestUpdate(filteredContexts, CONTEXT_REFRESH_COMPARE_OPERATION);
                continue;
            }
            if (event instanceof IChangeHistoryEvent) {
                IChangeHistoryEvent changeHistoryEvent = (IChangeHistoryEvent)event;
                changeSets = changeHistoryEvent.getChangeSets();
                component = changeHistoryEvent.getComponent();
                if (type == "com.ibm.team.scm.ChangeHistoryEvent.Deliver") {
                    if (changeSets.isEmpty()) continue;
                    filteredContexts = this.filterContexts(contexts, wc, changeSets);
                    this.updateChangesJob.requestUpdate(filteredContexts, CONTEXT_FULL_REFRESH_OPERATION);
                    continue;
                }
                if (type == "com.ibm.team.scm.ChangeHistoryEvent.AcceptChangeSets") {
                    IChangeHistoryEvent historyEvent = (IChangeHistoryEvent)event;
                    Collection collection = ComponentBaselineUtil.getIncomingBaselineGroups(contexts, historyEvent.getWorkspaceConnection(), historyEvent.getChangeSets());
                    for (IBaselineGroup group : collection) {
                        this.updateChangesJob.requestUpdate(group.getActivitySource().getModel(), (IMutate)((Object)group));
                    }
                    if (changeSets.isEmpty()) continue;
                    filteredContexts = component != null ? this.filterContexts(contexts, wc, component) : this.filterContexts(contexts, wc, changeSets);
                    this.updateChangesJob.requestUpdate(filteredContexts, CONTEXT_REFRESH_COMPARE_NOTIFY_ACCEPT_OPERATION);
                    continue;
                }
                if (type == "com.ibm.team.scm.ChangeHistoryEvent.CreateChangeSet" || type == "com.ibm.team.scm.ChangeHistoryEvent.AcceptCombined" || type == "com.ibm.team.scm.ChangeHistoryEvent.DiscardChangeSet" || type == "com.ibm.team.scm.ChangeHistoryEvent.CloseChangeSets") {
                    if (changeSets.isEmpty()) continue;
                    filteredContexts = component != null ? this.filterContexts(contexts, wc, component) : this.filterContexts(contexts, wc, changeSets);
                    this.updateChangesJob.requestUpdate(filteredContexts, CONTEXT_REFRESH_COMPARE_NOTIFY_ACCEPT_OPERATION);
                    continue;
                }
            }
            if (type == "com.ibm.team.scm.CurrentChangeSet") {
                filteredContexts = this.filterContexts(contexts, wc);
                this.updateChangesJob.requestUpdate(filteredContexts, CONTEXT_CURRENT_ACTIVITY_OPERATION);
                continue;
            }
            if (event instanceof IPropertyChangeEvent) {
                IPropertyChangeEvent propertyChangeEvent = (IPropertyChangeEvent)event;
                if (propertyChangeEvent.getProperty() == "flow table") {
                    this.updateChangesJob.requestModelUpdate(COLLABORATION_UPDATE_OPERATION, null);
                    continue;
                }
                if (propertyChangeEvent.getProperty() == "components") {
                    this.updateChangesJob.requestModelUpdate(COLLABORATION_UPDATE_OPERATION, null);
                    continue;
                }
                if (propertyChangeEvent.getProperty() == "bases") {
                    Map oldValue = (Map)propertyChangeEvent.getOldValue();
                    Map map = (Map)propertyChangeEvent.getNewValue();
                    ArrayList<IComponentHandle> modifiedComponents = new ArrayList<IComponentHandle>();
                    block7: for (IComponentHandle newComponent : oldValue.keySet()) {
                        for (IComponentHandle oldComponent : map.keySet()) {
                            if (!newComponent.sameItemId((IItemHandle)oldComponent) || ((IBaselineHandle)oldValue.get(oldComponent)).sameItemId((IItemHandle)map.get(newComponent))) continue;
                            modifiedComponents.add(newComponent);
                            continue block7;
                        }
                    }
                    filteredContexts = this.filterContextsByComponents(contexts, wc, modifiedComponents);
                    this.updateChangesJob.requestUpdate(filteredContexts, CONTEXT_REFRESH_COMPARE_NOTIFY_ACCEPT_OPERATION);
                    continue;
                }
            }
            if (type == "com.ibm.team.scm.ConfigurationUpdate") {
                IConfigurationUpdateEvent e = (IConfigurationUpdateEvent)event;
                wc = e.getWorkspaceConnection();
                List modifiedComponents = e.getUpdateReport().getAffectedComponents();
                if (modifiedComponents.isEmpty()) continue;
                filteredContexts = this.filterContextsByComponents(contexts, wc, modifiedComponents);
                this.updateChangesJob.requestUpdate(filteredContexts, CONTEXT_REFRESH_COMPARE_OPERATION);
                continue;
            }
            LoggingHelper.error((String)"com.ibm.team.filesystem.client", (String)("Unhandled event " + event), (Throwable)new IllegalStateException());
        }
    }

    Set<IComponentSyncContext> filterContextsByComponents(Set<IComponentSyncContext> contexts, IWorkspaceConnection wc, List<IComponentHandle> components) {
        if (components.isEmpty()) {
            return this.filterContexts(contexts, wc);
        }
        HashSet<IComponentSyncContext> result = new HashSet<IComponentSyncContext>();
        for (IComponentHandle component : components) {
            result.addAll(this.filterContexts(contexts, wc, component));
        }
        return result;
    }

    Set<IComponentSyncContext> filterContexts(Set<IComponentSyncContext> contexts, ITeamRepository localRepo) {
        HashSet<IComponentSyncContext> result = new HashSet<IComponentSyncContext>();
        for (IComponentSyncContext context : contexts) {
            if (!context.teamRepository().equals(localRepo)) continue;
            result.add(context);
        }
        return result;
    }

    Set<IComponentSyncContext> filterContexts(Set<IComponentSyncContext> contexts, IWorkspaceConnection wc, List<IChangeSetHandle> changeSets) {
        if (changeSets.isEmpty()) {
            return this.filterContexts(contexts, wc);
        }
        HashSet<IComponentSyncContext> result = new HashSet<IComponentSyncContext>();
        for (IChangeSetHandle changeSet : changeSets) {
            result.addAll(this.filterContexts(contexts, wc, changeSet));
        }
        return result;
    }

    Set<IComponentSyncContext> filterContexts(Set<IComponentSyncContext> contexts, IWorkspaceConnection wc, IComponentHandle component) {
        HashSet<IComponentSyncContext> componentFiltered = new HashSet<IComponentSyncContext>();
        for (IComponentSyncContext context : contexts) {
            ComponentSyncInfo info = context.getComponentSyncInfo();
            if (info == null || !component.sameItemId((IItemHandle)info.getComponent())) continue;
            componentFiltered.add(context);
        }
        return componentFiltered;
    }

    Set<IComponentSyncContext> filterContexts(Set<IComponentSyncContext> contexts, IWorkspaceConnection wc, IChangeSetHandle changeSet) {
        IChangeSet cs = (IChangeSet)wc.teamRepository().itemManager().getSharedItemIfKnown((IItemHandle)changeSet);
        if (cs != null && cs.getComponent() != null) {
            return this.filterContexts(contexts, wc, cs.getComponent());
        }
        return this.filterContexts(contexts, wc);
    }

    Set<IComponentSyncContext> filterContexts(Set<IComponentSyncContext> contexts, IWorkspaceConnection wc) {
        HashSet<IComponentSyncContext> result = new HashSet<IComponentSyncContext>();
        for (IComponentSyncContext context : contexts) {
            if (context.getOutgoingTeamPlace() != wc && context.getIncomingTeamPlace() != wc) continue;
            result.add(context);
        }
        return result;
    }

    boolean hasConnection(Set<IComponentSyncContext> contexts, IWorkspaceConnection wc) {
        for (IComponentSyncContext context : contexts) {
            if (context.getOutgoingTeamPlace() != wc && context.getIncomingTeamPlace() != wc) continue;
            return true;
        }
        return false;
    }

    public void requestUpdate(IComponentSyncContext context, IMutate element) {
        this.updateChangesJob.requestUpdate(context, element);
    }

    public void requestUpdate(IComponentSyncContext context, Object type) {
        this.updateChangesJob.requestUpdate(Collections.singleton(context), type);
    }

    static void dump(IEvent event) {
        if (event instanceof IPropertyChangeEvent) {
            IPropertyChangeEvent pce = (IPropertyChangeEvent)event;
            System.out.println("IPropertyChangeEvent " + pce.getProperty() + " | " + pce);
        } else {
            System.out.println(event);
        }
    }

    public boolean internalIsBusy() {
        Object[] objectArray = this.eventSourceTracked.toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object source = objectArray[n2];
            if (((EventSource)source).internalIsBusy()) {
                return true;
            }
            ++n2;
        }
        return !this.updateChangesJob.isQueueEmpty() || this.updateChangesJob.getState() == 4;
    }

    public void propertyChange(Preferences.PropertyChangeEvent event) {
        String property = event.getProperty();
        if (property.equals("show_all_flow_targets")) {
            this.updateChangesJob.requestModelUpdate(COLLABORATION_UPDATE_OPERATION, null);
        }
        if (property.equals("hide_empty_baselines")) {
            boolean hide = FileSystemResourcesPlugin.getDefault().getPluginPreferences().getBoolean("hide_empty_baselines");
            int flags = WorkspaceComparisonFlags.INCLUDE_BASELINE_INFO | WorkspaceComparisonFlags.INCLUDE_REPLACED_COMPONENT_INFO;
            if (!hide) {
                flags |= WorkspaceComparisonFlags.INCLUDE_EMPTY_BASELINES;
            }
            this.model.setCompareToFlags(flags);
            this.updateChangesJob.requestModelUpdate(MODEL_ALL_CONTEXTS_REFRESH_COMPARE_OPERATION, null);
        } else if (property.equals("max_changes_per_change_set")) {
            int maxChanges = FileSystemResourcesPlugin.getDefault().getPluginPreferences().getInt("max_changes_per_change_set");
            this.model.setMaxChangesPerChangeSet(maxChanges);
            this.updateChangesJob.requestModelUpdate(MODEL_ALL_CONTEXTS_MAX_CHANGES_PER_CHANGESET, null);
        } else if (property.equals("autorefresh_enabled") || property.equals("non_atomic_commit") || property.equals("non_atomic_commit_file_update_limit")) {
            this.setOperationOptionPreference();
        }
    }

    private void setOperationOptionPreference() {
        Preferences preferences = FileSystemResourcesPlugin.getDefault().getPluginPreferences();
        OperationOptions commitOptions = new OperationOptions(preferences.getBoolean("autorefresh_enabled"), preferences.getBoolean("non_atomic_commit"), preferences.getInt("non_atomic_commit_file_update_limit"));
        IOperationFactory factory = IOperationFactory.instance;
        if (factory instanceof OperationFactory) {
            ((OperationFactory)factory).setOperationOptions(commitOptions);
        }
    }

    public class UpdateChangesJob
    extends Job {
        Hashtable queue;

        public UpdateChangesJob() {
            super(Messages.EventManager_2);
            this.queue = new Hashtable();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isQueueEmpty() {
            Hashtable hashtable = this.queue;
            synchronized (hashtable) {
                return this.queue.isEmpty();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void requestModelUpdate(Object type, Object arg) {
            Hashtable hashtable = this.queue;
            synchronized (hashtable) {
                if (arg == null) {
                    this.queue.put(type, EventManager.this.model);
                } else {
                    HashSet<Object[]> args = (HashSet<Object[]>)this.queue.get(type);
                    if (args == null) {
                        args = new HashSet<Object[]>();
                        this.queue.put(type, args);
                    }
                    args.add(new Object[]{EventManager.this.model, arg});
                }
            }
            this.schedule(1000L);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void requestUpdate(IComponentSyncContext context, IMutate element) {
            Hashtable hashtable = this.queue;
            synchronized (hashtable) {
                HashSet<Object[]> dirtyContextItems = (HashSet<Object[]>)this.queue.get(CONTEXT_DIRTY_ITEMS_OPERATION);
                if (dirtyContextItems == null) {
                    dirtyContextItems = new HashSet<Object[]>();
                    this.queue.put(CONTEXT_DIRTY_ITEMS_OPERATION, dirtyContextItems);
                }
                dirtyContextItems.add(new Object[]{context, element});
            }
            this.schedule(1000L);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void requestUpdate(Set newContexts, Object type) {
            Hashtable hashtable = this.queue;
            synchronized (hashtable) {
                Set contexts = (Set)this.queue.get(type);
                if (contexts != null) {
                    contexts.addAll(newContexts);
                } else {
                    this.queue.put(type, new HashSet(newContexts));
                }
            }
            this.schedule(1000L);
        }

        Set checkNull(Set set) {
            return set != null ? set : Collections.EMPTY_SET;
        }

        /*
         * Exception decompiling
         */
        protected IStatus run(IProgressMonitor pm) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 7 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }
}

